/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import java.io.IOException;
import java.net.Socket;
import java.util.Vector;
import oracle.ias.cache.group.Address;
import oracle.ias.cache.group.EndPoint;
import oracle.ias.cache.group.FailureDetector;
import oracle.ias.cache.group.GroupCommunication;
import oracle.ias.cache.group.GroupException;
import oracle.ias.cache.group.GroupManager;
import oracle.ias.cache.group.GroupMessage;
import oracle.ias.cache.group.MessageBuffer;
import oracle.ias.cache.group.MessageQueue;
import oracle.ias.cache.group.Monitor;
import oracle.ias.cache.group.Packet;
import oracle.ias.cache.group.TestCommand;
import oracle.ias.cache.group.Transport;
import oracle.ias.cache.group.View;

public class Receiver
extends Thread {
    static byte[] coordinator_lock = new byte[0];
    static byte[] member_lock = new byte[0];
    static byte[] total_lock = new byte[0];
    boolean work = true;
    EndPoint ep;
    static int counter = 0;
    private boolean lazyInit_;
    private Socket acceptedSocket_;
    private boolean gracefulClosed_;

    public Receiver(EndPoint endPoint) {
        super(Transport.getRTG(), "receiver");
        this.ep = endPoint;
        if (endPoint != null && endPoint.addr != null) {
            this.setName("EndPoint Receiver [" + endPoint.getShortName() + "]");
        }
        this.setDaemon(true);
        this.lazyInit_ = false;
    }

    public Receiver(Socket socket) throws GroupException, IOException {
        super(Transport.getRTG(), "receiver");
        this.acceptedSocket_ = socket;
        this.setDaemon(true);
        this.lazyInit_ = true;
    }

    public void init() throws IOException, GroupException {
        Address address = new Address(this.acceptedSocket_.getInetAddress(), this.acceptedSocket_.getPort());
        this.ep = new EndPoint(address, this.acceptedSocket_);
        if (this.ep != null && this.ep.addr != null) {
            this.setName("EndPoint Receiver [" + this.ep.getShortName() + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        var1_1 = null;
        var2_2 = null;
        var3_3 = null;
        var11_4 = 0;
        try {
            if (this.lazyInit_) {
                this.init();
            }
        }
        catch (Exception var12_5) {
            if (GroupCommunication.shouldLog(3) == false) return;
            GroupCommunication.log("Unable to establish incoming connection.", var12_5);
            return;
        }
        while (!Transport.isReady()) {
            ++var11_4;
            try {
                Thread.sleep(10L);
            }
            catch (Exception var12_6) {
                // empty catch block
            }
            if (var11_4 <= 10000) continue;
            if (GroupCommunication.shouldLog(0) == false) return;
            GroupCommunication.log("Error: Initialization TimeOut, receiver thread quit.");
            return;
        }
        block73: while (this.work != false) {
            block108: {
                try {
                    var1_1 = this.ep.read();
                    if (var1_1 == null) {
                        throw new GroupException(GroupCommunication.EXP_GRP_CON_TERMINATED);
                    }
                    var7_19 = Transport.getLocalAddress();
                    var1_1.fromMyself = var7_19.equals(var1_1.source);
                    if (GroupCommunication.shouldLog(15)) {
                        GroupCommunication.log("Received: " + var1_1);
                        break block108;
                    }
                    if (GroupCommunication.shouldLog(10)) {
                        GroupCommunication.log("Received: " + var1_1.getType() + " from " + var1_1.source.toString(true));
                    }
                }
                catch (Throwable var12_7) {
                    try {
                        if (GroupCommunication.isReady() && this.work) {
                            var13_23 = null;
                            if (this.ep != null) {
                                var13_23 = this.ep.addr;
                            }
                            if (this.gracefulClosed_ && GroupCommunication.shouldLog(7)) {
                                GroupCommunication.log("Gracefully disconnected from " + var13_23 + ". ");
                            } else if (!this.gracefulClosed_ && GroupCommunication.shouldLog(6)) {
                                GroupCommunication.log("Warning: Lost connection to " + var13_23 + ". " + var12_7.getMessage());
                            }
                            var14_31 = Receiver.coordinator_lock;
                            // MONITORENTER : oracle.ias.cache.group.Receiver.coordinator_lock
                            if (Transport.isReady()) {
                                FailureDetector.failureDetected(this.ep.addr, Receiver.coordinator_lock);
                            }
                            // MONITOREXIT : var14_31
                        }
                        this.ep.close();
                        return;
                    }
                    catch (Throwable var13_24) {
                        return;
                    }
                }
            }
            switch (var1_1.type) {
                case 3: {
                    this.ep.addr = var1_1.source;
                    Transport.endPointList.put(this.ep.addr, this.ep);
                    try {
                        if (var1_1.destination == null) {
                            var12_8 = Receiver.coordinator_lock;
                            // MONITORENTER : oracle.ias.cache.group.Receiver.coordinator_lock
                            var13_25 = Transport.findEmptySlot(Transport.getAddrList());
                            this.ep.addr.setPosition(var13_25);
                            Address.incGUid();
                            this.ep.addr.setUid(Address.getGUid());
                            this.ep.addr.setTimeStamp(System.currentTimeMillis());
                            Transport.addrList.addElement(this.ep.addr);
                            var4_18 = GroupManager.currentAddrList(GroupManager.SYSTEM_GROUP);
                            var2_2 = new Packet(4, 0, Transport.ssep.addr, var1_1.source, var4_18);
                            // MONITOREXIT : var12_8
                            var12_8 = this.ep.lock;
                            // MONITORENTER : this.ep.lock
                            this.ep.write(var2_2);
                            // MONITOREXIT : var12_8
                            if (!GroupCommunication.shouldLog(15)) continue block73;
                            GroupCommunication.log("Reply REGISTER message to " + var1_1.source.toString(true) + ". View: " + var4_18);
                            continue block73;
                        }
                        var2_2 = new Packet(21, 0, Transport.ssep.addr, var1_1.source, null);
                        var12_8 = this.ep.lock;
                        // MONITORENTER : this.ep.lock
                        this.ep.write(var2_2);
                        // MONITOREXIT : var12_8
                    }
                    catch (Exception var12_9) {
                        if (!GroupCommunication.shouldLog(3)) continue block73;
                        GroupCommunication.log("Can't reply REGISTER message to " + this.ep.addr, var12_9);
                    }
                    continue block73;
                }
                case 5: {
                    var12_10 = Receiver.coordinator_lock;
                    // MONITORENTER : oracle.ias.cache.group.Receiver.coordinator_lock
                    try {
                        GroupManager.joinGroup(GroupManager.SYSTEM_GROUP, var1_1);
                    }
                    catch (Exception var13_26) {
                        if (!GroupCommunication.shouldLog(3)) ** GOTO lbl102
                        GroupCommunication.log("Can't reply READY message to " + this.ep.addr, var13_26);
                    }
lbl102:
                    // 3 sources

                    continue block73;
                }
                case 4: {
                    var12_11 = Receiver.member_lock;
                    // MONITORENTER : oracle.ias.cache.group.Receiver.member_lock
                    try {
                        var4_18 = (View)var1_1.message;
                        var13_27 = var4_18.getCid();
                        if (var13_27 >= 0 && var13_27 < var4_18.size()) {
                            FailureDetector.setCoordinator((Address)var4_18.getMembers().elementAt(var13_27));
                        } else if (GroupCommunication.shouldLog(3)) {
                            GroupCommunication.log("Invalid coordinator index:" + var13_27 + ". Expected range: 0-" + var4_18.size());
                        }
                        var14_31 = ((View)var1_1.message).getMembers();
                        Transport.setAddrList((Vector)var14_31);
                        var15_33 = (Address)var14_31.lastElement();
                        if (var15_33.getUid() > Address.getGUid()) {
                            Address.setGUid(var15_33.getUid());
                        }
                        GroupManager.setView((View)var1_1.message);
                        GroupManager.flush(var1_1);
                    }
                    catch (Exception var13_28) {
                        if (Transport.terminated || !GroupCommunication.shouldLog(3)) ** GOTO lbl126
                        GroupCommunication.log("Can't handle a NEW_VIEW message. Got packet: " + var1_1, var13_28);
                    }
lbl126:
                    // 3 sources

                    continue block73;
                }
                case 20: {
                    this.gracefulClosed_ = true;
                    var12_12 = Receiver.coordinator_lock;
                    // MONITORENTER : oracle.ias.cache.group.Receiver.coordinator_lock
                    try {
                        this.ep.close(true);
                    }
                    catch (Exception var13_29) {
                        if (!GroupCommunication.shouldLog(3)) ** GOTO lbl138
                        GroupCommunication.log("Can't handle TERM system message.", var13_29);
                    }
lbl138:
                    // 3 sources

                    continue block73;
                }
                case 10: {
                    try {
                        Monitor.getInstance().gotPinged();
                        var10_22 = GroupManager.getViewInfo(GroupManager.SYSTEM_GROUP, var1_1.getVid());
                        if (var10_22 != null && (var8_20 = var10_22.getMessageBuffer()) != null) {
                            var8_20.cleanup(var1_1.getReceiveArray());
                            var8_20.update(var1_1);
                        }
                        var2_2 = new Packet(11, 0, Transport.getLocalAddress(), (Address)var1_1.getSourceAddress(), null);
                        GroupManager.getCurrentViewInfoRWLock(GroupManager.SYSTEM_GROUP).acquireReadLock();
                        var10_22 = GroupManager.getCurrentViewInfo(GroupManager.SYSTEM_GROUP);
                        GroupManager.getCurrentViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
                        var8_20 = var10_22.getMessageBuffer();
                        var2_2.setReceiveArray(var8_20.getReceiveVector());
                        var2_2.setReceivedTONumber(var8_20.getReceivedTONumber());
                        Transport.send(var2_2);
                    }
                    catch (Exception var12_13) {
                        if (Transport.terminated || !GroupCommunication.shouldLog(3)) continue block73;
                        GroupCommunication.log("Unable to handle PING request. Got packet: " + var1_1, var12_13);
                    }
                    catch (Error var12_14) {
                        if (!GroupCommunication.shouldLog(3)) continue block73;
                        GroupCommunication.log("Ping error", var12_14);
                    }
                    continue block73;
                }
                case 11: {
                    try {
                        Monitor.getInstance().gotReply((Address)var1_1.getSourceAddress());
                        var10_22 = GroupManager.getViewInfo(GroupManager.SYSTEM_GROUP, var1_1.getVid());
                        if (var10_22 == null || (var8_20 = var10_22.getMessageBuffer()) == null) continue block73;
                        var8_20.update(var1_1.getReceiveArray(), var1_1.getSenderIndex());
                        var8_20.update(var1_1);
                    }
                    catch (Exception var12_15) {
                        if (!GroupCommunication.shouldLog(3)) continue block73;
                        GroupCommunication.log("Ping_ACK exception", var12_15);
                    }
                    continue block73;
                }
                case 22: {
                    if (GroupCommunication.shouldLog(0)) {
                        GroupCommunication.log("Got KILL Message from " + var1_1.source + ", shutting down group communication layer.");
                    }
                    GroupCommunication.term();
                    continue block73;
                }
                case 13: {
                    try {
                        GroupManager.getCurrentViewInfoRWLock(GroupManager.SYSTEM_GROUP).acquireReadLock();
                        var10_22 = GroupManager.getCurrentViewInfo(GroupManager.SYSTEM_GROUP);
                        GroupManager.getCurrentViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
                        var4_18 = var10_22.getView();
                        var8_20 = var10_22.getMessageBuffer();
                        var3_3 = (Packet)var1_1.getMessage();
                        if (var3_3.getVid() == var4_18.getVid()) {
                            Receiver.deliver(var3_3, var8_20);
                            continue block73;
                        }
                        if (var3_3.getVid() <= var4_18.getVid()) continue block73;
                        var10_22 = GroupManager.getViewInfo(GroupManager.SYSTEM_GROUP, var3_3.getVid());
                        var8_20 = var10_22.getMessageBuffer();
                        if (var8_20 == null) throw new GroupException(GroupCommunication.EXP_GRP_INTERNAL + GroupCommunication.EXP_GRP_VIEWINFOEMPTY);
                        var8_20.hold(var3_3);
                    }
                    catch (Exception var12_16) {
                        if (!GroupCommunication.shouldLog(3)) continue block73;
                        GroupCommunication.log("Unable to forward packet: " + var1_1, var12_16);
                    }
                    continue block73;
                }
                case 15: {
                    var12_17 = 0;
                    var13_30 = 0;
                    var14_31 = Receiver.coordinator_lock;
                    // MONITORENTER : oracle.ias.cache.group.Receiver.coordinator_lock
                    try {
                        GroupManager.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).acquireReadLock();
                        var4_18 = GroupManager.getLatestViewInfo(GroupManager.SYSTEM_GROUP).getView();
                        GroupManager.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
                        var12_17 = var4_18.getVid();
                        var13_30 = var1_1.getVid();
                        if (var13_30 == var12_17) {
                            GroupManager.endFlush(var1_1);
                        }
                    }
                    catch (Exception var15_34) {
                        if (!GroupCommunication.shouldLog(3)) ** GOTO lbl219
                        GroupCommunication.log("Unable to flush view from: " + var13_30 + " to " + var12_17, var15_34);
                    }
lbl219:
                    // 3 sources

                    continue block73;
                }
                case 14: {
                    try {
                        var3_3 = (Packet)var1_1.getMessage();
                        GroupManager.getCurrentViewInfoRWLock(GroupManager.SYSTEM_GROUP).acquireReadLock();
                        var10_22 = GroupManager.getCurrentViewInfo(GroupManager.SYSTEM_GROUP);
                        GroupManager.getCurrentViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
                        var4_18 = var10_22.getView();
                        var8_20 = var10_22.getMessageBuffer();
                        if (var3_3.getVid() == var4_18.getVid()) {
                            Receiver.deliver(var3_3, var8_20);
                            continue block73;
                        }
                        var10_22 = GroupManager.getViewInfo(GroupManager.SYSTEM_GROUP, var1_1.getVid());
                        var8_20 = var10_22.getMessageBuffer();
                        var8_20.hold(var3_3);
                    }
                    catch (Exception var14_32) {
                        if (!GroupCommunication.shouldLog(3)) continue block73;
                        GroupCommunication.log("Unable to handle DELIVER request. Got packet: " + var1_1, var14_32);
                    }
                    continue block73;
                }
                case 16: {
                    var14_31 = Receiver.member_lock;
                    // MONITORENTER : oracle.ias.cache.group.Receiver.member_lock
                    try {
                        GroupManager.updateView(GroupManager.SYSTEM_GROUP);
                    }
                    catch (Exception var15_35) {
                        if (!GroupCommunication.shouldLog(3)) ** GOTO lbl249
                        GroupCommunication.log("Unable to handle FLUSHOVER request: " + var1_1, var15_35);
                    }
lbl249:
                    // 3 sources

                    continue block73;
                }
                case 17: {
                    var15_36 = false;
                    var16_37 = false;
                    if (var1_1.getMessage() instanceof TestCommand && ((var17_38 = (TestCommand)var1_1.getMessage()).getTarget() instanceof String || Transport.isMyself((Address)var17_38.getTarget()))) {
                        switch (var17_38.getAction()) {
                            case 1: {
                                continue block73;
                            }
                        }
                        continue block73;
                    }
                    if (var1_1.destination instanceof Address) {
                        Receiver.process(var1_1);
                        try {
                            var10_22 = GroupManager.getViewInfo(GroupManager.SYSTEM_GROUP, var1_1.getVid());
                            if (var10_22 == null || (var14_31 = (Object)var10_22.getView()) == null) continue block73;
                            var8_20 = var10_22.getMessageBuffer();
                            var9_21 = var1_1.getReceiveArray();
                            if (var1_1.getReceivedTONumber() == -1L) continue block73;
                            var8_20.update(var1_1);
                        }
                        catch (Exception var17_39) {
                            if (!GroupCommunication.shouldLog(3)) continue block73;
                            GroupCommunication.log("Internal Error: Can't process USER MSG from " + var1_1.source.toString(true), var17_39);
                        }
                        continue block73;
                    }
                    try {
                        try {
                            GroupManager.getDeliverRWLock(GroupManager.SYSTEM_GROUP).acquireReadLock();
                            var16_37 = true;
                            GroupManager.getCurrentViewInfoRWLock(GroupManager.SYSTEM_GROUP).acquireReadLock();
                            var15_36 = true;
                            var10_22 = GroupManager.getCurrentViewInfo(GroupManager.SYSTEM_GROUP);
                            var14_31 = var10_22.getView();
                            var8_20 = var10_22.getMessageBuffer();
                            if (var15_36) {
                                GroupManager.getCurrentViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
                                var15_36 = false;
                            }
                            if (var1_1.getSequenceNumber() > Packet.getSequencer()) {
                                Packet.setSequencer(var1_1.getSequenceNumber());
                            }
                            if (var1_1.getVid() <= var14_31.getVid()) ** GOTO lbl297
                            var10_22 = GroupManager.getViewInfo(GroupManager.SYSTEM_GROUP, var1_1.getVid());
                            if (var10_22 != null) {
                                var8_20 = var10_22.getMessageBuffer();
                                if (GroupCommunication.shouldLog(15)) {
                                    GroupCommunication.log("Holding message: " + var1_1 + ", for current view: " + var14_31.getVid());
                                }
                                if (var8_20 != null) {
                                    var8_20.hold(var1_1);
                                }
                            }
                            ** GOTO lbl313
lbl297:
                            // 1 sources

                            if (var1_1.getVid() >= var14_31.getVid()) ** GOTO lbl301
                            if (var1_1.getSerialNumber() == 0L) {
                                Receiver.process(var1_1);
                            }
                            ** GOTO lbl313
lbl301:
                            // 1 sources

                            try {
                                var9_21 = var1_1.getReceiveArray();
                                if (var9_21 != null) {
                                    var8_20.update(var9_21, var1_1.getSenderIndex());
                                }
                                if (var1_1.getReceivedTONumber() != -1L) {
                                    var8_20.update(var1_1);
                                }
                                Receiver.deliver(var1_1, var8_20);
                            }
                            catch (Exception var17_40) {
                                if (!GroupCommunication.shouldLog(3)) ** GOTO lbl313
                                GroupCommunication.log("User Message Exception:", var17_40);
                            }
lbl313:
                            // 5 sources

                            var25_42 = null;
                            if (var15_36) {
                                GroupManager.getCurrentViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
                            }
                            if (!var16_37) continue block73;
                            GroupManager.getDeliverRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
                        }
                        catch (Exception var17_41) {
                            if (GroupCommunication.shouldLog(3)) {
                                GroupCommunication.log("Internal Error: Can't process USER MSG.", var17_41);
                            }
                            var25_42 = null;
                            if (var15_36) {
                                GroupManager.getCurrentViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
                            }
                            if (!var16_37) continue block73;
                            GroupManager.getDeliverRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
                        }
                        continue block73;
                    }
                    catch (Throwable var24_43) {
                        var25_42 = null;
                        if (var15_36) {
                            GroupManager.getCurrentViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
                        }
                        if (var16_37 == false) throw var24_43;
                        GroupManager.getDeliverRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
                        throw var24_43;
                    }
                }
            }
            if (!GroupCommunication.shouldLog(3)) continue;
            GroupCommunication.log("Unknown PACKET. Got packet: " + var1_1);
        }
    }

    void stopit() {
        this.work = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void deliver(Packet packet, MessageBuffer messageBuffer) {
        try {
            if (messageBuffer != null && messageBuffer.hasDelivered(packet)) {
                return;
            }
            if (packet.isTotal() && packet.isFromMyself() && packet.getSequenceNumber() != -1L) {
                Receiver.process(packet);
                if (messageBuffer == null) return;
                messageBuffer.delivered(packet);
                messageBuffer.replace(packet);
                return;
            }
            if (packet.isTotal() && packet.getSequenceNumber() == -1L) {
                byte[] byArray = total_lock;
                synchronized (total_lock) {
                    if (!Transport.isMyself(FailureDetector.getCoordinator()) && GroupCommunication.shouldLog(6)) {
                        GroupCommunication.log("come back.");
                        packet.dump();
                    }
                    Transport.multicastTotalOrderedMsg(packet);
                    Receiver.process(packet);
                    if (messageBuffer != null) {
                        messageBuffer.delivered(packet);
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                }
            } else {
                Receiver.process(packet);
                if (messageBuffer != null) {
                    messageBuffer.delivered(packet);
                }
            }
            {
                if (packet.isAtomic() || !Transport.isMyself(FailureDetector.getCoordinator()) && packet.isTotal()) {
                    messageBuffer.save(packet);
                }
                if (!GroupCommunication.shouldLog(15)) return;
                GroupCommunication.log("Delivered packet: " + packet + ", to " + messageBuffer);
                return;
            }
        }
        catch (Exception exception) {
            if (!GroupCommunication.shouldLog(3)) return;
            GroupCommunication.log("Deliver Error.", exception);
        }
    }

    static void process(Packet packet) {
        Object object;
        Object object2;
        if (packet.getNodeCast()) {
            object2 = (Address)packet.getSourceAddress();
            object = Transport.getLocalAddress();
            if (!((Address)object2).ip.equals(((Address)object).ip)) {
                return;
            }
        }
        object2 = Transport.receivingQList.elements();
        while (object2.hasMoreElements()) {
            object = (MessageQueue)object2.nextElement();
            object.enqueue(new GroupMessage(0, packet));
        }
        if (GroupCommunication.shouldLog(15)) {
            GroupCommunication.log("Processed packet: " + packet);
        }
    }
}

