/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManagerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import oracle.ias.cache.group.GroupCommunication;
import oracle.ias.cache.group.GroupException;
import oracle.ias.cache.group.SSLConfig;

public class SSLManager {
    private static SSLManager s_ssl_mgr = null;
    private SSLConfig m_ssl_conf;
    SSLContext m_ctx;
    KeyManagerFactory m_kmf;
    TrustManagerFactory m_tmf;
    KeyStore m_ks;

    private SSLManager(SSLConfig sSLConfig) throws Exception {
        this.m_ssl_conf = sSLConfig;
        String string = this.m_ssl_conf.getProtocol();
        String string2 = this.m_ssl_conf.getAlgorithm();
        String string3 = this.m_ssl_conf.getKeyStoreType();
        String string4 = this.m_ssl_conf.getKeyStorePassword();
        String string5 = this.m_ssl_conf.getProviderName();
        if (GroupCommunication.shouldLog(15)) {
            GroupCommunication.log("protocol=" + string + " algorithm=" + string2 + " keyStoreType=" + string3 + " keyStorePassword=" + string4);
        }
        InputStream inputStream = this.m_ssl_conf.getKeyStoreInputStream();
        try {
            Security.addProvider((Provider)Class.forName(string5).newInstance());
        }
        catch (InstantiationException instantiationException) {
            throw new GroupException(GroupCommunication.EXP_GRP_SSL_PROVIDER_INSTANTIATION + string5, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new GroupException(GroupCommunication.EXP_GRP_SSL_PROVIDER_INSTANTIATION + string5, illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new GroupException(GroupCommunication.EXP_GRP_SSL_PROVIDER_CLASSNOTFOUND + string5, classNotFoundException);
        }
        catch (ClassCastException classCastException) {
            throw new GroupException(string5 + GroupCommunication.EXP_GRP_SSL_PROVIDER_CLASSCAST);
        }
        char[] cArray = string4.toCharArray();
        this.m_ctx = SSLContext.getInstance((String)string);
        this.m_kmf = KeyManagerFactory.getInstance((String)string2);
        this.m_tmf = TrustManagerFactory.getInstance((String)string2);
        this.m_ks = KeyStore.getInstance(string3);
        this.m_ks.load(inputStream, cArray);
        this.m_kmf.init(this.m_ks, cArray);
        this.m_tmf.init(this.m_ks);
        this.m_ctx.init(this.m_kmf.getKeyManagers(), this.m_tmf.getTrustManagers(), null);
    }

    public static void init(SSLConfig sSLConfig) throws Exception {
        if (sSLConfig == null) {
            throw new GroupException(GroupCommunication.EXP_GRP_SSL_CONFIG);
        }
        s_ssl_mgr = new SSLManager(sSLConfig);
    }

    public static SSLManager getInstance() {
        return s_ssl_mgr;
    }

    public SSLServerSocketFactory getServerSocketFactory() {
        SSLServerSocketFactory sSLServerSocketFactory;
        if (this.m_ctx != null) {
            sSLServerSocketFactory = this.m_ctx.getServerSocketFactory();
            if (GroupCommunication.shouldLog(15)) {
                GroupCommunication.log("Got secure ServerSocketFactory");
            }
        } else {
            sSLServerSocketFactory = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
            if (GroupCommunication.shouldLog(15)) {
                GroupCommunication.log("Got default secure ServerSocketFactory");
            }
        }
        return sSLServerSocketFactory;
    }

    public ServerSocket createSSLServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        SSLServerSocketFactory sSLServerSocketFactory;
        ServerSocket serverSocket;
        if (GroupCommunication.shouldLog(15)) {
            GroupCommunication.log("Create Secure Server Socket");
        }
        if ((serverSocket = (sSLServerSocketFactory = this.getServerSocketFactory()).createServerSocket(n, n2, inetAddress)) == null) {
            throw new IOException(GroupCommunication.EXP_GRP_SSL_SSOCKET);
        }
        if (this.m_ssl_conf.getClientAuth()) {
            ((SSLServerSocket)serverSocket).setNeedClientAuth(true);
        }
        return serverSocket;
    }

    public SSLSocketFactory getSocketFactory() {
        SSLSocketFactory sSLSocketFactory;
        if (this.m_ctx != null) {
            sSLSocketFactory = this.m_ctx.getSocketFactory();
            if (GroupCommunication.shouldLog(15)) {
                GroupCommunication.log("Got secure SocketFactory");
            }
        } else {
            sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            if (GroupCommunication.shouldLog(15)) {
                GroupCommunication.log("Got default secure SocketFactory");
            }
        }
        return sSLSocketFactory;
    }

    public Socket createSSLSocket(String string, int n) throws IOException {
        Socket socket = null;
        SSLSocketFactory sSLSocketFactory = this.getSocketFactory();
        if (sSLSocketFactory != null) {
            socket = sSLSocketFactory.createSocket(string, n);
            if (GroupCommunication.shouldLog(15)) {
                GroupCommunication.log("created secure Socket");
            }
        } else if (GroupCommunication.shouldLog(15)) {
            GroupCommunication.log("no SSLSocketFactory!");
        }
        if (socket == null) {
            throw new IOException(GroupCommunication.EXP_GRP_SSL_SOCKET);
        }
        return socket;
    }
}

