/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import java.io.Serializable;
import java.util.Vector;
import oracle.ias.cache.BitMap;
import oracle.ias.cache.group.Address;

public class View
implements Serializable {
    int vid = 0;
    int cid = -1;
    Vector members;
    transient BitMap bm = null;

    public View(int n, int n2, Vector vector) {
        this.vid = n;
        this.cid = n2;
        this.members = vector;
        this.bm = null;
    }

    public int getVid() {
        return this.vid;
    }

    public int getCid() {
        return this.cid;
    }

    public Vector getMembers() {
        return this.members;
    }

    public int size() {
        return this.members == null ? 0 : this.members.size();
    }

    public BitMap getBitMap() {
        if (this.bm == null) {
            int n;
            int n2 = 0;
            for (n = 0; n < this.members.size(); ++n) {
                if (n2 >= ((Address)this.members.elementAt(n)).getPosition()) continue;
                n2 = ((Address)this.members.elementAt(n)).getPosition();
            }
            this.bm = new BitMap(n2 + 1);
            for (n = 0; n < this.members.size(); ++n) {
                this.bm.setBit(((Address)this.members.elementAt(n)).getPosition());
            }
        }
        return (BitMap)this.bm.clone();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nView Id: ");
        stringBuffer.append(this.vid);
        stringBuffer.append("\nView CId: ");
        stringBuffer.append(this.cid);
        stringBuffer.append("\nView Members:\n");
        if (this.members != null) {
            for (int i = 0; i < this.members.size(); ++i) {
                stringBuffer.append("#");
                stringBuffer.append(i + 1);
                stringBuffer.append(".\t");
                stringBuffer.append(this.members.elementAt(i));
                stringBuffer.append("\n");
            }
        }
        stringBuffer.append("\nView BitMap:\n");
        stringBuffer.append(this.bm);
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        View view = (View)object;
        return view.vid == this.vid;
    }
}

