/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import oracle.net.ns.NetException;
import oracle.net.ns.Packet;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;

public class MarkerPacket
extends Packet
implements SQLnetDef {
    protected int type;
    protected int oldDataType;
    protected int data;
    private boolean isReset;
    private boolean isBreak;

    public MarkerPacket(SessionAtts sessionAtts) {
        super(sessionAtts);
        this.createBuffer(10, 12, 0);
        this.buffer[4] = 12;
        this.buffer[8] = 0;
    }

    public MarkerPacket(SessionAtts sessionAtts, int n) {
        super(sessionAtts);
        this.createBuffer(11, 12, 0);
        this.buffer[4] = 12;
        this.buffer[8] = 1;
        this.buffer[10] = (byte)n;
    }

    public MarkerPacket(Packet packet) throws NetException {
        super(packet);
        this.type = this.buffer[8];
        this.oldDataType = this.buffer[9];
        switch (this.type) {
            case 0: {
                this.data = 0;
                this.isBreak = true;
                return;
            }
            case 1: {
                this.data = this.buffer[10];
                if (this.data == 2) {
                    this.isReset = true;
                    return;
                }
                this.isBreak = true;
                return;
            }
        }
        throw new NetException(205);
    }

    public boolean isBreakPkt() {
        return this.isBreak;
    }
}

