/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipcp;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipcr.OipcrIResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIResultInfo;
import oracle.sysman.oip.oipc.oipcr.OipcrResult;

public class OipcpPrerequisiteResult {
    private OipcrIResult m_oResult = null;
    private String S_PREREQ_RESULT_SUCCESS = "Passed";
    private String S_PREREQ_RESULT_FAILED = "Failed <<<<";
    private String S_PREREQ_RESULT_SKIPPED = "Not executed <<<<";

    public OipcpPrerequisiteResult(OipcrIResult oResult) {
        this.m_oResult = oResult;
    }

    public OipcpPrerequisiteResult() {
        this.m_oResult = OipcrResult.NOT_EXECUTED_RESULT;
    }

    public boolean isSuccess() {
        return this.m_oResult.getResult() == 1;
    }

    public boolean isUserVerified() {
        return this.m_oResult.isUserVerified();
    }

    public void setUserVerified(boolean bUserVerified) {
        this.m_oResult.setUserVerified(bUserVerified);
    }

    public boolean isFailed() {
        return this.m_oResult.getResult() == 7;
    }

    public boolean isSkipped() {
        return this.m_oResult.getResult() == 3;
    }

    public int getResult() {
        return this.m_oResult.getResult();
    }

    public String getResultText() {
        return this.getResultTextImpl(this.getResult());
    }

    public String getEnglishResultText() {
        String sResId = "";
        int nResult = this.getResult();
        switch (nResult) {
            case 1: {
                sResId = this.S_PREREQ_RESULT_SUCCESS;
                break;
            }
            case 7: {
                sResId = this.S_PREREQ_RESULT_FAILED;
                break;
            }
            case 3: {
                sResId = this.S_PREREQ_RESULT_SKIPPED;
            }
        }
        return sResId;
    }

    private String getResultTextImpl(int nResult) {
        String sResId = "";
        switch (nResult) {
            case 1: {
                sResId = "OUI-62003";
                break;
            }
            case 7: {
                sResId = "OUI-62004";
                break;
            }
            case 3: {
                sResId = "OUI-62005";
            }
        }
        return OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcp.resources.OipcpRuntimeRes", (String)sResId);
    }

    public String getExpectedResultString() {
        ArrayList<String> oResultList = new ArrayList<String>(5);
        Iterator oIterResultDetails = this.m_oResult.getResultDetails();
        if (oIterResultDetails != null) {
            while (oIterResultDetails.hasNext()) {
                OipcrIResultInfo oInfo = (OipcrIResultInfo)oIterResultDetails.next();
                Object oExp = oInfo.getExpectedData();
                if (oExp == null) continue;
                oResultList.add(oExp.toString());
            }
        }
        return this.formatResult(oResultList);
    }

    public String getActualResultString() {
        ArrayList<String> oResultList = new ArrayList<String>(5);
        Iterator oIterResultDetails = this.m_oResult.getResultDetails();
        if (oIterResultDetails != null) {
            while (oIterResultDetails.hasNext()) {
                OipcrIResultInfo oInfo = (OipcrIResultInfo)oIterResultDetails.next();
                Object oAct = oInfo.getActualData();
                if (oAct == null) continue;
                oResultList.add(oAct.toString());
            }
        }
        return this.formatResult(oResultList);
    }

    private String formatResult(List oDetailsList) {
        String sFormatedResult = "";
        boolean begin = true;
        int numDetails = oDetailsList.size();
        if (numDetails == 0) {
            return null;
        }
        for (int i = 0; i < numDetails; ++i) {
            String sDetail = (String)oDetailsList.get(i);
            if (!begin) {
                sFormatedResult = sFormatedResult + ", ";
            } else {
                begin = false;
            }
            sFormatedResult = sFormatedResult + sDetail;
        }
        return sFormatedResult;
    }

    public String getFormattedResultText() {
        if (this.m_oResult.getResultSize() > 1) {
            return this.getComplexResultsText();
        }
        return this.getSimpleResultsText();
    }

    private String getSimpleResultsText() {
        StringBuffer sb = new StringBuffer();
        String sExpData = this.getExpectedResultString();
        String sActData = this.getActualResultString();
        if (sExpData != null) {
            sb.append(OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcp.resources.OipcpRuntimeRes", (String)"OIPCP0001", (Object[])new String[]{this.getExpectedResultString()}));
        }
        if (sActData != null) {
            sb.append(OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcp.resources.OipcpRuntimeRes", (String)"OIPCP0002", (Object[])new String[]{this.getActualResultString()}));
        }
        sb.append(OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcp.resources.OipcpRuntimeRes", (String)"OIPCP0003", (Object[])new String[]{this.getResultText()}));
        return sb.toString();
    }

    private String getComplexResultsText() {
        StringBuffer sbResultTable = new StringBuffer();
        Iterator oIterResultDetails = this.m_oResult.getResultDetails();
        if (oIterResultDetails != null) {
            while (oIterResultDetails.hasNext()) {
                OipcrIResultInfo oInfo = (OipcrIResultInfo)oIterResultDetails.next();
                Object oExpData = oInfo.getExpectedData();
                String sExpectedResult = oExpData == null ? null : oExpData.toString();
                Object oActData = oInfo.getActualData();
                String sActualResult = oActData == null ? null : oActData.toString();
                String sResultText = this.getResultTextImpl(oInfo.getResult());
                if (oExpData == null) {
                    if (oActData == null) continue;
                    sbResultTable.append(OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcp.resources.OipcpRuntimeRes", (String)"OIPCP0007", (Object[])new Object[]{sActualResult, sResultText}));
                    continue;
                }
                if (oActData == null) {
                    sbResultTable.append(OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcp.resources.OipcpRuntimeRes", (String)"OIPCP0008", (Object[])new Object[]{sExpectedResult, sResultText}));
                    continue;
                }
                if (sResultText.trim().equalsIgnoreCase(this.S_PREREQ_RESULT_FAILED)) {
                    sbResultTable.append(OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcp.resources.OipcpRuntimeRes", (String)"OIPCP0012", (Object[])new Object[]{sExpectedResult, sActualResult, sResultText}));
                    continue;
                }
                sbResultTable.append(OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcp.resources.OipcpRuntimeRes", (String)"OIPCP0006", (Object[])new Object[]{sExpectedResult, sActualResult, sResultText}));
            }
        }
        sbResultTable.append(OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcp.resources.OipcpRuntimeRes", (String)"OIPCP0003", (Object[])new String[]{this.getResultText()}));
        return sbResultTable.toString();
    }

    public OiixException getCause() {
        return this.m_oResult.getCause();
    }

    public OipcrIResult getRawResult() {
        return this.m_oResult;
    }
}

