/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipcr;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.parsers.ParserConfigurationException;
import oracle.sysman.oii.oiix.OiixJarClassLoader;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipck.OipckIKnowledgeSourceLibrary;
import oracle.sysman.oip.oipc.oipck.OipckIRefKnowledgeSourceLibrary;
import oracle.sysman.oip.oipc.oipck.OipckKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipck.OipckKnowledgeSrcLibBuilder;
import oracle.sysman.oip.oipc.oipck.OipckNoReferenceSpecifiedException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownBuilderException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipcr.OipcrExecuteRuleException;
import oracle.sysman.oip.oipc.oipcr.OipcrIResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIRulesEngine;
import oracle.sysman.oip.oipc.oipcr.OipcrResult;
import oracle.sysman.oip.oipc.oipcr.OipcrRule;
import oracle.sysman.oip.oipc.oipcr.OipcrRuleMap;
import oracle.sysman.oip.oipc.oipcr.OipcrRuleMapReader;
import oracle.sysman.oip.oipc.oipcr.OipcrRuleNotFoundException;
import oracle.sysman.oip.oipc.oipcr.OipcrRuleSet;
import oracle.sysman.oip.oipc.oipcr.OipcrRuleSetNotFoundException;
import oracle.sysman.oip.oipc.oipcr.OipcrRulesEngineInitException;
import oracle.sysman.oip.oipc.oipcu.OipcuPrereqProps;
import oracle.sysman.oix.oixd.OixdInvalidDocumentException;
import org.xml.sax.SAXException;

public class OipcrRulesEngine
implements OipcrIRulesEngine {
    private OipcrRuleMap m_oRuleMap;
    private OipckIRefKnowledgeSourceLibrary m_oRefKnowledgeSourceLibrary;
    private OipckIKnowledgeSourceLibrary m_oKnowledgeSourceLibrary;
    private String m_sInputDir = null;
    private String m_sOutputDir = null;
    private OipcuPrereqProps m_oProperties = null;
    private static final String S_RULES_MAP_FILE = "rulemap";
    private static final String S_RULES_MAP_DEFAULT_FILE = "rulemap.xml";
    private static final String S_KNOWLEDGE_SRC_FILE = "knowledgesource";
    private static final String S_KNOWLEDGE_SRC_DEFAULT_FILE = "knowledgesrc.xml";
    private Class[] m_oExecuteRuleParams;

    OipcrRulesEngine(String sInputDir, String sOutputDir, OipcuPrereqProps oProps) {
        this.m_sInputDir = sInputDir;
        this.m_oProperties = oProps;
        this.m_sOutputDir = sOutputDir;
        try {
            this.m_oExecuteRuleParams = new Class[]{Class.forName("oracle.sysman.oip.oipc.oipcr.OipcrIRulesEngine"), Class.forName("java.lang.String")};
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace(System.err);
        }
    }

    public OipcrIResult executeRule(String sRuleSet, String sRule, String sFileName) throws OipcrExecuteRuleException {
        Class oRuleSetClass = null;
        Method oRuleMethod = null;
        OipcrRuleSet oRuleSet = null;
        OipcrRule oRule = null;
        OipcrIResult oResult = null;
        String sClassName = null;
        String sMethodName = null;
        try {
            try {
                oRuleSet = this.m_oRuleMap.getRuleSet(sRuleSet);
                oRule = oRuleSet.getRule(sRule);
            }
            catch (OipcrRuleSetNotFoundException e) {
                throw new OipcrExecuteRuleException((Throwable)((Object)e));
            }
            catch (OipcrRuleNotFoundException e) {
                throw new OipcrExecuteRuleException((Throwable)((Object)e));
            }
            try {
                sClassName = oRule.getClassName();
                oRuleSetClass = Class.forName(sClassName);
            }
            catch (ClassNotFoundException e) {
                try {
                    oRuleSetClass = OiixJarClassLoader.getClass((String)sClassName);
                }
                catch (ClassNotFoundException e2) {
                    Object[] args = new String[]{sClassName, sRuleSet, e.getMessage()};
                    throw new OipcrExecuteRuleException("OUI-15031", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15031", (Object[])args), e);
                }
            }
            try {
                sMethodName = oRule.getMethodName();
                oRuleMethod = oRuleSetClass.getDeclaredMethod(sMethodName, this.m_oExecuteRuleParams);
            }
            catch (NoSuchMethodException e) {
                StringBuffer sb = new StringBuffer("");
                Method[] oMethods = oRuleSetClass.getDeclaredMethods();
                sb.append("Methods listed in the class:" + sClassName + "\n");
                for (int i = 0; i < oMethods.length; ++i) {
                    sb.append("-------------------------------\n");
                    sb.append("Method:" + i + "\n");
                    sb.append("Name:" + oMethods[i].getName() + "\n");
                    int mod = oMethods[i].getModifiers();
                    sb.append("IsPublic:" + Modifier.isPublic(mod) + "\n");
                    sb.append("IsStatic:" + Modifier.isStatic(mod) + "\n");
                    sb.append("Parameters:\n");
                    Class<?>[] oArgsClass = oMethods[i].getParameterTypes();
                    for (int j = 0; j < oArgsClass.length; ++j) {
                        sb.append(oArgsClass[j].getName() + "\n");
                    }
                    Class<?>[] oExcpnTypes = oMethods[i].getExceptionTypes();
                    sb.append("Exceptions:\n");
                    for (int j = 0; j < oExcpnTypes.length; ++j) {
                        sb.append(oExcpnTypes[j].getName() + "\n");
                    }
                    sb.append("Return type:" + oMethods[i].getReturnType().getName() + "\n");
                    sb.append("-------------------------------\n");
                }
                System.err.println(sb.toString());
                Object[] args = new String[]{sMethodName, sRule, sClassName, e.getMessage()};
                throw new OipcrExecuteRuleException("OUI-15032", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15032", (Object[])args), e);
            }
            catch (NullPointerException e) {
                Object[] args = new String[]{sMethodName, sRule, sClassName, e.getMessage()};
                throw new OipcrExecuteRuleException("OUI-15033", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15033", (Object[])args), e);
            }
            catch (SecurityException e) {
                Object[] args = new String[]{sMethodName, sRule, sClassName, e.getMessage()};
                throw new OipcrExecuteRuleException("OUI-15034", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15034", (Object[])args), e);
            }
            try {
                String sRefFile = sFileName == null ? null : OiixPathOps.concatPath((String)this.m_sInputDir, (String)sFileName);
                Object[] args = new Object[]{this, sRefFile};
                oResult = (OipcrIResult)oRuleMethod.invoke(null, args);
            }
            catch (ClassCastException e) {
                Object[] args = new String[]{sRuleSet, sRule, sClassName, sMethodName, e.getMessage()};
                throw new OipcrExecuteRuleException("OUI-15035", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15035", (Object[])args), e);
            }
            catch (IllegalAccessException e) {
                Object[] args = new String[]{sRuleSet, sRule, sClassName, sMethodName, e.getMessage()};
                throw new OipcrExecuteRuleException("OUI-15036", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15036", (Object[])args), e);
            }
            catch (IllegalArgumentException e) {
                Object[] args = new String[]{sRuleSet, sRule, sClassName, sMethodName, e.getMessage()};
                throw new OipcrExecuteRuleException("OUI-15037", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15037", (Object[])args), e);
            }
            catch (InvocationTargetException e) {
                Object[] args = new String[]{sRuleSet, sRule, sClassName, sMethodName, e.getTargetException().getMessage()};
                throw new OipcrExecuteRuleException("OUI-15038", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15038", (Object[])args), e);
            }
            catch (NullPointerException e) {
                Object[] args = new String[]{sRuleSet, sRule, sClassName, sMethodName, e.getMessage()};
                throw new OipcrExecuteRuleException("OUI-15040", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15040", (Object[])args), e);
            }
            catch (ExceptionInInitializerError e) {
                String[] args = new String[]{sRuleSet, sRule, sClassName, sMethodName, e.getMessage()};
                throw new OipcrExecuteRuleException("OUI-15041", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15041"), e);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            oResult = OipcrResult.getNotExecutedResult(new OipcrExecuteRuleException(e));
        }
        return oResult;
    }

    public void initialize() throws OipcrRulesEngineInitException {
        this.createRuleMap();
        this.createKnowledgeSourceLibrary();
    }

    private void createRuleMap() throws OipcrRulesEngineInitException {
        Collection oFiles = this.getFileLocation(S_RULES_MAP_FILE, S_RULES_MAP_DEFAULT_FILE);
        OipcrRuleMapReader oReader = OipcrRuleMapReader.getReader(oFiles);
        try {
            oReader.build();
        }
        catch (OixdInvalidDocumentException e) {
            throw new OipcrRulesEngineInitException(e);
        }
        catch (IOException e) {
            throw new OipcrRulesEngineInitException(e);
        }
        catch (SAXException e) {
            throw new OipcrRulesEngineInitException(e);
        }
        catch (ParserConfigurationException e) {
            throw new OipcrRulesEngineInitException(e);
        }
        this.m_oRuleMap = oReader.getRuleMap();
    }

    private void createKnowledgeSourceLibrary() throws OipcrRulesEngineInitException {
        Collection oFiles = this.getFileLocation(S_KNOWLEDGE_SRC_FILE, S_KNOWLEDGE_SRC_DEFAULT_FILE);
        OipckKnowledgeSrcLibBuilder oLibBuilder = OipckKnowledgeSrcLibBuilder.getLibraryBuilder(oFiles);
        try {
            oLibBuilder.build();
        }
        catch (OixdInvalidDocumentException e) {
            throw new OipcrRulesEngineInitException(e);
        }
        catch (IOException e) {
            throw new OipcrRulesEngineInitException(e);
        }
        catch (SAXException e) {
            throw new OipcrRulesEngineInitException(e);
        }
        catch (ParserConfigurationException e) {
            throw new OipcrRulesEngineInitException(e);
        }
        this.m_oKnowledgeSourceLibrary = oLibBuilder.getKnowledgeSourceLibrary();
        this.m_oRefKnowledgeSourceLibrary = oLibBuilder.getRefKnowledgeSourceLibrary();
    }

    private Collection getFileLocation(String sName) {
        return this.getFileLocation(sName, null);
    }

    private Collection getFileLocation(String sName, String sDefault) {
        Iterator oVal = this.getProperty(sName, sDefault);
        ArrayList<String> oFiles = new ArrayList<String>();
        if (oVal != null) {
            while (oVal.hasNext()) {
                oFiles.add(OiixPathOps.concatPath((String)this.m_sInputDir, (String)((String)oVal.next())));
            }
            oVal = null;
            return oFiles;
        }
        return null;
    }

    private Iterator getProperty(String sName, String sDefault) {
        Iterator oValue = null;
        ArrayList<String> oList = null;
        if (this.m_oProperties != null) {
            oValue = this.m_oProperties.getFilesListForProperty(sName);
        }
        if (oValue != null) {
            return oValue;
        }
        oList = new ArrayList<String>();
        oList.add(sDefault);
        return oList.iterator();
    }

    public void dispose() {
        this.m_oKnowledgeSourceLibrary = null;
        this.m_oRefKnowledgeSourceLibrary = null;
        this.m_oRuleMap = null;
    }

    public Object getKnowledgeSource(String sKey) throws OipckUnknownKnowledgeSourceException, OipckUnknownBuilderException, OipckKnowledgeSourceException {
        return this.m_oKnowledgeSourceLibrary.getKnowledgeSource(sKey);
    }

    public Object getRefKnowledgeSource(String sKey, String sFile) throws OipckUnknownKnowledgeSourceException, OipckNoReferenceSpecifiedException, OipckUnknownBuilderException, OipckKnowledgeSourceException {
        return this.m_oRefKnowledgeSourceLibrary.getRefKnowledgeSource(sKey, sFile);
    }
}

