/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipcu;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixVectorOps;
import oracle.sysman.oip.oipc.oipcc.OipccEndPrereqSessionException;

public class OipcuPrereqProps {
    Properties m_props = null;
    String m_sConfigLoc = null;
    String m_sResultsLoc = null;
    public static final String S_PREREQ_ENTRY_POINT_PROP_NAME = "entry_point";
    public static final String S_PREREQ_RULEMAP_PROP_NAME = "rulemap";
    public static final String S_PREREQ_INPUT_PROP_NAME = "prerequisite_input";
    public static final String S_PREREQ_JAVALIBS_PROP_NAME = "javalibs";
    public static final String S_PREREQ_NATIVELIBS_PROP_NAME = "nativelibs";
    public static final String S_PREREQ_KNOWLEDGE_SOURCE_PROP_NAME = "knowledgesource";
    public static final String S_PREREQ_REF_FILES_PROP_NAME = "reffiles";
    public static final String S_PREREQ_FIXUPMAP_PROP_NAME = "fixupmap";
    public static final String S_PREREQ_FIXUPFILES_PROP_NAME = "fixupfiles";
    public static final String S_PREREQ_ADVANCED_HOST = "advancedHost";
    public static final String S_PREREQ_ASM_HOST = "asmHost";
    public static final String S_PREREQ_LINUX_VENDORS_PROP_NAME = "linux_vendors";
    public static final String S_PREREQ_ADVANCED_HOST_PROPERTY = "oracle.installer.advancedHost";
    public static final String S_PREREQ_ASM_HOST_PROPERTY = "oracle.installer.asmHost";
    public static final char S_ENTRYPOINT_ENCLOSING_CHAR = '\"';
    public static final char S_VARIABLE_NAME_ENCLOSING_CHAR = '%';
    private static final String S_SEPARATOR = ";";
    private static final String PREREQ_DEFAULT_PROPERTIES_FILE_NAME = "OUIPrereqDefault";
    public static final String S_PREREQ_FIXUP_ENABLE = "fixupEnable";
    public static final String S_EXECUTE_REMOTE_PREREQS = "executeRemotePrereqs";

    public OipcuPrereqProps(String sPrereqPropFile, String sInputLoc, String sOutputLoc) throws OipccEndPrereqSessionException {
        try {
            String sPropFile = new File(sPrereqPropFile).getCanonicalPath();
            this.m_props = this.loadProperties(sPropFile);
            this.setConfigLoc(sInputLoc);
            this.setResultsLoc(sOutputLoc);
            this.setSystemProperties();
        }
        catch (IOException ioe) {
            throw new OipccEndPrereqSessionException(ioe.getMessage(), ioe);
        }
    }

    public OipcuPrereqProps(String sPrereqPropFile) throws OipccEndPrereqSessionException {
        try {
            String sDefaultLoc = System.getProperty("user.dir");
            this.m_props = this.loadProperties(sPrereqPropFile);
            this.setConfigLoc(sDefaultLoc);
            this.setResultsLoc(sDefaultLoc);
            this.setSystemProperties();
        }
        catch (IOException ioe) {
            throw new OipccEndPrereqSessionException(ioe.getMessage(), ioe);
        }
    }

    private void setSystemProperties() {
        String executeRemotePrereqs;
        String fixupEnable;
        String sAsmHost;
        String sAdvancedHost = this.getPropertyValue(S_PREREQ_ADVANCED_HOST);
        if (sAdvancedHost != null) {
            System.setProperty(S_PREREQ_ADVANCED_HOST_PROPERTY, sAdvancedHost);
        }
        if ((sAsmHost = this.getPropertyValue(S_PREREQ_ASM_HOST)) != null) {
            System.setProperty(S_PREREQ_ASM_HOST_PROPERTY, sAsmHost);
        }
        if ((fixupEnable = this.getPropertyValue(S_PREREQ_FIXUP_ENABLE)) != null) {
            System.setProperty("oracle.installer.fixUpEnable", fixupEnable);
        }
        if ((executeRemotePrereqs = this.getPropertyValue(S_EXECUTE_REMOTE_PREREQS)) != null) {
            System.setProperty("oracle.installer.executeRemotePrereqs", executeRemotePrereqs);
        }
    }

    public String getConfigLoc() {
        return this.m_sConfigLoc;
    }

    public String getResultsLoc() {
        return this.m_sResultsLoc;
    }

    void setConfigLoc(String sInputLoc) throws IOException {
        String sAbsLoc;
        this.m_sConfigLoc = sAbsLoc = OiixPathOps.getCanonicalPath((String)sInputLoc);
    }

    void setResultsLoc(String sOutputLoc) {
        String sAbsLoc;
        this.m_sResultsLoc = sAbsLoc = new File(sOutputLoc).getAbsolutePath();
    }

    public Collection getPrereqInputFiles() {
        Iterator oVal = this.getFilesListForProperty(S_PREREQ_INPUT_PROP_NAME);
        ArrayList<String> oFiles = new ArrayList<String>();
        if (oVal != null) {
            while (oVal.hasNext()) {
                oFiles.add(OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)this.getConfigLoc(), (String)((String)oVal.next()))));
            }
            oVal = null;
            return oFiles;
        }
        return null;
    }

    public String getPropertyValue(String sPropName) {
        return this.m_props.getProperty(sPropName);
    }

    public Enumeration getAllProps() {
        return this.m_props.propertyNames();
    }

    public Properties getProperties() {
        return this.m_props;
    }

    private Properties loadProperties(String sPropFile) throws IOException {
        Properties props = new Properties();
        props.load(new FileInputStream(sPropFile));
        return props;
    }

    public Iterator getFilesList() {
        ArrayList oFilesList = new ArrayList();
        String sPropVal = null;
        sPropVal = this.getPropertyValue(S_PREREQ_INPUT_PROP_NAME);
        if (sPropVal != null) {
            oFilesList.addAll(this.getFilesList(sPropVal));
        }
        if ((sPropVal = this.getPropertyValue(S_PREREQ_RULEMAP_PROP_NAME)) != null) {
            oFilesList.addAll(this.getFilesList(sPropVal));
        }
        if ((sPropVal = this.getPropertyValue(S_PREREQ_KNOWLEDGE_SOURCE_PROP_NAME)) != null) {
            oFilesList.addAll(this.getFilesList(sPropVal));
        }
        if ((sPropVal = this.getPropertyValue(S_PREREQ_JAVALIBS_PROP_NAME)) != null) {
            oFilesList.addAll(this.getFilesList(sPropVal));
        }
        if ((sPropVal = this.getPropertyValue(S_PREREQ_NATIVELIBS_PROP_NAME)) != null) {
            oFilesList.addAll(this.getFilesList(sPropVal));
        }
        if ((sPropVal = this.getPropertyValue(S_PREREQ_REF_FILES_PROP_NAME)) != null) {
            oFilesList.addAll(this.getFilesList(sPropVal));
        }
        if ((sPropVal = this.getPropertyValue(S_PREREQ_LINUX_VENDORS_PROP_NAME)) != null) {
            oFilesList.addAll(this.getFilesList(sPropVal));
        }
        if ((sPropVal = this.getPropertyValue(S_PREREQ_FIXUPMAP_PROP_NAME)) != null) {
            oFilesList.addAll(this.getFilesList(sPropVal));
        }
        if ((sPropVal = this.getPropertyValue(S_PREREQ_FIXUPFILES_PROP_NAME)) != null) {
            oFilesList.addAll(this.getFilesList(sPropVal));
        }
        return oFilesList.iterator();
    }

    public Iterator getFilesListForProperty(String sPropertyName) {
        String sPropVal = this.getPropertyValue(sPropertyName);
        if (sPropVal != null) {
            return this.getFilesList(sPropVal).iterator();
        }
        return null;
    }

    private Collection getFilesList(String sFileList) {
        return this.getCollectionForValue(sFileList);
    }

    private Collection getCollectionForValue(String sList) {
        String[] asList = OiixFunctionOps.explodeString((String)sList, (String)S_SEPARATOR);
        return OiixVectorOps.strArr2Vect((String[])asList);
    }

    private Collection getCollectionForProperty(String sPropName) {
        Collection oList = null;
        String sProps = this.getPropertyValue(sPropName);
        if (sProps != null) {
            oList = this.getCollectionForValue(sProps);
        }
        if (oList == null) {
            try {
                ResourceBundle oResBundle = ResourceBundle.getBundle(PREREQ_DEFAULT_PROPERTIES_FILE_NAME);
                sProps = oResBundle.getString(sPropName);
                if (sProps != null) {
                    oList = this.getCollectionForValue(sProps);
                }
            }
            catch (MissingResourceException oMre) {
                // empty catch block
            }
        }
        return oList;
    }

    private Collection getEntryPointSuffixCollection(String sModeType) {
        Collection oEntryList = this.getCollectionForProperty(sModeType);
        if (oEntryList == null) {
            return null;
        }
        ArrayList<String> oOutEntryList = new ArrayList<String>();
        Iterator oInEntryList = oEntryList.iterator();
        while (oInEntryList.hasNext()) {
            Collection oColl;
            String sEntryMode = (String)oInEntryList.next();
            char firstChar = sEntryMode.charAt(0);
            int iLastChar = (sEntryMode = sEntryMode.substring(1)).indexOf(firstChar);
            if (iLastChar != -1) {
                sEntryMode = sEntryMode.substring(0, iLastChar);
            }
            if (firstChar == '\"') {
                oOutEntryList.add(sEntryMode);
                continue;
            }
            if (firstChar != '%' || (oColl = this.getEntryPointSuffixCollection(sEntryMode)) == null) continue;
            oOutEntryList.addAll(oColl);
        }
        return oOutEntryList;
    }

    public Iterator getEntryPointSuffixList(String sModeType) {
        Collection oSuffix = this.getEntryPointSuffixCollection(sModeType);
        if (oSuffix != null) {
            return oSuffix.iterator();
        }
        return null;
    }
}

