/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.remoteinterfaces.clusterops;

import java.util.Hashtable;
import java.util.Map;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.prov.remoteinterfaces.clusterops.ClusterUnixOps;
import oracle.sysman.prov.remoteinterfaces.clusterops.ClusterWindowsOps;
import oracle.sysman.prov.remoteinterfaces.exception.ClusterException;
import oracle.sysman.prov.remoteinterfaces.exception.FatalException;
import oracle.sysman.prov.remoteinterfaces.exception.NodesAliveException;
import oracle.sysman.prov.remoteinterfaces.exception.PluginException;
import oracle.sysman.prov.remoteinterfaces.exception.RemoteFileOperationException;
import oracle.sysman.prov.remoteinterfaces.exception.RemoteShellFatalException;
import oracle.sysman.prov.remoteinterfaces.exception.SharedDeviceException;
import oracle.sysman.prov.remoteinterfaces.exception.UserEquivalenceException;
import oracle.sysman.prov.remoteinterfaces.nativesystem.NativeSystem;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Paths;
import oracle.sysman.prov.remoteinterfaces.nativesystem.RemoteExecutionEngine;
import oracle.sysman.prov.remoteinterfaces.nativesystem.SessionId;
import oracle.sysman.prov.remoteinterfaces.nativesystem.SystemFactory;
import oracle.sysman.prov.remoteinterfaces.nativesystem.UserPreferences;
import oracle.sysman.prov.remoteinterfaces.result.ClusterResult;

public class ClusterBaseOps {
    protected NativeSystem m_nativeSystem = null;
    SessionId m_sessionId = null;
    static Hashtable s_sessions = new Hashtable();
    static final int COUNT = 4;
    static final int BASE_OPS_INDEX = 0;
    static final int FILE_OPS_INDEX = 1;
    static final int UNIX_OPS_INDEX = 2;
    static final int WINDOWS_OPS_INDEX = 3;

    public static ClusterBaseOps getInstance(SessionId id) throws FatalException {
        ClusterBaseOps baseops = null;
        baseops = OiixPlatform.isPlatInGroup((int)-3, (int)SystemFactory.s_localPlatId) ? ClusterWindowsOps.getInstance() : ClusterUnixOps.getInstance();
        return baseops;
    }

    protected ClusterBaseOps(SessionId id) throws FatalException {
        this.m_sessionId = id;
        this.m_nativeSystem = SystemFactory.CreateNativeSystem(this.m_sessionId);
        this.m_nativeSystem.initSession(this.m_sessionId, SystemFactory.s_localPlatId);
        Object[] objs = (Object[])s_sessions.get(this.m_sessionId);
        if (objs == null) {
            objs = new ClusterBaseOps[4];
        }
        objs[0] = this;
        s_sessions.put(this.m_sessionId, objs);
    }

    public static ClusterBaseOps getInstance() throws FatalException {
        return ClusterBaseOps.getInstance(null);
    }

    public ClusterBaseOps() throws FatalException {
        this.m_sessionId = SessionId.getId();
        Object[] objs = (Object[])s_sessions.get(this.m_sessionId);
        ClusterBaseOps baseops = null;
        if (objs != null) {
            baseops = (ClusterBaseOps)objs[0];
        } else {
            objs = new ClusterBaseOps[4];
        }
        if (baseops == null) {
            this.m_nativeSystem = SystemFactory.CreateNativeSystem(this.m_sessionId);
            this.m_nativeSystem.initSession(this.m_sessionId, SystemFactory.s_localPlatId);
            objs[0] = this;
            s_sessions.put(this.m_sessionId, objs);
        } else {
            this.m_nativeSystem = baseops.m_nativeSystem;
        }
    }

    public static synchronized void registerPlugin(String pluginName) throws PluginException, FatalException {
        RemoteExecutionEngine.registerPlugin(pluginName);
    }

    public static synchronized void unRegisterPlugin(String pluginName) throws FatalException {
        RemoteExecutionEngine.unRegisterPlugin(pluginName);
    }

    public static String[] getAllRegisteredPlugins() {
        return RemoteExecutionEngine.getAllRegisteredPlugins();
    }

    public static boolean isRegistered(String pluginName) {
        return RemoteExecutionEngine.isRegistered(pluginName);
    }

    public static void setDefaultPlugin(String pluginName) throws PluginException, FatalException {
        RemoteExecutionEngine.setDefaultPlugin(pluginName);
    }

    public static String getDefaultPlugin() {
        return RemoteExecutionEngine.getDefaultPlugin();
    }

    public static boolean isDefaultPlugin(String pluginName) {
        return RemoteExecutionEngine.isDefaultPlugin(pluginName);
    }

    public ClusterResult runCmdOnNode(String cmd, String[] args, String[] env, String nodename) throws FatalException, ClusterException {
        return this.m_nativeSystem.runCmdOnNodes(this.m_sessionId, cmd, args, env, new String[]{nodename}, false);
    }

    public ClusterResult runCmdOnNodes(String cmd, String[] args, String[] env, String[] nodelist) throws FatalException, ClusterException {
        return this.m_nativeSystem.runCmdOnNodes(this.m_sessionId, cmd, args, env, nodelist, false);
    }

    public ClusterResult runCmdOnNodes(String cmd, String[] args, String[] env, String[] nodelist, boolean asNormalUser) throws FatalException, ClusterException {
        return this.m_nativeSystem.runCmdOnNodes(this.m_sessionId, cmd, args, env, nodelist, asNormalUser);
    }

    public ClusterResult runCmdOnLocalNode(String cmd) throws FatalException, ClusterException {
        return this.m_nativeSystem.runCmdOnLocalNode(this.m_sessionId, cmd);
    }

    public void startup(String[] remoteNodes) throws FatalException, ClusterException {
        this.startup(remoteNodes, null, null, null);
    }

    public void startup(String[] remoteNodes, UserPreferences preferences) throws FatalException, ClusterException {
        this.startup(remoteNodes, null, null, preferences);
    }

    public void startup(String[] remoteNodes, String username, String password) throws FatalException, ClusterException {
        this.startup(remoteNodes, username, password, null);
    }

    public void startup(String[] remoteNodes, String username, String password, UserPreferences preferences) throws FatalException, ClusterException {
        this.startup(remoteNodes, username, password, preferences, null);
    }

    private NativeSystem resetNativeSystem(String username, String password, UserPreferences preferences) throws FatalException {
        NativeSystem nativeSystem = null;
        if (SystemFactory.useWMI() && preferences != null && username != null && password != null && preferences.getPreference("REMOTENODES_PLATFORM") != null) {
            String remotePlatform = preferences.getPreference("REMOTENODES_PLATFORM");
            int remotePlatform_int = -1;
            if (remotePlatform != null) {
                try {
                    Integer obj = new Integer(remotePlatform);
                    remotePlatform_int = obj;
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if (remotePlatform_int != -1 && SystemFactory.s_localPlatId == remotePlatform_int && OiixPlatform.isPlatInGroup((int)-3, (int)SystemFactory.s_localPlatId)) {
                nativeSystem = SystemFactory.CreateNativeSystemWMI(this.m_sessionId);
                System.out.println("Ccreating WMI nativesystem");
            }
        }
        return nativeSystem;
    }

    public void startup(String[] remoteNodes, String username, String password, UserPreferences preferences, Map platInfo) throws FatalException, ClusterException {
        Object[] objs = (Object[])s_sessions.get(this.m_sessionId);
        ClusterBaseOps baseops = null;
        if (objs != null) {
            baseops = (ClusterBaseOps)objs[0];
        } else {
            objs = new ClusterBaseOps[4];
        }
        if (baseops == null) {
            this.m_nativeSystem = null;
            this.m_nativeSystem = this.resetNativeSystem(username, password, preferences);
            if (this.m_nativeSystem == null) {
                this.m_nativeSystem = SystemFactory.CreateNativeSystem(this.m_sessionId);
            }
            this.m_nativeSystem.initSession(this.m_sessionId, SystemFactory.s_localPlatId);
            objs[0] = this;
            s_sessions.put(this.m_sessionId, objs);
        }
        if (platInfo != null) {
            SystemFactory.setPlatformInfo(platInfo);
        }
        try {
            this.m_nativeSystem = this.resetNativeSystem(username, password, preferences);
            if (this.m_nativeSystem == null) {
                this.m_nativeSystem = SystemFactory.CreateNativeSystem(this.m_sessionId);
            }
            this.m_nativeSystem.startup(this.m_sessionId, remoteNodes, username, password, preferences);
        }
        catch (RemoteShellFatalException rsfe) {
            this.shutdown();
            throw rsfe;
        }
        catch (ClusterException ce) {
            this.shutdown();
            throw ce;
        }
    }

    public void shutdown(boolean no_Delete) {
        if (this.m_nativeSystem != null) {
            this.m_nativeSystem.shutdown(this.m_sessionId, no_Delete);
        }
        s_sessions.remove(this.m_sessionId);
        if (s_sessions.size() == 0) {
            SystemFactory.dispose();
        }
    }

    public void shutdown() {
        if (this.m_nativeSystem != null) {
            this.m_nativeSystem.shutdown(this.m_sessionId);
        }
        s_sessions.remove(this.m_sessionId);
        if (s_sessions.size() == 0) {
            SystemFactory.dispose();
        }
    }

    public Paths getLocalPaths() throws FatalException {
        return this.m_nativeSystem.getLocalPaths(this.m_sessionId);
    }

    public Paths getRemotePaths(String node) throws FatalException {
        return this.m_nativeSystem.getRemotePaths(this.m_sessionId, node);
    }

    public ClusterResult areNodesAlive(String[] nodeNames, int timeout) throws FatalException, NodesAliveException {
        return this.m_nativeSystem.areNodesAlive(this.m_sessionId, nodeNames, timeout);
    }

    public ClusterResult areNodesAliveEx(String[] nodeNames, int timeout, boolean usePing, boolean useSSH, boolean useRSH) throws FatalException, NodesAliveException {
        return this.m_nativeSystem.areNodesAliveEx(this.m_sessionId, nodeNames, timeout, usePing, useSSH, useRSH);
    }

    public ClusterResult getFreeSpaceOnNode(String node, String path) throws FatalException, ClusterException {
        return this.m_nativeSystem.getFreeSpaceOnNode(this.m_sessionId, node, path);
    }

    public ClusterResult isSharedPath(String pathName, String[] nodeNames) throws FatalException, RemoteFileOperationException, SharedDeviceException {
        return this.m_nativeSystem.isSharedPath(this.m_sessionId, pathName, nodeNames);
    }

    public ClusterResult validateUserEquivalence(String nodeName) throws FatalException, UserEquivalenceException {
        return this.m_nativeSystem.validateUserEquivalence(this.m_sessionId, new String[]{nodeName});
    }

    public ClusterResult validateUserEquivalence(String[] nodeNames) throws FatalException, UserEquivalenceException {
        return this.m_nativeSystem.validateUserEquivalence(this.m_sessionId, nodeNames);
    }

    public ClusterResult getHostNameForNode(String nodeName) throws FatalException, ClusterException {
        return this.m_nativeSystem.getHostNameForNode(this.m_sessionId, nodeName);
    }

    public ClusterResult validateSSHEquivalence(String nodeName) throws FatalException, UserEquivalenceException {
        return this.m_nativeSystem.validateSSHEquivalence(this.m_sessionId, new String[]{nodeName});
    }

    public ClusterResult validateSSHEquivalence(String[] nodeNames) throws FatalException, UserEquivalenceException {
        return this.m_nativeSystem.validateSSHEquivalence(this.m_sessionId, nodeNames);
    }

    public ClusterResult validateAdvancedSSHEquivalence(String username, String[] nodeNames) throws FatalException, UserEquivalenceException, ClusterException {
        return this.m_nativeSystem.validateAdvancedSSHEquivalence(this.m_sessionId, username, nodeNames);
    }

    public ClusterResult checkRSHServer(String[] nodeNames) throws FatalException, ClusterException {
        return this.m_nativeSystem.checkRSHServer(nodeNames);
    }

    public ClusterResult checkSSHServer(String[] nodeNames) throws FatalException, ClusterException {
        return this.m_nativeSystem.checkSSHServer(nodeNames);
    }

    public ClusterResult getNodesSyncInterval(String[] nodeNames) throws FatalException, ClusterException {
        return this.m_nativeSystem.getNodesSyncInterval(this.m_sessionId, nodeNames);
    }

    public ClusterResult validateRSHEquivalence(String nodeName) throws FatalException, UserEquivalenceException {
        return this.m_nativeSystem.validateRSHEquivalence(this.m_sessionId, new String[]{nodeName});
    }

    public ClusterResult validateRSHEquivalence(String[] nodeNames) throws FatalException, UserEquivalenceException {
        return this.m_nativeSystem.validateRSHEquivalence(this.m_sessionId, nodeNames);
    }

    public ClusterResult validateSSHEquivalence(String[] nodeNames, String username) throws FatalException, UserEquivalenceException {
        return this.m_nativeSystem.validateSSHEquivalence(this.m_sessionId, nodeNames, username);
    }

    public ClusterResult validateRSHEquivalence(String[] nodeNames, String username) throws FatalException, UserEquivalenceException {
        return this.m_nativeSystem.validateRSHEquivalence(this.m_sessionId, nodeNames, username);
    }

    public ClusterResult copyFileToNode(String fileName1, String nodeName) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyFileBetweenNodes(this.m_sessionId, "localhost", fileName1, nodeName, fileName1);
    }

    public ClusterResult copyFileToNodes(String fileName1, String[] nodeNames) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyFileToNodes(this.m_sessionId, fileName1, nodeNames, fileName1);
    }

    public ClusterResult copyFileToNode(String fileName1, String nodeName, String fileName2) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyFileBetweenNodes(this.m_sessionId, "localhost", fileName1, nodeName, fileName2);
    }

    public ClusterResult copyFileToNodes(String fileName1, String[] nodeNames, String fileName2) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyFileToNodes(this.m_sessionId, fileName1, nodeNames, fileName2);
    }

    public ClusterResult copyFileFromNode(String sourceNode, String sourceFile, String destFile) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyFileBetweenNodes(this.m_sessionId, sourceNode, sourceFile, "localhost", destFile);
    }

    public ClusterResult extractArchiveOnNode(String filename, String nodename, String destdir, int cmd) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.extractArchiveOnNode(this.m_sessionId, filename, nodename, destdir, cmd, true, null);
    }

    public ClusterResult extractArchiveOnNode(String filename, String nodename, String destdir, String unzipCmd) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.extractArchiveOnNode(this.m_sessionId, filename, nodename, destdir, 6, true, unzipCmd);
    }

    public ClusterResult copyDirToNode(String nodeName, String dirName) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyDirToNodes(this.m_sessionId, new String[]{nodeName}, dirName, dirName, null, null, true);
    }

    public ClusterResult copyDirToNodes(String[] nodeNames, String dirName) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyDirToNodes(this.m_sessionId, nodeNames, dirName, dirName, null, null, true);
    }

    public ClusterResult copyDirToNodes(String sourceDir, String[] nodeNames, String destDir) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyDirToNodes(this.m_sessionId, nodeNames, sourceDir, destDir, null, null, true);
    }

    public ClusterResult copyDirToNodes(String[] nodeNames, String dirName, String excludeListFile) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyDirToNodes(this.m_sessionId, nodeNames, dirName, dirName, excludeListFile, null, true);
    }

    public ClusterResult copyDirToNodes(String[] nodeNames, String dirName, String excludeListFile, String tmpDir) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyDirToNodes(this.m_sessionId, nodeNames, dirName, dirName, excludeListFile, tmpDir, true);
    }

    public ClusterResult copyDirToNodes(String[] nodeNames, String srcdir, String destdir, String excludeListFile, String tmpDir) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyDirToNodes(this.m_sessionId, nodeNames, srcdir, destdir, excludeListFile, tmpDir, true);
    }

    public ClusterResult copyDirContentsToNodes(String[] nodeNames, String dirName) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyDirToNodes(this.m_sessionId, nodeNames, dirName, dirName, null, null, false);
    }

    public ClusterResult copyDirContentsToNodes(String[] nodeNames, String srcDirName, String destDirName) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyDirToNodes(this.m_sessionId, nodeNames, srcDirName, destDirName, null, null, false);
    }

    public ClusterResult copyListedDirsToNode(String nodeName, String dirName, String copyListFile, String excludeListFile) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyListedPathsToNodes(this.m_sessionId, new String[]{nodeName}, dirName, copyListFile, excludeListFile, null, true);
    }

    public ClusterResult copyListedDirsToNodes(String[] nodeNames, String dirName, String copyListFile, String excludeListFile) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyListedPathsToNodes(this.m_sessionId, nodeNames, dirName, copyListFile, excludeListFile, null, true);
    }

    public ClusterResult copyListedDirsToNode(String nodeName, String dirName, String copyListFile, String excludeListFile, String tmpDir) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyListedPathsToNodes(this.m_sessionId, new String[]{nodeName}, dirName, copyListFile, excludeListFile, tmpDir, true);
    }

    public ClusterResult copyListedDirsToNodes(String[] nodeNames, String dirName, String copyListFile, String excludeListFile, String tmpDir) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyListedPathsToNodes(this.m_sessionId, nodeNames, dirName, copyListFile, excludeListFile, tmpDir, true);
    }

    public ClusterResult copyListedFilesToNode(String nodeName, String dirName, String copyListFile) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyListedPathsToNodes(this.m_sessionId, new String[]{nodeName}, dirName, copyListFile, null, null, true);
    }

    public ClusterResult copyListedFilesToNodes(String[] nodeNames, String dirName, String copyListFile) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyListedPathsToNodes(this.m_sessionId, nodeNames, dirName, copyListFile, null, null, true);
    }

    public ClusterResult copyListedFilesToNode(String nodeName, String dirName, String copyListFile, String tmpDir) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyListedPathsToNodes(this.m_sessionId, new String[]{nodeName}, dirName, copyListFile, null, tmpDir, true);
    }

    public ClusterResult copyListedFilesToNodes(String[] nodeNames, String dirName, String copyListFile, String tmpDir) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyListedPathsToNodes(this.m_sessionId, nodeNames, dirName, copyListFile, null, tmpDir, true);
    }

    public ClusterResult copyListedFilesToNode(String nodeName, String copyListFile) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyListedPathsToNodes(this.m_sessionId, new String[]{nodeName}, null, copyListFile, null, null, false);
    }

    public ClusterResult copyListedFilesToNodes(String[] nodeNames, String copyListFile) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyListedPathsToNodes(this.m_sessionId, nodeNames, null, copyListFile, null, null, false);
    }

    public ClusterResult createDirInNode(String nodeName, String dirName) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.createDirInNodes(this.m_sessionId, new String[]{nodeName}, dirName);
    }

    public ClusterResult createDirInNodes(String[] nodeNames, String dirName) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.createDirInNodes(this.m_sessionId, nodeNames, dirName);
    }

    public ClusterResult createListedDirsOnNode(String nodeName, String createListFile) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.createListedDirsOnNodes(this.m_sessionId, new String[]{nodeName}, createListFile, null, null);
    }

    public ClusterResult createListedDirsOnNodes(String[] nodeNames, String createListFile) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.createListedDirsOnNodes(this.m_sessionId, nodeNames, createListFile, null, null);
    }

    public ClusterResult createListedDirsOnNode(String nodeName, String createListFile, String parentDir) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.createListedDirsOnNodes(this.m_sessionId, new String[]{nodeName}, createListFile, parentDir, null);
    }

    public ClusterResult createListedDirsOnNodes(String[] nodeNames, String createListFile, String parentDir) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.createListedDirsOnNodes(this.m_sessionId, nodeNames, createListFile, parentDir, null);
    }

    public ClusterResult createListedDirsOnNode(String nodeName, String createListFile, String parentDir, String tmpDir) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.createListedDirsOnNodes(this.m_sessionId, new String[]{nodeName}, createListFile, parentDir, tmpDir);
    }

    public ClusterResult createListedDirsOnNodes(String[] nodeNames, String createListFile, String parentDir, String tmpDir) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.createListedDirsOnNodes(this.m_sessionId, nodeNames, createListFile, parentDir, tmpDir);
    }

    public ClusterResult createServiceOnNode(String nodeName, String servicePath, String serviceName, String serviceArgs) throws FatalException, ClusterException {
        return this.m_nativeSystem.createServiceOnNode(this.m_sessionId, nodeName, servicePath, serviceName, serviceArgs);
    }

    public ClusterResult removeServiceOnNode(String nodeName, String servicePath, String serviceName) throws FatalException, ClusterException {
        return this.m_nativeSystem.removeServiceOnNode(this.m_sessionId, nodeName, servicePath, serviceName);
    }

    public ClusterResult removeDirRecurseFromNode(String nodeName, String dirName) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.removeDirFromNodes(this.m_sessionId, new String[]{nodeName}, dirName, true, false);
    }

    public ClusterResult removeDirRecurseFromNodes(String[] nodeNames, String dirName) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.removeDirFromNodes(this.m_sessionId, nodeNames, dirName, true, false);
    }

    public ClusterResult removeDirFromNode(String nodeName, String dirName) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.removeDirFromNodes(this.m_sessionId, new String[]{nodeName}, dirName, false, false);
    }

    public ClusterResult removeDirFromNodes(String[] nodeNames, String dirName) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.removeDirFromNodes(this.m_sessionId, nodeNames, dirName, false, false);
    }

    public ClusterResult removeDirFromNode(String nodeName, String dirName, boolean deleteEmptyParent) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.removeDirFromNodes(this.m_sessionId, new String[]{nodeName}, dirName, false, deleteEmptyParent);
    }

    public ClusterResult removeDirFromNodes(String[] nodeNames, String dirName, boolean deleteEmptyParent) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.removeDirFromNodes(this.m_sessionId, nodeNames, dirName, false, deleteEmptyParent);
    }

    public ClusterResult dirExists(String node, String dir) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.pathExistsOnNode(this.m_sessionId, node, dir, 8);
    }

    public ClusterResult fileExists(String node, String file) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.pathExistsOnNode(this.m_sessionId, node, file, 9);
    }

    public ClusterResult isDirWritable(String node, String dir) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.isDirWritable(this.m_sessionId, node, dir);
    }

    public ClusterResult removeFileFromNode(String nodeName, String filename) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.removeFileFromNodes(this.m_sessionId, new String[]{nodeName}, filename);
    }

    public ClusterResult removeFileFromNodes(String[] nodeNames, String filename) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.removeFileFromNodes(this.m_sessionId, nodeNames, filename);
    }

    public ClusterResult removeListedFilesFromNode(String nodeName, String removeListFile) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.removeListedPathsFromNodes(this.m_sessionId, new String[]{nodeName}, removeListFile, 9);
    }

    public ClusterResult removeListedFilesFromNodes(String[] nodeNames, String removeListFile) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.removeListedPathsFromNodes(this.m_sessionId, nodeNames, removeListFile, 9);
    }

    public ClusterResult removeListedDirsFromNode(String nodeName, String removeListFile) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.removeListedPathsFromNodes(this.m_sessionId, new String[]{nodeName}, removeListFile, 8);
    }

    public ClusterResult removeListedDirsFromNodes(String[] nodeNames, String removeListFile) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.removeListedPathsFromNodes(this.m_sessionId, nodeNames, removeListFile, 8);
    }

    public ClusterResult moveFileOnNode(String node, String sourceFile, String destFile) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.moveFileOnNode(this.m_sessionId, node, sourceFile, destFile);
    }

    public ClusterResult listDirectoryOnNode(String nodeName, String dirPath) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.listDirectoryOnNode(this.m_sessionId, nodeName, dirPath);
    }

    public ClusterResult copyDirFromNodes(String[] nodeNames, String srcDir, String destDir, String tmpDir, boolean extractModificationTime) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyDirFromNodes(this.m_sessionId, nodeNames, srcDir, destDir, tmpDir, extractModificationTime);
    }

    public ClusterResult copyDirFromNodes(String[] nodeNames, String srcDir, String destDir) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyDirFromNodes(this.m_sessionId, nodeNames, srcDir, destDir, null, true);
    }

    public ClusterResult runRootCmdOnNode(String cmd, String[] args, String[] env, String password, String nodeName) throws FatalException, ClusterException {
        throw new FatalException("PROV-17000", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-17000"));
    }

    public ClusterResult runRootCmdOnLocalNode(String cmd, String[] args, String[] env, String password) throws FatalException, ClusterException {
        throw new FatalException("PROV-17000", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-17000"));
    }

    public ClusterResult runRootCmdOnNodes(String cmd, String[] args, String[] env, String password, String[] nodeNames) throws FatalException, ClusterException {
        throw new FatalException("PROV-17000", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-17000"));
    }

    public ClusterResult testSudoPbrun(String nodeName) throws FatalException, ClusterException {
        throw new FatalException("PROV-17000", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-17000"));
    }

    public ClusterResult createSymLinkOnNode(String node, String sourceFile, String destFile) throws FatalException, RemoteFileOperationException {
        throw new FatalException("PROV-17000", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-17000"));
    }

    public ClusterResult copyDirToNodes(String[] nodeNames, String dirName, boolean extractModificationTime) throws FatalException, RemoteFileOperationException {
        throw new FatalException("PROV-17000", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-17000"));
    }

    public ClusterResult extractArchiveOnNode(String filename, String nodename, String destdir, boolean extractModificationTime) throws FatalException, RemoteFileOperationException {
        throw new FatalException("PROV-17000", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-17000"));
    }
}

