/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.remoteinterfaces.clusterops;

import oracle.sysman.prov.remoteinterfaces.clusterops.ClusterBaseOps;
import oracle.sysman.prov.remoteinterfaces.exception.ClusterException;
import oracle.sysman.prov.remoteinterfaces.exception.FatalException;
import oracle.sysman.prov.remoteinterfaces.exception.RemoteFileOperationException;
import oracle.sysman.prov.remoteinterfaces.nativesystem.SessionId;
import oracle.sysman.prov.remoteinterfaces.nativesystem.UnixSystem;
import oracle.sysman.prov.remoteinterfaces.result.ClusterResult;

public class ClusterUnixOps
extends ClusterBaseOps {
    public static ClusterBaseOps getInstance(SessionId id) throws FatalException {
        if (id == null) {
            id = SessionId.getId();
        }
        Object[] objs = (Object[])s_sessions.get(id);
        ClusterUnixOps unixops = null;
        if (objs != null) {
            unixops = (ClusterUnixOps)objs[2];
        }
        if (unixops != null) {
            return unixops;
        }
        unixops = new ClusterUnixOps(id);
        return unixops;
    }

    public static ClusterBaseOps getInstance() throws FatalException {
        return ClusterUnixOps.getInstance(null);
    }

    protected ClusterUnixOps(SessionId id) throws FatalException {
        super(id);
        Object[] objs = (Object[])s_sessions.get(this.m_sessionId);
        objs[2] = this;
    }

    public ClusterUnixOps() throws FatalException {
        Object[] objs = (Object[])s_sessions.get(this.m_sessionId);
        ClusterUnixOps unixops = (ClusterUnixOps)objs[2];
        if (unixops == null) {
            objs[2] = this;
        }
    }

    public ClusterResult runRootCmdOnNode(String cmd, String[] args, String[] env, String password, String nodeName) throws FatalException, ClusterException {
        return this.m_nativeSystem.runRootCmdOnNodes(this.m_sessionId, cmd, args, env, password, new String[]{nodeName});
    }

    public ClusterResult runRootCmdOnLocalNode(String cmd, String[] args, String[] env, String password) throws FatalException, ClusterException {
        return ((UnixSystem)this.m_nativeSystem).runRootCmdOnLocalNode(this.m_sessionId, cmd, args, env, password);
    }

    public ClusterResult runRootCmdOnNodes(String cmd, String[] args, String[] env, String password, String[] nodeNames) throws FatalException, ClusterException {
        return this.m_nativeSystem.runRootCmdOnNodes(this.m_sessionId, cmd, args, env, password, nodeNames);
    }

    public ClusterResult testSudoPbrun(String nodeName) throws FatalException, ClusterException {
        return this.m_nativeSystem.testSudoPbrun(this.m_sessionId, nodeName);
    }

    public ClusterResult createSymLinkOnNode(String node, String sourceFile, String destFile) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.createSymLinkOnNode(this.m_sessionId, node, sourceFile, destFile);
    }

    public ClusterResult copyDirToNodes(String[] nodeNames, String dirName, boolean extractModificationTime) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyDirToNodes(this.m_sessionId, nodeNames, dirName, dirName, null, null, extractModificationTime);
    }

    public ClusterResult extractArchiveOnNode(String filename, String nodename, String destdir, boolean extractModificationTime) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.extractArchiveOnNode(this.m_sessionId, filename, nodename, destdir, 5, extractModificationTime, null);
    }

    public ClusterResult extractArchiveOnNode(String filename, String nodename, String destdir, boolean extractModificationTime, String unzipCmd) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.extractArchiveOnNode(this.m_sessionId, filename, nodename, destdir, 5, extractModificationTime, unzipCmd);
    }
}

