/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.remoteinterfaces.core;

import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.prov.remoteinterfaces.command.Command;
import oracle.sysman.prov.remoteinterfaces.core.ClientResource;
import oracle.sysman.prov.remoteinterfaces.core.Semaphore;
import oracle.sysman.prov.remoteinterfaces.core.SyncBuffer;
import oracle.sysman.prov.remoteinterfaces.exception.FatalException;
import oracle.sysman.prov.remoteinterfaces.logger.ClusterLogger;
import oracle.sysman.prov.remoteinterfaces.result.ClusterResult;
import oracle.sysman.prov.remoteinterfaces.result.CommandResult;
import oracle.sysman.prov.remoteinterfaces.result.GenericResult;

public class ClusterManager {
    private static SyncBuffer s_commandBuffer = null;
    private static ThreadGroup s_clusterThreadGroup = null;
    private static Vector s_workers = null;
    private static Hashtable s_clientThreadTable = null;
    private static Object s_lock = null;
    private static final int DEF_THREADPOOLSIZE = 32;
    private static final int DEF_THREADPOOLMAXSIZE = 256;
    private static final String THREADPOOLSIZE = "oracle.sysman.prov.threadpoolsize";
    private static final String THREADPOOL_MAXSIZE = "oracle.sysman.prov.threadpoolmaxsize";
    private static final String CLUSTER_THREAD_GROUP = "Cluster Thread Group";
    private static int s_threadCount = 0;

    public void init() {
        ClusterLogger.log("Entering ClusterManager.init()", ClusterLogger.LOG_FINER);
        if (s_clientThreadTable == null) {
            s_clientThreadTable = new Hashtable();
        }
        if (s_commandBuffer == null) {
            s_commandBuffer = new SyncBuffer();
        }
        if (s_clusterThreadGroup == null) {
            s_clusterThreadGroup = new ThreadGroup(CLUSTER_THREAD_GROUP);
        }
        if (s_workers == null) {
            s_workers = new Vector();
        }
        if (s_lock == null) {
            s_lock = new Object();
        }
        if (s_threadCount == 0) {
            s_threadCount = Integer.getInteger(THREADPOOLSIZE, 32);
            ClusterLogger.log("Creating " + s_threadCount + " worker threads ", ClusterLogger.LOG_FINER);
            for (int i = 0; i < s_threadCount; ++i) {
                ExecuteCommand worker = new ExecuteCommand(s_clusterThreadGroup, "Worker " + i, i);
                s_workers.add(worker);
                worker.start();
            }
        }
    }

    public void dispose() {
        ClusterLogger.log("Entering ClusterManager.dispose()", ClusterLogger.LOG_FINER);
        if (s_clusterThreadGroup != null) {
            Thread[] activelist = new ExecuteCommand[s_threadCount];
            int num = s_clusterThreadGroup.enumerate(activelist);
            ClusterLogger.log("Number of active worker threads: " + num, ClusterLogger.LOG_FINEST);
            s_clusterThreadGroup.interrupt();
            for (int i = 0; i < num; ++i) {
                try {
                    ClusterLogger.log("Waiting for worker thread " + activelist[i].getName() + " to die", ClusterLogger.LOG_FINEST);
                    activelist[i].join();
                    activelist[i] = null;
                    continue;
                }
                catch (InterruptedException e) {
                    ClusterLogger.log(e.getMessage());
                }
            }
            try {
                s_clusterThreadGroup.destroy();
            }
            catch (IllegalThreadStateException itse) {
                ClusterLogger.log(itse);
                System.out.println("active Count" + s_clusterThreadGroup.activeCount());
            }
            activelist = null;
            s_workers.clear();
            s_threadCount = 0;
        }
        if (s_commandBuffer != null && s_clientThreadTable != null) {
            ClientResource clientResource = null;
            Command commandObj = null;
            int numCommands = s_commandBuffer.getCount();
            for (int i = 0; i < numCommands; ++i) {
                try {
                    Semaphore blockingSemaphore;
                    commandObj = (Command)s_commandBuffer.get();
                    if (commandObj == null || (clientResource = (ClientResource)s_clientThreadTable.get(commandObj.getOwnerThread())) == null || (blockingSemaphore = clientResource.getSemaphore()) == null) continue;
                    ClusterLogger.log("Blocking semaphore is not null.", ClusterLogger.LOG_FINEST);
                    blockingSemaphore.release();
                    continue;
                }
                catch (Exception e) {
                    ClusterLogger.log("exception while getting command object");
                }
            }
        }
        s_clientThreadTable = null;
        s_commandBuffer = null;
        s_clusterThreadGroup = null;
        s_workers = null;
        s_lock = null;
    }

    public ClusterManager(boolean init) {
    }

    public ClusterManager() {
        Object object = s_clientThreadTable.get(Thread.currentThread());
        if (object == null) {
            s_clientThreadTable.put(Thread.currentThread(), new ClientResource());
        }
    }

    public ClusterResult submit(Command[] commandVector) throws FatalException {
        ClientResource clientResource = (ClientResource)s_clientThreadTable.get(Thread.currentThread());
        clientResource.init();
        int num = 0;
        try {
            num = s_commandBuffer.put(commandVector);
        }
        catch (InterruptedException ie) {
            throw new FatalException(ie);
        }
        int bufSize = s_commandBuffer.getCount();
        int numThr = 0;
        int maxPoolSize = Integer.getInteger(THREADPOOL_MAXSIZE, 256);
        ClusterLogger.log("number of elements inserted into the commandBuffer: " + num, ClusterLogger.LOG_FINER);
        ClusterLogger.log("cmdBufferSize: " + bufSize, ClusterLogger.LOG_FINER);
        ClusterLogger.log("maxThreadPoolSize " + maxPoolSize, ClusterLogger.LOG_FINER);
        ClusterLogger.log("currentThreadPoolSize " + s_threadCount, ClusterLogger.LOG_FINER);
        if (bufSize > s_threadCount && maxPoolSize > s_threadCount) {
            numThr = bufSize - maxPoolSize > 0 ? maxPoolSize - s_threadCount : bufSize - s_threadCount;
            ClusterLogger.log("Creating " + numThr + " more worker threads." + " Total no. of worker threads =  " + (s_threadCount += numThr), ClusterLogger.LOG_FINER);
            for (int i = 0; i < numThr; ++i) {
                ExecuteCommand worker = new ExecuteCommand(s_clusterThreadGroup, "Worker " + (s_threadCount + i), s_threadCount + i);
                s_workers.add(worker);
                worker.start();
            }
        }
        Semaphore blockingSemaphore = clientResource.getSemaphore();
        try {
            for (int i = 0; i < num; ++i) {
                blockingSemaphore.acquire();
            }
        }
        catch (InterruptedException ie) {
            throw new FatalException(ie);
        }
        Map results = clientResource.getBuffer();
        GenericResult clusterResult = new GenericResult(results);
        clientResource.destroy();
        return clusterResult;
    }

    private class ExecuteCommand
    extends Thread {
        private int id;

        ExecuteCommand(ThreadGroup group, String name, int x) {
            super(group, name);
            this.id = x;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Command commandObj = null;
            CommandResult result = null;
            Map results = null;
            ClientResource clientResource = null;
            while (true) {
                Semaphore blockingSemaphore;
                try {
                    while (true) {
                        commandObj = (Command)s_commandBuffer.get();
                        if (this.isInterrupted()) {
                            ClusterLogger.log("Got interrupted.. Worker thread id: " + this.id);
                            throw new InterruptedException(OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-13000", (Object[])new String[]{"Cluster Thread Group: Worker " + this.id}));
                        }
                        if (commandObj == null) {
                            ClusterLogger.log("Command Object Null. Worker Thread id: " + this.id, ClusterLogger.LOG_SEVERE);
                            return;
                        }
                        result = commandObj.execute();
                        clientResource = (ClientResource)s_clientThreadTable.get(commandObj.getOwnerThread());
                        if (clientResource == null) {
                            ClusterLogger.log("ClientResource NULL. Worker Thread id: " + this.id + " Owner thread: " + commandObj.getOwnerThread().getName(), ClusterLogger.LOG_SEVERE);
                            return;
                        }
                        Object object = s_lock;
                        synchronized (object) {
                            results = clientResource.getBuffer();
                            if (results != null) {
                                results.put(commandObj.getNodeName(), result);
                            }
                        }
                        Semaphore blockingSemaphore2 = clientResource.getSemaphore();
                        blockingSemaphore2.release();
                    }
                }
                catch (InterruptedException e) {
                    ClusterLogger.log("Thread got interrupted. returning from run(). Worker Thread id: " + this.id);
                    if (commandObj != null && (clientResource = (ClientResource)s_clientThreadTable.get(commandObj.getOwnerThread())) != null && (blockingSemaphore = clientResource.getSemaphore()) != null) {
                        ClusterLogger.log("Blocking semaphore is not null.", ClusterLogger.LOG_FINEST);
                        blockingSemaphore.release();
                    }
                    return;
                }
                catch (Exception e) {
                    ClusterLogger.log(e);
                    ClusterLogger.log("Exception caught while trying to execute in thread: " + this.id + "\n" + e.getMessage(), ClusterLogger.LOG_SEVERE);
                    if (commandObj == null) {
                        return;
                    }
                    try {
                        clientResource = (ClientResource)s_clientThreadTable.get(commandObj.getOwnerThread());
                        if (clientResource == null) {
                            ClusterLogger.log("ClientResource NULL. Worker Thread id: " + this.id + " Owner thread: " + commandObj.getOwnerThread().getName(), ClusterLogger.LOG_SEVERE);
                            continue;
                        }
                        blockingSemaphore = clientResource.getSemaphore();
                        blockingSemaphore.release();
                        continue;
                    }
                    catch (Exception e1) {
                        ClusterLogger.log(e1);
                        ClusterLogger.log("Worker Thread id: " + this.id + "\n error message: " + e1.getMessage(), ClusterLogger.LOG_SEVERE);
                        continue;
                    }
                }
                break;
            }
        }
    }
}

