/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.remoteinterfaces.core;

import oracle.sysman.prov.remoteinterfaces.logger.ClusterLogger;

public class Semaphore {
    private int m_count;
    private String m_semid;

    public Semaphore(int initialCount, String name) {
        this.m_count = initialCount;
        this.m_semid = name;
    }

    public synchronized void release() {
        ++this.m_count;
        ClusterLogger.log(this.m_semid + ":Release called by thread " + Thread.currentThread().getName() + " m_count=" + this.m_count);
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Semaphore semaphore = this;
        synchronized (semaphore) {
            ClusterLogger.log(this.m_semid + ":Acquire called by thread " + Thread.currentThread().getName() + " m_count=" + this.m_count);
            try {
                while (this.m_count <= 0) {
                    this.wait();
                }
                --this.m_count;
            }
            catch (InterruptedException ie) {
                this.notify();
                throw ie;
            }
        }
    }

    public String getID() {
        return this.m_semid;
    }
}

