/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.remoteinterfaces.nativesystem;

import java.io.File;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.prov.remoteinterfaces.exception.FatalException;

public class Assertions {
    public static final void assertList(String[] nodeList) throws FatalException {
        if (nodeList == null || nodeList.length == 0) {
            throw new FatalException("PROV-16001", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16001"));
        }
        for (int i = 0; i < nodeList.length; ++i) {
            if (nodeList[i] != null && nodeList[i].trim().length() != 0) continue;
            throw new FatalException("PROV-16017", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16017"));
        }
    }

    public static final void assertName(String name) throws FatalException {
        if (name == null || name.trim().length() == 0) {
            throw new FatalException("PROV-16001", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16001"));
        }
    }

    public static final void validatePath(String path) throws FatalException {
        if (path != null && path.trim().length() != 0) {
            File file = new File(path);
            if (!file.exists()) {
                throw new FatalException("PROV-16000", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16000", (Object[])new String[]{path}));
            }
        } else {
            throw new FatalException("PROV-16001", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16001"));
        }
    }

    public static final void isDirWritable(String path) throws FatalException {
        if (path != null && path.trim().length() != 0) {
            File file = new File(path);
            if (!file.canWrite()) {
                throw new FatalException("PROV-16019", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"ERROR_PATH_WRITABLE_ON_LOCALNODE", (Object[])new String[]{path}));
            }
        } else {
            throw new FatalException("PROV-16001", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16001"));
        }
    }

    public static final void canRead(String path) throws FatalException {
        if (path != null && path.trim().length() != 0) {
            File file = new File(path);
            if (!file.canRead()) {
                throw new FatalException("PROV-16020", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16020", (Object[])new String[]{path}));
            }
        } else {
            throw new FatalException("PROV-16001", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16001"));
        }
    }

    public static final void assertHome(String oracleHome) throws FatalException {
        if (oracleHome == null || oracleHome.trim().length() == 0) {
            throw new FatalException("PROV-16001", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16001"));
        }
        if (!new File(oracleHome).isDirectory()) {
            throw new FatalException("PROV-16034", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16034", (Object[])new String[]{oracleHome}));
        }
    }
}

