/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.remoteinterfaces.nativesystem;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.prov.remoteinterfaces.cluster.NodeInfo;
import oracle.sysman.prov.remoteinterfaces.exception.FatalException;
import oracle.sysman.prov.remoteinterfaces.exception.PluginException;
import oracle.sysman.prov.remoteinterfaces.logger.ClusterLogger;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Assertions;
import oracle.sysman.prov.remoteinterfaces.nativesystem.NativeSystem;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Paths;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Session;
import oracle.sysman.prov.remoteinterfaces.nativesystem.SessionId;
import oracle.sysman.prov.remoteinterfaces.plugins.RemoteCommand;
import oracle.sysman.prov.remoteinterfaces.result.CommandResult;

public class RemoteExecutionEngine {
    private static LinkedList plugins_list = new LinkedList();
    private static boolean WRITE_STDOUT = true;
    private static String DEFAULT_PLUGIN = "oracle.sysman.prov.remoteinterfaces.plugins.RemoteCommandSSH";
    private static Map plugins_class_map = new HashMap();

    private boolean checkPluginCompatibility(String pluginName) throws PluginException {
        try {
            RemoteCommand rc = this.getPluginObject(pluginName);
        }
        catch (ClassCastException cce) {
            ClusterLogger.log(cce, ClusterLogger.LOG_INFO);
            ClusterLogger.log("Plugin : " + pluginName + "is not compatible with Remote Interfaces", ClusterLogger.LOG_INFO, WRITE_STDOUT);
            this.wrapPluginException(pluginName, "PROV-16050");
        }
        return true;
    }

    private RemoteCommand getPluginObject(String pluginName) throws PluginException {
        RemoteCommand rc = null;
        Class cl = (Class)plugins_class_map.get(pluginName);
        try {
            rc = (RemoteCommand)cl.newInstance();
        }
        catch (InstantiationException ie) {
            ClusterLogger.log(ie, ClusterLogger.LOG_INFO);
            this.wrapPluginException(pluginName, "PROV-16050");
        }
        catch (IllegalAccessException iae) {
            ClusterLogger.log(iae, ClusterLogger.LOG_INFO);
            this.wrapPluginException(pluginName, "PROV-16050");
        }
        return rc;
    }

    private RemoteCommand getDefaultPluginObject() {
        Class<?> cl = null;
        try {
            cl = Class.forName(RemoteExecutionEngine.getDefaultPlugin());
        }
        catch (ClassNotFoundException cne) {
            ClusterLogger.log(cne, ClusterLogger.LOG_INFO);
            ClusterLogger.log("Default plugin  not found in class path ", ClusterLogger.LOG_INFO, WRITE_STDOUT);
        }
        RemoteCommand rc = null;
        try {
            rc = (RemoteCommand)cl.newInstance();
        }
        catch (InstantiationException ie) {
            ClusterLogger.log(ie, ClusterLogger.LOG_INFO);
        }
        catch (IllegalAccessException iae) {
            ClusterLogger.log(iae, ClusterLogger.LOG_INFO);
        }
        return rc;
    }

    private String wrapPluginException(String pluginName, String exceptionType) throws PluginException {
        Object[] args = new String[]{pluginName};
        String errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)exceptionType, (Object[])args);
        throw new PluginException(exceptionType, errorMessage);
    }

    private static synchronized boolean checkPluginAvailability(String pluginName) throws PluginException {
        Class<?> cl = null;
        try {
            cl = Class.forName(pluginName);
        }
        catch (ClassNotFoundException cne) {
            ClusterLogger.log(cne, ClusterLogger.LOG_INFO);
            ClusterLogger.log("Plugin : " + pluginName + " not found in class path ", ClusterLogger.LOG_INFO, WRITE_STDOUT);
            return false;
        }
        ClusterLogger.log("Plugin : " + pluginName + " found in class path ", ClusterLogger.LOG_INFO, WRITE_STDOUT);
        plugins_class_map.put(pluginName, cl);
        return true;
    }

    public static synchronized void registerPlugin(String pluginName) throws PluginException, FatalException {
        Assertions.assertName(pluginName);
        RemoteExecutionEngine r_eng = new RemoteExecutionEngine();
        if (!plugins_list.contains(pluginName)) {
            if (RemoteExecutionEngine.checkPluginAvailability(pluginName)) {
                if (r_eng.checkPluginCompatibility(pluginName)) {
                    ClusterLogger.log("Registering Plugin : " + pluginName, ClusterLogger.LOG_INFO, WRITE_STDOUT);
                    plugins_list.addLast(pluginName);
                } else {
                    r_eng.wrapPluginException(pluginName, "PROV-16050");
                }
            } else {
                r_eng.wrapPluginException(pluginName, "PROV-16051");
            }
        }
    }

    public static synchronized void unRegisterPlugin(String pluginName) throws FatalException {
        Assertions.assertName(pluginName);
        if (plugins_list.contains(pluginName)) {
            ClusterLogger.log("UnRegistering Plugin : " + pluginName, ClusterLogger.LOG_INFO, WRITE_STDOUT);
            plugins_list.remove(pluginName);
            if (plugins_class_map.containsKey(pluginName)) {
                plugins_class_map.remove(pluginName);
            }
        }
    }

    public static String[] getAllRegisteredPlugins() {
        if (plugins_list.size() > 0) {
            return plugins_list.toArray(new String[0]);
        }
        return null;
    }

    public static boolean isRegistered(String pluginName) {
        if (pluginName == null) {
            return false;
        }
        return plugins_list != null && plugins_list.size() > 0 && plugins_list.contains(pluginName);
    }

    public static void setDefaultPlugin(String pluginName) throws PluginException, FatalException {
        Assertions.assertName(pluginName);
        RemoteExecutionEngine r_eng = new RemoteExecutionEngine();
        if (RemoteExecutionEngine.checkPluginAvailability(pluginName) && r_eng.checkPluginCompatibility(pluginName)) {
            ClusterLogger.log(" Changing Default Plugin from  : " + DEFAULT_PLUGIN + " to : " + pluginName, ClusterLogger.LOG_INFO, WRITE_STDOUT);
            DEFAULT_PLUGIN = pluginName;
        }
    }

    public static String getDefaultPlugin() {
        RemoteExecutionEngine r_eng = new RemoteExecutionEngine();
        return DEFAULT_PLUGIN;
    }

    public static boolean isDefaultPlugin(String pluginName) {
        if (pluginName == null) {
            return false;
        }
        RemoteExecutionEngine r_eng = new RemoteExecutionEngine();
        return pluginName.trim().equals(DEFAULT_PLUGIN.trim());
    }

    private RemoteCommand findPlugin(NodeInfo nodeinfo) throws PluginException {
        if (nodeinfo == null) {
            System.out.println("nodeinfo is null");
        }
        if (nodeinfo.getSessionId() == null) {
            System.out.println("find Plugin nodeinfo.getSessionid() is null");
        }
        SessionId sess_id = nodeinfo.getSessionId();
        RemoteCommand rce = null;
        nodeinfo.getNativeSystem();
        Map sessions = NativeSystem.getSessions();
        Session sess = (Session)sessions.get(sess_id);
        String pluginName = sess.getPreference("REMOTE_COMMAND_PLUGIN_NAME");
        if (pluginName != null) {
            ClusterLogger.log(" Session Preferences pluginName value  : " + pluginName, ClusterLogger.LOG_INFO, false);
            if (RemoteExecutionEngine.isRegistered(pluginName)) {
                ClusterLogger.log(" Plugin  : " + pluginName + " is Registered Plugin for current session ", ClusterLogger.LOG_INFO, false);
                rce = this.getPluginObject(pluginName);
            } else if (RemoteExecutionEngine.isDefaultPlugin(pluginName)) {
                ClusterLogger.log(" Plugin  : " + pluginName + " is default Plugin for current session : ", ClusterLogger.LOG_INFO, false);
                rce = this.getDefaultPluginObject();
            } else {
                ClusterLogger.log(" Plugin  : " + pluginName + " is neither a Registered Plugin nor Default Plugin", ClusterLogger.LOG_INFO, WRITE_STDOUT);
                this.wrapPluginException(pluginName, "PROV-16050");
            }
        } else {
            ClusterLogger.log(" Plugin  : " + pluginName + " is not found in session; using default plugin :" + RemoteExecutionEngine.getDefaultPlugin(), ClusterLogger.LOG_INFO, WRITE_STDOUT);
            rce = this.getDefaultPluginObject();
        }
        return rce;
    }

    public CommandResult runcmd(NodeInfo nodeinfo, String[] cmdarr, String[] input, String[] env, boolean bSsh) {
        RemoteCommand rc = null;
        try {
            if (nodeinfo == null) {
                System.out.println("runcmd nodeinfo is null");
            }
            rc = this.findPlugin(nodeinfo);
        }
        catch (PluginException pe) {
            ClusterLogger.log(" Plugin  :  is a Bad Plugin for Remote Interfaces ", ClusterLogger.LOG_INFO, WRITE_STDOUT);
            ClusterLogger.log(" Using default plugin", ClusterLogger.LOG_INFO, WRITE_STDOUT);
            rc = this.getDefaultPluginObject();
        }
        return rc.runcmd(nodeinfo, cmdarr, input, env, bSsh);
    }

    public CommandResult copyFile(NodeInfo nodeinfo1, String file1, NodeInfo nodeinfo2, String file2) {
        RemoteCommand rc = null;
        try {
            rc = this.findPlugin(nodeinfo1);
        }
        catch (PluginException pe) {
            ClusterLogger.log(" Plugin  : is a Bad Plugin for Remote Interfaces ", ClusterLogger.LOG_INFO, WRITE_STDOUT);
            ClusterLogger.log(" Using default plugin", ClusterLogger.LOG_INFO, WRITE_STDOUT);
            rc = this.getDefaultPluginObject();
        }
        return rc.copyFile(nodeinfo1, file1, nodeinfo2, file2);
    }

    public CommandResult runCmdWithoutWait(NodeInfo nodeinfo, String[] cmdArr, boolean bSsh) {
        RemoteCommand rc = null;
        try {
            rc = this.findPlugin(nodeinfo);
        }
        catch (PluginException pe) {
            ClusterLogger.log(" Plugin  : is a Bad Plugin for Remote Interfaces ", ClusterLogger.LOG_INFO, WRITE_STDOUT);
            ClusterLogger.log(" Using default plugin", ClusterLogger.LOG_INFO, WRITE_STDOUT);
            rc = this.getDefaultPluginObject();
        }
        return rc.runCmdWithoutWait(nodeinfo, cmdArr, bSsh);
    }

    private RemoteCommand findPluginForNode(NodeInfo nodeinfo) {
        RemoteCommand rc = null;
        try {
            rc = this.findPlugin(nodeinfo);
        }
        catch (PluginException pe) {
            ClusterLogger.log(" Plugin  :  is a Bad Plugin for Remote Interfaces ", ClusterLogger.LOG_INFO, WRITE_STDOUT);
            ClusterLogger.log(" Using default plugin", ClusterLogger.LOG_INFO, WRITE_STDOUT);
            rc = this.getDefaultPluginObject();
        }
        return rc;
    }

    private RemoteCommand findPluginForNode(Session sess, String node) {
        NodeInfo nodeinfo = sess.getNodeInfo(node);
        if (nodeinfo == null) {
            nodeinfo = sess.getLocalNodeInfo();
        }
        return this.findPluginForNode(nodeinfo);
    }

    public String[] formulateCmd(boolean bsSh, Session sess, String node, Paths paths, String cmd, String cmdArgs, String nodePrefix) {
        RemoteCommand rc = null;
        rc = this.findPluginForNode(sess, node);
        return rc.formulateCmd(bsSh, sess, node, paths, cmd, cmdArgs, nodePrefix);
    }

    public String[] formulateCmd(String key, boolean bsSh, Session sess, String node, Paths paths, String cmd, String cmdArgs) {
        RemoteCommand rc = null;
        rc = this.findPluginForNode(sess, node);
        return rc.formulateCmd(key, bsSh, sess, node, paths, cmd, cmdArgs);
    }

    public String[] formulateCmd(String key, Session sess, String node, Paths paths, String cmd, String cmdArgs, String sudoPath, String sudoArgs) {
        RemoteCommand rc = null;
        rc = this.findPluginForNode(sess, node);
        return rc.formulateCmd(key, sess, node, paths, cmd, cmdArgs, sudoPath, sudoArgs);
    }

    public String[] formulateCmd(Session sess, boolean bSsh, String node, Paths paths, String remoteShellPath, String remoteShellArgs, String cmd, String cmdArgs, String nodePrefix) {
        RemoteCommand rc = null;
        rc = this.findPluginForNode(sess, node);
        return rc.formulateCmd(bSsh, node, paths, remoteShellPath, remoteShellArgs, cmd, cmdArgs, nodePrefix);
    }

    public String[] formulateCmd(Session sess, boolean bSsh, String node, Paths paths, String remoteShellPath, String remoteShellArgs, String cmd, String cmdArgs, String nodePrefix, String username) {
        RemoteCommand rc = null;
        rc = this.findPluginForNode(sess, node);
        return rc.formulateCmd(bSsh, node, paths, remoteShellPath, remoteShellArgs, cmd, cmdArgs, nodePrefix, username);
    }

    public String formulateCmd(Session sess, NodeInfo nodeinfo, String key, String dirpath, String flag, Paths paths) {
        RemoteCommand rc = null;
        rc = this.findPluginForNode(nodeinfo);
        return rc.formulateCmd(paths, key, dirpath, flag);
    }

    public String[] formulateCmd(String key, boolean bsSh, Session sess, String node, Paths paths, String cmd, String cmdArgs, String username) {
        RemoteCommand rc = null;
        rc = this.findPluginForNode(sess, node);
        return rc.formulateCmd(key, bsSh, sess, node, paths, cmd, cmdArgs, username);
    }

    public String[] formulateLocalCmd(Session sess, String key, String node, String cmd, String cmdArgs) {
        RemoteCommand rc = null;
        if (sess == null) {
            System.out.println("sess is null");
        }
        System.out.println("formulateLocalCmd " + node + cmd + cmdArgs);
        rc = this.findPluginForNode(sess, node);
        return rc.formulateLocalCmd(key, node, cmd, cmdArgs);
    }
}

