/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.remoteinterfaces.nativesystem;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import oracle.sysman.prov.remoteinterfaces.cluster.NodeInfo;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Commands;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Paths;
import oracle.sysman.prov.remoteinterfaces.nativesystem.RemoteExecutionEngine;
import oracle.sysman.prov.remoteinterfaces.nativesystem.SessionId;
import oracle.sysman.prov.remoteinterfaces.nativesystem.UserPreferences;

public class Session {
    private SessionId m_sessionId = null;
    private UserPreferences m_userPrefs = new UserPreferences();
    private String m_sUsername = null;
    private String m_sPassword = null;
    private boolean m_bIsUserShellSpecified = false;
    private boolean m_bIsUserShellSsh = true;
    private boolean m_bSsh = false;
    private boolean m_bRsh = false;
    private String m_sRshPath = null;
    private String m_sRcpPath = null;
    private String m_sSshPath = null;
    private String m_sScpPath = null;
    private String m_sRshArgs = null;
    private String m_sRcpArgs = null;
    private String m_sSshArgs = null;
    private String m_sScpArgs = null;
    private boolean m_bFallbackToRSH = false;
    private String m_sLoginShell = null;
    private String r_pluginName = null;
    private int m_nRemoteNodesPlatform = -1;
    private boolean m_startupDone = false;
    private Commands m_commands = null;
    private NodeInfo m_localNodeInfo = null;
    private Paths m_localpaths = null;
    private Map m_nodeRemoteShell = new Hashtable();
    private boolean m_localnodeSetupDone = false;
    private String m_remotePathsLoc = null;
    private RemoteExecutionEngine r_eng = null;

    Session(SessionId id) {
        this.m_sessionId = id;
    }

    SessionId getSessionId() {
        return this.m_sessionId;
    }

    public String getPreference(String key) {
        return this.m_userPrefs.getPreference(key);
    }

    public void setPreference(String key, String value) {
        this.m_userPrefs.setPreference(key, value);
    }

    void setUserPrefs(UserPreferences userPrefs) {
        this.m_userPrefs = userPrefs;
    }

    public String getUsername() {
        return this.m_sUsername;
    }

    void setUsername(String username) {
        this.m_sUsername = username;
    }

    public boolean isUserNameSet() {
        return this.m_sUsername != null;
    }

    public String getPassword() {
        return this.m_sPassword;
    }

    void setPassword(String password) {
        this.m_sPassword = password;
    }

    public boolean isPasswordSet() {
        return this.m_sPassword != null;
    }

    public boolean isUserShellSpecified() {
        return this.m_bIsUserShellSpecified;
    }

    public void setUserShellSpecified(boolean userShellSpecified) {
        this.m_bIsUserShellSpecified = userShellSpecified;
    }

    boolean isUserShellSsh() {
        return this.m_bIsUserShellSsh;
    }

    void setIsUserShellSsh(boolean isUserShellSsh) {
        this.m_bIsUserShellSsh = isUserShellSsh;
    }

    public String getRshPath() {
        return this.m_sRshPath;
    }

    public String getSshPath() {
        return this.m_sSshPath;
    }

    public String getRcpPath() {
        return this.m_sRcpPath;
    }

    public String getScpPath() {
        return this.m_sScpPath;
    }

    public String getRshArgs() {
        return this.m_sRshArgs;
    }

    public String getSshArgs() {
        return this.m_sSshArgs;
    }

    void setRshPath(String rshPath) {
        this.m_sRshPath = rshPath;
    }

    void setRcpPath(String rcpPath) {
        this.m_sRcpPath = rcpPath;
    }

    void setSshPath(String sshPath) {
        this.m_sSshPath = sshPath;
    }

    void setScpPath(String scpPath) {
        this.m_sScpPath = scpPath;
    }

    boolean isSsh() {
        return this.m_bSsh;
    }

    void setSsh(boolean ssh) {
        this.m_bSsh = ssh;
    }

    boolean isRsh() {
        return this.m_bRsh;
    }

    void setRsh(boolean rsh) {
        this.m_bRsh = rsh;
    }

    void setRshArgs(String args) {
        this.m_sRshArgs = args;
        if (this.m_sUsername != null) {
            this.m_sRshArgs = this.m_sRshArgs + " -l " + this.m_sUsername;
        }
    }

    void setSshArgs(String args) {
        this.m_sSshArgs = args;
        if (this.m_sUsername != null) {
            this.m_sSshArgs = this.m_sSshArgs + " -l " + this.m_sUsername;
        }
    }

    public String getRcpArgs() {
        return this.m_sRcpArgs;
    }

    void setRcpArgs(String args) {
        this.m_sRcpArgs = args;
    }

    public String getScpArgs() {
        return this.m_sScpArgs;
    }

    void setScpArgs(String args) {
        this.m_sScpArgs = args;
    }

    boolean isFallbackToRSH() {
        return this.m_bFallbackToRSH;
    }

    void setFallbackToRSH(boolean fallbackToRSH) {
        this.m_bFallbackToRSH = fallbackToRSH;
    }

    String getLoginShell() {
        if (this.m_sLoginShell != null) {
            return this.m_sLoginShell;
        }
        return this.m_localpaths.getValue("SH_PATH");
    }

    void setLoginShell(String loginShell) {
        this.m_sLoginShell = loginShell;
    }

    int getRemoteNodesPlatform() {
        return this.m_nRemoteNodesPlatform;
    }

    void setRemoteNodesPlatform(int remoteNodesPlatform) {
        this.m_nRemoteNodesPlatform = remoteNodesPlatform;
    }

    public NodeInfo getNodeInfo(String nodename) {
        if (nodename != null) {
            return (NodeInfo)this.m_nodeRemoteShell.get(nodename);
        }
        return null;
    }

    void setNodeInfo(NodeInfo nodeinfo) {
        if (nodeinfo != null) {
            this.m_nodeRemoteShell.put(nodeinfo.getNodeName(), nodeinfo);
        }
    }

    Iterator getNodes() {
        return this.m_nodeRemoteShell.keySet().iterator();
    }

    Iterator getNodeInfoObjs() {
        return this.m_nodeRemoteShell.values().iterator();
    }

    public Commands getCommands() {
        return this.m_commands;
    }

    public void setCommands(Commands commands) {
        this.m_commands = commands;
    }

    public Paths getLocalPaths() {
        return this.m_localpaths;
    }

    public void setLocalPaths(Paths localPaths) {
        this.m_localpaths = localPaths;
    }

    public boolean isStartupDone() {
        return this.m_startupDone;
    }

    public void setStartupDone(boolean startupDone) {
        this.m_startupDone = startupDone;
    }

    public NodeInfo getLocalNodeInfo() {
        return this.m_localNodeInfo;
    }

    public void setLocalNodeInfo(NodeInfo localNodeInfo) {
        this.m_localNodeInfo = localNodeInfo;
    }

    public boolean isLocalNodeSetupDone() {
        return this.m_localnodeSetupDone;
    }

    public void localNodeSetupDone(boolean b) {
        this.m_localnodeSetupDone = true;
    }

    public String getRemotePathsLoc() {
        return this.m_remotePathsLoc;
    }

    public void setRemotePathsLoc(String remotePathsLoc) {
        this.m_remotePathsLoc = remotePathsLoc;
    }

    public void setRemotePlugin(String pluginName) {
        this.r_pluginName = pluginName;
    }

    public String getRemotePlugin() {
        return this.r_pluginName;
    }

    public void setRemoteExecutionEngine(RemoteExecutionEngine eng) {
        this.r_eng = eng;
    }

    public RemoteExecutionEngine getRemoteExecutionEngine() {
        return this.r_eng;
    }
}

