/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.remoteinterfaces.nativesystem;

import java.io.File;
import java.text.MessageFormat;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.prov.remoteinterfaces.cluster.NodeInfo;
import oracle.sysman.prov.remoteinterfaces.exception.ClusterException;
import oracle.sysman.prov.remoteinterfaces.exception.CommandException;
import oracle.sysman.prov.remoteinterfaces.exception.FatalException;
import oracle.sysman.prov.remoteinterfaces.exception.RemoteShellException;
import oracle.sysman.prov.remoteinterfaces.exception.RemoteShellFatalException;
import oracle.sysman.prov.remoteinterfaces.logger.ClusterLogger;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Assertions;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Constants;
import oracle.sysman.prov.remoteinterfaces.nativesystem.NativeSystem;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Paths;
import oracle.sysman.prov.remoteinterfaces.nativesystem.RemoteExecutionEngine;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Session;
import oracle.sysman.prov.remoteinterfaces.nativesystem.SessionId;
import oracle.sysman.prov.remoteinterfaces.result.ClusterResult;
import oracle.sysman.prov.remoteinterfaces.result.CommandResult;
import oracle.sysman.prov.remoteinterfaces.result.GenericResult;

public class UnixSystem
extends NativeSystem
implements Constants {
    private static final String TEMP_LOC = "/tmp";
    private static final String FILE_SEPARATOR = "/";
    private static final char FILE_SEPARATOR_CHAR = '/';

    public String getFileSeparator() {
        return FILE_SEPARATOR;
    }

    public char getFileSeparatorChar() {
        return '/';
    }

    protected int findIndexOf(String substr, String str) {
        return str.indexOf(substr);
    }

    UnixSystem(SessionId sessId) throws FatalException {
        super(sessId);
    }

    UnixSystem(SessionId sessId, int platId) throws FatalException {
        super(sessId, platId);
    }

    public void startup(SessionId sessId, String[] remoteNodes) throws FatalException, ClusterException {
        ClusterLogger.log("entering UnixSystem.startup()", ClusterLogger.LOG_FINER);
        super.startup(sessId, remoteNodes);
    }

    protected void checkRemoteShell(Session sess) throws RemoteShellFatalException {
        boolean bUserSpecifiedSsh = false;
        boolean bUserSpecifiedRsh = false;
        String remoteshell = sess.getPreference("REMOTE_SHELL");
        if (remoteshell != null) {
            bUserSpecifiedSsh = remoteshell.equalsIgnoreCase("ssh");
            bUserSpecifiedRsh = remoteshell.equalsIgnoreCase("rsh");
            if (!bUserSpecifiedSsh && !bUserSpecifiedRsh) {
                Object[] args = new Object[]{remoteshell};
                throw new RemoteShellFatalException("PROV-16006", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16006", (Object[])args));
            }
            ClusterLogger.log("Client requested for a valid remote shell: " + remoteshell);
            sess.setUserShellSpecified(true);
            if (bUserSpecifiedSsh) {
                sess.setIsUserShellSsh(true);
            } else {
                sess.setIsUserShellSsh(false);
            }
            ClusterLogger.log("Is remote shell specified by user? [Session Id = " + sess.getSessionId() + "]: " + true);
        }
    }

    protected void checkUserEquivPrereqs(Session sess) throws RemoteShellFatalException {
        if (sess.isUserShellSpecified()) {
            try {
                if (sess.isUserShellSsh() && s_bUseExistingSSH) {
                    Assertions.validatePath(sess.getSshPath());
                    Assertions.validatePath(sess.getScpPath());
                    sess.setSsh(true);
                }
                Assertions.validatePath(sess.getRshPath());
                Assertions.validatePath(sess.getRcpPath());
                sess.setRsh(true);
            }
            catch (FatalException fe) {
                ClusterLogger.log((Throwable)((Object)fe));
                Object[] args = new Object[]{sess.isUserShellSsh() ? sess.getSshPath() + " " + sess.getScpPath() : sess.getRshPath() + " " + sess.getRcpPath()};
                throw new RemoteShellFatalException("PROV-16006", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"INVALID_REMOTE_SHELL0", (Object[])args));
            }
        } else {
            boolean error = false;
            try {
                if (s_bUseExistingSSH) {
                    Assertions.validatePath(sess.getSshPath());
                    Assertions.validatePath(sess.getScpPath());
                }
                sess.setSsh(true);
            }
            catch (FatalException fe) {
                error = true;
                ClusterLogger.log(fe.getErrorMessage());
            }
            if (sess.isFallbackToRSH()) {
                try {
                    Assertions.validatePath(sess.getRshPath());
                    Assertions.validatePath(sess.getRcpPath());
                    sess.setRsh(true);
                }
                catch (FatalException fe1) {
                    error = true;
                    ClusterLogger.log(fe1.getErrorMessage());
                }
            }
            if (error) {
                throw new RemoteShellFatalException("PROV-16021", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16021"));
            }
        }
    }

    public void shutdown(SessionId sessId) {
        ClusterLogger.log("entering UnixSystem.shutdown()", ClusterLogger.LOG_FINER);
        super.shutdown(sessId);
    }

    CommandResult checkRemoteExecutionSetup(NodeInfo nodeinfo, boolean update) throws RemoteShellException {
        if (nodeinfo == null) {
            System.out.println("UnixSystem nodeinfo is null");
        }
        String node = nodeinfo.getNodeName();
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        CommandResult result = this.isNodeAlive(nodeinfo, 5);
        if (!result.getStatus()) {
            String errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16002", (Object[])new String[]{node, String.valueOf(5)});
            errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16008") + "\n" + errorMessage;
            throw new RemoteShellException(node, "PROV-16008", errorMessage, (Throwable)((Object)result.getException()));
        }
        if (sess.isUserShellSpecified()) {
            result = sess.isUserShellSsh() ? this.investigateShellEquivalence(nodeinfo, sess.getSshPath(), sess.getSshArgs(), true) : this.investigateShellEquivalence(nodeinfo, sess.getRshPath(), sess.getRshArgs(), false);
            if (update) {
                nodeinfo.setSsh(sess.isUserShellSsh());
            }
        } else {
            String errMsg = null;
            if (sess.isSsh()) {
                try {
                    result = this.investigateShellEquivalence(nodeinfo, sess.getSshPath(), sess.getSshArgs(), true);
                    if (update) {
                        nodeinfo.setSsh(true);
                    }
                }
                catch (RemoteShellException rse) {
                    errMsg = rse.getMessage();
                }
            }
            if (errMsg != null && sess.isRsh()) {
                try {
                    result = this.investigateShellEquivalence(nodeinfo, sess.getRshPath(), sess.getRshArgs(), false);
                    if (update) {
                        nodeinfo.setSsh(false);
                    }
                    errMsg = null;
                }
                catch (RemoteShellException rse2) {
                    errMsg = "\n" + rse2.getMessage();
                }
            }
            if (errMsg != null) {
                errMsg = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16008") + "\n" + errMsg;
                throw new RemoteShellException(node, "PROV-16008", errMsg);
            }
        }
        return result;
    }

    public CommandResult checkSSHSetup(NodeInfo nodeinfo) {
        return this.checkSSHSetup(nodeinfo, null);
    }

    public CommandResult checkSSHSetup(NodeInfo nodeinfo, String user) {
        CommandResult result = this.isNodeAlive(nodeinfo, 5);
        if (result.getStatus()) {
            Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
            String path = null;
            String args = sess.getLocalPaths().getValue("SSH_ARGS");
            if (user == null) {
                user = sess.getUsername();
            }
            if (user != null) {
                args = args + " -l " + user;
            }
            path = sess != null ? sess.getSshPath() : sess.getLocalPaths().getValue("SSH_PATH");
            try {
                result = this.investigateShellEquivalence(nodeinfo, path, args, true);
            }
            catch (RemoteShellException rse) {
                result.setException(rse);
                result.setStatus(false);
                result.setResult(new Boolean(false));
            }
        }
        return result;
    }

    public CommandResult checkRSHSetup(NodeInfo nodeinfo) {
        return this.checkRSHSetup(nodeinfo, null);
    }

    public CommandResult checkRSHSetup(NodeInfo nodeinfo, String user) {
        CommandResult result = this.isNodeAlive(nodeinfo, 5);
        if (result.getStatus()) {
            Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
            String path = null;
            String args = sess.getLocalPaths().getValue("RSH_ARGS");
            if (user == null) {
                user = sess.getUsername();
            }
            if (user != null) {
                args = args + " -l " + user;
            }
            path = sess != null ? sess.getSshPath() : sess.getLocalPaths().getValue("RSH_PATH");
            try {
                result = this.investigateShellEquivalence(nodeinfo, path, args, false);
            }
            catch (RemoteShellException rse) {
                result.setException(rse);
                result.setStatus(false);
                result.setResult(new Boolean(false));
            }
        }
        return result;
    }

    private CommandResult investigateShellEquivalence(NodeInfo nodeinfo, String path, String args, boolean bSsh) throws RemoteShellException {
        ClusterLogger.log("Checking user equivalence");
        String SPACE = " ";
        CommandResult result = null;
        String node = nodeinfo.getNodeName();
        Paths paths = nodeinfo.getPaths();
        String cmd = paths.getValue("TRUE");
        String[] unixcmd = null;
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        unixcmd = r_eng.formulateCmd(bSsh, sess, node, paths, cmd, "", "-n");
        result = this.runcmd(nodeinfo, unixcmd, bSsh);
        if (result.getStatus()) {
            return result;
        }
        String errstr = result.getErrStr();
        Object[] errMsg = new String[]{errstr};
        throw new RemoteShellException(node, "PROV-16018", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16018", (Object[])errMsg), (Throwable)((Object)result.getException()));
    }

    public CommandResult runcmd(NodeInfo nodeinfo, String[] cmd, boolean bSsh) {
        int numTokens = cmd.length;
        SessionId sessId = nodeinfo.getSessionId();
        Session sess = (Session)s_sessions.get(sessId);
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        if (numTokens > 1) {
            return r_eng.runcmd(nodeinfo, cmd, null, null, bSsh);
        }
        return r_eng.runcmd(nodeinfo, UnixSystem.getCmdArr(cmd[0]), null, null, bSsh);
    }

    protected String getScratchPath() {
        return TEMP_LOC;
    }

    String[] getPingCommand(Session sess, String node, int timeout, Paths paths) {
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        return r_eng.formulateLocalCmd(sess, paths.getValue("PING_KEY"), node, paths.getValue("PING_PATH"), paths.getValue("PING_ARGS") + " " + String.valueOf(timeout));
    }

    public String createFileName(NodeInfo nodeinfo, String fileName) {
        fileName = this.getStandardForm(fileName);
        String nodeName = nodeinfo.getNodeName();
        if (nodeName.equals("localhost")) {
            return fileName;
        }
        String username = ((Session)s_sessions.get(nodeinfo.getSessionId())).getUsername();
        if (username != null) {
            return username + "@" + nodeName + ":" + fileName;
        }
        return nodeName + ":" + fileName;
    }

    public CommandResult getFreeSpace(NodeInfo nodeinfo, String path) {
        ClusterLogger.log("entering UnixSystem.getFreeSpace()", ClusterLogger.LOG_FINER);
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        Paths paths = nodeinfo.getPaths();
        String node = nodeinfo.getNodeName();
        boolean bSsh = nodeinfo.isSshSet();
        String[] unixcmd = null;
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        String cmd = paths.getValue("DF_PATH");
        String cmdArgs = paths.getValue("DF_ARGS") + " " + path;
        unixcmd = r_eng.formulateCmd(bSsh, sess, node, paths, cmd, cmdArgs, "-n");
        CommandResult res = this.runcmd(nodeinfo, unixcmd, bSsh);
        Integer space = null;
        if (res.getStatus()) {
            String outStr = res.getOutStr();
            StringTokenizer st = new StringTokenizer(outStr, LINE_SEPARATOR);
            if (st.countTokens() >= 2) {
                int col = 4;
                StringTokenizer st1 = new StringTokenizer(st.nextToken());
                int numCols = st1.countTokens();
                String colName = paths.getValue("DF_COL_NAME");
                int idx = -1;
                for (int i = 0; i < numCols; ++i) {
                    idx = st1.nextToken().indexOf(colName);
                    if (idx == -1) continue;
                    col = i + 1;
                }
                st1 = new StringTokenizer(st.nextToken());
                int k = 0;
                while (true) {
                    if (st1.hasMoreTokens()) {
                        String token = st1.nextToken();
                        if (++k != col) continue;
                        try {
                            space = new Integer(token);
                            res.setResult(space);
                        }
                        catch (NumberFormatException nfe) {
                            res.setException(new CommandException(node, nfe));
                        }
                        break;
                    }
                    if (!st.hasMoreTokens()) break;
                    st1 = new StringTokenizer(st.nextToken());
                }
                if (space == null) {
                    res.setException(new CommandException(node, "PROV-16023", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"ERROR_FREE_SPACE0")));
                }
            } else {
                res.setException(new CommandException(node, "PROV-16023", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"ERROR_FREE_SPACE1")));
            }
        }
        if (space == null) {
            res.setStatus(false);
            res.setResult(new Integer(0));
        }
        return res;
    }

    public CommandResult createCFSFile(NodeInfo nodeinfo, String filePath) {
        ClusterLogger.log("entering UnixSystem.createCFSFile()", ClusterLogger.LOG_FINER);
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        Paths paths = nodeinfo.getPaths();
        String node = nodeinfo.getNodeName();
        boolean bSsh = nodeinfo.isSshSet();
        CommandResult result = null;
        String[] unixcmd = null;
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        String cmd = paths.getValue("TOUCH_PATH");
        String cmdArgs = filePath;
        unixcmd = r_eng.formulateCmd(bSsh, sess, node, paths, cmd, cmdArgs, "-n");
        result = this.runcmd(nodeinfo, unixcmd, bSsh);
        if (!result.getStatus()) {
            return result;
        }
        cmd = paths.getValue("ECHO_PATH") + " " + "This is CFS test file content" + " > " + filePath;
        unixcmd = r_eng.formulateCmd(bSsh, sess, node, paths, cmd, "", "-n");
        return this.runcmd(nodeinfo, unixcmd, bSsh);
    }

    public CommandResult testCFSFile(NodeInfo nodeinfo, String path) {
        ClusterLogger.log("entering UnixSystem.testCFSFile()", ClusterLogger.LOG_FINER);
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        Paths paths = nodeinfo.getPaths();
        String node = nodeinfo.getNodeName();
        ClusterLogger.log("node " + node + " path " + path, ClusterLogger.LOG_FINER);
        File filePath = new File(path);
        boolean bSsh = nodeinfo.isSshSet();
        CommandResult result = null;
        String cmd = paths.getValue("CAT_PATH") + " " + path;
        String[] unixcmd = null;
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        unixcmd = r_eng.formulateCmd(bSsh, sess, node, paths, cmd, "", "-n");
        result = this.runcmd(nodeinfo, unixcmd, bSsh);
        String outStr = result.getOutStr();
        if (outStr.indexOf("This is CFS test file content") == -1) {
            ClusterLogger.log(node + " Command output is empty");
            result.setException(new CommandException(node, "PROV-16031", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"ERROR_SHARED_DEVICE0", (Object[])new Object[]{path, node})));
            result.setStatus(false);
            result.setResult(new Boolean(false));
        }
        return result;
    }

    protected String getDefaultDestDirToExtractFiles() {
        return FILE_SEPARATOR;
    }

    protected String getTmpArchivePath(String tmpDir) {
        String filename = tmpDir + FILE_SEPARATOR + "tempArchive" + this.getTimeStamp() + ".tar";
        return filename;
    }

    public CommandResult extractArchive(String filename, NodeInfo nodeinfo, String destdir, int cmd, boolean extractModificationTime, String unzipCmd) {
        ClusterLogger.log("entering UnixSystem.extractArchive()", ClusterLogger.LOG_FINER);
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        Paths paths = nodeinfo.getPaths();
        String nodename = nodeinfo.getNodeName();
        filename = OiixPathOps.getStandardForm((String)filename);
        if (destdir != null) {
            destdir = OiixPathOps.getStandardForm((String)destdir);
        }
        String archiveCmd = null;
        if (unzipCmd != null && unzipCmd.trim().length() > 0) {
            archiveCmd = destdir != null && destdir.trim().length() > 0 ? "cd " + destdir + " && " + unzipCmd + " " + filename : unzipCmd + " " + filename;
        } else if (cmd == 5) {
            archiveCmd = paths.getValue("TAR_PATH") + " " + paths.getValue("TAR_EXTRACT_ARGS");
            if (!extractModificationTime) {
                archiveCmd = archiveCmd + paths.getValue("TAR_MTIME_ARGS");
            }
            archiveCmd = archiveCmd + " " + filename + " " + paths.getValue("TAR_DESTDIR_ARGS") + " " + destdir;
        } else if (cmd == 6) {
            archiveCmd = paths.getValue("UNZIP_PATH") + " " + paths.getValue("UNZIP_ARGS") + " " + filename + " " + paths.getValue("UNZIP_DESTDIR_ARGS") + " " + destdir;
        } else {
            archiveCmd = paths.getValue("TAR_PATH") + " " + paths.getValue("TAR_EXTRACT_ARGS");
            if (!extractModificationTime) {
                archiveCmd = archiveCmd + paths.getValue("TAR_MTIME_ARGS");
            }
            archiveCmd = archiveCmd + " " + filename + " " + paths.getValue("TAR_DESTDIR_ARGS") + " " + destdir;
        }
        CommandResult res = null;
        res = this.runCmd(archiveCmd, null, null, nodeinfo);
        return res;
    }

    protected String getArchiveCommand(String archive, String parentDir, String copyListFile, String exclListFile, Paths paths, int remotePlatId) throws FatalException {
        if (OiixPlatform.isPlatInGroup((int)-3, (int)remotePlatId)) {
            paths.isValidated("ZIP_PATH");
            return this.getZipCommand(archive, parentDir, copyListFile, exclListFile, paths);
        }
        paths.isValidated("TAR_PATH");
        return this.getTarCommand(archive, parentDir, copyListFile, exclListFile, paths);
    }

    protected int getArchiveCommandToBeUsed(int remotePlatId) {
        if (OiixPlatform.isPlatInGroup((int)-3, (int)remotePlatId)) {
            return 6;
        }
        return 5;
    }

    protected String getTarCommand(String archive, String parentDir, String copyListFile, String exclListFile, Paths paths) {
        boolean isOption = paths.getValue("TAR_EXCLUDE_ARGS").startsWith("-");
        String cmd = "";
        cmd = parentDir != null ? "(cd " + parentDir + " && " : "(";
        cmd = cmd + paths.getValue("TAR_PATH") + " " + paths.getValue("TAR_CREATE_ARGS") + (exclListFile != null && !isOption ? paths.getValue("TAR_EXCLUDE_ARGS") : "") + " " + archive + " " + (exclListFile != null && isOption ? paths.getValue("TAR_EXCLUDE_ARGS") : "") + " " + (exclListFile != null ? exclListFile : "") + " " + (copyListFile != null ? paths.getValue("TAR_INCLUDE_ARGS") + " " + copyListFile : "*") + " )";
        return cmd;
    }

    protected void createArchive(String archive, String srcDir, String copyListFile, String excludeListFile, Session sess) throws FatalException {
        Paths paths = sess.getLocalPaths();
        paths.isValidated("SH_PATH");
        int remotePlatId = sess.getRemoteNodesPlatform();
        String[] cmdArray = new String[]{paths.getValue("SH_PATH"), paths.getValue("SH_ARGS"), this.getArchiveCommand(archive, srcDir, copyListFile, excludeListFile, paths, remotePlatId)};
        ClusterLogger.log("command to be run: " + this.convertToStr(cmdArray), ClusterLogger.LOG_INFO, true);
        CommandResult result = this.runcmd(sess.getLocalNodeInfo(), cmdArray, true);
        if (!result.getStatus()) {
            throw new FatalException("PROV-16036", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16036"), (Throwable)((Object)result.getException()));
        }
    }

    public CommandResult copyAndExtractArchive(String archive, NodeInfo nodeinfo, String destdir, boolean create, int cmd, boolean extractModificationTime) {
        return this.copyAndExtractArchive(archive, nodeinfo, destdir, create, cmd, extractModificationTime, null);
    }

    public CommandResult copyAndExtractArchive(String archive, NodeInfo nodeinfo, String destdir, boolean create, int cmd, boolean extractModificationTime, String tempLoc) {
        ClusterLogger.log("entering UnixSystem.copyAndExtractArchive()", ClusterLogger.LOG_FINER);
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        Paths paths = nodeinfo.getPaths();
        String nodename = nodeinfo.getNodeName();
        archive = OiixPathOps.getStandardForm((String)archive);
        if (destdir != null) {
            destdir = OiixPathOps.getStandardForm((String)destdir);
        }
        if (tempLoc != null) {
            tempLoc = OiixPathOps.getStandardForm((String)tempLoc);
        }
        CommandResult res = null;
        if (destdir != null && create && !(res = this.createDir(nodeinfo, destdir)).getStatus()) {
            return res;
        }
        boolean bSsh = nodeinfo.isSshSet();
        if (tempLoc == null) {
            tempLoc = nodeinfo.getScratchPath();
        } else {
            res = this.createDir(nodeinfo, tempLoc);
            if (!res.getStatus()) {
                return res;
            }
        }
        String remotearchive = OiixPathOps.concatPath((String)tempLoc, (String)("remote" + OiixPathOps.getFileName((String)archive)));
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        res = this.copyFile(sess.getLocalNodeInfo(), archive, nodeinfo, remotearchive);
        if (!res.getStatus()) {
            return res;
        }
        res = this.extractArchive(remotearchive, nodeinfo, destdir, cmd, extractModificationTime, null);
        this.removeFile(nodeinfo, remotearchive);
        return res;
    }

    public CommandResult copyDirFromNode(NodeInfo nodeinfo, String sourcedir, String destdir, boolean extractModificationTime, String tempLoc) {
        ClusterLogger.log("entering UnixSystem.copyDirFromNode()", ClusterLogger.LOG_FINER);
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        Paths paths = nodeinfo.getPaths();
        String nodename = nodeinfo.getNodeName();
        boolean bSsh = nodeinfo.isSshSet();
        if (sourcedir != null) {
            sourcedir = OiixPathOps.getStandardForm((String)sourcedir);
        }
        if (destdir != null) {
            destdir = OiixPathOps.getStandardForm((String)destdir);
        }
        if (tempLoc != null) {
            tempLoc = OiixPathOps.getStandardForm((String)tempLoc);
        }
        CommandResult res = null;
        int archiveCmd = this.getArchiveCommandToBeUsed(sess.getLocalNodeInfo().getNativeSystem().getPlatformId());
        String timestamp = this.getTimeStamp();
        String rArchive = "remoteArchive" + nodename + timestamp;
        String lArchive = "localArchive" + nodename + timestamp;
        if (archiveCmd == 6) {
            rArchive = rArchive + ".zip";
            lArchive = lArchive + ".zip";
        } else {
            rArchive = rArchive + ".tar";
            lArchive = lArchive + ".tar";
        }
        String sourceTar = null;
        String destTar = null;
        if (tempLoc == null) {
            sourceTar = nodeinfo.getScratchPath() + FILE_SEPARATOR + rArchive;
            destTar = sess.getLocalNodeInfo().getScratchPath() + FILE_SEPARATOR + lArchive;
        } else {
            res = this.createDir(nodeinfo, tempLoc);
            if (!res.getStatus()) {
                return res;
            }
            sourceTar = tempLoc + FILE_SEPARATOR + rArchive;
            destTar = tempLoc + FILE_SEPARATOR + lArchive;
        }
        String cmd = null;
        cmd = archiveCmd == 6 ? this.getZipCommand(sourceTar, sourcedir, null, null, paths) : this.getTarCommand(sourceTar, sourcedir, null, null, paths);
        String[] unixcmd1 = null;
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        unixcmd1 = r_eng.formulateCmd(bSsh, sess, nodename, paths, cmd, "", "-n");
        res = this.runcmd(nodeinfo, unixcmd1, bSsh);
        res = this.copyFile(nodeinfo, sourceTar, sess.getLocalNodeInfo(), destTar);
        if (!res.getStatus()) {
            return res;
        }
        destdir = destdir + FILE_SEPARATOR + nodename;
        new File(destdir).mkdirs();
        sess.getLocalNodeInfo().getNativeSystem().extractArchiveOnLocalNode(sess.getLocalNodeInfo(), this.getStandardForm(destTar), this.getStandardForm(destdir), archiveCmd, true);
        this.removeFile(nodeinfo, sourceTar);
        new File(destTar).delete();
        return res;
    }

    protected CommandResult extractArchiveOnLocalNode(NodeInfo nodeinfo, String archiveFile, String destdir, int cmd, boolean extractModificationTime) {
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        Paths localPaths = sess.getLocalPaths();
        String unixcmd = "cd " + destdir + " && ";
        if (cmd == 6) {
            unixcmd = unixcmd + localPaths.getValue("UNZIP_PATH") + "  " + localPaths.getValue("UNZIP_ARGS");
        } else {
            unixcmd = unixcmd + localPaths.getValue("TAR_PATH") + "  " + localPaths.getValue("TAR_EXTRACT_ARGS");
            if (!extractModificationTime) {
                unixcmd = unixcmd + localPaths.getValue("TAR_MTIME_ARGS");
            }
        }
        unixcmd = unixcmd + " " + archiveFile;
        String[] cmdArray = new String[]{sess.getLoginShell(), localPaths.getValue("SH_ARGS"), unixcmd};
        ClusterLogger.log("command to be run: " + this.convertToStr(cmdArray), ClusterLogger.LOG_INFO, true);
        return this.runcmd(sess.getLocalNodeInfo(), cmdArray, true);
    }

    public CommandResult pathExists(NodeInfo nodeinfo, String path, int pathType) {
        ClusterLogger.log("entering UnixSystem.pathExists()", ClusterLogger.LOG_FINER);
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        Paths paths = nodeinfo.getPaths();
        String node = nodeinfo.getNodeName();
        boolean bSsh = nodeinfo.isSshSet();
        String flags = "";
        switch (pathType) {
            case 8: {
                flags = paths.getValue("DIR_EXISTS_FLAG");
                break;
            }
            case 11: {
                flags = paths.getValue("DIR_EXISTS_FLAG") + " " + path + " && " + paths.getValue("DIR_WRITABLE_FLAG");
                break;
            }
            case 9: {
                flags = paths.getValue("FILE_EXISTS_FLAG");
                break;
            }
            case 10: {
                flags = paths.getValue("SLINK_EXISTS_FLAG");
                break;
            }
            default: {
                flags = paths.getValue("PATH_EXISTS_FLAG");
            }
        }
        path = OiixPathOps.getStandardForm((String)path);
        Object res = null;
        String unixcmd = null;
        String[] unixcmd1 = null;
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        if (bSsh) {
            unixcmd = MessageFormat.format(paths.getValue("CMD2"), "", path, "", "", flags);
            String cmd = " '" + unixcmd + "'";
            unixcmd1 = r_eng.formulateCmd("KEY15", true, sess, node, paths, cmd, "");
        } else {
            unixcmd = MessageFormat.format(paths.getValue("CMD3"), "", path, "", "", flags);
            String cmd = " '" + unixcmd + "'";
            unixcmd1 = r_eng.formulateCmd("KEY15", false, sess, node, paths, cmd, "");
        }
        return this.runcmd(nodeinfo, unixcmd1, bSsh);
    }

    public CommandResult runCmd(String cmd, String[] args, String[] env, NodeInfo nodeinfo) {
        return this.runCmd(cmd, args, env, nodeinfo, false);
    }

    public CommandResult runCmd(String cmd, String[] args, String[] env, NodeInfo nodeinfo, boolean asNormalUser) {
        int i;
        ClusterLogger.log("entering UnixSystem.runCmd()", ClusterLogger.LOG_FINER);
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        if (!asNormalUser && null != sess.getPreference("oracle.sysman.prov.remoteinterfaces.sudo_pbrun_path") && sess.getPreference("oracle.sysman.prov.remoteinterfaces.sudo_pbrun_path").length() > 0) {
            return this.runSudoPbrunCmd(cmd, args, env, nodeinfo);
        }
        Paths paths = nodeinfo.getPaths();
        String node = nodeinfo.getNodeName();
        boolean bSsh = nodeinfo.isSshSet();
        String unixcmd = "";
        if (env != null) {
            for (i = 0; i < env.length; ++i) {
                unixcmd = unixcmd + env[i] + " ";
            }
            unixcmd = unixcmd + ";";
        }
        unixcmd = unixcmd + cmd;
        if (args != null) {
            for (i = 0; i < args.length; ++i) {
                unixcmd = unixcmd + " " + args[i] + " ";
            }
        }
        Object res = null;
        String[] cmdArr = null;
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        cmdArr = r_eng.formulateCmd(bSsh, sess, node, paths, unixcmd, "", "-n");
        return this.runcmd(nodeinfo, cmdArr, bSsh);
    }

    public CommandResult runRemoteSSHCmd(String[] args, String[] env, NodeInfo nodeinfo, String remoteNode, String username) {
        int i;
        ClusterLogger.log("entering UnixSystem.runRemoteSSHCmd()", ClusterLogger.LOG_FINER);
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        Paths paths = nodeinfo.getPaths();
        String node = nodeinfo.getNodeName();
        boolean bSsh = nodeinfo.isSshSet();
        String cmd = paths.getValue("SSH_PATH") + " " + paths.getValue("SSH_ARGS") + " -l " + username + " -n " + remoteNode + " '" + paths.getValue("SH_PATH") + " " + paths.getValue("SH_ARGS") + " '" + paths.getValue("DATE_PATH") + " " + paths.getValue("DATE_ARGS") + "''";
        String unixcmd = "";
        if (env != null) {
            for (i = 0; i < env.length; ++i) {
                unixcmd = unixcmd + env[i] + " ";
            }
            unixcmd = unixcmd + ";";
        }
        unixcmd = unixcmd + cmd;
        if (args != null) {
            for (i = 0; i < args.length; ++i) {
                unixcmd = unixcmd + " " + args[i] + " ";
            }
        }
        Object res = null;
        String[] cmdArr = null;
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        cmdArr = r_eng.formulateCmd("KEY15", true, sess, node, paths, unixcmd, "", username);
        return this.runcmd(nodeinfo, cmdArr, bSsh);
    }

    public CommandResult runRootCmd(String cmd, String[] args, String[] env, String password, NodeInfo nodeinfo) {
        ClusterLogger.log("entering UnixSystem.runRootCmd()", ClusterLogger.LOG_FINER);
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        Paths paths = nodeinfo.getPaths();
        String node = nodeinfo.getNodeName();
        boolean bSsh = nodeinfo.isSshSet();
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        String[] cmdarr1 = null;
        String sudocmd = paths.getValue("SUDO_PATH");
        String cmdArgs = paths.getValue("SUDO_K_ARGS");
        cmdarr1 = r_eng.formulateCmd(bSsh, sess, node, paths, sudocmd, cmdArgs, "-n");
        this.runcmd(nodeinfo, cmdarr1, bSsh);
        StringBuffer cmdBuf = new StringBuffer();
        String envStr = "";
        if (env != null) {
            for (int i = 0; i < env.length; ++i) {
                cmdBuf.append(env[i]);
                cmdBuf.append(" ");
            }
            cmdBuf.append(";");
            envStr = cmdBuf.toString();
        }
        cmdBuf = new StringBuffer();
        String argsStr = "";
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                cmdBuf.append(args[i]);
                cmdBuf.append(" ");
            }
            argsStr = cmdBuf.toString();
        }
        String unixcmd = null;
        unixcmd = bSsh ? MessageFormat.format(paths.getValue("CMD4"), paths.getValue("SUDO_PATH"), paths.getValue("SUDO_S_ARGS"), paths.getValue("SH_PATH") + "  " + paths.getValue("SH_ARGS"), envStr, cmd, argsStr) : MessageFormat.format(paths.getValue("CMD5"), paths.getValue("SUDO_PATH"), paths.getValue("SUDO_S_ARGS"), paths.getValue("SH_PATH") + "  " + paths.getValue("SH_ARGS"), envStr, cmd, argsStr);
        String[] cmdarr = r_eng.formulateCmd("KEY13", bSsh, sess, node, paths, unixcmd, "");
        CommandResult res = r_eng.runcmd(nodeinfo, cmdarr, new String[]{password}, null, bSsh);
        this.runcmd(nodeinfo, cmdarr1, bSsh);
        return res;
    }

    public CommandResult runSudoPbrunCmd(String cmd, String[] args, String[] env, NodeInfo nodeinfo) {
        ClusterLogger.log("entering UnixSystem.runPbrunSudoCmd()", ClusterLogger.LOG_FINER);
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        Paths paths = nodeinfo.getPaths();
        String node = nodeinfo.getNodeName();
        boolean bSsh = nodeinfo.isSshSet();
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        String[] cmdarr1 = null;
        String sudoPath = sess.getPreference("oracle.sysman.prov.remoteinterfaces.sudo_pbrun_path");
        String cmdArgs = paths.getValue("SUDO_K_ARGS");
        cmdarr1 = r_eng.formulateCmd(bSsh, sess, node, paths, sudoPath, cmdArgs, "-n");
        this.runcmd(nodeinfo, cmdarr1, bSsh);
        StringBuffer cmdBuf = new StringBuffer();
        String envStr = "";
        if (env != null) {
            for (int i = 0; i < env.length; ++i) {
                cmdBuf.append(env[i]);
                cmdBuf.append(" ");
            }
            cmdBuf.append(";");
            envStr = cmdBuf.toString();
        }
        cmdBuf = new StringBuffer();
        String argsStr = "";
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                cmdBuf.append(args[i]);
                cmdBuf.append(" ");
            }
            argsStr = cmdBuf.toString();
        }
        String sudoArgs = sess.getPreference("oracle.sysman.prov.remoteinterfaces.sudo_pbrun_args");
        String password = sess.getPreference("oracle.sysman.prov.remoteinterfaces.sudo_pbrun_password");
        String[] inputArr = null;
        if (null != password) {
            inputArr = new String[]{password};
        }
        String[] cmdarr = r_eng.formulateCmd("KEY16", sess, node, paths, cmd, argsStr, sudoPath, sudoArgs);
        CommandResult res = r_eng.runcmd(nodeinfo, cmdarr, inputArr, env, bSsh);
        this.runcmd(nodeinfo, cmdarr1, bSsh);
        return res;
    }

    public ClusterResult testSudoPbrun(SessionId sessId, String node) throws FatalException, ClusterException {
        Assertions.assertName(node);
        this.startup(sessId, new String[]{node});
        Session sess = (Session)s_sessions.get(sessId);
        GenericResult clusterResult = null;
        NodeInfo nodeinfo = sess.getNodeInfo(node);
        CommandResult res = null;
        ClusterLogger.log("entering UnixSystem.runPbrunSudoCmd()", ClusterLogger.LOG_FINER);
        Paths paths = nodeinfo.getPaths();
        boolean bSsh = nodeinfo.isSshSet();
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        String[] cmdarr1 = null;
        String sudoPath = sess.getPreference("oracle.sysman.prov.remoteinterfaces.sudo_pbrun_path");
        String cmdArgs = paths.getValue("SUDO_K_ARGS");
        cmdarr1 = r_eng.formulateCmd(bSsh, sess, node, paths, sudoPath, cmdArgs, "-n");
        this.runcmd(nodeinfo, cmdarr1, bSsh);
        String truePath = paths.getValue("TRUE");
        cmdarr1 = r_eng.formulateCmd(bSsh, sess, node, paths, sudoPath, truePath, "-n");
        res = r_eng.runCmdWithoutWait(nodeinfo, cmdarr1, bSsh);
        clusterResult = new GenericResult(res);
        return clusterResult;
    }

    protected void checkCreateListedDirPrereqs(Paths paths) throws FatalException {
        paths.isValidated("CAT_PATH");
    }

    public CommandResult createListedDirs(NodeInfo nodeinfo, String createListFile) {
        return this.createListedDirs(nodeinfo, createListFile, null);
    }

    public CommandResult createListedDirs(NodeInfo nodeinfo, String createListFile, String tempLoc) {
        ClusterLogger.log("entering UnixSystem.createListedDirs()", ClusterLogger.LOG_FINER);
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        Paths paths = nodeinfo.getPaths();
        String node = nodeinfo.getNodeName();
        boolean bSsh = nodeinfo.isSshSet();
        CommandResult res = null;
        if (tempLoc == null) {
            tempLoc = nodeinfo.getScratchPath();
        } else {
            res = this.createDir(nodeinfo, tempLoc);
            if (!res.getStatus()) {
                return res;
            }
        }
        String tempfilelist = OiixPathOps.concatPath((String)tempLoc, (String)("createlistfile" + this.getTimeStamp() + ".txt"));
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        res = this.copyFile(sess.getLocalNodeInfo(), createListFile, nodeinfo, tempfilelist);
        if (!res.getStatus()) {
            return res;
        }
        String unixcmd = paths.getValue("CAT_PATH") + " " + tempfilelist + " | " + paths.getValue("XARGS_PATH") + " " + paths.getValue("MKDIR_PATH") + " " + paths.getValue("MKDIR_ARGS");
        String[] cmdarr = null;
        cmdarr = r_eng.formulateCmd(bSsh, sess, node, paths, unixcmd, "", null);
        res = this.runcmd(nodeinfo, cmdarr, bSsh);
        this.removeFile(nodeinfo, tempfilelist);
        return res;
    }

    public CommandResult removeFile(NodeInfo nodeinfo, String file) {
        ClusterLogger.log("entering UnixSystem.removeDir()", ClusterLogger.LOG_FINER);
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        Paths paths = nodeinfo.getPaths();
        String node = nodeinfo.getNodeName();
        boolean bSsh = nodeinfo.isSshSet();
        file = this.getStandardForm(file);
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        String cmd = paths.getValue("RM_PATH") + " " + paths.getValue("RM_F_ARGS") + " " + file;
        String[] cmdarr = null;
        cmdarr = r_eng.formulateCmd(bSsh, sess, node, paths, cmd, "", "-n");
        return this.runcmd(nodeinfo, cmdarr, bSsh);
    }

    public CommandResult removeDir(NodeInfo nodeinfo, String dir, boolean recurse, boolean deleteEmptyParent) {
        String errors;
        ClusterLogger.log("entering UnixSystem.removeDir()", ClusterLogger.LOG_FINER);
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        Paths paths = nodeinfo.getPaths();
        String node = nodeinfo.getNodeName();
        boolean bSsh = nodeinfo.isSshSet();
        dir = this.getStandardForm(dir);
        String unixcmd = "";
        unixcmd = recurse ? unixcmd + paths.getValue("RM_PATH") + " " + paths.getValue("RM_RF_ARGS") : (deleteEmptyParent ? unixcmd + paths.getValue("RMDIR_PATH") + " " + paths.getValue("RMDIR_PARENTS_ARGS") + " " + paths.getValue("RMDIR_ARGS") : unixcmd + paths.getValue("RMDIR_PATH") + " " + paths.getValue("RMDIR_ARGS"));
        unixcmd = unixcmd + " " + dir;
        String[] cmdarr = null;
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        cmdarr = r_eng.formulateCmd(bSsh, sess, node, paths, unixcmd, "", "-n");
        CommandResult result = this.runcmd(nodeinfo, cmdarr, bSsh);
        if (!result.getStatus() && deleteEmptyParent && (errors = result.getErrStr()) != null && errors.indexOf(" not removed; Directory not empty") != -1 && errors.indexOf(dir + " not removed; Directory not empty") == -1) {
            result.setStatus(true);
            result.setResult(new Boolean(true));
            result.setException(null);
            ClusterLogger.log("Ignoring the error due to non-empty parents", ClusterLogger.LOG_INFO, true);
        }
        return result;
    }

    protected void checkRemoveListedPathsPrereqs(Paths paths) throws FatalException {
        paths.isValidated("CAT_PATH");
    }

    public CommandResult removeListedPaths(NodeInfo nodeinfo, String removeListFile, int pathType) {
        ClusterLogger.log("entering UnixSystem.removeListedPaths()", ClusterLogger.LOG_FINER);
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        Paths paths = nodeinfo.getPaths();
        String node = nodeinfo.getNodeName();
        boolean bSsh = nodeinfo.isSshSet();
        CommandResult res = null;
        String scratchPath = nodeinfo.getScratchPath();
        String tempfilelist = OiixPathOps.concatPath((String)scratchPath, (String)("removelistfile" + this.getTimeStamp() + ".txt"));
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        res = this.copyFile(sess.getLocalNodeInfo(), removeListFile, nodeinfo, tempfilelist);
        if (!res.getStatus()) {
            return res;
        }
        String unixcmd = paths.getValue("CAT_PATH") + " " + tempfilelist + " | " + paths.getValue("XARGS_PATH") + " " + paths.getValue("RM_PATH");
        unixcmd = pathType == 9 ? unixcmd + " " + paths.getValue("RM_F_ARGS") : unixcmd + " " + paths.getValue("RM_RF_ARGS");
        String[] cmdarr = null;
        cmdarr = r_eng.formulateCmd(bSsh, sess, node, paths, unixcmd, "", null);
        res = this.runcmd(nodeinfo, cmdarr, bSsh);
        this.removeFile(nodeinfo, tempfilelist);
        return res;
    }

    public ClusterResult runRootCmdOnLocalNode(SessionId sessId, String cmd, String[] args, String[] env, String password) throws FatalException, ClusterException {
        int i;
        ClusterLogger.log("entering UnixSystem.runRootCmdOnLocalNode()", ClusterLogger.LOG_FINER);
        String localnode = s_sHostnameLocal;
        CommandResult localresult = null;
        Session sess = (Session)s_sessions.get(sessId);
        Paths localCommands = sess.getLocalPaths();
        String unixcmd = localCommands.getValue("SUDO_PATH") + " " + localCommands.getValue("SUDO_K_ARGS");
        ClusterLogger.log(unixcmd, ClusterLogger.LOG_INFO, true);
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        r_eng.runcmd(sess.getLocalNodeInfo(), UnixSystem.getCmdArr(unixcmd), null, null, true);
        StringBuffer cmdBuf = new StringBuffer();
        cmdBuf.append(localCommands.getValue("SUDO_PATH"));
        cmdBuf.append(" ");
        cmdBuf.append(localCommands.getValue("SUDO_S_ARGS"));
        cmdBuf.append(" ");
        cmdBuf.append(sess.getLoginShell());
        cmdBuf.append(" ");
        cmdBuf.append(localCommands.getValue("SH_ARGS"));
        cmdBuf.append(" '");
        if (env != null) {
            for (i = 0; i < env.length; ++i) {
                cmdBuf.append(env[i]);
                cmdBuf.append(" ");
            }
            cmdBuf.append(";");
        }
        cmdBuf.append(cmd);
        cmdBuf.append(" ");
        if (args != null) {
            for (i = 0; i < args.length; ++i) {
                cmdBuf.append(args[i]);
                cmdBuf.append(" ");
            }
        }
        cmdBuf.append("'");
        unixcmd = cmdBuf.toString();
        String[] cmdArray = new String[]{sess.getLoginShell(), localCommands.getValue("SH_ARGS"), unixcmd};
        ClusterLogger.log(unixcmd, ClusterLogger.LOG_INFO, true);
        localresult = r_eng.runcmd(sess.getLocalNodeInfo(), cmdArray, new String[]{password}, null, true);
        unixcmd = localCommands.getValue("SUDO_PATH") + " " + localCommands.getValue("SUDO_K_ARGS");
        ClusterLogger.log(unixcmd, ClusterLogger.LOG_INFO, true);
        r_eng.runcmd(sess.getLocalNodeInfo(), UnixSystem.getCmdArr(unixcmd), null, null, true);
        GenericResult clusterResult = new GenericResult(localresult);
        if (localresult.getStatus()) {
            return clusterResult;
        }
        String errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16037", (Object[])new Object[]{cmd, localnode});
        throw new ClusterException("PROV-16037", errorMessage, clusterResult.getResults());
    }

    protected CommandResult linkFile(NodeInfo nodeinfo, String sourceFile, String destFile) {
        ClusterLogger.log("entering UnixSystem.linkFile()", ClusterLogger.LOG_FINER);
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        Paths paths = nodeinfo.getPaths();
        String node = nodeinfo.getNodeName();
        boolean bSsh = nodeinfo.isSshSet();
        sourceFile = OiixPathOps.getStandardForm((String)sourceFile);
        destFile = OiixPathOps.getStandardForm((String)destFile);
        String[] cmdarr = null;
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        cmdarr = r_eng.formulateCmd(bSsh, sess, node, paths, paths.getValue("LN_PATH"), paths.getValue("LN_ARGS") + " " + sourceFile + " " + destFile, "-n");
        return this.runcmd(nodeinfo, cmdarr, bSsh);
    }

    public CommandResult moveFile(NodeInfo nodeinfo, String sourceFile, String destFile) {
        ClusterLogger.log("entering UnixSystem.moveFile()", ClusterLogger.LOG_FINER);
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        Paths paths = nodeinfo.getPaths();
        String node = nodeinfo.getNodeName();
        boolean bSsh = nodeinfo.isSshSet();
        String[] cmdarr = null;
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        cmdarr = r_eng.formulateCmd(bSsh, sess, node, paths, paths.getValue("MV_PATH"), paths.getValue("MV_ARGS") + " " + sourceFile + " " + destFile, "-n");
        return this.runcmd(nodeinfo, cmdarr, bSsh);
    }

    public CommandResult listDirectory(NodeInfo nodeinfo, String dirPath) {
        ClusterLogger.log("entering UnixSystem.listDirectory()", ClusterLogger.LOG_FINER);
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        Paths paths = nodeinfo.getPaths();
        String node = nodeinfo.getNodeName();
        boolean bSsh = nodeinfo.isSshSet();
        dirPath = OiixPathOps.getStandardForm((String)dirPath);
        String[] cmdarr = null;
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        cmdarr = r_eng.formulateCmd(bSsh, sess, node, paths, paths.getValue("LS_PATH"), paths.getValue("LS_ARGS") + " " + dirPath, "-n");
        CommandResult result = this.runcmd(nodeinfo, cmdarr, bSsh);
        if (result.getStatus()) {
            String outStr = result.getOutStr();
            StringTokenizer st = new StringTokenizer(outStr);
            int num = st.countTokens();
            if (!bSsh) {
                --num;
            }
            String[] filelist = new String[num];
            for (int i = 0; i < num; ++i) {
                filelist[i] = st.nextToken();
            }
            result.setResult(filelist);
        }
        return result;
    }

    public CommandResult getTimeOnNode(NodeInfo nodeinfo) {
        CommandResult result;
        block10: {
            RemoteExecutionEngine r_eng;
            ClusterLogger.log("entering UnixSystem.getTimeOnNode()", ClusterLogger.LOG_FINER);
            Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
            Paths paths = nodeinfo.getPaths();
            String node = nodeinfo.getNodeName();
            boolean bSsh = nodeinfo.isSshSet();
            String unixcmd = paths.getValue("DATE_PATH") + " " + paths.getValue("DATE_ARGS");
            String[] cmdarr = null;
            String nodename_args = paths.getValue("NODENAME_ARGS");
            if (nodename_args != null || nodename_args.trim().length() != 0) {
                r_eng = this.getRemoteExecutionEngine(sess);
                cmdarr = r_eng.formulateCmd(bSsh, sess, node, paths, unixcmd, "", "-n");
            } else {
                r_eng = this.getRemoteExecutionEngine(sess);
                cmdarr = r_eng.formulateCmd(bSsh, sess, node, paths, unixcmd, "", null);
            }
            result = this.runcmd(nodeinfo, cmdarr, bSsh);
            result.setResult(null);
            if (result.getStatus()) {
                String outStr = result.getOutStr();
                try {
                    if (nodename_args == null || nodename_args.trim().length() == 0) {
                        StringTokenizer st = new StringTokenizer(outStr);
                        if (st.countTokens() > 0) {
                            Integer value = Integer.valueOf(st.nextToken());
                            result.setResult(value);
                        }
                    } else {
                        StringTokenizer st = new StringTokenizer(outStr, ":");
                        if (st.countTokens() == 6) {
                            int year = Integer.valueOf(st.nextToken());
                            int month = Integer.valueOf(st.nextToken());
                            int date = Integer.valueOf(st.nextToken());
                            int hour = Integer.valueOf(st.nextToken());
                            int minute = Integer.valueOf(st.nextToken());
                            int second = Integer.valueOf(st.nextToken());
                            int val = (int)new GregorianCalendar(year, month, date, hour, minute, second).getTimeInMillis();
                            result.setResult(new Integer(val));
                        } else {
                            result.setStatus(false);
                        }
                    }
                }
                catch (NumberFormatException e) {
                    result.setException(new CommandException(node, e));
                    result.setStatus(false);
                    if (nodename_args != null && nodename_args.trim().length() != 0) break block10;
                    result.setResult(null);
                }
            }
        }
        return result;
    }

    public CommandResult getHostName(NodeInfo nodeinfo) {
        return this.getHostName(nodeinfo, false);
    }

    public CommandResult getHostName(NodeInfo nodeinfo, boolean fullname) {
        String outStr;
        StringTokenizer st;
        ClusterLogger.log("entering UnixSystem.getHostName()", ClusterLogger.LOG_FINER);
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        Paths paths = nodeinfo.getPaths();
        String node = nodeinfo.getNodeName();
        if (this.isLocalNode(node)) {
            CommandResult result = CommandResult.SUCCESS(node);
            if (fullname) {
                result.setResult(s_sFullHostnameLocal);
            } else {
                result.setResult(s_sHostnameLocal);
            }
            return result;
        }
        boolean bSsh = nodeinfo.isSshSet();
        String args = "";
        if (fullname) {
            args = paths.getValue("HOSTNAME_ARGS");
        }
        String[] cmdarr = null;
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        cmdarr = r_eng.formulateCmd(bSsh, sess, node, paths, paths.getValue("HOSTNAME_PATH"), args, null);
        CommandResult result = this.runcmd(nodeinfo, cmdarr, bSsh);
        result.setResult(null);
        if (result.getStatus() && (st = new StringTokenizer(outStr = result.getOutStr())).countTokens() > 0) {
            result.setResult(st.nextToken());
        }
        return result;
    }

    public String getExeName(String cmd) {
        return cmd;
    }

    protected CommandResult convertFile(NodeInfo nodeinfo, int platform, String file) {
        String node = nodeinfo.getNodeName();
        if (platform == -3 || OiixPlatform.isPlatInGroup((int)-3, (int)platform)) {
            boolean bSsh = nodeinfo.isSshSet();
            Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
            Paths paths = nodeinfo.getPaths();
            String[] cmdarr = null;
            RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
            cmdarr = r_eng.formulateCmd(bSsh, sess, node, paths, paths.getValue("DOSTOUNIX_PATH"), file, null);
            return this.runcmd(nodeinfo, cmdarr, bSsh);
        }
        return CommandResult.FAILURE_API_NOT_SUPPORTED(node);
    }
}

