/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.remoteinterfaces.nativesystem;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Hashtable;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.prov.remoteinterfaces.cluster.NodeInfo;
import oracle.sysman.prov.remoteinterfaces.exception.ClusterException;
import oracle.sysman.prov.remoteinterfaces.exception.FatalException;
import oracle.sysman.prov.remoteinterfaces.exception.PluginException;
import oracle.sysman.prov.remoteinterfaces.exception.RemoteFileOperationException;
import oracle.sysman.prov.remoteinterfaces.exception.RemoteShellException;
import oracle.sysman.prov.remoteinterfaces.exception.RemoteShellFatalException;
import oracle.sysman.prov.remoteinterfaces.logger.ClusterLogger;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Assertions;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Constants;
import oracle.sysman.prov.remoteinterfaces.nativesystem.NativeSystem;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Paths;
import oracle.sysman.prov.remoteinterfaces.nativesystem.RemoteExecutionEngine;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Session;
import oracle.sysman.prov.remoteinterfaces.nativesystem.SessionId;
import oracle.sysman.prov.remoteinterfaces.nativesystem.SystemFactory;
import oracle.sysman.prov.remoteinterfaces.nativesystem.UserPreferences;
import oracle.sysman.prov.remoteinterfaces.result.ClusterResult;
import oracle.sysman.prov.remoteinterfaces.result.CommandResult;
import oracle.sysman.prov.remoteinterfaces.result.GenericResult;

public class WindowsSystemWMI
extends NativeSystem
implements Constants {
    private static final String TMP = "c:\\tmp";
    private static final String FILE_SEPARATOR = "\\";
    private static final char FILE_SEPARATOR_CHAR = '\\';

    public String getFileSeparator() {
        return FILE_SEPARATOR;
    }

    public char getFileSeparatorChar() {
        return '\\';
    }

    protected int findIndexOf(String substr, String str) {
        substr = substr.toLowerCase();
        str = str.toLowerCase();
        return str.indexOf(substr);
    }

    WindowsSystemWMI(SessionId sessId) throws FatalException {
        super(sessId);
    }

    WindowsSystemWMI(SessionId sessId, int platId) throws FatalException {
        super(sessId, platId);
    }

    public void startup(SessionId sessId, String[] remoteNodes, String username, String password, UserPreferences pref) throws FatalException, ClusterException {
        String scratchPath;
        File scratchLoc;
        ClusterLogger.log("entering WindowsSystemWMI.startup()", ClusterLogger.LOG_INFO);
        if (System.getProperty("oracle.installer.library_loc") == null && System.getProperty("oracle.sysman.prov.PathsPropertiesLoc") == null) {
            throw new FatalException("PROV-16053", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"ERROR_DLL_PATH", null));
        }
        String l_servicePath = System.getProperty("oracle.sysman.prov.win_win_service_path");
        if (l_servicePath == null || l_servicePath.trim().length() == 0) {
            throw new FatalException("PROV-16053", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"ERROR_WIN_SERVICE_PATH", null));
        }
        try {
            FileInputStream win_service = new FileInputStream(l_servicePath);
        }
        catch (FileNotFoundException fnde) {
            throw new FatalException("PROV-16016", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"ERROR_WIN_SERVICE_PATH", (Object[])new String[]{l_servicePath, "localhost"}));
        }
        Session sess = (Session)s_sessions.get(sessId);
        if (sess == null) {
            this.initSession(sessId, SystemFactory.s_localPlatId);
            sess = (Session)s_sessions.get(sessId);
        }
        if (!((scratchLoc = new File(scratchPath = (scratchPath = sess.getLocalPaths().getValue("SCRATCHPATH")) != null ? OiixPathOps.getNativeForm((String)scratchPath) : TMP)).exists() && scratchLoc.isDirectory() && scratchLoc.canWrite() || scratchLoc.mkdirs())) {
            throw new FatalException("PROV-16014", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"ERROR_CREATE_DIR", (Object[])new String[]{scratchPath, "localhost"}));
        }
        if (!sess.isStartupDone()) {
            ClusterLogger.log(" sess.isStartupDone() is false", ClusterLogger.LOG_INFO, false);
            ClusterLogger.log("username: " + username, ClusterLogger.LOG_INFO, false);
            if (pref != null) {
                sess.setUserPrefs(pref);
            }
            if (username != null) {
                sess.setUsername(username);
                ClusterLogger.log("Setting username to " + username, ClusterLogger.LOG_INFO, true);
            }
            if (password != null) {
                sess.setPassword(password);
                ClusterLogger.log("Setting password to **********", ClusterLogger.LOG_INFO, true);
            }
            this.setSessionPreferences(sess);
            sess.setPreference("REMOTE_COMMAND_PLUGIN_NAME", "oracle.sysman.prov.remoteinterfaces.plugins.RemoteCommandWMI");
            try {
                RemoteExecutionEngine.registerPlugin("oracle.sysman.prov.remoteinterfaces.plugins.RemoteCommandWMI");
            }
            catch (PluginException fe) {
                fe.printStackTrace();
            }
            sess.getLocalNodeInfo().setNativeSystem(SystemFactory.CreateNativeSystemWMI(sessId));
            this.checkUserEquivPrereqs(sess);
            sess.setStartupDone(true);
        }
        Object failedNodes = null;
        Hashtable t = new Hashtable();
        Object resultOnNode = null;
        int nRemoteNodes = remoteNodes != null ? remoteNodes.length : 0;
        String failedNodes0 = null;
        for (int i = 0; i < nRemoteNodes; ++i) {
            NodeInfo nodeinfo = sess.getNodeInfo(remoteNodes[i]);
            if (nodeinfo != null && (!this.isLocalNode(remoteNodes[i]) || sess.isLocalNodeSetupDone())) continue;
            ClusterLogger.log("Doing startup tasks on node " + remoteNodes[i], ClusterLogger.LOG_INFO, true);
            if (nodeinfo == null) {
                nodeinfo = new NodeInfo(remoteNodes[i]);
                nodeinfo.setSessionId(sessId);
            }
            NativeSystem ns = null;
            try {
                ns = SystemFactory.CreateNativeSystem(sessId, remoteNodes[i]);
                nodeinfo.setNativeSystem(ns);
                nodeinfo.setPaths(sess.getCommands().createInstance(ns.m_platId, sess.getRemotePathsLoc()));
            }
            catch (FatalException e) {
                ClusterLogger.log((Throwable)((Object)e));
                if (failedNodes0 == null) {
                    failedNodes0 = remoteNodes[i];
                    continue;
                }
                failedNodes0 = failedNodes0 + ", " + remoteNodes[i];
                continue;
            }
            String prefVal = sess.getPreference("LOGIN_SHELL");
            if (prefVal != null) {
                nodeinfo.getPaths().setValue("SH_PATH", prefVal);
            }
            sess.setNodeInfo(nodeinfo);
            sess.setNodeInfo(nodeinfo);
            sess.localNodeSetupDone(true);
        }
        if (failedNodes0 != null) {
            throw new FatalException("PROV-16039", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PLATFORM_NOT_FOUND1", (Object[])new String[]{failedNodes0}));
        }
    }

    protected String getScratchPath() {
        return TMP;
    }

    String[] getPingCommand(Session sess, String node, int timeout, Paths paths) {
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        return r_eng.formulateLocalCmd(sess, paths.getValue("PING_KEY"), node, paths.getValue("PING_PATH"), paths.getValue("PING_ARGS") + " " + String.valueOf(timeout * 1000));
    }

    CommandResult checkRemoteExecutionSetup(NodeInfo nodeinfo, boolean update) throws RemoteShellException {
        String node = nodeinfo.getNodeName();
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        return null;
    }

    private CommandResult investigateShellEquivalence(NodeInfo nodeinfo, String path, String args) throws RemoteShellException {
        return CommandResult.FAILURE_API_NOT_SUPPORTED(nodeinfo.getNodeName());
    }

    public CommandResult getTimeOnNode(NodeInfo nodeinfo) {
        return CommandResult.FAILURE_API_NOT_SUPPORTED(nodeinfo.getNodeName());
    }

    public CommandResult createCFSFile(NodeInfo nodeinfo, String filePath) {
        return CommandResult.FAILURE_API_NOT_SUPPORTED(nodeinfo.getNodeName());
    }

    public CommandResult testCFSFile(NodeInfo nodeinfo, String path) {
        return CommandResult.FAILURE_API_NOT_SUPPORTED(nodeinfo.getNodeName());
    }

    public CommandResult getFreeSpace(NodeInfo nodeinfo, String path) {
        return CommandResult.FAILURE_API_NOT_SUPPORTED(nodeinfo.getNodeName());
    }

    public String createFileName(NodeInfo nodeinfo, String fileName) {
        return null;
    }

    public ClusterResult copyFileBetweenNodes(SessionId sessId, String nodeName1, String fileName1, String nodeName2, String fileName2) throws FatalException, RemoteFileOperationException {
        ClusterLogger.log("entering NativeSystem.copyFileBetweenNodes()", ClusterLogger.LOG_FINER);
        Assertions.assertName(nodeName1);
        Assertions.assertName(nodeName2);
        Session sess = (Session)s_sessions.get(sessId);
        NodeInfo nodeinfo1 = null;
        NodeInfo nodeinfo2 = null;
        NativeSystem ns = null;
        ArrayList<String> nodes = new ArrayList<String>();
        if (!nodeName1.equals("localhost")) {
            nodes.add(nodeName1);
            nodeinfo1 = sess.getNodeInfo(nodeName1);
        } else {
            nodeinfo1 = sess.getLocalNodeInfo();
            ns = nodeinfo1.getNativeSystem();
        }
        if (!nodeName2.equals("localhost")) {
            nodes.add(nodeName2);
            nodeinfo2 = sess.getNodeInfo(nodeName2);
        } else {
            nodeinfo2 = sess.getLocalNodeInfo();
            ns = nodeinfo2.getNativeSystem();
        }
        int size = nodes.size();
        String[] nodesArr = new String[size];
        for (int i = 0; i < size; ++i) {
            nodesArr[i] = (String)nodes.get(i);
        }
        try {
            this.startup(sessId, nodesArr);
        }
        catch (ClusterException e) {
            throw new RemoteFileOperationException(e);
        }
        Assertions.assertName(fileName1);
        Assertions.assertName(fileName2);
        fileName1 = this.getStandardForm(fileName1);
        fileName2 = this.getStandardForm(fileName2);
        CommandResult res = this.copyFile(nodeinfo1, fileName1, nodeinfo2, fileName2);
        GenericResult clusterResult = new GenericResult(res);
        if (res.getStatus()) {
            return clusterResult;
        }
        String errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16009", (Object[])new Object[]{fileName1, nodeName1, fileName2, nodeName2});
        throw new RemoteFileOperationException("PROV-16009", errorMessage, clusterResult.getResults());
    }

    public CommandResult extractArchive(String filename, NodeInfo nodeinfo, String destdir, int cmd, boolean extractModificationTime, String unzipCmd) {
        return CommandResult.FAILURE_API_NOT_SUPPORTED(nodeinfo.getNodeName());
    }

    public ClusterResult copyListedPathsToNodes(SessionId sessId, String[] nodeNames, String dirName, String copyListFile, String excludeListFile, String tmpDir, boolean create) throws FatalException, RemoteFileOperationException {
        throw new FatalException("PROV-17000", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-17000"));
    }

    public CommandResult copyAndExtractArchive(String archive, NodeInfo nodeinfo, String destdir, boolean create, int cmd, boolean extractModificationTime) {
        return CommandResult.FAILURE_API_NOT_SUPPORTED(nodeinfo.getNodeName());
    }

    public CommandResult copyAndExtractArchive(String archive, NodeInfo nodeinfo, String destdir, boolean create, int cmd, boolean extractModificationTime, String tempLoc) {
        return CommandResult.FAILURE_API_NOT_SUPPORTED(nodeinfo.getNodeName());
    }

    public ClusterResult copyDirToNodes(SessionId sessId, String[] nodeNames, String srcDir, String destDir, String excludeListFile, String tmpDir, boolean create, boolean extractModificationTime) throws FatalException, RemoteFileOperationException {
        throw new FatalException("PROV-17000", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-17000"));
    }

    public CommandResult copyDirFromNode(NodeInfo nodeinfo, String sourcedir, String destdir, boolean extractModificationTime, String tempLoc) {
        return CommandResult.FAILURE_API_NOT_SUPPORTED(nodeinfo.getNodeName());
    }

    protected CommandResult extractArchiveOnLocalNode(NodeInfo nodeinfo, String archiveFile, String destdir, int cmd, boolean extractModificationTime) {
        return CommandResult.FAILURE_API_NOT_SUPPORTED(nodeinfo.getNodeName());
    }

    public CommandResult createDir(NodeInfo nodeinfo, String dir) {
        ClusterLogger.log("WindowssystemWMI : createDir : " + dir, ClusterLogger.LOG_INFO, true);
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        String[] cmdarr = new String[]{"win_cdir", dir};
        return r_eng.runcmd(nodeinfo, cmdarr, null, null, true);
    }

    protected CommandResult createService(SessionId sessId, String nodeName, String servicePath, String serviceName, String serviceArgs) throws FatalException {
        ClusterLogger.log("WindowssystemWMI : createService : " + nodeName + " " + serviceName + " " + serviceArgs, ClusterLogger.LOG_INFO, true);
        Session sess = (Session)s_sessions.get(sessId);
        NodeInfo nodeinfo = sess.getNodeInfo(nodeName);
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        String[] cmdarr = new String[]{"win_cservice", servicePath, serviceName, serviceArgs};
        return r_eng.runcmd(nodeinfo, cmdarr, null, null, true);
    }

    protected CommandResult removeService(SessionId sessId, String nodeName, String servicePath, String serviceName) throws FatalException {
        ClusterLogger.log("WindowssystemWMI : deleteService : " + nodeName + " " + serviceName, ClusterLogger.LOG_INFO, true);
        Session sess = (Session)s_sessions.get(sessId);
        NodeInfo nodeinfo = sess.getNodeInfo(nodeName);
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        String[] cmdarr = new String[]{"win_rservice", servicePath, serviceName};
        return r_eng.runcmd(nodeinfo, cmdarr, null, null, true);
    }

    public ClusterResult createListedDirsOnNodes(SessionId sessId, String[] nodeNames, String createListFile, String parentDir, String tmpDir) throws FatalException, RemoteFileOperationException {
        ClusterLogger.log("entering WindowsSystemWMI.createListedDirsOnNodes()", ClusterLogger.LOG_FINER);
        throw new FatalException("PROV-17000", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-17000"));
    }

    public CommandResult createListedDirs(NodeInfo nodeinfo, String createListFile) {
        return CommandResult.FAILURE_API_NOT_SUPPORTED(nodeinfo.getNodeName());
    }

    public CommandResult createListedDirs(NodeInfo nodeinfo, String createListFile, String tempLoc) {
        return CommandResult.FAILURE_API_NOT_SUPPORTED(nodeinfo.getNodeName());
    }

    public CommandResult removeFile(NodeInfo nodeinfo, String file) {
        ClusterLogger.log("WindowssystemWMI : removefile : " + file, ClusterLogger.LOG_INFO, true);
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        String[] cmdarr = new String[]{"win_dfile", file};
        return r_eng.runcmd(nodeinfo, cmdarr, null, null, true);
    }

    public CommandResult removeDir(NodeInfo nodeinfo, String dir, boolean recurse, boolean deleteEmptyParent) {
        ClusterLogger.log("WindowssystemWMI : remove Dir : " + dir, ClusterLogger.LOG_INFO, true);
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        String[] cmdarr = new String[]{"win_ddir", dir};
        return r_eng.runcmd(nodeinfo, cmdarr, null, null, true);
    }

    public ClusterResult removeListedPathsFromNodes(SessionId sessId, String[] nodeNames, String removeListFile, int pathType) throws FatalException, RemoteFileOperationException {
        ClusterLogger.log("entering WindowsSystem.removeListedFilesFromNode()", ClusterLogger.LOG_FINER);
        throw new FatalException("PROV-17000", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-17000"));
    }

    public CommandResult removeListedPaths(NodeInfo nodeinfo, String removeListFile, int pathType) {
        return CommandResult.FAILURE_API_NOT_SUPPORTED(nodeinfo.getNodeName());
    }

    public CommandResult runRootCmd(String cmd, String[] args, String[] env, String password, NodeInfo nodeinfo) {
        return CommandResult.FAILURE_API_NOT_SUPPORTED(nodeinfo.getNodeName());
    }

    protected CommandResult linkFile(NodeInfo nodeinfo, String sourceFile, String destFile) {
        return CommandResult.FAILURE_API_NOT_SUPPORTED(nodeinfo.getNodeName());
    }

    public CommandResult pathExists(NodeInfo nodeinfo, String path, int pathType) {
        return CommandResult.FAILURE_API_NOT_SUPPORTED(nodeinfo.getNodeName());
    }

    public CommandResult moveFile(NodeInfo nodeinfo, String sourceFile, String destFile) {
        return CommandResult.FAILURE_API_NOT_SUPPORTED(nodeinfo.getNodeName());
    }

    public CommandResult listDirectory(NodeInfo nodeinfo, String dirPath) {
        return CommandResult.FAILURE_API_NOT_SUPPORTED(nodeinfo.getNodeName());
    }

    public CommandResult getHostName(NodeInfo nodeinfo) {
        return CommandResult.FAILURE_API_NOT_SUPPORTED(nodeinfo.getNodeName());
    }

    public CommandResult getHostName(NodeInfo nodeinfo, boolean fullname) {
        return CommandResult.FAILURE_API_NOT_SUPPORTED(nodeinfo.getNodeName());
    }

    public String getExeName(String cmd) {
        return cmd + ".exe";
    }

    protected String getPingPath() {
        return this.getWindowsCommandPath("ping.exe");
    }

    protected String getWindowsCommandPath(String cmdName) {
        String winCmd = null;
        String result = null;
        if (result != null) {
            File file = new File(result + FILE_SEPARATOR + cmdName);
            if (file.exists()) {
                winCmd = file.getAbsolutePath();
            } else {
                file = new File(result + FILE_SEPARATOR + "system32" + FILE_SEPARATOR + cmdName);
                if (file.exists()) {
                    winCmd = file.getAbsolutePath();
                }
            }
        }
        ClusterLogger.log("winCmd = " + winCmd);
        return winCmd;
    }

    public CommandResult runCmd(String cmd, String[] args, String[] env, NodeInfo nodeinfo) {
        ClusterLogger.log("WindowsSystemWMI : runCmd : " + cmd, ClusterLogger.LOG_INFO, true);
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        String[] cmdarr = new String[]{"win_runcmd", cmd};
        return r_eng.runcmd(nodeinfo, cmdarr, null, null, true);
    }

    public CommandResult runRemoteSSHCmd(String[] args, String[] env, NodeInfo nodeinfo, String remoteNode, String username) {
        return CommandResult.FAILURE_API_NOT_SUPPORTED(nodeinfo.getNodeName());
    }

    protected String getDefaultDestDirToExtractFiles() throws FatalException {
        return "C:/";
    }

    protected String getArchiveCommand(String archive, String parentDir, String copyListFile, String exclListFile, Paths paths) throws FatalException {
        throw new FatalException("PROV-17000", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-17000"));
    }

    protected int getArchiveCommandToBeUsed(int remotePlatId) {
        return 6;
    }

    protected String getTmpArchivePath(String tmpDir) {
        String filename = tmpDir + FILE_SEPARATOR + "tempArchive" + this.getTimeStamp() + ".zip";
        return filename;
    }

    protected void createArchive(String archive, String srcDir, String copyListFile, String excludeListFile, Session sess) throws FatalException {
        throw new FatalException("PROV-17000", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-17000"));
    }

    protected void checkRemoteShell(Session sess) throws RemoteShellFatalException {
        if (sess != null) {
            return;
        }
        throw new RemoteShellFatalException("PROV-17000", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-17000"));
    }

    public CommandResult checkRSHSetup(NodeInfo nodeinfo) {
        return CommandResult.FAILURE_API_NOT_SUPPORTED(nodeinfo.getNodeName());
    }

    public CommandResult checkRSHSetup(NodeInfo nodeinfo, String user) {
        return CommandResult.FAILURE_API_NOT_SUPPORTED(nodeinfo.getNodeName());
    }

    public CommandResult checkSSHSetup(NodeInfo nodeinfo) {
        return CommandResult.FAILURE_API_NOT_SUPPORTED(nodeinfo.getNodeName());
    }

    public CommandResult checkSSHSetup(NodeInfo nodeinfo, String user) {
        return CommandResult.FAILURE_API_NOT_SUPPORTED(nodeinfo.getNodeName());
    }

    protected void checkUserEquivPrereqs(Session sess) throws RemoteShellFatalException {
        if (!sess.isUserNameSet() || !sess.isPasswordSet()) {
            throw new RemoteShellFatalException("PROV-16052", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16052"));
        }
    }

    protected void checkCreateListedDirPrereqs(Paths paths) throws FatalException {
        throw new FatalException("PROV-17000", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-17000"));
    }

    protected void checkRemoveListedPathsPrereqs(Paths paths) throws FatalException {
        throw new FatalException("PROV-17000", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-17000"));
    }

    public static String getNativeForm(String stdPath) {
        String retPath = stdPath.replace('/', '\\');
        return retPath;
    }

    protected CommandResult convertFile(NodeInfo nodeinfo, int platform, String file) {
        return CommandResult.FAILURE_API_NOT_SUPPORTED(nodeinfo.getNodeName());
    }
}

