/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.remoteinterfaces.plugins;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.prov.remoteinterfaces.cluster.NodeInfo;
import oracle.sysman.prov.remoteinterfaces.exception.CommandException;
import oracle.sysman.prov.remoteinterfaces.logger.ClusterLogger;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Constants;
import oracle.sysman.prov.remoteinterfaces.nativesystem.NativeSystem;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Paths;
import oracle.sysman.prov.remoteinterfaces.plugins.MyUserInfo;
import oracle.sysman.prov.remoteinterfaces.plugins.RemoteCommand;
import oracle.sysman.prov.remoteinterfaces.result.CommandResult;

public class RemoteCommandJSCH
implements RemoteCommand,
Constants {
    private static final String DELIM2 = ":";
    private static final String EXITCODE_STR = "EXITCODE";
    private int m_exitVal = 0;
    private String m_out = null;
    private String r_error = null;

    String convertToStr(String[] arr) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            buffer.append(arr[i]);
            buffer.append(" ");
        }
        return buffer.toString();
    }

    private void cleanup(Channel ch, Session sess) {
        if (ch != null) {
            ch.disconnect();
        }
        if (sess != null) {
            sess.disconnect();
        }
    }

    public String getOutput() {
        return this.m_out;
    }

    public int getExitCode() {
        return this.m_exitVal;
    }

    public String getError() {
        return this.r_error;
    }

    public CommandResult runcmd(NodeInfo nodeinfo, String[] cmdarr, String[] input, String[] env, boolean bSsh) {
        nodeinfo.getNativeSystem();
        Map s_sessions = NativeSystem.getSessions();
        oracle.sysman.prov.remoteinterfaces.nativesystem.Session sess = (oracle.sysman.prov.remoteinterfaces.nativesystem.Session)s_sessions.get(nodeinfo.getSessionId());
        String node = nodeinfo.getNodeName();
        CommandResult result = new CommandResult(node);
        String cmdStr = this.convertToStr(cmdarr);
        ClusterLogger.log(cmdStr, ClusterLogger.LOG_INFO, false);
        if (!bSsh) {
            return null;
        }
        this.runJschCommand(sess, node, cmdStr, input);
        int retVal = this.getExitCode();
        CommandException ex = null;
        int exitVal = 1;
        if (retVal != 0) {
            ClusterLogger.log(cmdStr, ClusterLogger.LOG_INFO, false);
            ClusterLogger.log("Error: Not able to run the command on node " + node + ". Retval of runcmd: " + retVal, ClusterLogger.LOG_INFO, false);
            ex = new CommandException(node, "PROV-16003", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16003", (Object[])new String[]{cmdStr}));
            ex.setErrLevel(4);
        } else {
            exitVal = this.getExitCode();
            if (bSsh) {
                ClusterLogger.log("Exitcode of the remote command [rnode " + node + "]: " + exitVal, ClusterLogger.LOG_INFO, false);
                result.setExitCode(exitVal);
            } else {
                ClusterLogger.log("Exitcode of the rsh command [rnode " + node + "]: " + exitVal, ClusterLogger.LOG_INFO, false);
            }
            if (exitVal != 0) {
                if (bSsh) {
                    ex = new CommandException(node, "PROV-16004", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16004", (Object[])new String[]{cmdStr, String.valueOf(exitVal)}));
                    ex.setErrLevel(1);
                } else {
                    ex = new CommandException(node, "PROV-16010", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16010", (Object[])new String[]{cmdStr, String.valueOf(exitVal)}));
                    ex.setErrLevel(3);
                }
            }
        }
        String cmdOut = this.getOutput();
        result.setOutStr(cmdOut);
        ClusterLogger.log("Outstream [rnode " + node + "]: " + cmdOut, ClusterLogger.LOG_FINEST, false);
        String[] errors = null;
        if (null != this.getError()) {
            errors = OiixFunctionOps.explodeString((String)this.getError(), (String)"\n");
            ClusterLogger.log("Errstream [rnode " + node + "]: " + this.getError(), ClusterLogger.LOG_INFO, false);
        }
        if (null != errors) {
            StringBuffer buffer = new StringBuffer();
            String lineSep = LINE_SEPARATOR;
            for (int i = 0; i < errors.length; ++i) {
                if (sess.getCommands().ignoreErrString(errors[i])) continue;
                buffer.append(errors[i]);
                buffer.append(lineSep);
            }
            String cmdError = buffer.toString();
            if (cmdError.length() != 0) {
                result.setErrStr(cmdError);
                if (ex == null) {
                    ex = new CommandException(node, cmdError);
                    ex.setErrLevel(2);
                }
            }
        }
        if (ex != null) {
            result.setException(ex);
            result.setStatus(false);
            result.setResult(new Boolean(false));
            ClusterLogger.log("CommandResult status [rnode " + node + "]: false", ClusterLogger.LOG_INFO, false);
        } else {
            result.setStatus(true);
            result.setResult(new Boolean(true));
            ClusterLogger.log("CommandResult status [rnode " + node + "]: true", ClusterLogger.LOG_INFO, false);
        }
        return result;
    }

    private void runJschCommand(oracle.sysman.prov.remoteinterfaces.nativesystem.Session sess, String node, String cmdStr, String[] input) {
        Channel channel = null;
        Session session = null;
        try {
            JSch jsch = new JSch();
            String m_user = sess.getUsername();
            session = jsch.getSession(m_user, node, 22);
            MyUserInfo ui = new MyUserInfo(sess.getPassword());
            session.setUserInfo((UserInfo)ui);
            Properties configProps = new Properties();
            configProps.put("StrictHostKeyChecking", "no");
            session.setConfig(configProps);
            session.connect();
            channel = session.openChannel("exec");
            ((ChannelExec)channel).setCommand(cmdStr);
            channel.setXForwarding(true);
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            ((ChannelExec)channel).setErrStream((OutputStream)bo);
            InputStream in = channel.getInputStream();
            OutputStream out = channel.getOutputStream();
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(out));
            channel.connect();
            ClusterLogger.log("[" + node + "]: ", ClusterLogger.LOG_INFO, true);
            ClusterLogger.log(cmdStr, ClusterLogger.LOG_INFO, true);
            StringBuffer buf = new StringBuffer();
            byte[] tmp = new byte[1024];
            while (true) {
                String inputStr;
                int i;
                if (in.available() > 0 && (i = in.read(tmp, 0, 1024)) >= 0) {
                    buf.append(new String(tmp, 0, i - 1));
                    continue;
                }
                if (null != input && (inputStr = this.convertToStr(input)).length() > 0) {
                    bw.write(inputStr);
                    bw.newLine();
                    bw.flush();
                }
                if (channel.isClosed()) {
                    this.m_exitVal = channel.getExitStatus();
                    ClusterLogger.log("Exit-status: " + channel.getExitStatus(), ClusterLogger.LOG_INFO, true);
                    this.r_error = bo.toString();
                    if (this.r_error == null) break;
                    ClusterLogger.log("Error: " + this.r_error, ClusterLogger.LOG_INFO, true);
                    break;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ee) {
                    ClusterLogger.log(this.r_error, ClusterLogger.LOG_INFO, true);
                    ClusterLogger.log(ee, ClusterLogger.LOG_INFO);
                }
            }
            channel.disconnect();
            session.disconnect();
            this.m_out = buf.toString();
        }
        catch (Exception e) {
            ClusterLogger.log(this.r_error, ClusterLogger.LOG_INFO, true);
            ClusterLogger.log(e, ClusterLogger.LOG_INFO);
            ClusterLogger.log(this.m_out, ClusterLogger.LOG_INFO, true);
            this.cleanup(channel, session);
        }
        ClusterLogger.log(this.m_out, ClusterLogger.LOG_INFO, true);
        this.cleanup(channel, session);
    }

    public CommandResult copyFile(NodeInfo nodeinfo1, String file1, NodeInfo nodeinfo2, String file2) {
        String node2;
        String node1 = nodeinfo1.getNodeName();
        String node = node2 = nodeinfo2.getNodeName();
        NodeInfo nodeinfo = nodeinfo2;
        boolean sourceIsLocal = true;
        if (node2.equals("localhost")) {
            node = node1;
            nodeinfo = nodeinfo1;
            sourceIsLocal = false;
        }
        nodeinfo.getNativeSystem();
        Map s_sessions = NativeSystem.getSessions();
        oracle.sysman.prov.remoteinterfaces.nativesystem.Session sess = (oracle.sysman.prov.remoteinterfaces.nativesystem.Session)s_sessions.get(nodeinfo.getSessionId());
        CommandResult result = new CommandResult(node);
        if (nodeinfo.isSshSet()) {
            try {
                if (sourceIsLocal) {
                    this.scpTo(sess, node, file1, file2);
                } else {
                    this.scpFrom(sess, node, file2, file1);
                }
                result.setStatus(true);
                result.setResult(new Boolean(true));
            }
            catch (CommandException ce) {
                result.setException(ce);
                result.setStatus(false);
                result.setResult(new Boolean(false));
                ClusterLogger.log("CommandResult status [rnode " + node + "]: false", ClusterLogger.LOG_INFO, false);
            }
        }
        return result;
    }

    private void scpTo(oracle.sysman.prov.remoteinterfaces.nativesystem.Session sess, String node, String localFile, String remoteFile) throws CommandException {
        ClusterLogger.log("Copy localfile: " + localFile + " to remotefile: " + remoteFile + "remote node: " + node + "\n", ClusterLogger.LOG_INFO, true);
        Channel channel = null;
        Session session = null;
        try {
            int len;
            JSch jsch = new JSch();
            String m_user = sess.getUsername();
            session = jsch.getSession(m_user, node, 22);
            MyUserInfo ui = new MyUserInfo(sess.getPassword());
            session.setUserInfo((UserInfo)ui);
            Properties configProps = new Properties();
            configProps.put("StrictHostKeyChecking", "no");
            session.setConfig(configProps);
            session.connect();
            String command = "scp -p -t " + remoteFile;
            channel = session.openChannel("exec");
            ((ChannelExec)channel).setCommand(command);
            OutputStream out = channel.getOutputStream();
            InputStream in = channel.getInputStream();
            channel.connect();
            byte[] tmp = new byte[1];
            if (this.checkAck(in) != 0) {
                this.cleanup(channel, session);
                return;
            }
            long filesize = new File(localFile).length();
            command = "C0644 " + filesize + " ";
            command = localFile.lastIndexOf(47) > 0 ? command + localFile.substring(localFile.lastIndexOf(47) + 1) : command + localFile;
            command = command + "\n";
            out.write(command.getBytes());
            out.flush();
            if (this.checkAck(in) != 0) {
                this.cleanup(channel, session);
                return;
            }
            FileInputStream fis = new FileInputStream(localFile);
            byte[] buf = new byte[1024];
            while ((len = fis.read(buf, 0, buf.length)) > 0) {
                out.write(buf, 0, len);
                out.flush();
            }
            buf[0] = 0;
            out.write(buf, 0, 1);
            out.flush();
            if (this.checkAck(in) != 0) {
                this.cleanup(channel, session);
                return;
            }
        }
        catch (Exception ex) {
            this.cleanup(channel, session);
            throw new CommandException(node, "PROV-16011", ex.getMessage(), ex);
        }
        this.cleanup(channel, session);
    }

    private void scpFrom(oracle.sysman.prov.remoteinterfaces.nativesystem.Session sess, String node, String localFile, String remoteFile) throws CommandException {
        Channel channel = null;
        Session session = null;
        ClusterLogger.log("Copy remotefile: " + remoteFile + " to localfile: " + localFile + "\n", ClusterLogger.LOG_INFO, true);
        try {
            int c;
            String prefix = null;
            if (new File(localFile).isDirectory()) {
                prefix = localFile + File.separator;
            }
            JSch jsch = new JSch();
            String m_user = sess.getUsername();
            session = jsch.getSession(m_user, node, 22);
            MyUserInfo ui = new MyUserInfo(sess.getPassword());
            session.setUserInfo((UserInfo)ui);
            Properties configProps = new Properties();
            configProps.put("StrictHostKeyChecking", "no");
            session.setConfig(configProps);
            session.connect();
            String command = "scp -f " + remoteFile;
            channel = session.openChannel("exec");
            ((ChannelExec)channel).setCommand(command);
            OutputStream out = channel.getOutputStream();
            InputStream in = channel.getInputStream();
            channel.connect();
            byte[] buf = new byte[1024];
            buf[0] = 0;
            out.write(buf, 0, 1);
            out.flush();
            while ((c = this.checkAck(in)) == 67) {
                int foo;
                in.read(buf, 0, 5);
                long filesize = 0L;
                while (in.read(buf, 0, 1) >= 0 && buf[0] != 32) {
                    filesize = filesize * 10L + (long)(buf[0] - 48);
                }
                String file = null;
                int i = 0;
                while (true) {
                    in.read(buf, i, 1);
                    if (buf[i] == 10) break;
                    ++i;
                }
                file = new String(buf, 0, i);
                buf[0] = 0;
                out.write(buf, 0, 1);
                out.flush();
                FileOutputStream fos = new FileOutputStream(prefix == null ? localFile : prefix + file);
                do {
                    foo = (long)buf.length < filesize ? buf.length : (int)filesize;
                    if ((foo = in.read(buf, 0, foo)) < 0) break;
                    fos.write(buf, 0, foo);
                } while ((filesize -= (long)foo) != 0L);
                fos.close();
                byte[] tmp = new byte[1];
                if (this.checkAck(in) != 0) {
                    this.cleanup(channel, session);
                    return;
                }
                buf[0] = 0;
                out.write(buf, 0, 1);
                out.flush();
            }
        }
        catch (Exception ex) {
            this.cleanup(channel, session);
            throw new CommandException(node, "PROV-16011", ex.getMessage(), ex);
        }
        this.cleanup(channel, session);
    }

    private int checkAck(InputStream in) throws IOException {
        int b = in.read();
        if (b == 0) {
            return b;
        }
        if (b == -1) {
            return b;
        }
        if (b == 1 || b == 2) {
            int c;
            StringBuffer sb = new StringBuffer();
            do {
                c = in.read();
                sb.append((char)c);
            } while (c != 10);
            if (b == 1) {
                ClusterLogger.log(sb.toString(), ClusterLogger.LOG_INFO, true);
            }
            if (b == 2) {
                ClusterLogger.log(sb.toString(), ClusterLogger.LOG_INFO, true);
            }
        }
        return b;
    }

    public String[] formulateCmd(boolean bsSh, oracle.sysman.prov.remoteinterfaces.nativesystem.Session sess, String node, Paths paths, String cmd, String cmdArgs, String nodePrefix) {
        String[] cmdarr = null;
        cmdarr = nodePrefix != null ? (bsSh ? this.createCmdArr(paths.getValue("KEY11"), "", "", "", paths.getValue("SH_PATH"), paths.getValue("SH_ARGS"), cmd, cmdArgs) : this.createCmdArr(paths.getValue("KEY10"), sess.getRshPath(), sess.getRshArgs() + " " + nodePrefix + " ", node, paths.getValue("SH_PATH"), paths.getValue("SH_ARGS"), cmd, cmdArgs)) : (bsSh ? this.createCmdArr(paths.getValue("KEY11"), "", "", "", paths.getValue("SH_PATH"), paths.getValue("SH_ARGS"), cmd, cmdArgs) : this.createCmdArr(paths.getValue("KEY10"), sess.getRshPath(), sess.getRshArgs(), node, paths.getValue("SH_PATH"), paths.getValue("SH_ARGS"), cmd, cmdArgs));
        return cmdarr;
    }

    public String[] formulateCmd(String key, boolean bsSh, oracle.sysman.prov.remoteinterfaces.nativesystem.Session sess, String node, Paths paths, String cmd, String cmdArgs) {
        String[] cmdarr = null;
        cmdarr = bsSh ? this.createCmdArr(paths.getValue(key), "", "", "", paths.getValue("SH_PATH"), paths.getValue("SH_ARGS"), cmd, cmdArgs) : this.createCmdArr(paths.getValue(key), sess.getRshPath(), sess.getRshArgs() + " -n ", node, paths.getValue("SH_PATH"), paths.getValue("SH_ARGS"), cmd, cmdArgs);
        return cmdarr;
    }

    public String[] formulateCmd(String key, oracle.sysman.prov.remoteinterfaces.nativesystem.Session sess, String node, Paths paths, String cmd, String cmdArgs, String sudoPath, String sudoArgs) {
        String[] cmdarr = null;
        boolean bsSh = sess.getNodeInfo(node).isSshSet();
        cmdarr = bsSh ? this.createCmdArr(paths.getValue(key), "", "", "", paths.getValue("SH_PATH"), paths.getValue("SH_ARGS"), "'" + cmd + " " + cmdArgs + "'", "", sudoPath, sudoArgs) : this.createCmdArr(paths.getValue(key), sess.getRshPath(), sess.getRshArgs(), node, paths.getValue("SH_PATH"), paths.getValue("SH_ARGS"), cmd, cmdArgs);
        return cmdarr;
    }

    public String[] formulateCmd(boolean bSsh, String node, Paths paths, String remoteShellPath, String remoteShellArgs, String cmd, String cmdArgs, String nodePrefix) {
        String[] cmdarr = null;
        cmdarr = nodePrefix == null ? this.createCmdArr(paths.getValue("KEY11"), "", "", "", "", "", cmd, cmdArgs) : this.createCmdArr(paths.getValue("KEY11"), remoteShellPath, remoteShellArgs + " " + nodePrefix + " ", node, "", "", cmd, cmdArgs);
        return cmdarr;
    }

    public String[] formulateCmd(boolean bSsh, String node, Paths paths, String remoteShellPath, String remoteShellArgs, String cmd, String cmdArgs, String nodePrefix, String username) {
        String[] cmdarr = null;
        if (nodePrefix == null && username == null) {
            cmdarr = this.createCmdArr(paths.getValue("KEY11"), "", "", "", "", "", cmd, cmdArgs);
        }
        return cmdarr;
    }

    public String formulateCmd(Paths paths, String key, String dirpath, String flag) {
        return MessageFormat.format(paths.getValue(key), "", "'" + dirpath + "'", "", "", flag);
    }

    public String[] formulateCmd(String key, boolean bsSh, oracle.sysman.prov.remoteinterfaces.nativesystem.Session sess, String node, Paths paths, String cmd, String cmdArgs, String username) {
        String[] cmdarr = null;
        cmdarr = bsSh ? this.createCmdArr(paths.getValue(key), "", "", "", paths.getValue("SH_PATH"), paths.getValue("SH_ARGS"), cmd, cmdArgs) : this.createCmdArr(paths.getValue(key), sess.getRshPath(), sess.getRshArgs() + " -l " + username + " -n ", node, paths.getValue("SH_PATH"), paths.getValue("SH_ARGS"), cmd, cmdArgs);
        return cmdarr;
    }

    private String[] createCmdArr(String formatStr, String remoteShellPath, String remoteShellArgs, String node, String loginShellPath, String loginShellArgs, String cmdPath, String cmdArgs) {
        StringTokenizer st = new StringTokenizer(remoteShellArgs);
        StringBuffer tmpBuf = new StringBuffer();
        int n = st.countTokens();
        if (st.hasMoreTokens()) {
            tmpBuf.append(st.nextToken());
        }
        for (int i = 1; i < n; ++i) {
            tmpBuf.append("#");
            tmpBuf.append(st.nextToken());
        }
        remoteShellArgs = tmpBuf.toString();
        String unixcmd = MessageFormat.format(formatStr, remoteShellPath, remoteShellArgs, node, loginShellPath, loginShellArgs, cmdPath + " " + cmdArgs);
        ClusterLogger.log(unixcmd, ClusterLogger.LOG_INFO, true);
        st = new StringTokenizer(unixcmd, "#");
        String[] cmdArr = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            cmdArr[i] = st.nextToken();
            ++i;
        }
        return cmdArr;
    }

    private String[] createCmdArr(String formatStr, String remoteShellPath, String remoteShellArgs, String node, String loginShellPath, String loginShellArgs, String cmdPath, String cmdArgs, String sudoPath, String sudoArgs) {
        StringTokenizer st = new StringTokenizer(remoteShellArgs);
        StringBuffer tmpBuf = new StringBuffer();
        int n = st.countTokens();
        if (st.hasMoreTokens()) {
            tmpBuf.append(st.nextToken());
        }
        for (int i = 1; i < n; ++i) {
            tmpBuf.append("#");
            tmpBuf.append(st.nextToken());
        }
        remoteShellArgs = tmpBuf.toString();
        String unixcmd = MessageFormat.format(formatStr, remoteShellPath, remoteShellArgs, node, loginShellPath, loginShellArgs, cmdPath + " " + cmdArgs, sudoPath, sudoArgs);
        ClusterLogger.log(unixcmd, ClusterLogger.LOG_INFO, true);
        st = new StringTokenizer(unixcmd, "#");
        String[] cmdArr = new String[st.countTokens()];
        System.out.println();
        int i = 0;
        while (st.hasMoreTokens()) {
            cmdArr[i] = st.nextToken();
            ++i;
        }
        System.out.println();
        return cmdArr;
    }

    public String[] formulateLocalCmd(String key, String node, String cmd, String cmdArgs) {
        return this.createCmdArr(key, node, cmd, cmdArgs);
    }

    private String[] createCmdArr(String formatStr, String node, String cmdPath, String cmdArgs) {
        StringTokenizer st = new StringTokenizer(cmdArgs);
        StringBuffer tmpBuf = new StringBuffer();
        int n = st.countTokens();
        if (st.hasMoreTokens()) {
            tmpBuf.append(st.nextToken());
        }
        for (int i = 1; i < n; ++i) {
            tmpBuf.append("#");
            tmpBuf.append(st.nextToken());
        }
        String args = tmpBuf.toString();
        String unixcmd = MessageFormat.format(formatStr, "", "", node, "", "", "", cmdPath, args);
        ClusterLogger.log(unixcmd, ClusterLogger.LOG_INFO, true);
        st = new StringTokenizer(unixcmd, "#");
        String[] cmdArr = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            cmdArr[i] = st.nextToken();
            ++i;
        }
        return cmdArr;
    }

    public CommandResult runCmdWithoutWait(NodeInfo nodeinfo, String[] cmdArr, boolean bSsh) {
        nodeinfo.getNativeSystem();
        Map s_sessions = NativeSystem.getSessions();
        oracle.sysman.prov.remoteinterfaces.nativesystem.Session sess = (oracle.sysman.prov.remoteinterfaces.nativesystem.Session)s_sessions.get(nodeinfo.getSessionId());
        String node = nodeinfo.getNodeName();
        String cmdStr = this.convertToStr(cmdArr);
        CommandResult result = new CommandResult(node);
        Channel channel = null;
        Session session = null;
        try {
            int i;
            JSch jsch = new JSch();
            String m_user = sess.getUsername();
            session = jsch.getSession(m_user, node, 22);
            MyUserInfo ui = new MyUserInfo(sess.getPassword());
            session.setUserInfo((UserInfo)ui);
            Properties configProps = new Properties();
            configProps.put("StrictHostKeyChecking", "no");
            session.setConfig(configProps);
            session.connect();
            channel = session.openChannel("exec");
            ((ChannelExec)channel).setCommand(cmdStr);
            channel.setXForwarding(true);
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            ((ChannelExec)channel).setErrStream((OutputStream)bo);
            InputStream in = channel.getInputStream();
            channel.connect();
            ClusterLogger.log("[" + node + "]: ", ClusterLogger.LOG_INFO, true);
            ClusterLogger.log(cmdStr, ClusterLogger.LOG_INFO, true);
            StringBuffer buf = new StringBuffer();
            byte[] tmp = new byte[1024];
            while (in.available() > 0 && (i = in.read(tmp, 0, 1024)) >= 0) {
                buf.append(new String(tmp, 0, i - 1));
            }
            if (channel.isEOF()) {
                this.m_exitVal = channel.getExitStatus();
                ClusterLogger.log("Exit-status: " + channel.getExitStatus(), ClusterLogger.LOG_INFO, true);
                this.r_error = bo.toString();
                if (this.r_error != null) {
                    ClusterLogger.log("Error: " + this.r_error, ClusterLogger.LOG_INFO, true);
                }
                result.setStatus(true);
            } else {
                result.setStatus(false);
            }
            channel.disconnect();
            session.disconnect();
            this.m_out = buf.toString();
        }
        catch (Exception e) {
            ClusterLogger.log(this.r_error, ClusterLogger.LOG_INFO, true);
            ClusterLogger.log(e, ClusterLogger.LOG_INFO);
            ClusterLogger.log(this.m_out, ClusterLogger.LOG_INFO, true);
            this.cleanup(channel, session);
        }
        ClusterLogger.log(this.m_out, ClusterLogger.LOG_INFO, true);
        this.cleanup(channel, session);
        return result;
    }
}

