/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.remoteinterfaces.plugins;

import java.text.MessageFormat;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.prov.remoteinterfaces.cluster.NodeInfo;
import oracle.sysman.prov.remoteinterfaces.exception.CommandException;
import oracle.sysman.prov.remoteinterfaces.logger.ClusterLogger;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Constants;
import oracle.sysman.prov.remoteinterfaces.nativesystem.NativeSystem;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Paths;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Session;
import oracle.sysman.prov.remoteinterfaces.plugins.RemoteCommand;
import oracle.sysman.prov.remoteinterfaces.plugins.RuntimeExec;
import oracle.sysman.prov.remoteinterfaces.result.CommandResult;

public class RemoteCommandSSH
implements RemoteCommand,
Constants {
    private static final String DELIM2 = ":";
    private static final String EXITCODE_STR = "EXITCODE";

    String convertToStr(String[] arr) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            buffer.append(arr[i]);
            buffer.append(" ");
        }
        return buffer.toString();
    }

    public CommandResult runcmd(NodeInfo nodeinfo, String[] cmdarr, String[] input, String[] env, boolean bSsh) {
        nodeinfo.getNativeSystem();
        Map s_sessions = NativeSystem.getSessions();
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        String node = nodeinfo.getNodeName();
        CommandResult result = new CommandResult(node);
        String cmdStr = this.convertToStr(cmdarr);
        ClusterLogger.log(cmdStr, ClusterLogger.LOG_INFO, false);
        RuntimeExec runtime = new RuntimeExec(cmdarr, input, env);
        int retVal = runtime.runCommand();
        CommandException ex = null;
        int exitVal = 1;
        if (retVal != 0) {
            ClusterLogger.log(cmdStr, ClusterLogger.LOG_INFO, false);
            ClusterLogger.log("Error: Not able to run the command on node " + node + ". Retval of runcmd: " + retVal, ClusterLogger.LOG_INFO, false);
            ex = new CommandException(node, "PROV-16003", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16003", (Object[])new String[]{cmdStr}));
            ex.setErrLevel(4);
        } else {
            exitVal = runtime.getExitValue();
            if (bSsh) {
                ClusterLogger.log("Exitcode of the remote command [rnode " + node + "]: " + exitVal, ClusterLogger.LOG_INFO, false);
                result.setExitCode(exitVal);
            } else {
                ClusterLogger.log("Exitcode of the rsh command [rnode " + node + "]: " + exitVal, ClusterLogger.LOG_INFO, false);
            }
            if (exitVal != 0) {
                if (bSsh) {
                    ex = new CommandException(node, "PROV-16004", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16004", (Object[])new String[]{cmdStr, String.valueOf(exitVal)}));
                    ex.setErrLevel(1);
                } else {
                    ex = new CommandException(node, "PROV-16010", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16010", (Object[])new String[]{cmdStr, String.valueOf(exitVal)}));
                    ex.setErrLevel(3);
                }
            }
        }
        String cmdOut = runtime.getOutputString();
        result.setOutStr(cmdOut);
        ClusterLogger.log("Outstream [rnode " + node + "]: " + cmdOut, ClusterLogger.LOG_FINEST, false);
        if (!bSsh && ex == null) {
            exitVal = 1;
            String temp2 = "";
            if (cmdOut != null) {
                StringTokenizer st = new StringTokenizer(cmdOut, DELIM2);
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (token.indexOf(EXITCODE_STR) != 0) continue;
                    temp2 = st.nextToken();
                    try {
                        exitVal = Integer.parseInt(temp2.trim());
                    }
                    catch (NumberFormatException nfe) {
                        exitVal = 1;
                    }
                    break;
                }
            }
            ClusterLogger.log("Exitcode of the remote command [rnode " + node + "]: " + exitVal, ClusterLogger.LOG_INFO, false);
            result.setExitCode(exitVal);
            if (exitVal != 0) {
                ex = new CommandException(node, "PROV-16004", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16004", (Object[])new String[]{cmdStr, temp2}));
                ex.setErrLevel(1);
            }
        }
        String[] errors = runtime.getError();
        ClusterLogger.log("Errstream [rnode " + node + "]: " + runtime.getErrorString(), ClusterLogger.LOG_INFO, false);
        if (errors.length > 0) {
            StringBuffer buffer = new StringBuffer();
            String lineSep = LINE_SEPARATOR;
            for (int i = 0; i < errors.length; ++i) {
                if (sess.getCommands().ignoreErrString(errors[i])) continue;
                buffer.append(errors[i]);
                buffer.append(lineSep);
            }
            String cmdError = buffer.toString();
            if (cmdError.length() != 0) {
                result.setErrStr(cmdError);
                if (ex == null) {
                    ex = new CommandException(node, cmdError);
                    ex.setErrLevel(2);
                }
            }
        }
        if (ex != null) {
            result.setException(ex);
            result.setStatus(false);
            result.setResult(new Boolean(false));
            ClusterLogger.log("CommandResult status [rnode " + node + "]: false", ClusterLogger.LOG_INFO, false);
        } else {
            result.setStatus(true);
            result.setResult(new Boolean(true));
            ClusterLogger.log("CommandResult status [rnode " + node + "]: true", ClusterLogger.LOG_INFO, false);
        }
        return result;
    }

    public CommandResult copyFile(NodeInfo nodeinfo1, String file1, NodeInfo nodeinfo2, String file2) {
        String node2;
        CommandResult result = null;
        String node1 = nodeinfo1.getNodeName();
        String node = node2 = nodeinfo2.getNodeName();
        NodeInfo nodeinfo = nodeinfo2;
        boolean sourceIsLocal = true;
        if (node2.equals("localhost")) {
            node = node1;
            nodeinfo = nodeinfo1;
            sourceIsLocal = false;
        }
        nodeinfo.getNativeSystem();
        Map s_sessions = NativeSystem.getSessions();
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        String unixcmd = null;
        unixcmd = nodeinfo.isSshSet() ? sess.getScpPath() + " " + sess.getScpArgs() : sess.getRcpPath() + " " + sess.getRcpArgs();
        unixcmd = unixcmd + " " + nodeinfo1.getNativeSystem().createFileName(nodeinfo1, file1) + " " + nodeinfo2.getNativeSystem().createFileName(nodeinfo2, file2);
        result = nodeinfo.getNativeSystem().runcmd(nodeinfo, unixcmd, true);
        return result;
    }

    public String[] formulateCmd(boolean bsSh, Session sess, String node, Paths paths, String cmd, String cmdArgs, String nodePrefix) {
        String[] cmdarr = null;
        cmdarr = nodePrefix != null ? (bsSh ? this.createCmdArr(paths.getValue("KEY11"), sess.getSshPath(), sess.getSshArgs() + " " + nodePrefix + " ", node, paths.getValue("SH_PATH"), paths.getValue("SH_ARGS"), cmd, cmdArgs) : this.createCmdArr(paths.getValue("KEY10"), sess.getRshPath(), sess.getRshArgs() + " " + nodePrefix + " ", node, paths.getValue("SH_PATH"), paths.getValue("SH_ARGS"), cmd, cmdArgs)) : (bsSh ? this.createCmdArr(paths.getValue("KEY11"), sess.getSshPath(), sess.getSshArgs(), node, paths.getValue("SH_PATH"), paths.getValue("SH_ARGS"), cmd, cmdArgs) : this.createCmdArr(paths.getValue("KEY10"), sess.getRshPath(), sess.getRshArgs(), node, paths.getValue("SH_PATH"), paths.getValue("SH_ARGS"), cmd, cmdArgs));
        return cmdarr;
    }

    public String[] formulateCmd(String key, boolean bsSh, Session sess, String node, Paths paths, String cmd, String cmdArgs) {
        String[] cmdarr = null;
        cmdarr = bsSh ? this.createCmdArr(paths.getValue(key), sess.getSshPath(), sess.getSshArgs() + " -n ", node, paths.getValue("SH_PATH"), paths.getValue("SH_ARGS"), cmd, cmdArgs) : this.createCmdArr(paths.getValue(key), sess.getRshPath(), sess.getRshArgs() + " -n ", node, paths.getValue("SH_PATH"), paths.getValue("SH_ARGS"), cmd, cmdArgs);
        return cmdarr;
    }

    public String[] formulateCmd(String key, Session sess, String node, Paths paths, String cmd, String cmdArgs, String sudoPath, String sudoArgs) {
        String[] cmdarr = null;
        boolean bsSh = sess.getNodeInfo(node).isSshSet();
        cmdarr = bsSh ? this.createCmdArr(paths.getValue(key), sess.getSshPath(), sess.getSshArgs(), node, "", "", cmd, cmdArgs, sudoPath, sudoArgs) : this.createCmdArr(paths.getValue(key), sess.getRshPath(), sess.getRshArgs(), node, paths.getValue("SH_PATH"), paths.getValue("SH_ARGS"), cmd, cmdArgs, sudoPath, sudoArgs);
        return cmdarr;
    }

    public String[] formulateCmd(boolean bSsh, String node, Paths paths, String remoteShellPath, String remoteShellArgs, String cmd, String cmdArgs, String nodePrefix) {
        String[] cmdarr = null;
        cmdarr = nodePrefix == null ? this.createCmdArr(paths.getValue("KEY11"), remoteShellPath, remoteShellArgs, node, "", "", cmd, cmdArgs) : this.createCmdArr(paths.getValue("KEY11"), remoteShellPath, remoteShellArgs + " " + nodePrefix + " ", node, "", "", cmd, cmdArgs);
        return cmdarr;
    }

    public String[] formulateCmd(boolean bSsh, String node, Paths paths, String remoteShellPath, String remoteShellArgs, String cmd, String cmdArgs, String nodePrefix, String username) {
        String[] cmdarr = null;
        cmdarr = nodePrefix == null && username == null ? this.createCmdArr(paths.getValue("KEY11"), remoteShellPath, remoteShellArgs, node, "", "", cmd, cmdArgs) : this.createCmdArr(paths.getValue("KEY11"), remoteShellPath, remoteShellArgs + " -l " + username + " " + nodePrefix + " ", node, "", "", cmd, cmdArgs);
        return cmdarr;
    }

    public String formulateCmd(Paths paths, String key, String dirpath, String flag) {
        return MessageFormat.format(paths.getValue(key), "", "'" + dirpath + "'", "", "", flag);
    }

    public String[] formulateCmd(String key, boolean bsSh, Session sess, String node, Paths paths, String cmd, String cmdArgs, String username) {
        String[] cmdarr = null;
        cmdarr = bsSh ? this.createCmdArr(paths.getValue(key), sess.getSshPath(), sess.getSshArgs() + " -l " + username + " -n ", node, paths.getValue("SH_PATH"), paths.getValue("SH_ARGS"), cmd, cmdArgs) : this.createCmdArr(paths.getValue(key), sess.getRshPath(), sess.getRshArgs() + " -l " + username + " -n ", node, paths.getValue("SH_PATH"), paths.getValue("SH_ARGS"), cmd, cmdArgs);
        return cmdarr;
    }

    private String[] createCmdArr(String formatStr, String remoteShellPath, String remoteShellArgs, String node, String loginShellPath, String loginShellArgs, String cmdPath, String cmdArgs) {
        StringTokenizer st = new StringTokenizer(remoteShellArgs);
        StringBuffer tmpBuf = new StringBuffer();
        int n = st.countTokens();
        if (st.hasMoreTokens()) {
            tmpBuf.append(st.nextToken());
        }
        for (int i = 1; i < n; ++i) {
            tmpBuf.append("#");
            tmpBuf.append(st.nextToken());
        }
        remoteShellArgs = tmpBuf.toString();
        String unixcmd = MessageFormat.format(formatStr, remoteShellPath, remoteShellArgs, node, loginShellPath, loginShellArgs, cmdPath + " " + cmdArgs);
        ClusterLogger.log(unixcmd, ClusterLogger.LOG_INFO, true);
        st = new StringTokenizer(unixcmd, "#");
        String[] cmdArr = new String[st.countTokens()];
        System.out.println();
        int i = 0;
        while (st.hasMoreTokens()) {
            cmdArr[i] = st.nextToken();
            ++i;
        }
        System.out.println();
        return cmdArr;
    }

    private String[] createCmdArr(String formatStr, String remoteShellPath, String remoteShellArgs, String node, String loginShellPath, String loginShellArgs, String cmdPath, String cmdArgs, String sudoPath, String sudoArgs) {
        StringTokenizer st = new StringTokenizer(remoteShellArgs);
        StringBuffer tmpBuf = new StringBuffer();
        int n = st.countTokens();
        if (st.hasMoreTokens()) {
            tmpBuf.append(st.nextToken());
        }
        for (int i = 1; i < n; ++i) {
            tmpBuf.append("#");
            tmpBuf.append(st.nextToken());
        }
        remoteShellArgs = tmpBuf.toString();
        String unixcmd = MessageFormat.format(formatStr, remoteShellPath, remoteShellArgs, node, loginShellPath, loginShellArgs, cmdPath + " " + cmdArgs, sudoPath, sudoArgs);
        ClusterLogger.log(unixcmd, ClusterLogger.LOG_INFO, true);
        st = new StringTokenizer(unixcmd, "#");
        String[] cmdArr = new String[st.countTokens()];
        System.out.println();
        int i = 0;
        while (st.hasMoreTokens()) {
            cmdArr[i] = st.nextToken();
            ++i;
        }
        System.out.println();
        return cmdArr;
    }

    public String[] formulateLocalCmd(String key, String node, String cmd, String cmdArgs) {
        return this.createCmdArr(key, node, cmd, cmdArgs);
    }

    private String[] createCmdArr(String formatStr, String node, String cmdPath, String cmdArgs) {
        StringTokenizer st = new StringTokenizer(cmdArgs);
        StringBuffer tmpBuf = new StringBuffer();
        int n = st.countTokens();
        if (st.hasMoreTokens()) {
            tmpBuf.append(st.nextToken());
        }
        for (int i = 1; i < n; ++i) {
            tmpBuf.append("#");
            tmpBuf.append(st.nextToken());
        }
        String args = tmpBuf.toString();
        String unixcmd = MessageFormat.format(formatStr, "", "", node, "", "", "", cmdPath, args);
        ClusterLogger.log(unixcmd, ClusterLogger.LOG_INFO, true);
        st = new StringTokenizer(unixcmd, "#");
        String[] cmdArr = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            cmdArr[i] = st.nextToken();
            ++i;
        }
        return cmdArr;
    }

    public CommandResult runCmdWithoutWait(NodeInfo nodeinfo, String[] cmdarr, boolean bSsh) {
        nodeinfo.getNativeSystem();
        Map s_sessions = NativeSystem.getSessions();
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        String node = nodeinfo.getNodeName();
        CommandResult result = new CommandResult(node);
        String cmdStr = this.convertToStr(cmdarr);
        ClusterLogger.log(cmdStr, ClusterLogger.LOG_INFO, false);
        RuntimeExec runtime = new RuntimeExec(cmdarr, null, null);
        int exitVal = -1;
        try {
            exitVal = runtime.runCmdWithoutWait();
            result.setStatus(true);
            result.setResult(new Boolean(true));
        }
        catch (IllegalStateException e) {
            result.setStatus(false);
            result.setResult(new Boolean(false));
        }
        catch (IllegalThreadStateException e) {
            result.setStatus(false);
            result.setResult(new Boolean(false));
        }
        return result;
    }
}

