/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.remoteinterfaces.result;

import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.prov.remoteinterfaces.exception.CommandException;

public class CommandResult {
    private String m_nodeName;
    private boolean m_status;
    private Object m_result = null;
    private CommandException m_exception = null;
    private String m_out = null;
    private String m_err = null;
    private int m_exitcode = 1;

    public CommandResult(String nodename) {
        this.m_nodeName = nodename;
    }

    public String getNodeName() {
        return this.m_nodeName;
    }

    public boolean getStatus() {
        return this.m_status;
    }

    public void setStatus(boolean status) {
        this.m_status = status;
    }

    public Object getResult() {
        return this.m_result;
    }

    public void setResult(Object result) {
        this.m_result = result;
    }

    public CommandException getException() {
        return this.m_exception;
    }

    public void setException(CommandException ex) {
        this.m_exception = ex;
    }

    public String getOutStr() {
        return this.m_out;
    }

    public void setOutStr(String out) {
        this.m_out = out;
    }

    public String getErrStr() {
        return this.m_err;
    }

    public void setErrStr(String err) {
        this.m_err = err;
    }

    public int getExitCode() {
        return this.m_exitcode;
    }

    public void setExitCode(int val) {
        this.m_exitcode = val;
    }

    public static CommandResult SUCCESS(String nodename) {
        CommandResult result = new CommandResult(nodename);
        result.setExitCode(0);
        result.setStatus(true);
        return result;
    }

    public static CommandResult FAILURE_API_NOT_SUPPORTED(String nodename) {
        CommandResult result = new CommandResult(nodename);
        result.setExitCode(1);
        result.setStatus(false);
        result.setException(new CommandException(nodename, "PROV-17000", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-17000")));
        return result;
    }
}

