/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.remoteutil.logger;

import java.util.Hashtable;
import java.util.Vector;
import oracle.sysman.oii.oiio.oiiol.OiiolFileHandler;
import oracle.sysman.oii.oiio.oiiol.OiiolLogger;
import oracle.sysman.prov.remoteinterfaces.logger.ClusterLogger;
import oracle.sysman.prov.remoteutil.xml.DefaultXMLHandler;
import oracle.sysman.prov.remoteutil.xml.ElementHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ConfigXMLHandler
extends DefaultXMLHandler {
    private OiiolLogger m_clusterLogger = null;
    private boolean m_bPrintSourceInfo = false;
    private boolean m_bTraceThreads = false;
    private Vector m_logHandlers = null;
    private Hashtable m_packageTraceTable = null;
    private String m_sLogLoc = null;
    private static final String LOGGER = "LOGGER";
    private static final String HANDLERS = "HANDLERS";
    private static final String FILEHANDLER = "FILEHANDLER";
    private static final String PACKAGES = "PACKAGES";
    private static final String PACKAGE = "PACKAGE";
    private static final String NAME = "NAME";
    private static final String LEVEL = "LEVEL";
    private static final String PRINT_SOURCE = "PRINT_SOURCE";
    private static final String PRINT_THREAD_ID = "PRINT_THREAD_ID";
    private static final String DIR = "DIR";
    private static final String EXTN = "EXTN";
    private static final String LIMIT = "LIMIT";
    private static final String COUNT = "COUNT";
    private static final String LIMITEXCEEDS = "LIMITEXCEEDS";
    private static final String VALUE = "VALUE";

    public OiiolLogger getLogger() {
        return this.m_clusterLogger;
    }

    public void setLogLoc(String dir) {
        this.m_sLogLoc = dir;
    }

    public boolean getPrintSourceInfo() {
        return this.m_bPrintSourceInfo;
    }

    public boolean getTraceThreads() {
        return this.m_bTraceThreads;
    }

    public Vector getLogHandlers() {
        return this.m_logHandlers;
    }

    public Hashtable getPackageTraceTable() {
        return this.m_packageTraceTable;
    }

    public void startDocument() throws SAXException {
        this.m_logHandlers = new Vector();
        this.m_packageTraceTable = new Hashtable();
    }

    protected ElementHandler createElementHandlers() {
        LoggerElementHandler handlerLogger = new LoggerElementHandler(LOGGER);
        ElementHandler handlerHandlers = new ElementHandler(HANDLERS);
        FileHandlerElementHandler handlerHandler = new FileHandlerElementHandler(FILEHANDLER);
        handlerHandlers.addChildHandler(FILEHANDLER, handlerHandler);
        ElementHandler handlerPackages = new ElementHandler(PACKAGES);
        PackageElementHandler handlerPackage = new PackageElementHandler(PACKAGE);
        handlerPackages.addChildHandler(PACKAGE, handlerPackage);
        handlerLogger.addChildHandler(HANDLERS, handlerHandlers);
        handlerLogger.addChildHandler(PACKAGES, handlerPackages);
        return handlerLogger;
    }

    private class PackageElementHandler
    extends ElementHandler {
        public PackageElementHandler(String name) {
            super(name);
        }

        public void onStart(String name, Attributes atts) {
            String packagename = atts.getValue(ConfigXMLHandler.NAME);
            Boolean value = new Boolean(atts.getValue(ConfigXMLHandler.VALUE));
            if (value != null && !value.booleanValue()) {
                ConfigXMLHandler.this.m_packageTraceTable.put(packagename, value);
            }
        }
    }

    private class FileHandlerElementHandler
    extends ElementHandler {
        public FileHandlerElementHandler(String name) {
            super(name);
        }

        public void onStart(String name, Attributes atts) {
            OiiolFileHandler fHandler;
            String filename = atts.getValue(ConfigXMLHandler.NAME);
            String dir = atts.getValue(ConfigXMLHandler.DIR);
            String extn = atts.getValue(ConfigXMLHandler.EXTN);
            String level = atts.getValue(ConfigXMLHandler.LEVEL);
            String limit = atts.getValue(ConfigXMLHandler.LIMIT);
            String count = atts.getValue(ConfigXMLHandler.COUNT);
            String limitExceeds = atts.getValue(ConfigXMLHandler.LIMITEXCEEDS);
            int nLimit = 0;
            int nCount = 1;
            int nLimitExceeds = 0;
            try {
                nLimit = Integer.parseInt(limit);
                nCount = Integer.parseInt(count);
            }
            catch (NumberFormatException nfe) {
                nLimit = 0;
                nCount = 1;
                System.err.println(nfe.toString());
            }
            try {
                nLimitExceeds = Integer.parseInt(limitExceeds);
            }
            catch (NumberFormatException nfe) {
                nLimitExceeds = 0;
                System.err.println(nfe.toString());
            }
            if (ConfigXMLHandler.this.m_sLogLoc != null) {
                dir = ConfigXMLHandler.this.m_sLogLoc;
            }
            if ((fHandler = (OiiolFileHandler)ConfigXMLHandler.this.m_clusterLogger.setLogLocationWithTimestamp(dir, filename, extn, ClusterLogger.getLogLevel(level), null, nLimit, nCount, nLimitExceeds)) != null) {
                ConfigXMLHandler.this.m_logHandlers.add(fHandler);
            }
        }
    }

    private class LoggerElementHandler
    extends ElementHandler {
        public LoggerElementHandler(String name) {
            super(name);
        }

        public void onStart(String name, Attributes atts) {
            String loggername = atts.getValue(ConfigXMLHandler.NAME);
            String level = atts.getValue(ConfigXMLHandler.LEVEL);
            ConfigXMLHandler.this.m_clusterLogger = OiiolLogger.getOiiolLogger((String)loggername);
            ConfigXMLHandler.this.m_clusterLogger.setLevel(ClusterLogger.getLogLevel(level));
            String printSource = atts.getValue(ConfigXMLHandler.PRINT_SOURCE);
            ConfigXMLHandler.this.m_bPrintSourceInfo = new Boolean(printSource);
            String printThread = atts.getValue(ConfigXMLHandler.PRINT_THREAD_ID);
            ConfigXMLHandler.this.m_bTraceThreads = new Boolean(printThread);
        }
    }
}

