/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.remoteutil.xml;

import java.util.Stack;
import oracle.sysman.prov.remoteutil.xml.ElementHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultXMLHandler
extends DefaultHandler {
    private Stack m_handlers = new Stack();
    private boolean m_bRootHandled = false;

    public DefaultXMLHandler() throws SAXException {
        ElementHandler root = this.createElementHandlers();
        if (root == null) {
            throw new SAXException("Null root handler");
        }
        this.m_handlers.push(root);
    }

    public void startElement(String uri, String name, String qName, Attributes attributes) throws SAXException {
        ElementHandler handler = (ElementHandler)this.m_handlers.peek();
        if (!this.m_bRootHandled) {
            handler.onStart(name, attributes);
            handler.setUnknownElementHandler(name, attributes);
            this.m_bRootHandled = true;
        } else {
            handler.startElement(name, attributes, this.m_handlers);
        }
    }

    public void endElement(String uri, String name, String qName) throws SAXException {
        ElementHandler handler = (ElementHandler)this.m_handlers.peek();
        handler.endElement(name, this.m_handlers);
    }

    protected ElementHandler createElementHandlers() {
        return null;
    }

    public void characters(char[] chars, int nStart, int nLength) throws SAXException {
        ElementHandler handler = (ElementHandler)this.m_handlers.peek();
        handler.onText(chars, nStart, nLength);
    }

    public void warning(SAXParseException e) throws SAXException {
        e.printStackTrace();
        super.warning(e);
    }

    public void error(SAXParseException e) throws SAXException {
        e.printStackTrace();
        super.error(e);
    }

    public void fatalError(SAXParseException e) throws SAXException {
        e.printStackTrace();
        super.fatalError(e);
    }
}

