/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.remoteutil.xml;

import java.util.Hashtable;
import java.util.Stack;
import oracle.sysman.prov.remoteutil.xml.UnknownElementHandler;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class ElementHandler {
    private Hashtable m_childHandlers = new Hashtable();
    private String m_sName;
    private UnknownElementHandler m_unknownElementHandler;

    public ElementHandler() {
    }

    public ElementHandler(String name) {
        this.m_sName = name;
    }

    public void addChildHandler(String name, ElementHandler handler) {
        this.m_childHandlers.put(name, handler);
    }

    public String getName() {
        return this.m_sName;
    }

    public void startElement(String name, Attributes attributes, Stack handlers) {
        ElementHandler childHandler = (ElementHandler)this.m_childHandlers.get(name);
        if (childHandler == null) {
            if (this.m_unknownElementHandler == null) {
                this.m_unknownElementHandler = new UnknownElementHandler(this.m_sName);
            }
            childHandler = this.m_unknownElementHandler;
        }
        handlers.push(childHandler);
        AttributesImpl oai = new AttributesImpl(attributes);
        childHandler.onStart(name, oai);
        childHandler.setUnknownElementHandler(name, oai);
    }

    public void endElement(String name, Stack handlers) {
        this.onEnd(name);
        handlers.pop();
    }

    public void onText(char[] chars, int start, int length) {
    }

    public Object getObject() {
        return null;
    }

    public void onStart(String name, Attributes atts) {
    }

    public void onEnd(String name) {
    }

    protected ElementHandler getChildHandler(String name) {
        ElementHandler handler = null;
        handler = (ElementHandler)this.m_childHandlers.get(name);
        return handler;
    }

    void setUnknownElementHandler(String name, Attributes atts) {
        this.m_unknownElementHandler = new UnknownElementHandler(name);
        this.m_unknownElementHandler.setElementAttributes(atts);
    }

    public Element getUnknownXMLElement() {
        if (this.m_unknownElementHandler != null) {
            return this.m_unknownElementHandler.getElement();
        }
        return null;
    }
}

