/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.remoteutil.xml;

import java.util.Stack;
import oracle.sysman.prov.remoteutil.xml.ElementHandler;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class UnknownElementHandler
extends ElementHandler {
    private Element m_element;
    private Element m_currentElement;
    private Stack m_parentElements;

    public UnknownElementHandler(String sName) {
        this.m_element = new XMLDocument().createElement(sName);
        this.m_parentElements = new Stack();
    }

    public void startElement(String name, Attributes attributes, Stack handlers) {
        handlers.push(this);
        this.onStart(name, new AttributesImpl(attributes));
    }

    public void onStart(String name, Attributes atts) {
        if (this.m_currentElement == null) {
            this.m_currentElement = this.m_element.getOwnerDocument().createElement(name);
        } else {
            Element parent = this.m_parentElements.push(this.m_currentElement);
            this.m_currentElement = this.m_element.getOwnerDocument().createElement(name);
            parent.appendChild(this.m_currentElement);
        }
        if (atts != null) {
            for (int i = 0; i < atts.getLength(); ++i) {
                String attName = atts.getLocalName(i);
                String attValue = atts.getValue(i);
                this.m_currentElement.setAttribute(attName, attValue);
            }
        }
    }

    public void onText(char[] chars, int start, int length) {
        String text = new String(chars, start, length);
        if (this.m_currentElement != null && this.m_currentElement instanceof XMLElement) {
            XMLElement elem = (XMLElement)this.m_currentElement;
            elem.addText(chars, start, length);
        }
    }

    public void onEnd(String name) {
        if (this.m_parentElements.empty()) {
            if (this.m_currentElement != null) {
                this.m_element.appendChild(this.m_currentElement);
                this.m_currentElement = null;
            }
        } else {
            this.m_currentElement = (Element)this.m_parentElements.pop();
        }
    }

    public Element getElement() {
        return this.m_element;
    }

    public void setElementAttributes(Attributes atts) {
        if (atts != null && this.m_element != null) {
            for (int i = 0; i < atts.getLength(); ++i) {
                String attName = atts.getLocalName(i);
                String attValue = atts.getValue(i);
                this.m_element.setAttribute(attName, attValue);
            }
        }
    }

    void setUnknownElementHandler(String name, Attributes atts) {
    }
}

