/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.prov.remoteinterfaces.exception.CommandException;
import oracle.sysman.prov.ssh.RunCommandUserInfo;

public class CopyFile {
    String m_user = null;
    String m_host = null;
    UserInfo ui = null;

    public CopyFile(String host, String user, String password) {
        this.m_host = host;
        this.m_user = user;
        this.ui = new RunCommandUserInfo(password);
    }

    private void cleanup(Channel ch, Session sess) {
        ch.disconnect();
        sess.disconnect();
    }

    public void scpTo(String localFile, String remoteFile) throws CommandException {
        OiiolTextLogger.appendText((String)("Copy localfile: " + localFile + " to remotefile: " + remoteFile + "\n"));
        Channel channel = null;
        Session session = null;
        try {
            int len;
            JSch jsch = new JSch();
            session = jsch.getSession(this.m_user, this.m_host, 22);
            session.setUserInfo(this.ui);
            session.connect();
            String command = "scp -p -t " + remoteFile;
            channel = session.openChannel("exec");
            ((ChannelExec)channel).setCommand(command);
            OutputStream out = channel.getOutputStream();
            InputStream in = channel.getInputStream();
            channel.connect();
            byte[] tmp = new byte[1];
            if (this.checkAck(in) != 0) {
                this.cleanup(channel, session);
                return;
            }
            long filesize = new File(localFile).length();
            command = "C0644 " + filesize + " ";
            command = localFile.lastIndexOf(47) > 0 ? command + localFile.substring(localFile.lastIndexOf(47) + 1) : command + localFile;
            command = command + "\n";
            out.write(command.getBytes());
            out.flush();
            if (this.checkAck(in) != 0) {
                this.cleanup(channel, session);
                return;
            }
            FileInputStream fis = new FileInputStream(localFile);
            byte[] buf = new byte[1024];
            while ((len = fis.read(buf, 0, buf.length)) > 0) {
                out.write(buf, 0, len);
                out.flush();
            }
            buf[0] = 0;
            out.write(buf, 0, 1);
            out.flush();
            if (this.checkAck(in) != 0) {
                this.cleanup(channel, session);
                return;
            }
        }
        catch (Exception ex) {
            if (session != null && channel != null) {
                this.cleanup(channel, session);
            }
            throw new CommandException(this.m_host, "PROV-16011", ex.getMessage(), (Throwable)ex);
        }
        this.cleanup(channel, session);
    }

    public void scpFrom(String remoteFile, String localFile) throws CommandException {
        Channel channel = null;
        Session session = null;
        OiiolTextLogger.appendText((String)("Copy remotefile: " + remoteFile + " to localfile: " + localFile + "\n"));
        try {
            int c;
            String prefix = null;
            if (new File(localFile).isDirectory()) {
                prefix = localFile + File.separator;
            }
            JSch jsch = new JSch();
            session = jsch.getSession(this.m_user, this.m_host, 22);
            session.setUserInfo(this.ui);
            session.connect();
            String command = "scp -f " + remoteFile;
            channel = session.openChannel("exec");
            ((ChannelExec)channel).setCommand(command);
            OutputStream out = channel.getOutputStream();
            InputStream in = channel.getInputStream();
            channel.connect();
            byte[] buf = new byte[1024];
            buf[0] = 0;
            out.write(buf, 0, 1);
            out.flush();
            while ((c = this.checkAck(in)) == 67) {
                int foo;
                in.read(buf, 0, 5);
                long filesize = 0L;
                while (in.read(buf, 0, 1) >= 0 && buf[0] != 32) {
                    filesize = filesize * 10L + (long)(buf[0] - 48);
                }
                String file = null;
                int i = 0;
                while (true) {
                    in.read(buf, i, 1);
                    if (buf[i] == 10) break;
                    ++i;
                }
                file = new String(buf, 0, i);
                buf[0] = 0;
                out.write(buf, 0, 1);
                out.flush();
                FileOutputStream fos = new FileOutputStream(prefix == null ? localFile : prefix + file);
                do {
                    foo = (long)buf.length < filesize ? buf.length : (int)filesize;
                    if ((foo = in.read(buf, 0, foo)) < 0) break;
                    fos.write(buf, 0, foo);
                } while ((filesize -= (long)foo) != 0L);
                fos.close();
                byte[] tmp = new byte[1];
                if (this.checkAck(in) != 0) {
                    this.cleanup(channel, session);
                    return;
                }
                buf[0] = 0;
                out.write(buf, 0, 1);
                out.flush();
            }
        }
        catch (Exception ex) {
            if (session != null && channel != null) {
                this.cleanup(channel, session);
            }
            throw new CommandException(this.m_host, "PROV-16011", ex.getMessage(), (Throwable)ex);
        }
        this.cleanup(channel, session);
    }

    int checkAck(InputStream in) throws IOException {
        int b = in.read();
        if (b == 0) {
            return b;
        }
        if (b == -1) {
            return b;
        }
        if (b == 1 || b == 2) {
            int c;
            StringBuffer sb = new StringBuffer();
            do {
                c = in.read();
                sb.append((char)c);
            } while (c != 10);
            if (b == 1) {
                OiiolTextLogger.appendText((String)sb.toString());
            }
            if (b == 2) {
                OiiolTextLogger.appendText((String)sb.toString());
            }
        }
        return b;
    }
}

