/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.prov.remoteinterfaces.exception.CommandException;
import oracle.sysman.prov.ssh.RunCommandUserInfo;

public class RunCommand {
    private int m_exitVal = 0;
    private String m_out = null;
    private String m_user = null;
    private String m_host = null;
    private UserInfo ui = null;
    private String error = "An error occured which will cause the program to abort. Refer to latest Log file that was supplied while running the program. The Log file would created by name logfilename-<currentdatetime>";
    private String r_error = null;

    public RunCommand(String host, String user, String password) {
        this.m_host = host;
        this.m_user = user;
        this.ui = new RunCommandUserInfo(password);
    }

    public RunCommand(String host, String user, String password, String passphrase, boolean confirm) {
        this(host, user, password);
    }

    public void runCommand(String command) throws CommandException {
        Channel channel = null;
        Session session = null;
        try {
            JSch jsch = new JSch();
            session = jsch.getSession(this.m_user, this.m_host, 22);
            session.setUserInfo(this.ui);
            session.connect();
            channel = session.openChannel("exec");
            ((ChannelExec)channel).setCommand(command);
            channel.setXForwarding(true);
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            ((ChannelExec)channel).setErrStream((OutputStream)bo);
            InputStream in = channel.getInputStream();
            channel.connect();
            OiiolTextLogger.appendText((String)("[" + this.m_host + "]"));
            OiiolTextLogger.appendText((String)command);
            StringBuffer buf = new StringBuffer();
            byte[] tmp = new byte[1024];
            while (true) {
                String ls;
                char line_sep_char;
                char isNewLine;
                int buflen;
                if (in.available() > 0) {
                    int i = in.read(tmp, 0, 1024);
                    if (i < 0) {
                        int buflen2 = buf.length();
                        buf.deleteCharAt(buflen2 - 1);
                    } else {
                        buf.append(new String(tmp, 0, i));
                        continue;
                    }
                }
                if ((buflen = buf.length()) > 0 && (isNewLine = buf.charAt(buflen - 1)) == (line_sep_char = (ls = System.getProperty("line.separator")).charAt(0))) {
                    buf.deleteCharAt(buflen - 1);
                }
                if (channel.isClosed()) {
                    this.m_exitVal = channel.getExitStatus();
                    OiiolTextLogger.appendText((String)("Exit-status: " + channel.getExitStatus()));
                    this.r_error = bo.toString();
                    if (this.r_error == null) break;
                    OiiolTextLogger.appendText((String)("Error: " + this.r_error));
                    break;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ee) {
                    OiiolTextLogger.writeToLogAndConsole((String)this.error);
                    OiiolTextLogger.appendException((Exception)ee);
                }
            }
            channel.disconnect();
            session.disconnect();
            this.m_out = buf.toString();
        }
        catch (Exception e) {
            OiiolTextLogger.writeToLogAndConsole((String)this.error);
            OiiolTextLogger.appendException((Exception)e);
            OiiolTextLogger.appendText((String)this.m_out);
            String failedNodes = this.m_host;
            throw new CommandException(failedNodes, "PROV-16011", e.getMessage());
        }
        OiiolTextLogger.appendText((String)this.m_out);
        OiiolTextLogger.appendText((String)"");
    }

    public String getOutput() {
        return this.m_out;
    }

    public int getExitCode() {
        return this.m_exitVal;
    }

    public String getError() {
        return this.r_error;
    }

    public void runCommand(String command, String cmdArgs, String cmdInput) throws CommandException {
        Channel channel = null;
        Session session = null;
        try {
            String SPACE = " ";
            JSch jsch = new JSch();
            session = jsch.getSession(this.m_user, this.m_host, 22);
            session.setUserInfo(this.ui);
            session.connect();
            channel = session.openChannel("exec");
            String rcommand = command;
            if (cmdArgs != null) {
                rcommand = command + SPACE + cmdArgs;
            }
            ((ChannelExec)channel).setCommand(rcommand);
            channel.setXForwarding(true);
            byte[] cmdbuf = cmdInput.getBytes();
            ByteArrayInputStream bi = new ByteArrayInputStream(cmdbuf);
            channel.setInputStream((InputStream)bi);
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            ((ChannelExec)channel).setErrStream((OutputStream)bo);
            InputStream in = channel.getInputStream();
            channel.connect();
            OiiolTextLogger.appendText((String)("[" + this.m_host + "]"));
            OiiolTextLogger.appendText((String)rcommand);
            StringBuffer buf = new StringBuffer();
            byte[] tmp = new byte[1024];
            while (true) {
                if (in.available() > 0) {
                    int i = in.read(tmp, 0, 1024);
                    if (i < 0) {
                        int buflen = buf.length();
                        buf.deleteCharAt(buflen - 1);
                    } else {
                        buf.append(new String(tmp, 0, i));
                        continue;
                    }
                }
                if (channel.isClosed()) {
                    this.m_exitVal = channel.getExitStatus();
                    OiiolTextLogger.appendText((String)("Exit-status: " + channel.getExitStatus()));
                    this.r_error = bo.toString();
                    if (this.r_error == null) break;
                    OiiolTextLogger.appendText((String)("Error: " + this.r_error));
                    break;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ee) {
                    OiiolTextLogger.writeToLogAndConsole((String)this.error);
                    OiiolTextLogger.appendException((Exception)ee);
                }
            }
            channel.disconnect();
            session.disconnect();
            this.m_out = buf.toString();
        }
        catch (Exception e) {
            OiiolTextLogger.writeToLogAndConsole((String)this.error);
            OiiolTextLogger.appendException((Exception)e);
            OiiolTextLogger.appendText((String)this.m_out);
            String failedNodes = this.m_host;
            throw new CommandException(failedNodes, "PROV-16011", e.getMessage());
        }
        OiiolTextLogger.appendText((String)this.m_out);
        OiiolTextLogger.appendText((String)"");
    }
}

