/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.ssh;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.prov.remoteinterfaces.clusterops.ClusterBaseOps;
import oracle.sysman.prov.remoteinterfaces.exception.ClusterException;
import oracle.sysman.prov.remoteinterfaces.exception.FatalException;
import oracle.sysman.prov.remoteinterfaces.exception.NodesAliveException;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Paths;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Platform;
import oracle.sysman.prov.remoteinterfaces.nativesystem.SystemFactory;
import oracle.sysman.prov.remoteinterfaces.result.ClusterResult;
import oracle.sysman.prov.ssh.SSHSetup;
import oracle.sysman.prov.ssh.SSHSetupException;

public class SSHConnectivity {
    public static final String S_RESOURCE_BUNDLE = "oracle.sysman.prov.ssh.resources.RuntimeRes";
    private static final String DISPLAY_NAME = "java SSHConnectivity";
    private String[] m_saRemoteHosts = null;
    private String m_sUser = null;
    private String m_sLogFile = null;
    private boolean m_bUsePassPhrase = false;
    private boolean m_bSharedHome = false;
    private boolean m_bAdvanced = false;
    private boolean m_bAreNodesAlive = false;
    private boolean diffremotePlat = false;
    private String m_sPassword = null;
    private String m_sObfuscatedPassword = null;
    private String homeDir = null;
    private String m_sAsUser = null;
    private String m_sAsUserGrp = null;
    private String m_sSshLocalDir = null;
    private boolean m_silentMode = false;
    private boolean m_noDelete = false;
    private String m_sPassphrase = null;
    Paths m_localPaths = null;
    Paths m_remotePaths = null;
    int m_localPlatId;
    int m_remotePlatId = this.m_localPlatId = SystemFactory.s_localPlatId;
    Platform m_platform = null;

    private void startSetup() {
        SSHSetup oSshSetup = null;
        boolean rerun_keygen = true;
        if (this.m_bAreNodesAlive) {
            try {
                this.areNodesAlive(this.m_saRemoteHosts);
            }
            catch (NodesAliveException nae) {
                System.exit(1);
            }
        } else if (this.m_sObfuscatedPassword != null) {
            this.diffremotePlat = true;
            if (true) {
                SSHSetup.setRemotePlatformId(this.m_remotePlatId);
            }
            try {
                if (!this.m_bUsePassPhrase) {
                    oSshSetup = new SSHSetup(this.m_sObfuscatedPassword, true, this.m_sLogFile);
                } else {
                    this.m_sPassphrase = this.promptUser("Enter the passphrase: ");
                    if (this.m_sPassphrase.length() == 0) {
                        OiiolTextLogger.appendText((String)"Creating SSHSetup object without passphrase,obfuscated password");
                        oSshSetup = new SSHSetup(this.m_sObfuscatedPassword, true, this.m_sLogFile);
                    } else {
                        oSshSetup = new SSHSetup(this.m_sObfuscatedPassword, this.m_sPassphrase, true, this.m_sLogFile);
                    }
                }
            }
            catch (IOException ioe) {
                OiiolTextLogger.appendException((Exception)ioe);
                System.exit(1);
            }
            catch (FatalException fe) {
                OiiolTextLogger.appendException((Exception)((Object)fe));
                System.exit(1);
            }
            try {
                if (this.homeDir != null) {
                    SSHSetup.setHomeDir(this.homeDir);
                }
                OiiolTextLogger.writeToLogAndConsole((String)"Doing SSHSetup...");
                OiiolTextLogger.writeToLogAndConsole((String)"Please be patient, this operation might take sometime...Dont press Ctrl+C...");
                if (this.m_noDelete) {
                    oSshSetup.setnoDelete();
                }
                oSshSetup.setupConnectivity(rerun_keygen, this.m_saRemoteHosts, this.m_sUser, this.m_bSharedHome, this.m_bAdvanced, this.m_sAsUser, this.m_sAsUserGrp, this.m_sSshLocalDir);
            }
            catch (SSHSetupException se) {
                OiiolTextLogger.appendException((Exception)se);
                System.exit(1);
            }
            catch (ClusterException ce) {
                OiiolTextLogger.appendException((Exception)((Object)ce));
                System.exit(1);
            }
            catch (FatalException fe) {
                OiiolTextLogger.appendException((Exception)((Object)fe));
                System.exit(1);
            }
        } else {
            this.diffremotePlat = true;
            if (true) {
                SSHSetup.setRemotePlatformId(this.m_remotePlatId);
            }
            if (!this.m_silentMode) {
                OiiolTextLogger.writeToLogAndConsole((String)"");
                OiiolTextLogger.writeToLogAndConsole((String)OiixResourceBundle.getString((String)S_RESOURCE_BUNDLE, (String)"RERUN_KEYGEN"));
                BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
                String line = null;
                try {
                    line = in.readLine();
                    line = line.trim();
                    if (line.equalsIgnoreCase("no")) {
                        rerun_keygen = false;
                    }
                }
                catch (IOException e) {
                    OiiolTextLogger.appendException((Exception)e);
                }
            }
            if (this.m_sPassword == null) {
                this.m_sPassword = this.promptUser("Enter the password: ");
            }
            this.m_sPassphrase = this.m_bUsePassPhrase ? this.promptUser("Enter the passphrase: ") : "";
            try {
                if (this.m_sPassphrase.length() == 0) {
                    OiiolTextLogger.appendText((String)"SSHConnectivity :Creating SSHSetup object with m_sPassword");
                    oSshSetup = new SSHSetup(this.m_sPassword, false, this.m_sLogFile);
                } else {
                    OiiolTextLogger.appendText((String)"Creating SSHSetup object with m_sPassword,m_sPassphrase");
                    oSshSetup = new SSHSetup(this.m_sPassword, this.m_sPassphrase, false, this.m_sLogFile);
                }
            }
            catch (IOException ioe) {
                OiiolTextLogger.appendException((Exception)ioe);
                System.exit(1);
            }
            catch (FatalException fe) {
                OiiolTextLogger.appendException((Exception)((Object)fe));
                System.exit(1);
            }
            OiiolTextLogger.writeToLogAndConsole((String)"Doing SSHSetup...");
            OiiolTextLogger.writeToLogAndConsole((String)"Please be patient, this operation might take sometime...Dont press Ctrl+C...");
            try {
                if (this.homeDir != null) {
                    SSHSetup.setHomeDir(this.homeDir);
                }
                if (this.m_noDelete) {
                    oSshSetup.setnoDelete();
                }
                oSshSetup.setupConnectivity(rerun_keygen, this.m_saRemoteHosts, this.m_sUser, this.m_bSharedHome, this.m_bAdvanced, this.m_sAsUser, this.m_sAsUserGrp, this.m_sSshLocalDir);
            }
            catch (SSHSetupException se) {
                OiiolTextLogger.appendException((Exception)se);
                System.exit(1);
            }
            catch (FatalException fe) {
                OiiolTextLogger.appendException((Exception)((Object)fe));
                System.exit(1);
            }
            catch (ClusterException ce) {
                OiiolTextLogger.appendException((Exception)((Object)ce));
                System.exit(1);
            }
        }
    }

    public static void main(String[] args) {
        SSHConnectivity sh = new SSHConnectivity();
        try {
            sh.parseCmdLine(args);
        }
        catch (NumberFormatException ne) {
            OiiolTextLogger.writeToLogAndConsole((String)"Remote Platform id is impoperly supplied");
            System.exit(1);
        }
        String m_PropertiesDir = null;
        m_PropertiesDir = System.getProperty("oracle.sysman.prov.PathsPropertiesLoc");
        if (m_PropertiesDir == null && SystemFactory.s_localPlatId == sh.m_remotePlatId) {
            System.setProperty("oracle.sysman.prov.PathsPropertiesLoc", "/tmp");
        }
        sh.startSetup();
        System.exit(0);
    }

    boolean areNodesAlive(String[] nodes) throws NodesAliveException {
        OiiolTextLogger.writeToLogAndConsole((String)"");
        OiiolTextLogger.writeToLogAndConsole((String)"Checking if the remote hosts are reachable.");
        ClusterBaseOps baseops = null;
        ClusterResult result = null;
        try {
            baseops = ClusterBaseOps.getInstance();
            result = baseops.areNodesAliveEx(nodes, 5, true, true, true);
        }
        catch (FatalException e) {
            OiiolTextLogger.writeToLogAndConsole((String)("Failed Nodes : " + OiixFunctionOps.implodeList((String[])nodes, (String)" ")));
            return false;
        }
        catch (NodesAliveException e) {
            Iterator iter = e.getFailedNodes();
            String failed = "";
            while (iter.hasNext()) {
                failed = failed + (String)iter.next() + " ";
            }
            OiiolTextLogger.writeToLogAndConsole((String)("Failed Nodes : " + failed));
            OiiolTextLogger.appendException((Exception)((Object)e));
            throw e;
        }
        return true;
    }

    void parseCmdLine(String[] args) throws NumberFormatException {
        int len = args.length;
        for (int i = 0; i < len; ++i) {
            if (args[i].equals("-hosts")) {
                this.m_saRemoteHosts = OiixFunctionOps.explodeString((String)args[i + 1], (String)" ");
                ++i;
            } else if (args[i].equals("-user")) {
                this.m_sUser = args[i + 1];
                ++i;
            } else if (args[i].equals("-asUser")) {
                this.m_sAsUser = args[i + 1];
                ++i;
            } else if (args[i].equals("-asUserGrp")) {
                this.m_sAsUserGrp = args[i + 1];
                ++i;
            } else if (args[i].equals("-sshLocalDir")) {
                this.m_sSshLocalDir = args[i + 1];
                ++i;
            } else if (args[i].equals("-logfile")) {
                this.m_sLogFile = args[i + 1];
                ++i;
            }
            if (args[i].equals("-usePassphrase")) {
                this.m_bUsePassPhrase = true;
                continue;
            }
            if (args[i].equals("-shared")) {
                this.m_bSharedHome = true;
                continue;
            }
            if (args[i].equals("-areNodesAlive")) {
                this.m_bAreNodesAlive = true;
                continue;
            }
            if (args[i].equals("-silent")) {
                this.m_silentMode = true;
                continue;
            }
            if (args[i].equals("-noDelete")) {
                this.m_noDelete = true;
                continue;
            }
            if (args[i].equals("-advanced")) {
                this.m_bAdvanced = true;
                continue;
            }
            if (args[i].equals("-remotePlatform")) {
                try {
                    int val;
                    this.m_remotePlatId = val = Integer.parseInt(args[i + 1]);
                    this.diffremotePlat = true;
                }
                catch (NumberFormatException e) {
                    OiiolTextLogger.appendException((Exception)e);
                    throw e;
                }
                ++i;
                continue;
            }
            if (args[i].equals("-help")) {
                if (i + 1 < len) {
                    this.displayHelp(args[i + 1]);
                } else {
                    this.displayHelp();
                }
                System.exit(0);
                continue;
            }
            if (args[i].equals("-detail")) {
                if (i + 1 < len) {
                    this.displayDetailedHelp(args[i + 1]);
                } else {
                    this.displayDetailedHelp(DISPLAY_NAME);
                }
                System.exit(0);
                continue;
            }
            if (args[i].equals("-usage")) {
                if (i + 1 < len) {
                    this.displayUsage(args[i + 1]);
                }
                System.exit(0);
                continue;
            }
            if (args[i].equals("-obPasswordfile")) {
                this.loadObfuscatedPassword(args[i + 1]);
                ++i;
                continue;
            }
            if (!args[i].equals("-homeDir")) continue;
            this.homeDir = args[i + 1];
            ++i;
        }
    }

    private void loadObfuscatedPassword(String absPath) {
        Properties temp = null;
        String propVal = null;
        try {
            FileInputStream fs = new FileInputStream(absPath);
            temp = new Properties();
            temp.load(fs);
            fs.close();
        }
        catch (IOException e2) {
            // empty catch block
        }
        if (temp != null) {
            Enumeration<?> propNames = temp.propertyNames();
            String propName = (String)propNames.nextElement();
            this.m_sObfuscatedPassword = propVal = (String)temp.get(propName);
        }
    }

    private String promptUser(String prompt) {
        MaskingThread maskingthread = new MaskingThread(prompt);
        Thread mask = new Thread(maskingthread);
        mask.start();
        BufferedReader in = null;
        in = new BufferedReader(new InputStreamReader(System.in));
        String line = null;
        try {
            line = in.readLine();
        }
        catch (IOException e) {
            OiiolTextLogger.appendException((Exception)e);
        }
        maskingthread.stopMasking();
        return line;
    }

    void displayHelp() {
        this.displayHelp(DISPLAY_NAME);
    }

    private void displayHelp(String scriptName) {
        OiiolTextLogger.writeToLogAndConsole((String)OiixResourceBundle.getString((String)S_RESOURCE_BUNDLE, (String)"HELP1", (Object[])new String[]{scriptName}));
        OiiolTextLogger.writeToLogAndConsole((String)OiixResourceBundle.getString((String)S_RESOURCE_BUNDLE, (String)"DESCRIPTION_HELP"));
        OiiolTextLogger.writeToLogAndConsole((String)OiixResourceBundle.getString((String)S_RESOURCE_BUNDLE, (String)"USER_HELP"));
        OiiolTextLogger.writeToLogAndConsole((String)OiixResourceBundle.getString((String)S_RESOURCE_BUNDLE, (String)"HOSTS_HELP"));
        OiiolTextLogger.writeToLogAndConsole((String)OiixResourceBundle.getString((String)S_RESOURCE_BUNDLE, (String)"HOSTFILE_SHORT_HELP"));
        OiiolTextLogger.writeToLogAndConsole((String)OiixResourceBundle.getString((String)S_RESOURCE_BUNDLE, (String)"USEPASSPHRASE_HELP"));
        OiiolTextLogger.writeToLogAndConsole((String)OiixResourceBundle.getString((String)S_RESOURCE_BUNDLE, (String)"ASUSER_HELP"));
        OiiolTextLogger.writeToLogAndConsole((String)OiixResourceBundle.getString((String)S_RESOURCE_BUNDLE, (String)"ASUSERGRP_HELP"));
        OiiolTextLogger.writeToLogAndConsole((String)OiixResourceBundle.getString((String)S_RESOURCE_BUNDLE, (String)"SSHLOCALDIR_SHORT_HELP"));
        OiiolTextLogger.writeToLogAndConsole((String)OiixResourceBundle.getString((String)S_RESOURCE_BUNDLE, (String)"HOMEDIR_SHORT_HELP"));
        OiiolTextLogger.writeToLogAndConsole((String)OiixResourceBundle.getString((String)S_RESOURCE_BUNDLE, (String)"SHARED_SHORT_HELP"));
        OiiolTextLogger.writeToLogAndConsole((String)OiixResourceBundle.getString((String)S_RESOURCE_BUNDLE, (String)"REMOTEPLATFORM_SHORT_HELP"));
        OiiolTextLogger.writeToLogAndConsole((String)OiixResourceBundle.getString((String)S_RESOURCE_BUNDLE, (String)"LOCALPLATFORMGRP_HELP"));
        OiiolTextLogger.writeToLogAndConsole((String)OiixResourceBundle.getString((String)S_RESOURCE_BUNDLE, (String)"ADVANCED_SHORT_HELP"));
        OiiolTextLogger.writeToLogAndConsole((String)OiixResourceBundle.getString((String)S_RESOURCE_BUNDLE, (String)"CONFIRM_SHORT_HELP"));
        OiiolTextLogger.writeToLogAndConsole((String)OiixResourceBundle.getString((String)S_RESOURCE_BUNDLE, (String)"VERIFY_SHORT_HELP"));
        OiiolTextLogger.writeToLogAndConsole((String)OiixResourceBundle.getString((String)S_RESOURCE_BUNDLE, (String)"EXVERIFY_SHORT_HELP"));
        this.displayUsage(scriptName);
        OiiolTextLogger.writeToLogAndConsole((String)OiixResourceBundle.getString((String)S_RESOURCE_BUNDLE, (String)"SEEALSO", (Object[])new String[]{scriptName}));
        OiiolTextLogger.writeToLogAndConsole((String)OiixResourceBundle.getString((String)S_RESOURCE_BUNDLE, (String)"COPYRIGHT"));
    }

    private void displayDetailedHelp(String scriptName) {
        OiiolTextLogger.writeToLogAndConsole((String)OiixResourceBundle.getString((String)S_RESOURCE_BUNDLE, (String)"HELP1", (Object[])new String[]{scriptName}));
        OiiolTextLogger.writeToLogAndConsole((String)OiixResourceBundle.getString((String)S_RESOURCE_BUNDLE, (String)"DESCRIPTION_HELP"));
        OiiolTextLogger.writeToLogAndConsole((String)OiixResourceBundle.getString((String)S_RESOURCE_BUNDLE, (String)"USER_HELP"));
        OiiolTextLogger.writeToLogAndConsole((String)OiixResourceBundle.getString((String)S_RESOURCE_BUNDLE, (String)"HOSTS_HELP"));
        OiiolTextLogger.writeToLogAndConsole((String)OiixResourceBundle.getString((String)S_RESOURCE_BUNDLE, (String)"HOSTFILE_HELP"));
        OiiolTextLogger.writeToLogAndConsole((String)OiixResourceBundle.getString((String)S_RESOURCE_BUNDLE, (String)"USEPASSPHRASE_HELP"));
        OiiolTextLogger.writeToLogAndConsole((String)OiixResourceBundle.getString((String)S_RESOURCE_BUNDLE, (String)"ASUSER_HELP"));
        OiiolTextLogger.writeToLogAndConsole((String)OiixResourceBundle.getString((String)S_RESOURCE_BUNDLE, (String)"ASUSERGRP_HELP"));
        OiiolTextLogger.writeToLogAndConsole((String)OiixResourceBundle.getString((String)S_RESOURCE_BUNDLE, (String)"SSHLOCALDIR_HELP"));
        OiiolTextLogger.writeToLogAndConsole((String)OiixResourceBundle.getString((String)S_RESOURCE_BUNDLE, (String)"HOMEDIR_HELP"));
        OiiolTextLogger.writeToLogAndConsole((String)OiixResourceBundle.getString((String)S_RESOURCE_BUNDLE, (String)"SHARED_HELP"));
        OiiolTextLogger.writeToLogAndConsole((String)OiixResourceBundle.getString((String)S_RESOURCE_BUNDLE, (String)"REMOTEPLATFORM_HELP"));
        OiiolTextLogger.writeToLogAndConsole((String)OiixResourceBundle.getString((String)S_RESOURCE_BUNDLE, (String)"LOCALPLATFORMGRP_HELP"));
        OiiolTextLogger.writeToLogAndConsole((String)OiixResourceBundle.getString((String)S_RESOURCE_BUNDLE, (String)"ADVANCED_HELP"));
        OiiolTextLogger.writeToLogAndConsole((String)OiixResourceBundle.getString((String)S_RESOURCE_BUNDLE, (String)"CONFIRM_HELP"));
        OiiolTextLogger.writeToLogAndConsole((String)OiixResourceBundle.getString((String)S_RESOURCE_BUNDLE, (String)"VERIFY_HELP"));
        OiiolTextLogger.writeToLogAndConsole((String)OiixResourceBundle.getString((String)S_RESOURCE_BUNDLE, (String)"EXVERIFY_HELP", (Object[])new String[]{scriptName}));
        this.displayUsage(scriptName);
        OiiolTextLogger.writeToLogAndConsole((String)OiixResourceBundle.getString((String)S_RESOURCE_BUNDLE, (String)"COPYRIGHT"));
    }

    private void displayUsage(String scriptName) {
        OiiolTextLogger.writeToLogAndConsole((String)OiixResourceBundle.getString((String)S_RESOURCE_BUNDLE, (String)"USAGE", (Object[])new String[]{scriptName, "-user", "-hosts", "-hostfile", "-asUser", "SYSTEM", "-asUserGrp", "-sshLocalDir", "-advanced", "-usePassphrase", "-logfile", "-confirm", "-shared", "-verify", "-exverify", "-remotePlatform", "46", "453", "912", "-obPasswordfile", "-silent", "-localPlatformGrp", "-help"}));
        OiiolTextLogger.writeToLogAndConsole((String)OiixResourceBundle.getString((String)S_RESOURCE_BUNDLE, (String)"USAGE_EXAMPLE", (Object[])new String[]{scriptName}));
    }

    class MaskingThread
    extends Thread {
        private boolean stop;
        private char echochar = (char)32;

        public MaskingThread(String prompt) {
            System.out.println();
            System.out.print(prompt);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int priority = Thread.currentThread().getPriority();
            Thread.currentThread().setPriority(10);
            try {
                this.stop = true;
                while (this.stop) {
                    System.out.print("\b" + this.echochar);
                    Thread.currentThread();
                    Thread.sleep(1L);
                }
            }
            catch (InterruptedException iex) {
                Thread.currentThread().interrupt();
                return;
            }
            finally {
                Thread.currentThread().setPriority(priority);
            }
        }

        public void stopMasking() {
            this.stop = false;
        }
    }
}

