/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.ssh;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.KeyPair;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import oracle.sysman.emCfg.support.Formatter;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixNetOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.prov.remoteinterfaces.clusterops.ClusterBaseOps;
import oracle.sysman.prov.remoteinterfaces.exception.ClusterException;
import oracle.sysman.prov.remoteinterfaces.exception.CommandException;
import oracle.sysman.prov.remoteinterfaces.exception.FatalException;
import oracle.sysman.prov.remoteinterfaces.exception.SharedDeviceException;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Commands;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Paths;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Platform;
import oracle.sysman.prov.remoteinterfaces.nativesystem.SystemFactory;
import oracle.sysman.prov.ssh.CopyFile;
import oracle.sysman.prov.ssh.FileLockException;
import oracle.sysman.prov.ssh.RunCommand;
import oracle.sysman.prov.ssh.SSHSetupException;
import oracle.sysman.prov.ssh.UndoSSHSetupException;

public class SSHSetup {
    public static final String S_RESOURCE_BUNDLE = "oracle.sysman.prov.ssh.resources.RuntimeRes";
    private static final int DEFAULT_SLEEP_SECONDS = 30;
    private static final int CONV_MS_SECONDS = 1000;
    private static final String PATH_PROPERTIES_LOC_PROPERTY = "oracle.sysman.prov.PathsPropertiesLoc";
    private static final String SSH_SYSTEM_PROPERTY = "ssh_system.properties";
    private static final String SSH_LOCK_RETRY_COUNT = "oracle.sysman.prov.ssh.lock_retry_count";
    private static final String SSH_LOCK_SLEEP_TIME = "oracle.sysman.prov.ssh.lock_sleep_time";
    private static final String SSH_OLD_PUBLIC_KEY = "oracle.sysman.prov.ssh.public_key";
    private static final String SSH_OLD_PRIVATE_KEY = "oracle.sysman.prov.ssh.private_key";
    private static final String SSH_LOCK = "lock";
    private static final String SCP_TO = "SCP_TO";
    private static final String SCP_FROM = "SCP_FROM";
    private static final String DISPLAY_NAME = "java SSHSetup";
    private static final String BITS = "-b";
    private static final String IDENTITY = "identity";
    private static final String IDENTITY_PUB = "identity.pub";
    private static final String PRIVATE_KEY = "id_rsa";
    private static final String PUBLIC_KEY = "id_rsa.pub";
    private static final String AUTHORIZED_KEYS = "authorized_keys";
    private static final String KNOWN_HOSTS = "known_hosts";
    private static final String CONFIG = "config";
    private static final String SSHDIR = ".ssh";
    private static final String SPACE = " ";
    private static final String SSH_HOST_RSA_KEY_PUB = "ssh_host_rsa_key.pub";
    private boolean noDelete = false;
    private static final String COMMENT = "Keys generated using jsch";
    private static final String BAK = ".ri.bak";
    private static final String TMP = ".tmp";
    private static final String LOCALHOST = "LocalHost";
    private static final String PROPERTY_USER_NAME = "user.name";
    private static final String PROPERTY_USER_HOME = "user.home";
    private static final String UNSUPPORTED_PLTF_ERROR = "The Platform id that you are supplying is not supported. Refer to Logs for further details with name <logfile>prefixed with latest timestamp";
    private static final String CFS_FILE_CONTENT = "ssh";
    private String[] m_saRemoteHosts = null;
    private String m_sUser = null;
    private String m_sLogFile = null;
    private boolean m_bSharedHome = false;
    private boolean m_bAdvanced = false;
    private boolean m_bAreNodesAlive = false;
    private String m_sPassword = null;
    private String m_sObfuscatedPassword = null;
    private boolean m_bSilent = false;
    private String identity_filename = null;
    private String authorized_keys = null;
    private String BEGIN_QUOTE = "\"";
    private String END_QUOTE = "\"";
    private String m_sAsUser = null;
    private String m_sAsUserGrp = null;
    private String m_sSshLocalDir = null;
    private static String home = null;
    private String l_command = null;
    private String m_sPassphrase = null;
    private int bitsize = 1024;
    Paths m_localPaths = null;
    Paths m_remotePaths = null;
    static int m_localPlatId;
    static int m_remotePlatId;
    Platform m_platform = null;
    private String lib_loc = null;
    private String oui_loc = null;
    Map commandResults = new HashMap();
    Map commandExceptions = new HashMap();
    private String r_command = null;

    public SSHSetup() {
    }

    public SSHSetup(String LogFile) throws FatalException, IOException {
        this.SSHSetup_helper1(LogFile);
    }

    public SSHSetup(String sPassword, boolean bOfuscated, String logFile) throws FatalException, IOException {
        this.SSHSetup_helper2(sPassword, bOfuscated, logFile);
        this.SSHSetup_helper1(logFile);
    }

    public SSHSetup(String sPassword, String sPassphrase, boolean bOfuscated, String logFile) throws FatalException, IOException {
        this.SSHSetup_helper2(sPassword, bOfuscated, logFile);
        this.SSHSetup_helper1(logFile);
        this.m_sPassphrase = sPassphrase;
    }

    private void SSHSetup_helper1(String LogFile) throws FatalException, IOException {
        if (LogFile == null) {
            Object[] args = new String[]{"logFile parameter is null"};
            throw new FatalException("PROV-16001", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16001", (Object[])args));
        }
        if (LogFile.trim().length() == 0) {
            Object[] args = new String[]{"logFile parameter Empty String with length 0"};
            throw new FatalException("PROV-16048", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16048", (Object[])args));
        }
        this.m_sLogFile = OiixPathOps.getNativeForm((String)OiixPathOps.getStandardForm((String)LogFile));
        this.startup();
        this.initPaths();
        try {
            String logDir = OiixPathOps.getParentDir((String)OiixPathOps.getStandardForm((String)this.m_sLogFile));
            String logfile = OiixPathOps.getFileName((String)OiixPathOps.getStandardForm((String)this.m_sLogFile));
            int idx = logfile.lastIndexOf(46);
            String logfilename = "";
            String logfileextn = "";
            if (idx != -1) {
                logfilename = logfile.substring(0, idx);
                logfileextn = logfile.substring(idx, logfile.length());
            } else {
                logfilename = logfile;
            }
            OiiolTextLogger.setLogLoc((String)logDir, (String)logfilename, (String)logfileextn);
            System.out.println("Logfile Location : " + OiiolTextLogger.getCurLogFileName());
        }
        catch (IOException e) {
            OiiolTextLogger.appendException((Exception)e);
            throw e;
        }
    }

    private void SSHSetup_helper2(String sPassword, boolean bOfuscated, String logFile) throws FatalException {
        if (bOfuscated) {
            this.decryptObfuscatedPassword(sPassword);
        } else {
            this.m_sPassword = sPassword;
        }
    }

    public static void setRemotePlatformId(int remotePlatId) {
        m_remotePlatId = remotePlatId;
    }

    void decryptObfuscatedPassword(String m_sObfuscatedPassword) throws FatalException {
        try {
            this.m_sPassword = Formatter.hexStringMD5ToNormalString((String)m_sObfuscatedPassword, (String)"UTF8");
        }
        catch (Exception e) {
            this.m_sPassword = null;
            OiiolTextLogger.writeToLogAndConsole((String)"Password seems to be incorrect.");
            OiiolTextLogger.appendException((Exception)e);
            throw new FatalException("PROV-16044", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16044", null));
        }
    }

    public static void setOUILoc(String ouiLoc) {
        System.setProperty("oracle.installer.oui_loc", ouiLoc);
    }

    public void setnoDelete() {
        this.noDelete = true;
    }

    void startup() throws FatalException {
        this.lib_loc = System.getProperty("oracle.installer.library_loc");
        if (this.lib_loc == null) {
            this.oui_loc = System.getProperty("oracle.installer.oui_loc");
            if (this.oui_loc == null) {
                Object[] args = new String[]{"Set oui_loc System Property to OMS_HOME/oui"};
                throw new FatalException("PROV-16043", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16043", (Object[])args));
            }
            this.lib_loc = OiixPathOps.concatPath((String)OiixPathOps.getStandardForm((String)this.oui_loc), (String)("lib/" + OiixPlatform.getCurrentPlatformDirectoryName()));
        }
        System.setProperty("oracle.installer.library_loc", OiixPathOps.getNativeForm((String)this.lib_loc));
        OiiolTextLogger.appendText((String)("LIBRARY_LOC = " + System.getProperty("oracle.installer.library_loc")));
    }

    void initPaths() throws FatalException {
        this.initPaths(m_remotePlatId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void initPaths(int remotePlatId) throws FatalException {
        Commands commands = null;
        try {
            commands = new Commands();
            this.m_localPaths = commands.createInstance(m_localPlatId);
            String m_PropertiesDir = null;
            m_PropertiesDir = System.getProperty(PATH_PROPERTIES_LOC_PROPERTY);
            String r_PropertiesDir = System.getProperty("oracle.sysman.prov.RemotePathsPropertiesLoc");
            OiiolTextLogger.appendText((String)("m_PropertiesDir = " + m_PropertiesDir + " r_PropertiesDir = " + r_PropertiesDir));
            if (r_PropertiesDir == null) {
                OiiolTextLogger.appendText((String)"SSHSetup: Creating remotePaths using PATH_PROPERTIES_LOC_PROPERTY");
                if (m_PropertiesDir == null) throw new FatalException("PROV-16049", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16049"));
                this.m_remotePaths = commands.createInstance(remotePlatId, m_PropertiesDir);
                return;
            } else {
                OiiolTextLogger.appendText((String)"SSHSetup: Creating remotePaths using REMOTE_PATH_PROPERTIES_LOC_PROPERTY");
                this.m_remotePaths = commands.createInstance(remotePlatId, r_PropertiesDir);
            }
            return;
        }
        catch (FatalException e) {
            OiiolTextLogger.appendException((Exception)((Object)e));
            OiiolTextLogger.writeToLogAndConsole((String)UNSUPPORTED_PLTF_ERROR);
            OiiolTextLogger.writeToLogAndConsole((String)e.getMessage());
            this.logPlatformids();
            throw e;
        }
    }

    private void logPlatformids() {
        try {
            this.m_platform = new Platform();
        }
        catch (Exception ee) {
            OiiolTextLogger.appendException((Exception)ee);
            System.exit(1);
        }
        SSHSetup sSHSetup = this;
        int[] supportedPltfs = sSHSetup.m_platform.getPlatforms();
        int count = supportedPltfs.length;
        Integer id = null;
        OiiolTextLogger.writeToLogAndConsole((String)"Supported Platform id's\n");
        for (int i = 0; i < count; ++i) {
            id = new Integer(supportedPltfs[i]);
            OiiolTextLogger.writeToLogAndConsole((String)(id.toString() + SPACE + Platform.getPlatformDirectoryName((int)supportedPltfs[i])));
        }
    }

    public void setLogFile(String sLogFile) {
        this.m_sLogFile = OiixPathOps.getNativeForm((String)OiixPathOps.getStandardForm((String)sLogFile));
    }

    public static void setHomeDir(String userHomeDir) {
        home = OiixPathOps.getNativeForm((String)OiixPathOps.getStandardForm((String)userHomeDir));
    }

    public synchronized void setupConnectivity(boolean oflag, String[] remoteHosts, String username, boolean sharedHome) throws SSHSetupException, ClusterException, FatalException {
        this.setupConnectivity(oflag, remoteHosts, username, sharedHome, false);
    }

    public synchronized void setupConnectivity(boolean oflag, String[] remoteHosts, String username, boolean sharedHome, boolean advanced) throws SSHSetupException, ClusterException, FatalException {
        this.setupConnectivity(oflag, remoteHosts, username, sharedHome, false, null, null, null);
    }

    public synchronized void setupConnectivity(boolean oflag, String[] remoteHosts, String username, boolean advanced, String asUser, String asUserGrp, String sshLocalDir) throws SSHSetupException, ClusterException, FatalException {
        boolean sharedCase = true;
        if (home == null) {
            home = System.getProperty(PROPERTY_USER_HOME);
        }
        if (username.equals(System.getProperty(PROPERTY_USER_NAME))) {
            try {
                this.validateSharedPath(remoteHosts, username, home);
            }
            catch (SharedDeviceException sde) {
                sharedCase = false;
            }
        } else {
            sharedCase = false;
        }
        if (!sharedCase) {
            this.setupConnectivity(oflag, remoteHosts, username, false, advanced, asUser, asUserGrp, sshLocalDir);
        } else {
            this.setupConnectivity(oflag, remoteHosts, username, true, advanced, asUser, asUserGrp, sshLocalDir);
        }
    }

    public synchronized void setupConnectivity(boolean oflag, String[] remoteHosts, String username, boolean sharedHome, boolean advanced, String asUser, String asUserGrp, String sshLocalDir) throws SSHSetupException, ClusterException, FatalException {
        try {
            int i;
            boolean createdir;
            try {
                this.getLock();
            }
            catch (FileLockException fle) {
                throw new SSHSetupException((Exception)((Object)fle));
            }
            String lib_loc = System.getProperty("oracle.installer.library_loc");
            if (lib_loc == null) {
                String oui_loc = System.getProperty("oracle.installer.oui_loc");
                lib_loc = OiixPathOps.concatPath((String)OiixPathOps.getStandardForm((String)oui_loc), (String)("lib/" + OiixPlatform.getCurrentPlatformDirectoryName()));
            }
            System.setProperty("oracle.installer.library_loc", OiixPathOps.getNativeForm((String)lib_loc));
            OiiolTextLogger.appendText((String)("LIBRARY_LOC = " + System.getProperty("oracle.installer.library_loc")));
            boolean sameUser = false;
            if (username == null) {
                username = System.getProperty(PROPERTY_USER_NAME);
                sameUser = true;
            } else if (username.equals(System.getProperty(PROPERTY_USER_NAME))) {
                sameUser = true;
            }
            OiiolTextLogger.writeToLogAndConsole((String)"Validating remote binaries..");
            try {
                if (this.validateRemoteBinaries(remoteHosts, username)) {
                    OiiolTextLogger.writeToLogAndConsole((String)"Remote binaries check succeeded");
                }
            }
            catch (SSHSetupException e) {
                OiiolTextLogger.writeToLogAndConsole((String)e.getMessage());
                SSHSetup.releaseLock();
                throw e;
            }
            boolean sameUserSameHost = false;
            String localFQDN = "";
            String localHost = "";
            String localIP = "";
            String localHostFound = "";
            localFQDN = OiixNetOps.getFullHostName();
            localHost = OiixNetOps.getMachineName((String)localFQDN);
            localIP = OiixNetOps.getHostIPAddress();
            if (sameUser) {
                for (int m = 0; m < remoteHosts.length; ++m) {
                    if (remoteHosts[m].equals(localFQDN)) {
                        localHostFound = localFQDN;
                        sameUserSameHost = true;
                        break;
                    }
                    if (!remoteHosts[m].equals(localHost)) continue;
                    localHostFound = localHost;
                    sameUserSameHost = true;
                    break;
                }
            }
            if (home == null) {
                home = System.getProperty(PROPERTY_USER_HOME);
            }
            String sshDir = OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)home, (String)SSHDIR));
            String keyfile = OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)sshDir, (String)this.m_localPaths.getValue("IDENTITY")));
            String pubKeyFile = OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)sshDir, (String)this.m_localPaths.getValue("IDENTITY_PUB")));
            ClusterBaseOps baseops = new ClusterBaseOps();
            File f = new File(sshDir);
            boolean bl = createdir = !f.exists();
            if (createdir && !f.mkdirs()) {
                this.l_command = this.m_localPaths.getValue("MKDIR_PATH") + SPACE + this.m_localPaths.getValue("MKDIR_ARGS") + " '" + sshDir + "'";
                this.runCmdOnLocalNodeHelper(baseops, this.l_command);
            }
            File f1 = new File(keyfile);
            File f2 = new File(pubKeyFile);
            if (f1.exists() && f2.exists() && !oflag) {
                OiiolTextLogger.appendText((String)"User selected : no, using Old keys");
            } else {
                if (oflag) {
                    OiiolTextLogger.appendText((String)"User selected : yes, generating new Keys");
                } else {
                    OiiolTextLogger.appendText((String)"Public, Private keys don't exist, generating new Keys");
                }
                if (f1.exists() && f2.exists() && oflag) {
                    try {
                        if (this.fileExists(keyfile + BAK)) {
                            this.deletefileHelper(keyfile + BAK);
                        }
                        OiixFileOps.backUpFile((String)keyfile, (String)(keyfile + BAK));
                        if (this.fileExists(pubKeyFile + BAK)) {
                            this.deletefileHelper(pubKeyFile + BAK);
                        }
                        OiixFileOps.backUpFile((String)pubKeyFile, (String)(pubKeyFile + BAK));
                    }
                    catch (IOException e) {
                        OiiolTextLogger.appendException((Exception)e);
                    }
                }
                f1.delete();
                f2.delete();
                OiiolTextLogger.appendText((String)"");
                OiiolTextLogger.appendText((String)"Generating new keys");
                JSch jsch = new JSch();
                int type = 2;
                try {
                    KeyPair kpair = KeyPair.genKeyPair((JSch)jsch, (int)type);
                    kpair.setPassphrase(this.m_sPassphrase);
                    kpair.writePrivateKey(keyfile);
                    kpair.writePublicKey(pubKeyFile, COMMENT);
                    kpair.dispose();
                }
                catch (Exception e) {
                    this.writeExceptionToLogAndConsole(e);
                    OiiolTextLogger.appendException((Exception)e);
                    this.commandResults.put(LOCALHOST, "Key Generation failed");
                    this.commandExceptions.put(LOCALHOST, new CommandException(LOCALHOST, e.getMessage(), (Throwable)e));
                    try {
                        SSHSetup.releaseLock();
                    }
                    catch (FileLockException funlck) {
                        throw new SSHSetupException((Exception)((Object)funlck));
                    }
                    throw new SSHSetupException("PROV-16011", this.commandResults, this.commandExceptions);
                }
                String identity = OiixPathOps.concatPath((String)OiixPathOps.getParentDir((String)keyfile), (String)IDENTITY);
                String identity_pub = OiixPathOps.concatPath((String)OiixPathOps.getParentDir((String)keyfile), (String)IDENTITY_PUB);
                if (!identity.equals(keyfile)) {
                    OiixFileOps.copyFile((String)keyfile, (String)identity, (boolean)false, (boolean)false);
                    OiixFileOps.copyFile((String)pubKeyFile, (String)identity_pub, (boolean)false, (boolean)false);
                }
            }
            this.authorized_keys = OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)sshDir, (String)AUTHORIZED_KEYS));
            if (new File(this.authorized_keys).exists() && oflag) {
                try {
                    if (this.fileExists(this.authorized_keys + BAK)) {
                        this.deletefileHelper(this.authorized_keys + BAK);
                    }
                    OiixFileOps.backUpFile((String)this.authorized_keys, (String)(this.authorized_keys + BAK));
                    if (!this.noDelete) {
                        File ath = new File(this.authorized_keys);
                        ath.delete();
                    }
                }
                catch (IOException e) {
                    OiiolTextLogger.appendException((Exception)e);
                }
            }
            try {
                OiixFileOps.appendFile((String)this.authorized_keys, (String)pubKeyFile);
            }
            catch (IOException e) {
                OiiolTextLogger.appendException((Exception)e);
                this.commandResults.put(LOCALHOST, "Append to authorized_keys failed");
                this.commandExceptions.put(LOCALHOST, new CommandException(LOCALHOST, e.getMessage(), (Throwable)e));
                try {
                    SSHSetup.releaseLock();
                }
                catch (FileLockException funlck) {
                    throw new SSHSetupException((Exception)((Object)funlck));
                }
                throw new SSHSetupException("PROV-16011", this.commandResults, this.commandExceptions);
            }
            String config = OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)sshDir, (String)CONFIG));
            File fConfig = new File(config);
            if (fConfig.exists() && oflag) {
                try {
                    if (this.fileExists(config + BAK)) {
                        this.deletefileHelper(config + BAK);
                    }
                    OiixFileOps.backUpFile((String)config, (String)(config + BAK));
                }
                catch (IOException e) {
                    OiiolTextLogger.appendException((Exception)e);
                }
                fConfig.delete();
            }
            String str = "Host *\nForwardX11 no\n";
            this.writeStringToFile(config, str, false);
            boolean found_rHome = false;
            String h_cmd = "echo $HOME";
            RunCommand cmd = null;
            for (int t_cnt = 0; t_cnt < remoteHosts.length; ++t_cnt) {
                cmd = new RunCommand(remoteHosts[t_cnt], username, this.m_sPassword);
                if (!this.runCommandHelper(remoteHosts[t_cnt], h_cmd, cmd)) continue;
                found_rHome = true;
                break;
            }
            if (!found_rHome) {
                try {
                    SSHSetup.releaseLock();
                }
                catch (FileLockException funlck) {
                    throw new SSHSetupException((Exception)((Object)funlck));
                }
                throw new SSHSetupException("PROV-16011", this.commandResults, this.commandExceptions);
            }
            String remoteHome = cmd.getOutput();
            String s_sRemoteSshDir = OiixPathOps.concatPath((String)remoteHome, (String)SSHDIR);
            String remoteAuthorized_keys = OiixPathOps.concatPath((String)s_sRemoteSshDir, (String)AUTHORIZED_KEYS);
            String scratchFile = OiixPathOps.concatPath((String)s_sRemoteSshDir, (String)this.m_remotePaths.getValue("IDENTITY_PUB"));
            String remoteConfig = OiixPathOps.concatPath((String)s_sRemoteSshDir, (String)CONFIG);
            String remoteKnownHosts = OiixPathOps.concatPath((String)s_sRemoteSshDir, (String)KNOWN_HOSTS);
            int loopCount = remoteHosts.length;
            if (sharedHome && sameUser) {
                loopCount = 0;
            }
            if (!sameUser) {
                boolean r_SharedCase = true;
                try {
                    this.validateRemoteSharedPath(remoteHosts, username, remoteHome);
                }
                catch (SharedDeviceException sde) {
                    r_SharedCase = false;
                }
                if (r_SharedCase) {
                    loopCount = 1;
                }
            }
            for (int j = 0; j < loopCount; ++j) {
                cmd = new RunCommand(remoteHosts[j], username, this.m_sPassword);
                this.r_command = this.m_remotePaths.getValue("MKDIR_PATH") + SPACE + this.m_remotePaths.getValue("MKDIR_ARGS") + SPACE + this.BEGIN_QUOTE + s_sRemoteSshDir + this.END_QUOTE;
                if (!this.runCommandHelper(remoteHosts[j], this.r_command, cmd)) continue;
                scratchFile = scratchFile + remoteHosts[j];
                this.r_command = this.m_remotePaths.getValue("RM_PATH_2") + SPACE + this.m_remotePaths.getValue("RM_ARGS_2") + SPACE + this.BEGIN_QUOTE + scratchFile + this.END_QUOTE;
                if (!this.runCommandHelper(remoteHosts[j], this.r_command, cmd)) continue;
                CopyFile copyCmd = new CopyFile(remoteHosts[j], username, this.m_sPassword);
                scratchFile = this.BEGIN_QUOTE + scratchFile + this.END_QUOTE;
                if (!this.scptoHelper(pubKeyFile, scratchFile, copyCmd, remoteHosts[j])) continue;
                this.r_command = this.m_remotePaths.getValue("CP_PATH_2") + SPACE + this.m_remotePaths.getValue("CP_ARGS_2") + SPACE + this.BEGIN_QUOTE + remoteAuthorized_keys + this.END_QUOTE + SPACE + this.BEGIN_QUOTE + remoteAuthorized_keys + BAK + this.END_QUOTE;
                if (!this.runCommandHelper(remoteHosts[j], this.r_command, cmd)) continue;
                this.r_command = this.m_remotePaths.getValue("CAT_PATH") + SPACE + scratchFile + " >> " + this.BEGIN_QUOTE + remoteAuthorized_keys + this.END_QUOTE;
                if (!this.runCommandHelper(remoteHosts[j], this.r_command, cmd)) continue;
                this.r_command = this.m_remotePaths.getValue("RM_PATH_2") + SPACE + this.m_remotePaths.getValue("RM_ARGS_2") + SPACE + scratchFile;
                if (!this.runCommandHelper(remoteHosts[j], this.r_command, cmd)) continue;
                this.r_command = this.m_remotePaths.getValue("CHMOD_PATH") + " 644 " + this.BEGIN_QUOTE + remoteAuthorized_keys + this.END_QUOTE;
                if (!this.runCommandHelper(remoteHosts[j], this.r_command, cmd)) continue;
                this.r_command = this.m_remotePaths.getValue("CHMOD_PATH") + " og-w " + this.BEGIN_QUOTE + remoteHome + this.END_QUOTE;
                if (!this.runCommandHelper(remoteHosts[j], this.r_command, cmd)) continue;
                this.r_command = this.m_remotePaths.getValue("CHMOD_PATH") + " og-w " + this.BEGIN_QUOTE + s_sRemoteSshDir + this.END_QUOTE;
                if (!this.runCommandHelper(remoteHosts[j], this.r_command, cmd) || sameUserSameHost) continue;
                this.r_command = this.m_remotePaths.getValue("MV_PATH_2") + SPACE + this.m_remotePaths.getValue("MV_ARGS_2") + SPACE + this.BEGIN_QUOTE + remoteConfig + this.END_QUOTE + SPACE + this.BEGIN_QUOTE + remoteConfig + BAK + this.END_QUOTE;
                if (this.runCommandHelper(remoteHosts[j], this.r_command, cmd) && this.scptoHelper(config, remoteConfig = this.BEGIN_QUOTE + remoteConfig + this.END_QUOTE, copyCmd, remoteHosts[j])) continue;
            }
            String known_hosts = OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)sshDir, (String)KNOWN_HOSTS));
            if (new File(known_hosts).exists() && oflag) {
                try {
                    if (this.fileExists(known_hosts + BAK)) {
                        this.deletefileHelper(known_hosts + BAK);
                    }
                    OiixFileOps.backUpFile((String)known_hosts, (String)(known_hosts + BAK));
                }
                catch (IOException e) {
                    OiiolTextLogger.appendException((Exception)e);
                }
                if (!this.noDelete) {
                    File kh = new File(known_hosts);
                    kh.delete();
                }
            }
            String sourceFile = OiixPathOps.concatPath((String)this.m_remotePaths.getValue("SSH_HOST_KEY_LOC"), (String)SSH_HOST_RSA_KEY_PUB);
            str = "";
            String hostkey = null;
            String hostname = null;
            String fullHostname = null;
            String ip = null;
            for (i = 0; i < remoteHosts.length; ++i) {
                cmd = new RunCommand(remoteHosts[i], username, this.m_sPassword);
                this.r_command = this.m_remotePaths.getValue("CAT_PATH") + SPACE + this.BEGIN_QUOTE + sourceFile + this.END_QUOTE;
                if (!this.runCommandHelper(remoteHosts[i], this.r_command, cmd)) continue;
                hostkey = cmd.getOutput();
                InetAddress inetAddr = null;
                try {
                    inetAddr = InetAddress.getByName(remoteHosts[i]);
                    fullHostname = inetAddr.getHostName();
                    int idx = fullHostname.indexOf(46);
                    if (idx == -1) {
                        hostname = fullHostname;
                        fullHostname = inetAddr.getCanonicalHostName();
                    } else {
                        hostname = fullHostname.substring(0, idx);
                    }
                    OiiolTextLogger.appendText((String)("Hostname : " + hostname));
                    OiiolTextLogger.appendText((String)("FullHostname : " + fullHostname));
                    ip = inetAddr.getHostAddress();
                    OiiolTextLogger.appendText((String)("IP address : " + ip + "\n"));
                    str = str + hostname + "," + ip + SPACE + hostkey + "\n";
                    str = str + fullHostname + SPACE + hostkey + "\n";
                    continue;
                }
                catch (UnknownHostException e) {
                    OiiolTextLogger.appendException((Exception)e);
                }
            }
            this.writeStringToFile(known_hosts, str, true);
            this.l_command = this.m_localPaths.getValue("CHMOD_PATH") + " og-w '" + home + "'";
            this.runCmdOnLocalNodeHelper(baseops, this.l_command);
            this.setPermissionsOnSshDir(OiixPathOps.getStandardForm((String)sshDir));
            if (this.commandResults.size() >= 1 && !advanced) {
                try {
                    SSHSetup.releaseLock();
                }
                catch (FileLockException funlck) {
                    throw new SSHSetupException((Exception)((Object)funlck));
                }
                throw new SSHSetupException("PROV-16011", this.commandResults, this.commandExceptions);
            }
            for (i = 0; i < remoteHosts.length; ++i) {
                if (!advanced || sharedHome) continue;
                OiiolTextLogger.appendText((String)("Creating keys on remote Host " + remoteHosts[i]));
                OiiolTextLogger.appendText((String)("to setup SSH on Host " + remoteHosts[i]));
                this.identity_filename = this.m_localPaths.getValue("IDENTITY_PUB");
                String remotepublic_key = null;
                String remoteprivate_key = null;
                remotepublic_key = OiixPathOps.concatPath((String)s_sRemoteSshDir, (String)this.identity_filename);
                remoteprivate_key = OiixPathOps.concatPath((String)s_sRemoteSshDir, (String)this.m_localPaths.getValue("IDENTITY"));
                cmd = new RunCommand(remoteHosts[i], username, this.m_sPassword);
                this.r_command = this.m_remotePaths.getValue("RM_PATH") + SPACE + remotepublic_key;
                if (!this.runCommandHelper(remoteHosts[i], this.r_command, cmd)) continue;
                this.r_command = this.m_remotePaths.getValue("RM_PATH") + SPACE + remoteprivate_key;
                if (!this.runCommandHelper(remoteHosts[i], this.r_command, cmd)) continue;
                String remoteprivate_correctkey_org = OiixPathOps.concatPath((String)s_sRemoteSshDir, (String)this.m_localPaths.getValue("IDENTITY"));
                this.r_command = this.m_remotePaths.getValue("RM_PATH") + SPACE + remoteprivate_correctkey_org;
                if (!this.runCommandHelper(remoteHosts[i], this.r_command, cmd)) continue;
                this.r_command = this.m_remotePaths.getValue("SSH_KEYGEN_PATH") + SPACE + this.m_remotePaths.getValue("SSH_KEYGEN_ARGS") + SPACE + this.m_remotePaths.getValue("SSH_KEYGEN_ARGS_KEYFILE") + SPACE + remoteprivate_key + SPACE + this.m_remotePaths.getValue("SSH_KEYGEN_ARGS_PASSPHRASE") + SPACE + "''" + SPACE + BITS + SPACE + this.bitsize;
                if (!this.runCommandHelper(remoteHosts[i], this.r_command, cmd)) continue;
                String identity = OiixPathOps.concatPath((String)OiixPathOps.getParentDir((String)remoteprivate_key), (String)IDENTITY);
                String identity_pub = OiixPathOps.concatPath((String)OiixPathOps.getParentDir((String)remoteprivate_key), (String)IDENTITY_PUB);
                if (identity.equals(remoteprivate_key)) continue;
                this.r_command = this.m_remotePaths.getValue("CP_PATH_2") + SPACE + this.m_remotePaths.getValue("CP_ARGS_2") + SPACE + this.BEGIN_QUOTE + remoteprivate_key + this.END_QUOTE + SPACE + this.BEGIN_QUOTE + identity + this.END_QUOTE;
                if (!this.runCommandHelper(remoteHosts[i], this.r_command, cmd)) continue;
                this.r_command = this.m_remotePaths.getValue("CP_PATH_2") + SPACE + this.m_remotePaths.getValue("CP_ARGS_2") + SPACE + this.BEGIN_QUOTE + remotepublic_key + this.END_QUOTE + SPACE + this.BEGIN_QUOTE + identity_pub + this.END_QUOTE;
                if (this.runCommandHelper(remoteHosts[i], this.r_command, cmd)) continue;
            }
            for (i = 0; i < remoteHosts.length; ++i) {
                String localtmp;
                if (!advanced || sharedHome) continue;
                CopyFile copyCmd = new CopyFile(remoteHosts[i], username, this.m_sPassword);
                String remotepublic_key = OiixPathOps.concatPath((String)s_sRemoteSshDir, (String)this.identity_filename);
                if (!this.scpfromHelper(remotepublic_key, localtmp = OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)sshDir, (String)(this.m_localPaths.getValue("IDENTITY_PUB") + "." + remoteHosts[i]))), copyCmd, remoteHosts[i])) continue;
                String catcmd = this.m_localPaths.getValue("CAT_PATH") + SPACE + "'" + localtmp + "'" + " >> " + "'" + this.authorized_keys + "'";
                this.runCmdOnLocalNodeHelper(baseops, catcmd);
                this.l_command = this.m_localPaths.getValue("RM_PATH") + SPACE + this.m_localPaths.getValue("RM_F_ARGS") + SPACE + "'" + localtmp + "'";
                this.runCmdOnLocalNodeHelper(baseops, this.l_command);
            }
            String serverPubKeyFile = OiixPathOps.concatPath((String)this.m_localPaths.getValue("SSH_HOST_KEY_LOC"), (String)SSH_HOST_RSA_KEY_PUB);
            hostkey = OiixFunctionOps.implodeList((String[])this.readFile(serverPubKeyFile), (String)"\n");
            String localHostkey = localHost + "," + localIP + SPACE + hostkey + "\n";
            this.writeStringToFile(known_hosts, localHostkey, true);
            if (!localHost.trim().equals(localFQDN.trim())) {
                localHostkey = localFQDN + SPACE + hostkey + "\n";
                this.writeStringToFile(known_hosts, localHostkey, true);
            }
            for (int i2 = 0; i2 < remoteHosts.length; ++i2) {
                CopyFile copyCmd = null;
                if (advanced && !sharedHome) {
                    copyCmd = new CopyFile(remoteHosts[i2], username, this.m_sPassword);
                    OiiolTextLogger.appendText((String)("Advanced: Copying " + this.authorized_keys + "to " + remoteAuthorized_keys + " to node " + remoteHosts[i2]));
                    if (!this.scptoHelper(this.authorized_keys, remoteAuthorized_keys, copyCmd, remoteHosts[i2])) continue;
                }
                if (!advanced && (!advanced || !sharedHome)) continue;
                copyCmd = new CopyFile(remoteHosts[i2], username, this.m_sPassword);
                OiiolTextLogger.appendText((String)("Advanced: Copying " + known_hosts + " to " + remoteKnownHosts + " to node " + remoteHosts[i2]));
                if (this.scptoHelper(known_hosts, remoteKnownHosts, copyCmd, remoteHosts[i2])) continue;
            }
            if (asUser != null && sshLocalDir != null) {
                String localDirStd;
                String homeD = OiixPathOps.getNativeForm((String)SSHSetup.getHomeDir());
                File fp = new File(sshLocalDir);
                String sshLocalDir_Parent = OiixPathOps.getNativeForm((String)fp.getParent());
                OiiolTextLogger.appendText((String)("Home Dir : " + homeD + " sshLocalDir_Parent " + sshLocalDir_Parent));
                if (asUser != null && !sshLocalDir_Parent.equals(homeD)) {
                    localDirStd = OiixPathOps.getStandardForm((String)sshLocalDir);
                    File fSshLocalDir = new File(sshLocalDir);
                    if (fSshLocalDir.exists()) {
                        OiixFileOps.recdelete((File)fSshLocalDir);
                    }
                    if (!fSshLocalDir.mkdirs()) {
                        this.l_command = this.m_localPaths.getValue("MKDIR_PATH") + SPACE + this.m_localPaths.getValue("MKDIR_ARGS") + " '" + localDirStd + "'";
                        this.runCmdOnLocalNodeHelper(baseops, this.l_command);
                    }
                    String identity1 = OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)localDirStd, (String)this.m_localPaths.getValue("IDENTITY")));
                    String identitypub1 = OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)localDirStd, (String)this.m_localPaths.getValue("IDENTITY_PUB")));
                    String authkeys1 = OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)localDirStd, (String)AUTHORIZED_KEYS));
                    String known_hosts1 = OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)localDirStd, (String)KNOWN_HOSTS));
                    String config1 = OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)localDirStd, (String)CONFIG));
                    try {
                        OiixFileOps.copyFile((String)keyfile, (String)identity1, (boolean)true, (boolean)false);
                        OiixFileOps.copyFile((String)pubKeyFile, (String)identitypub1, (boolean)true, (boolean)false);
                        OiixFileOps.copyFile((String)this.authorized_keys, (String)authkeys1, (boolean)true, (boolean)false);
                        OiixFileOps.copyFile((String)known_hosts, (String)known_hosts1, (boolean)true, (boolean)false);
                        OiixFileOps.copyFile((String)config, (String)config1, (boolean)true, (boolean)false);
                    }
                    catch (Exception e) {
                        OiiolTextLogger.appendException((Exception)e);
                        this.commandResults.put(LOCALHOST, "Unable to copy files to sshlocalDir");
                        this.commandExceptions.put(LOCALHOST, new CommandException(LOCALHOST, e.getMessage(), (Throwable)e));
                        try {
                            SSHSetup.releaseLock();
                        }
                        catch (FileLockException funlck) {
                            throw new SSHSetupException((Exception)((Object)funlck));
                        }
                        throw new SSHSetupException("PROV-16011", this.commandResults, this.commandExceptions);
                    }
                    this.setPermissionsOnSshDir(localDirStd);
                    this.setPermissionsOnSshDir(OiixPathOps.getStandardForm((String)sshDir));
                }
                if (asUserGrp == null) {
                    asUserGrp = "";
                }
                localDirStd = OiixPathOps.getStandardForm((String)sshLocalDir);
                this.l_command = this.m_localPaths.getValue("CHOWN_PATH") + " -R " + asUser + " '" + localDirStd + "'";
                this.runCmdOnLocalNodeHelper(baseops, this.l_command);
            }
            try {
                SSHSetup.releaseLock();
            }
            catch (FileLockException funlck) {
                throw new SSHSetupException((Exception)((Object)funlck));
            }
            if (advanced && this.commandResults.size() >= 1) {
                throw new SSHSetupException("PROV-16011", this.commandResults, this.commandExceptions);
            }
        }
        catch (ClusterException ce) {
            throw ce;
        }
        catch (FatalException fe) {
            throw fe;
        }
        catch (SSHSetupException se) {
            throw se;
        }
        catch (Throwable te) {
            try {
                SSHSetup.releaseLock();
            }
            catch (FileLockException fle) {
                throw new FatalException((Throwable)((Object)fle));
            }
            throw new FatalException(te);
        }
    }

    private void runCmdOnLocalNodeHelper(ClusterBaseOps baseOps, String command) throws ClusterException, FatalException {
        try {
            baseOps.runCmdOnLocalNode(command);
        }
        catch (ClusterException ce) {
            try {
                SSHSetup.releaseLock();
            }
            catch (FileLockException funlck) {
                throw new FatalException((Throwable)((Object)funlck));
            }
            throw ce;
        }
        catch (FatalException fe) {
            try {
                SSHSetup.releaseLock();
            }
            catch (FileLockException funlck) {
                throw new FatalException((Throwable)((Object)funlck));
            }
            throw fe;
        }
    }

    private boolean runCommandHelper(String remoteNode, String command, RunCommand cmd) {
        try {
            cmd.runCommand(command);
        }
        catch (CommandException ce) {
            if (this.commandResults.get(remoteNode) == null) {
                this.commandResults.put(remoteNode, command);
            }
            if (this.commandExceptions.get(remoteNode) == null) {
                this.commandExceptions.put(remoteNode, ce);
            }
            return false;
        }
        return true;
    }

    private boolean scptoHelper(String src, String dest, CopyFile copyCmd, String remoteNode) {
        try {
            copyCmd.scpTo(src, dest);
        }
        catch (CommandException ce) {
            if (this.commandResults.get(remoteNode) == null) {
                this.commandResults.put(remoteNode, SCP_TO);
            }
            if (this.commandExceptions.get(remoteNode) == null) {
                this.commandExceptions.put(remoteNode, ce);
            }
            return false;
        }
        return true;
    }

    private boolean scpfromHelper(String src, String dest, CopyFile copyCmd, String remoteNode) {
        try {
            copyCmd.scpFrom(src, dest);
        }
        catch (CommandException ce) {
            if (this.commandResults.get(remoteNode) == null) {
                this.commandResults.put(remoteNode, SCP_TO);
            }
            if (this.commandExceptions.get(remoteNode) == null) {
                this.commandExceptions.put(remoteNode, ce);
            }
            return false;
        }
        return true;
    }

    private synchronized boolean fileExists(String filename) {
        if (filename == null) {
            return false;
        }
        File fp = new File(OiixPathOps.getNativeForm((String)filename));
        return fp.exists();
    }

    private void setPermissionsOnSshDir(String dir) throws FatalException, ClusterException {
        String oldPrivateKey;
        String identity;
        String config;
        String known_hosts;
        String authorized_keys;
        ClusterBaseOps baseops = new ClusterBaseOps();
        this.l_command = this.m_localPaths.getValue("CHMOD_PATH") + " 755 '" + dir + "'";
        this.runCmdOnLocalNodeHelper(baseops, this.l_command);
        String identity_pub = OiixPathOps.concatPath((String)dir, (String)this.m_localPaths.getValue("IDENTITY_PUB"));
        if (this.fileExists(identity_pub)) {
            this.l_command = this.m_localPaths.getValue("CHMOD_PATH") + " 644 '" + identity_pub + "'";
            this.runCmdOnLocalNodeHelper(baseops, this.l_command);
        }
        if (this.fileExists(authorized_keys = OiixPathOps.concatPath((String)dir, (String)AUTHORIZED_KEYS))) {
            this.l_command = this.m_localPaths.getValue("CHMOD_PATH") + " 644 '" + OiixPathOps.concatPath((String)dir, (String)AUTHORIZED_KEYS) + "'";
            this.runCmdOnLocalNodeHelper(baseops, this.l_command);
        }
        if (this.fileExists(known_hosts = OiixPathOps.concatPath((String)dir, (String)KNOWN_HOSTS))) {
            this.l_command = this.m_localPaths.getValue("CHMOD_PATH") + " 644 '" + known_hosts + "'";
            this.runCmdOnLocalNodeHelper(baseops, this.l_command);
        }
        if (this.fileExists(config = OiixPathOps.concatPath((String)dir, (String)CONFIG))) {
            this.l_command = this.m_localPaths.getValue("CHMOD_PATH") + " 644 '" + config + "'";
            this.runCmdOnLocalNodeHelper(baseops, this.l_command);
        }
        if (this.fileExists(identity = OiixPathOps.concatPath((String)dir, (String)this.m_localPaths.getValue("IDENTITY")))) {
            this.l_command = this.m_localPaths.getValue("CHMOD_PATH") + " 600 '" + OiixPathOps.concatPath((String)dir, (String)this.m_localPaths.getValue("IDENTITY")) + "'";
            this.runCmdOnLocalNodeHelper(baseops, this.l_command);
        }
        if (!(oldPrivateKey = OiixPathOps.concatPath((String)dir, (String)IDENTITY)).equals(identity)) {
            String oldPublicKey;
            if (this.fileExists(oldPrivateKey)) {
                this.l_command = this.m_localPaths.getValue("CHMOD_PATH") + " 600 '" + oldPrivateKey + "'";
                this.runCmdOnLocalNodeHelper(baseops, this.l_command);
            }
            if (this.fileExists(oldPublicKey = OiixPathOps.concatPath((String)dir, (String)IDENTITY_PUB))) {
                this.l_command = this.m_localPaths.getValue("CHMOD_PATH") + " 644 '" + oldPublicKey + "'";
                this.runCmdOnLocalNodeHelper(baseops, this.l_command);
            }
        }
    }

    private void writeStringToFile(String filepath, String str, boolean append) {
        try {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(filepath, append);
            }
            catch (FileNotFoundException e) {
                OiiolTextLogger.appendException((Exception)e);
            }
            PrintWriter pw = new PrintWriter(fos, true);
            pw.println(str);
            try {
                fos.close();
            }
            catch (IOException e) {
                OiiolTextLogger.appendException((Exception)e);
            }
            pw.close();
        }
        catch (Exception e) {
            OiiolTextLogger.appendException((Exception)e);
        }
    }

    private void writeExceptionToLogAndConsole(Exception ex) {
        OiiolTextLogger.appendException((Exception)ex);
    }

    public void validateRemoteSharedPath(String[] remoteNodes, String username, String r_dirPath) throws SharedDeviceException {
        if (remoteNodes.length == 0) {
            OiiolTextLogger.appendText((String)"Remote Nodes is NULL");
            Object[] args = new String[]{"Remote Nodes is NULL"};
            throw new SharedDeviceException("PROV-16024", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16024", (Object[])args), null);
        }
        if (remoteNodes.length == 1) {
            return;
        }
        String path = OiixPathOps.concatPath((String)r_dirPath, (String)"CFSFileName.tmp");
        path = this.BEGIN_QUOTE + path + this.END_QUOTE;
        RunCommand cmd = new RunCommand(remoteNodes[0], username, this.m_sPassword);
        String remotecmd = this.m_remotePaths.getValue("TOUCH_PATH") + SPACE + path;
        if (remotecmd == null) {
            throw new SharedDeviceException("PROV-16001", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16001", null), null);
        }
        try {
            cmd.runCommand(remotecmd);
        }
        catch (CommandException cme) {
            this.removeRemoteFileHelper(remoteNodes[0], username, path);
            throw new SharedDeviceException("PROV-16011", cme.getMessage(), null);
        }
        for (int i = 1; i < remoteNodes.length; ++i) {
            cmd = new RunCommand(remoteNodes[i], username, this.m_sPassword);
            remotecmd = this.m_remotePaths.getValue("CAT_PATH") + SPACE + path;
            if (remotecmd == null) {
                this.removeRemoteFileHelper(remoteNodes[0], username, path);
                throw new SharedDeviceException("PROV-16001", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16001", null), null);
            }
            try {
                cmd.runCommand(remotecmd);
            }
            catch (CommandException cme) {
                this.removeRemoteFileHelper(remoteNodes[0], username, path);
                throw new SharedDeviceException("PROV-16011", cme.getMessage(), null);
            }
            int exitVal = cmd.getExitCode();
            if (exitVal == 0) continue;
            String error = cmd.getOutput();
            Integer exitCode = new Integer(cmd.getExitCode());
            String s_exitCode = exitCode.toString();
            String err_msg = "The command exited with " + s_exitCode + " and command output is " + error;
            this.removeRemoteFileHelper(remoteNodes[0], username, path);
            throw new SharedDeviceException("PROV-16031", err_msg, null);
        }
        this.removeRemoteFileHelper(remoteNodes[0], username, path);
    }

    public boolean validateRemoteBinaries(String[] remoteHosts, String username) throws SSHSetupException {
        for (int i = 0; i < remoteHosts.length; ++i) {
            RunCommand cmd;
            String remoteHostKeyLoc = this.m_remotePaths.getValue("SSH_HOST_KEY_LOC");
            String remoteHostKey = OiixPathOps.concatPath((String)remoteHostKeyLoc, (String)SSH_HOST_RSA_KEY_PUB);
            String shPath = this.m_remotePaths.getValue("SH_PATH");
            String shArgs = this.m_remotePaths.getValue("SH_ARGS");
            String sshKeygen = this.m_remotePaths.getValue("SSH_KEYGEN_PATH");
            String cmd2 = this.m_remotePaths.getValue("TRUE");
            String h_cmd = shPath + SPACE + shArgs + " '" + cmd2 + "'";
            if (!this.runCommandHelper(remoteHosts[i], h_cmd, cmd = new RunCommand(remoteHosts[i], username, this.m_sPassword))) {
                return false;
            }
            if (cmd.getExitCode() != 0) {
                throw new SSHSetupException("Existence check failed for " + shPath + " on node: " + remoteHosts[i]);
            }
            cmd2 = MessageFormat.format(this.m_remotePaths.getValue("CMD2"), "", remoteHostKey, "", "", "-f");
            h_cmd = shPath + SPACE + shArgs + " '" + cmd2 + "'";
            if (!this.runCommandHelper(remoteHosts[i], h_cmd, cmd = new RunCommand(remoteHosts[i], username, this.m_sPassword))) {
                return false;
            }
            if (cmd.getExitCode() != 0) {
                throw new SSHSetupException("Unable to find " + remoteHostKey + " on node: " + remoteHosts[i]);
            }
            cmd2 = MessageFormat.format(this.m_remotePaths.getValue("CMD2"), "", sshKeygen, "", "", "-f");
            h_cmd = shPath + SPACE + shArgs + " '" + cmd2 + "'";
            if (!this.runCommandHelper(remoteHosts[i], h_cmd, cmd = new RunCommand(remoteHosts[i], username, this.m_sPassword))) {
                return false;
            }
            if (cmd.getExitCode() == 0) continue;
            throw new SSHSetupException("Unable to find " + sshKeygen + " on node: " + remoteHosts[i]);
        }
        return true;
    }

    private void removeRemoteFileHelper(String remoteNode, String username, String r_filePath) throws SharedDeviceException {
        RunCommand cmd = new RunCommand(remoteNode, username, this.m_sPassword);
        String remotecmd = this.m_remotePaths.getValue("RM_PATH") + SPACE + this.m_remotePaths.getValue("RM_F_ARGS") + SPACE + r_filePath;
        try {
            cmd.runCommand(remotecmd);
        }
        catch (CommandException ce) {
            throw new SharedDeviceException("PROV-16011", ce.getMessage(), null);
        }
    }

    public void validateSharedPath(String[] remoteNodes, String username, String dirPath) throws SharedDeviceException {
        if (remoteNodes.length == 0) {
            OiiolTextLogger.appendText((String)"Remote Nodes is NULL");
            Object[] args = new String[]{"Remote Nodes is NULL"};
            throw new SharedDeviceException("PROV-16024", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16024", (Object[])args), null);
        }
        String path = OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)dirPath, (String)"CFSFileName"));
        path = this.BEGIN_QUOTE + path + this.END_QUOTE;
        File fp = null;
        FileOutputStream fout = null;
        String str = new String(CFS_FILE_CONTENT);
        try {
            OiiolTextLogger.appendText((String)("Path is : " + path));
            fp = new File(path);
        }
        catch (NullPointerException ne) {
            Object[] args = new String[]{"PASS A VALID PATH FOR dirPath"};
            OiiolTextLogger.appendText((String)"dirPath is null");
            throw new SharedDeviceException("PROV-16001", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16001", (Object[])args), null);
        }
        try {
            fout = new FileOutputStream(fp);
        }
        catch (FileNotFoundException fne) {
            Object[] args = new String[]{"Unable to create File in dirPath"};
            OiiolTextLogger.appendText((String)("File not found in path : " + path));
            throw new SharedDeviceException("PROV-16000", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16000", (Object[])args), null);
        }
        PrintWriter pw = new PrintWriter(fout, true);
        pw.println(str);
        try {
            fout.close();
        }
        catch (IOException e) {
            OiiolTextLogger.appendException((Exception)e);
            Object[] args = new String[]{"Unable to write to file"};
            OiiolTextLogger.appendText((String)("Unable to write to file : " + path));
            this.deletefileHelper(path);
            throw new SharedDeviceException("PROV-16026", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16026", (Object[])args), null);
        }
        pw.close();
        for (int i = 0; i < remoteNodes.length; ++i) {
            RunCommand cmd = new RunCommand(remoteNodes[i], username, this.m_sPassword);
            String remotecmd = this.m_remotePaths.getValue("CAT_PATH") + SPACE + path;
            if (remotecmd == null) {
                this.deletefileHelper(path);
                throw new SharedDeviceException("PROV-16001", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16001", null), null);
            }
            try {
                cmd.runCommand(remotecmd);
            }
            catch (CommandException cme) {
                this.deletefileHelper(path);
                throw new SharedDeviceException("PROV-16011", cme.getMessage(), null);
            }
            int exitVal = cmd.getExitCode();
            if (exitVal == 0) {
                String m_out = cmd.getOutput();
                if (m_out.indexOf(CFS_FILE_CONTENT) != -1) continue;
                OiiolTextLogger.appendText((String)"CFS_FILE is empty");
                this.deletefileHelper(path);
                throw new SharedDeviceException("PROV-16031", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"ERROR_SHARED_DEVICE", (Object[])new Object[]{path, remoteNodes[i]}), null);
            }
            String error = cmd.getOutput();
            Integer exitCode = new Integer(cmd.getExitCode());
            String s_exitCode = exitCode.toString();
            String err_msg = "The command exited with " + s_exitCode + " and command output is " + error;
            this.deletefileHelper(path);
            throw new SharedDeviceException("PROV-16031", err_msg, null);
        }
        try {
            ClusterBaseOps baseops = new ClusterBaseOps();
            this.l_command = this.m_localPaths.getValue("RM_PATH") + SPACE + this.m_localPaths.getValue("RM_F_ARGS") + SPACE + path;
            this.runCmdOnLocalNodeHelper(baseops, this.l_command);
        }
        catch (ClusterException ce) {
            throw new SharedDeviceException(ce);
        }
        catch (FatalException fe) {
            throw new SharedDeviceException("PROV-16031", fe.getMessage(), null);
        }
    }

    private static synchronized String getLockLocation() {
        String homeDir = SSHSetup.getHomeDir();
        String sshDir = OiixPathOps.getNativeForm((String)OiixPathOps.getStandardForm((String)OiixPathOps.concatPath((String)homeDir, (String)SSHDIR)));
        File sshDir_d = new File(sshDir);
        if (!sshDir_d.exists()) {
            sshDir_d.mkdir();
        }
        String lock = OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)sshDir, (String)SSH_LOCK));
        OiiolTextLogger.appendText((String)("Lock Location : " + lock));
        return lock;
    }

    private synchronized int getLockRetryCount() {
        int lock_retry_count = 120;
        String lock_count = System.getProperty(SSH_LOCK_RETRY_COUNT);
        if (lock_count != null) {
            OiiolTextLogger.appendText((String)("lock_count " + lock_count));
            lock_retry_count = Integer.getInteger(SSH_LOCK_RETRY_COUNT);
        }
        OiiolTextLogger.appendText((String)("Lock Retry Count " + lock_retry_count));
        return lock_retry_count;
    }

    private synchronized int getLockSleepTime() {
        int lock_sleep_time = 30000;
        String lock_stime = System.getProperty(SSH_LOCK_SLEEP_TIME);
        if (lock_stime != null) {
            lock_sleep_time = Integer.getInteger(SSH_LOCK_SLEEP_TIME);
            lock_sleep_time = 1000 * lock_sleep_time;
        }
        OiiolTextLogger.appendText((String)("Lock Sleep Time " + lock_sleep_time));
        return lock_sleep_time;
    }

    private static String getHomeDir() {
        if (home == null) {
            home = System.getProperty(PROPERTY_USER_HOME);
        }
        OiiolTextLogger.appendText((String)("Home Dir " + home));
        return OiixPathOps.getNativeForm((String)home);
    }

    private synchronized void getLock() throws FileLockException {
        int locksleep_time = this.getLockSleepTime();
        String lock_loc = OiixPathOps.getNativeForm((String)SSHSetup.getLockLocation());
        File lock = new File(lock_loc);
        OiiolTextLogger.appendText((String)"Trying to get Lock ....");
        if (lock.exists()) {
            for (int lockretry_cnt = this.getLockRetryCount(); lockretry_cnt != 0; --lockretry_cnt) {
                try {
                    OiiolTextLogger.appendText((String)("Sleeping for " + locksleep_time + " ms"));
                    Thread.sleep(locksleep_time);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                if (!lock.exists()) break;
                OiiolTextLogger.appendText((String)("Trying to get Lock ...." + lockretry_cnt));
            }
        }
        if (lock.exists()) {
            String failedNodes = LOCALHOST;
            Object[] args = new String[]{failedNodes, lock_loc};
            OiiolTextLogger.appendText((String)("FailedNodes " + args[0] + " lock_loc " + args[1]));
            String errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16046", (Object[])args);
            throw new FileLockException("PROV-16046", errorMessage);
        }
        try {
            lock.createNewFile();
        }
        catch (IOException ioe) {
            throw new FileLockException(ioe);
        }
        OiiolTextLogger.appendText((String)"Lock Acquired");
    }

    public static synchronized void releaseLock() throws FileLockException {
        String lock_loc = SSHSetup.getLockLocation();
        File lock = new File(lock_loc);
        OiiolTextLogger.appendText((String)"Releasing Lock...");
        if (lock.exists()) {
            if (!lock.delete()) {
                String failedNodes = LOCALHOST;
                throw new FileLockException("PROV-16047", OiixResourceBundle.getString((String)"PROV-16047", (String)"PROV-16047", (Object[])new String[]{failedNodes, lock_loc}));
            }
            OiiolTextLogger.appendText((String)"Lock Released");
        }
    }

    private synchronized boolean revertCustomerSSHSetup() {
        String homeDir = SSHSetup.getHomeDir();
        String sshDir = OiixPathOps.concatPath((String)homeDir, (String)SSHDIR);
        String knownhosts_path = OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)sshDir, (String)KNOWN_HOSTS));
        File known_hosts = new File(knownhosts_path);
        if (known_hosts.exists()) {
            if (known_hosts.length() == 0L) {
                return true;
            }
            if (known_hosts.length() != 0L) {
                boolean retVal = true;
                String[] known_hosts_file = this.readFile(knownhosts_path);
                if (known_hosts_file != null) {
                    for (int i = 0; i < known_hosts_file.length; ++i) {
                        if (known_hosts_file[i].trim().length() == 0) continue;
                        retVal = false;
                    }
                }
                return retVal;
            }
            return false;
        }
        return true;
    }

    private synchronized void restoreCustomerRemoteSSHSetup(String[] remoteNodes, String username) {
        String r_home;
        RunCommand cmd;
        String h_cmd;
        String command = null;
        int loopCount = remoteNodes.length;
        if (!username.equals(System.getProperty(PROPERTY_USER_NAME))) {
            boolean r_SharedCase = true;
            h_cmd = "echo $HOME";
            cmd = new RunCommand(remoteNodes[0], username, this.m_sPassword);
            if (!this.runCommandHelper(remoteNodes[0], h_cmd, cmd)) {
                return;
            }
            r_home = cmd.getOutput();
            try {
                this.validateRemoteSharedPath(remoteNodes, username, r_home);
            }
            catch (SharedDeviceException sde) {
                r_SharedCase = false;
            }
            if (r_SharedCase) {
                loopCount = 1;
            }
        }
        for (int i = 0; i < loopCount; ++i) {
            h_cmd = "echo $HOME";
            cmd = new RunCommand(remoteNodes[i], username, this.m_sPassword);
            if (!this.runCommandHelper(remoteNodes[i], h_cmd, cmd)) continue;
            r_home = cmd.getOutput();
            String sshDir = OiixPathOps.concatPath((String)r_home, (String)SSHDIR);
            String r_authorizedkeys_bak = OiixPathOps.concatPath((String)sshDir, (String)"authorized_keys.ri.bak");
            String r_authorizedkeys = OiixPathOps.concatPath((String)sshDir, (String)AUTHORIZED_KEYS);
            command = this.m_remotePaths.getValue("RM_PATH") + SPACE + this.m_remotePaths.getValue("RM_F_ARGS") + SPACE + "'" + r_authorizedkeys + "'";
            this.runCommandHelper(remoteNodes[i], command, cmd);
            command = this.m_remotePaths.getValue("MV_PATH") + SPACE + this.m_remotePaths.getValue("MV_ARGS") + SPACE + "'" + r_authorizedkeys_bak + "'" + SPACE + "'" + r_authorizedkeys + "'";
            this.runCommandHelper(remoteNodes[i], command, cmd);
            String r_config_bak = OiixPathOps.concatPath((String)sshDir, (String)"config.ri.bak");
            String r_config = OiixPathOps.concatPath((String)sshDir, (String)CONFIG);
            command = this.m_remotePaths.getValue("RM_PATH") + SPACE + this.m_remotePaths.getValue("RM_F_ARGS") + SPACE + "'" + r_config + "'";
            this.runCommandHelper(remoteNodes[i], command, cmd);
            command = this.m_remotePaths.getValue("MV_PATH") + SPACE + this.m_remotePaths.getValue("MV_ARGS") + SPACE + "'" + r_config_bak + "'" + SPACE + "'" + r_config + "'";
            this.runCommandHelper(remoteNodes[i], command, cmd);
        }
    }

    private synchronized void restoreCustomerLocalSSHSetup(String homeDir) throws UndoSSHSetupException {
        File ssh_dir;
        boolean del_sshdir = true;
        Object command = null;
        String sshDir = OiixPathOps.concatPath((String)homeDir, (String)SSHDIR);
        String knownhosts_path_bak = OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)sshDir, (String)"known_hosts.ri.bak"));
        String knownhosts_path = OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)sshDir, (String)KNOWN_HOSTS));
        String config_path_bak = OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)sshDir, (String)"config.ri.bak"));
        String config_path = OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)sshDir, (String)CONFIG));
        String authorized_keys_path_bak = OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)sshDir, (String)"authorized_keys.ri.bak"));
        String authorized_keys_path = OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)sshDir, (String)AUTHORIZED_KEYS));
        String identity_path_bak = OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)sshDir, (String)(this.m_localPaths.getValue("IDENTITY") + BAK)));
        String identity_path = OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)sshDir, (String)this.m_localPaths.getValue("IDENTITY")));
        String identity_pub_path_bak = OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)sshDir, (String)(this.m_localPaths.getValue("IDENTITY_PUB") + BAK)));
        String identity_pub_path = OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)sshDir, (String)this.m_localPaths.getValue("IDENTITY_PUB")));
        if (this.mvfileHelper(knownhosts_path_bak, knownhosts_path)) {
            del_sshdir = false;
        } else {
            this.deletefileHelper(knownhosts_path);
        }
        if (this.mvfileHelper(config_path_bak, config_path)) {
            del_sshdir = false;
        } else {
            this.deletefileHelper(config_path);
        }
        if (this.mvfileHelper(authorized_keys_path_bak, authorized_keys_path)) {
            del_sshdir = false;
        } else {
            this.deletefileHelper(authorized_keys_path);
        }
        if (this.mvfileHelper(identity_path_bak, identity_path)) {
            del_sshdir = false;
        } else {
            this.deletefileHelper(identity_path);
        }
        if (this.mvfileHelper(identity_pub_path_bak, identity_pub_path)) {
            del_sshdir = false;
        } else {
            this.deletefileHelper(identity_pub_path);
        }
        try {
            File sshd = new File(sshDir);
            File[] files = sshd.listFiles();
            if (files.length > 0) {
                this.setPermissionsOnSshDir(sshDir);
            }
        }
        catch (ClusterException ce) {
            try {
                SSHSetup.releaseLock();
            }
            catch (FileLockException fle) {
                throw new UndoSSHSetupException((Exception)((Object)fle));
            }
        }
        catch (FatalException fe) {
            try {
                SSHSetup.releaseLock();
            }
            catch (FileLockException fle) {
                throw new UndoSSHSetupException((Exception)((Object)fle));
            }
            throw new UndoSSHSetupException((Exception)((Object)fe));
        }
        if (del_sshdir && (ssh_dir = new File(sshDir)).exists()) {
            ssh_dir.delete();
        }
    }

    private boolean mvfileHelper(String srcFilePath, String destFilePath) {
        String command = null;
        File srcFile = new File(srcFilePath);
        if (srcFile.exists()) {
            OiiolTextLogger.appendText((String)("Restoring " + srcFilePath + " to " + destFilePath));
            command = this.m_localPaths.getValue("MV_PATH") + SPACE + this.m_localPaths.getValue("MV_ARGS") + SPACE + "'" + srcFilePath + "'" + SPACE + "'" + destFilePath + "'";
            try {
                ClusterBaseOps baseops = new ClusterBaseOps();
                this.runCmdOnLocalNodeHelper(baseops, command);
            }
            catch (FatalException fe) {
                File destFile = new File(destFilePath);
                srcFile.delete();
                srcFile.renameTo(destFile);
            }
            catch (ClusterException ce) {
                srcFile.delete();
                File destFile = new File(destFilePath);
                srcFile.renameTo(destFile);
            }
            return true;
        }
        return false;
    }

    private synchronized void deletefileHelper(String filePath) {
        if (filePath != null) {
            OiiolTextLogger.appendText((String)("Deleting " + filePath));
            File path = new File(filePath);
            if (path.exists()) {
                path.delete();
            }
        }
    }

    private synchronized void removeLocalSSHSetup(String homeDir, String[] remoteNodes) {
        String sshDir = OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)homeDir, (String)SSHDIR));
        String known_hosts = OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)sshDir, (String)KNOWN_HOSTS));
        String authorized_keys = OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)sshDir, (String)AUTHORIZED_KEYS));
        String known_hosts_tmp = OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)sshDir, (String)"known_hosts.tmp"));
        String pubkey = OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)sshDir, (String)this.m_localPaths.getValue("IDENTITY_PUB")));
        OiiolTextLogger.appendText((String)"removeLocalSSHSetup : Updating known_hosts");
        this.updateKnownHosts(known_hosts_tmp, remoteNodes, known_hosts);
        String[] authkeys_file = this.readFile(authorized_keys);
        if (authkeys_file == null) {
            return;
        }
        String[] pubkeyFile = this.readFile(pubkey);
        OiiolTextLogger.appendText((String)"removeLocalSSHSetup : Updating authorized_keys");
        this.updateAuthKeys(pubkeyFile, authkeys_file, authorized_keys);
    }

    private synchronized void updateKnownHosts(String known_hosts_tmp, String[] remoteNodes, String known_hosts) {
        OiiolTextLogger.appendText((String)("updateKnownHosts : remoteNodes length" + remoteNodes.length));
        String[] file = this.readFile(known_hosts);
        int outLoopCount = remoteNodes.length;
        int inLoopCount = file.length;
        OiiolTextLogger.appendText((String)("inLoopCount " + inLoopCount + " OutLoopCount " + outLoopCount));
        if (file != null) {
            File tmp = new File(known_hosts_tmp);
            try {
                tmp.createNewFile();
            }
            catch (IOException ioe) {
                OiiolTextLogger.appendException((Exception)ioe);
                return;
            }
            boolean firstline = true;
            boolean found = false;
            for (int i = 0; i < file.length; ++i) {
                found = false;
                for (int j = 0; j < remoteNodes.length; ++j) {
                    if (file[i].indexOf(remoteNodes[j]) == -1) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                if (firstline) {
                    this.writeStringToFile(known_hosts_tmp, file[i], false);
                    firstline = false;
                    continue;
                }
                this.writeStringToFile(known_hosts_tmp, file[i], true);
            }
            File known_hosts_file = new File(known_hosts);
            known_hosts_file.delete();
            tmp.renameTo(known_hosts_file);
        }
    }

    private synchronized void removeRemoteSSHSetup(String[] remoteNodes, String username, String homeDir) {
        String r_home;
        RunCommand cmd;
        int loopCount = remoteNodes.length;
        String r_command = null;
        if (!username.equals(System.getProperty(PROPERTY_USER_NAME))) {
            String h_cmd = "echo $HOME";
            cmd = new RunCommand(remoteNodes[0], username, this.m_sPassword);
            if (!this.runCommandHelper(remoteNodes[0], h_cmd, cmd)) {
                return;
            }
            r_home = cmd.getOutput();
            boolean r_SharedCase = true;
            try {
                this.validateRemoteSharedPath(remoteNodes, username, r_home);
            }
            catch (SharedDeviceException sde) {
                r_SharedCase = false;
            }
            if (r_SharedCase) {
                loopCount = 1;
            }
        }
        for (int i = 0; i < loopCount; ++i) {
            r_command = new String("echo $HOME");
            cmd = new RunCommand(remoteNodes[i], username, this.m_sPassword);
            if (!this.runCommandHelper(remoteNodes[i], r_command, cmd)) continue;
            r_home = cmd.getOutput();
            String r_sshDir = OiixPathOps.concatPath((String)r_home, (String)SSHDIR);
            String r_authorized_keys = OiixPathOps.concatPath((String)r_sshDir, (String)AUTHORIZED_KEYS);
            CopyFile copyCmd = new CopyFile(remoteNodes[i], username, this.m_sPassword);
            String sshDir = OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)homeDir, (String)SSHDIR));
            String localtmp = OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)sshDir, (String)("authorized_keys." + remoteNodes[i])));
            r_authorized_keys = this.BEGIN_QUOTE + r_authorized_keys + this.END_QUOTE;
            if (!this.scpfromHelper(r_authorized_keys, localtmp, copyCmd, remoteNodes[i])) {
                this.deletefileHelper(localtmp);
                continue;
            }
            String l_pubkeyFile = OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)sshDir, (String)this.m_localPaths.getValue("IDENTITY_PUB")));
            String[] pubkeyFile = this.readFile(l_pubkeyFile);
            String[] r_authkeysFile = this.readFile(localtmp);
            this.updateAuthKeys(pubkeyFile, r_authkeysFile, localtmp);
            if (!this.scptoHelper(localtmp, r_authorized_keys, copyCmd, remoteNodes[i])) {
                this.deletefileHelper(localtmp);
                continue;
            }
            this.deletefileHelper(localtmp);
        }
    }

    private synchronized void updateAuthKeys(String[] pubkeyFile, String[] r_authkeysFile, String localtmp) {
        if (pubkeyFile != null && r_authkeysFile != null) {
            String homeDir = SSHSetup.getHomeDir();
            String r_authkeys_tmp_path = OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)homeDir, (String)"authorized_keys.tmp"));
            File r_authkeys_tmp = new File(r_authkeys_tmp_path);
            try {
                r_authkeys_tmp.createNewFile();
            }
            catch (IOException ioe) {
                OiiolTextLogger.appendException((Exception)ioe);
                return;
            }
            boolean firstline = true;
            boolean done = false;
            for (int i = 0; i < r_authkeysFile.length; ++i) {
                if (r_authkeysFile[i].indexOf(pubkeyFile[0]) == -1) {
                    if (firstline) {
                        this.writeStringToFile(r_authkeys_tmp_path, r_authkeysFile[i], false);
                        firstline = false;
                        continue;
                    }
                    this.writeStringToFile(r_authkeys_tmp_path, r_authkeysFile[i], true);
                    continue;
                }
                if (!done) {
                    done = true;
                    continue;
                }
                if (firstline) {
                    this.writeStringToFile(r_authkeys_tmp_path, r_authkeysFile[i], false);
                    firstline = false;
                    continue;
                }
                this.writeStringToFile(r_authkeys_tmp_path, r_authkeysFile[i], true);
            }
            File localtmp_file = new File(localtmp);
            localtmp_file.delete();
            r_authkeys_tmp.renameTo(localtmp_file);
        }
    }

    private synchronized String[] readFile(String filePath) {
        FileInputStream fi = null;
        BufferedReader bfi = null;
        ArrayList<String> file_c = new ArrayList<String>();
        String line = null;
        File fp = new File(filePath);
        try {
            fi = new FileInputStream(fp);
        }
        catch (FileNotFoundException fnde) {
            OiiolTextLogger.appendText((String)("Reading " + filePath + " File not found"));
            OiiolTextLogger.appendException((Exception)fnde);
            return null;
        }
        bfi = new BufferedReader(new InputStreamReader(fi));
        while (true) {
            try {
                line = bfi.readLine();
            }
            catch (IOException ioe) {
                this.commandResults.put(LOCALHOST, "Read File " + filePath + " failed");
                this.commandExceptions.put(LOCALHOST, new CommandException(LOCALHOST, ioe.getMessage(), (Throwable)ioe));
                break;
            }
            if (line == null) break;
            if (line.trim().length() <= 0) continue;
            file_c.add(line);
        }
        if (!file_c.isEmpty()) {
            String[] file = file_c.toArray(new String[0]);
            return file;
        }
        return null;
    }

    public synchronized void dropSSHSetup(String[] remoteNodes, String username) throws UndoSSHSetupException, ClusterException, FatalException {
        this.dropSSHSetup(remoteNodes, username, null);
    }

    public synchronized void dropSSHSetup(String[] remoteNodes, String username, String sshLocalDir) throws UndoSSHSetupException, ClusterException, FatalException {
        if (remoteNodes.length == 0 || username == null) {
            throw new FatalException("PROV-16001", OiixResourceBundle.getString((String)"PROV-16001", (String)"PROV-16001", null));
        }
        try {
            try {
                this.getLock();
            }
            catch (FileLockException fle1) {
                throw new UndoSSHSetupException((Exception)((Object)fle1));
            }
            boolean sharedCase = true;
            String homeDir = SSHSetup.getHomeDir();
            if (username.equals(System.getProperty(PROPERTY_USER_NAME))) {
                try {
                    this.validateSharedPath(remoteNodes, username, homeDir);
                }
                catch (SharedDeviceException sde) {
                    sharedCase = false;
                }
            } else {
                sharedCase = false;
            }
            if (sshLocalDir != null) {
                if (sharedCase) {
                    this.removeLocalSSHSetup(sshLocalDir, remoteNodes);
                    if (sshLocalDir != homeDir) {
                        this.removeLocalSSHSetup(homeDir, remoteNodes);
                    }
                } else {
                    this.removeLocalSSHSetup(sshLocalDir, remoteNodes);
                    if (sshLocalDir != homeDir) {
                        this.removeLocalSSHSetup(homeDir, remoteNodes);
                    }
                    this.removeRemoteSSHSetup(remoteNodes, username, sshLocalDir);
                }
            } else if (sharedCase) {
                this.removeLocalSSHSetup(homeDir, remoteNodes);
            } else {
                this.removeLocalSSHSetup(homeDir, remoteNodes);
                this.removeRemoteSSHSetup(remoteNodes, username, homeDir);
            }
            if (this.revertCustomerSSHSetup()) {
                OiiolTextLogger.appendText((String)"Reverting Customer setup");
                if (sshLocalDir != null) {
                    if (sharedCase) {
                        this.restoreCustomerLocalSSHSetup(homeDir);
                        if (sshLocalDir != homeDir) {
                            this.restoreCustomerLocalSSHSetup(sshLocalDir);
                        }
                    } else {
                        this.restoreCustomerLocalSSHSetup(homeDir);
                        if (sshLocalDir != homeDir) {
                            this.restoreCustomerLocalSSHSetup(sshLocalDir);
                        }
                        this.restoreCustomerRemoteSSHSetup(remoteNodes, username);
                    }
                } else if (sharedCase) {
                    this.restoreCustomerLocalSSHSetup(homeDir);
                } else {
                    this.restoreCustomerLocalSSHSetup(homeDir);
                    this.restoreCustomerRemoteSSHSetup(remoteNodes, username);
                }
            }
            try {
                SSHSetup.releaseLock();
            }
            catch (FileLockException fle) {
                throw new UndoSSHSetupException((Exception)((Object)fle));
            }
            if (this.commandResults.size() >= 1) {
                throw new UndoSSHSetupException("PROV-16011", this.commandResults, this.commandExceptions);
            }
        }
        catch (UndoSSHSetupException uce) {
            throw uce;
        }
        catch (Throwable te) {
            try {
                SSHSetup.releaseLock();
            }
            catch (FileLockException fle) {
                throw new FatalException((Throwable)((Object)fle));
            }
            throw new FatalException(te);
        }
    }

    static {
        m_remotePlatId = m_localPlatId = SystemFactory.s_localPlatId;
        String s_sPropertiesDir = System.getProperty(PATH_PROPERTIES_LOC_PROPERTY);
        if (s_sPropertiesDir != null) {
            String absPath = OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)s_sPropertiesDir, (String)SSH_SYSTEM_PROPERTY));
            Properties temp = null;
            try {
                FileInputStream fs = new FileInputStream(absPath);
                temp = new Properties();
                temp.load(fs);
                fs.close();
            }
            catch (IOException e2) {
                // empty catch block
            }
            if (temp != null) {
                Enumeration<?> propNames = temp.propertyNames();
                while (propNames.hasMoreElements()) {
                    String propName = (String)propNames.nextElement();
                    String propval = (String)temp.get(propName);
                    if (System.getProperty(propName) != null) continue;
                    OiiolTextLogger.appendText((String)("Setting " + propName + " to " + propval));
                    System.setProperty(propName, propval);
                }
            }
        }
    }
}

