/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

public final class Guid
implements Cloneable {
    public static final int GUID_BYTE_SIZE = 16;
    public static final int GUID_STRING_SIZE = 35;
    public static final int GUID_STRING_SIZE_NEW = 32;
    private static byte[] _npd_global;
    private byte[] _guid_bytes;
    private String _guid_string;

    private static synchronized native int init_npd();

    private native int getNLUID();

    private native int getNLUIBinaryVersion();

    private native int getNLUIStringVersion();

    private native int getNLUIHashCode();

    public static String compactGuidString(String string) {
        if (string != null && string.length() == 35) {
            return string.substring(0, 12) + string.substring(13, 17) + string.substring(18, 22) + string.substring(23, 35);
        }
        if (string != null && string.length() == 32) {
            return string;
        }
        return "oracle.ldap.util.Guid: Invalid GUID String";
    }

    public static String expandGuidString(String string) {
        if (string != null && string.length() == 32) {
            return string.substring(0, 12) + "-" + string.substring(12, 16) + "-" + string.substring(16, 20) + "-" + string.substring(20, 32);
        }
        if (string != null && string.length() == 35) {
            return string;
        }
        return "oracle.ldap.util.Guid: Invalid GUID String";
    }

    public static Guid newInstance() {
        return new Guid();
    }

    public Guid() {
        int n;
        if (_npd_global == null) {
            n = Guid.init_npd();
        }
        n = this.getNLUID();
    }

    public Guid(String string) {
        String string2;
        int n;
        if (_npd_global == null) {
            n = Guid.init_npd();
        }
        if ((string2 = Guid.expandGuidString(string)).length() == 35) {
            this._guid_string = string2.toUpperCase();
            n = this.getNLUIBinaryVersion();
            if (n != 0) {
                this._guid_string = null;
                this._guid_bytes = null;
            }
        }
    }

    public Guid(byte[] byArray) {
        int n;
        if (_npd_global == null) {
            n = Guid.init_npd();
        }
        if (byArray.length == 16) {
            this._guid_bytes = byArray;
            n = this.getNLUIStringVersion();
            if (n != 0) {
                this._guid_string = null;
                this._guid_bytes = null;
            }
        }
    }

    public byte[] getBytes() {
        return this._guid_bytes;
    }

    public final String toString() {
        return Guid.compactGuidString(this._guid_string);
    }

    public boolean equals(Object object) {
        if (this.getClass() == object.getClass()) {
            return this.toString().equals(object.toString());
        }
        return false;
    }

    public int hashCode() {
        if (this._guid_bytes != null) {
            return this.getNLUIHashCode();
        }
        return 0;
    }

    public Object clone() {
        Guid guid = new Guid(this._guid_string);
        return guid;
    }

    public static void main(String[] stringArray) {
        int n = 1;
        if (stringArray.length >= 1) {
            n = Integer.parseInt(stringArray[0]);
        }
        int n2 = 0;
        while (n2 < n) {
            Guid guid = new Guid();
            System.out.println(guid);
            ++n2;
        }
    }

    static {
        block4: {
            try {
                if (System.getProperty("os.name", "DEFAULT").startsWith("Windows")) {
                    System.loadLibrary("oraldapjclnt9");
                    break block4;
                }
                System.loadLibrary("ldapjclnt9");
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                if (System.getProperty("os.name", "DEFAULT").startsWith("Windows")) {
                    System.out.println("Error loading native library:oraldapjclnt9.dll.");
                    break block4;
                }
                System.out.println("Error loading native library:libldapjclnt9.so.");
            }
        }
    }
}

