/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import javax.naming.CommunicationException;
import javax.naming.directory.DirContext;
import oracle.ldap.util.CommunicationErrorException;
import oracle.ldap.util.LDAPEntry;
import oracle.ldap.util.Property;
import oracle.ldap.util.PropertySet;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.Util;
import oracle.ldap.util.UtilException;

public abstract class LDAPGroup
extends LDAPEntry {
    protected LDAPGroup(DirContext dirContext, String string) {
        super(dirContext, string);
    }

    protected LDAPGroup(DirContext dirContext, String string, PropertySet propertySet) {
        super(dirContext, string, propertySet);
    }

    public String[] getAllUniquemembers(DirContext dirContext) throws UtilException {
        try {
            this.resolve(dirContext);
            String[] stringArray = new String[]{"uniquemember"};
            PropertySetCollection propertySetCollection = Util.getEntryDetails(dirContext, this.entryDN, "(objectclass=*)", 0, stringArray);
            String[] stringArray2 = null;
            PropertySet propertySet = propertySetCollection.getPropertySet(0);
            if (!propertySet.isEmpty()) {
                Property property = propertySet.getProperty(0);
                int n = property.size();
                stringArray2 = new String[n];
                int n2 = 0;
                while (n2 < n) {
                    stringArray2[n2] = (String)property.getValue(n2);
                    ++n2;
                }
            }
            return stringArray2;
        }
        catch (Exception exception) {
            if (exception instanceof CommunicationException) {
                throw new CommunicationErrorException(LDAPEntry.resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), exception);
            }
            throw new UtilException(LDAPEntry.resBundle.getString("GENERAL_ERROR_SEARCH"), exception);
        }
    }

    public boolean isUniquemember(DirContext dirContext, String string) throws UtilException {
        this.resolve(dirContext);
        return Util.ldapCompare(dirContext, this.entryDN, "uniquemember", string);
    }

    public void addUniquemember(DirContext dirContext, String string) throws UtilException {
        this.resolve(dirContext);
        Util.addUniquemember(dirContext, this.entryDN, string);
    }

    public void removeUniquemember(DirContext dirContext, String string) throws UtilException {
        this.resolve(dirContext);
        Util.removeUniquemember(dirContext, this.entryDN, string);
    }
}

