/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.util.StringTokenizer;
import java.util.Vector;

public class LDAPObjectClass {
    private String objClsValue = null;
    private String OID = null;
    private String NAME = null;
    private String DESC = null;
    private Vector SUPER = null;
    private Vector mandatoryAttrs = null;
    private Vector optionalAttrs = null;
    public final int TYPE_NONE = 0;
    public final int TYPE_STRUCTURAL = 1;
    public final int TYPE_ABSTRACT = 2;
    public final int TYPE_AUXILIARY = 3;
    private int TYPE = 0;

    public LDAPObjectClass(String string) {
        String[] stringArray;
        this.objClsValue = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(string.indexOf("(") + 1));
        this.OID = stringTokenizer.nextToken();
        StringTokenizer stringTokenizer2 = new StringTokenizer(string.substring(string.indexOf("NAME") + 4).trim(), "'");
        this.NAME = stringTokenizer2.nextToken();
        if (string.indexOf("DESC") > -1) {
            stringArray = new StringTokenizer(string.substring(string.indexOf("DESC") + 4).trim(), "'");
            this.DESC = stringArray.nextToken();
        }
        if (string.indexOf("AUXILIARY") > -1) {
            this.TYPE = 3;
        } else if (string.indexOf("ABSTRACT") > -1) {
            this.TYPE = 2;
        } else if (string.indexOf("STRUCTURAL") > -1) {
            this.TYPE = 1;
        }
        stringArray = new String[]{"SUP", "MUST", "MAY"};
        Vector[] vectorArray = new Vector[3];
        this.SUPER = new Vector();
        this.mandatoryAttrs = new Vector();
        this.optionalAttrs = new Vector();
        vectorArray[0] = this.SUPER;
        vectorArray[1] = this.mandatoryAttrs;
        vectorArray[2] = this.optionalAttrs;
        int n = 0;
        while (n < stringArray.length) {
            int n2 = string.indexOf(stringArray[n]);
            if (n2 > -1) {
                StringTokenizer stringTokenizer3 = new StringTokenizer(string.substring(n2 + stringArray[n].length(), string.length()));
                String string2 = stringTokenizer3.nextToken();
                if (string2.equals("(")) {
                    StringTokenizer stringTokenizer4 = new StringTokenizer(stringTokenizer3.nextToken(")"), "$");
                    while (stringTokenizer4.hasMoreTokens()) {
                        vectorArray[n].addElement(stringTokenizer4.nextToken().trim());
                    }
                } else {
                    vectorArray[n].addElement(string2.replace('\'', ' ').trim());
                }
            }
            ++n;
        }
    }

    public String getName() {
        return this.NAME;
    }

    public String getOID() {
        return this.OID;
    }

    public String getDESC() {
        return this.DESC;
    }

    public int getType() {
        return this.TYPE;
    }

    public String[] getSuperClass() {
        return this.SUPER.toArray(new String[0]);
    }

    public String[] getMandatoryAttributes() {
        return this.mandatoryAttrs.toArray(new String[0]);
    }

    public String[] getOptionalAttributes() {
        return this.optionalAttrs.toArray(new String[0]);
    }

    public String getObjectClassDef() {
        return this.objClsValue;
    }

    public static String getName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(string.indexOf("NAME") + 4).trim(), "'");
        return stringTokenizer.nextToken();
    }

    public static String getOID(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(string.indexOf("(") + 1));
        return stringTokenizer.nextToken();
    }
}

