/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Vector;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import oracle.ldap.util.DirEntryReconcile;
import oracle.ldap.util.InvalidParameterException;
import oracle.ldap.util.LDIFReader;
import oracle.ldap.util.LDIFRecord;
import oracle.ldap.util.LDIFSubstitute;
import oracle.ldap.util.LDIFWriter;
import oracle.ldap.util.LogException;
import oracle.ldap.util.Logger;
import oracle.ldap.util.MigrationException;
import oracle.ldap.util.ParameterException;
import oracle.ldap.util.Property;
import oracle.ldap.util.PropertySet;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.RootOracleContext;
import oracle.ldap.util.Subscriber;
import oracle.ldap.util.Util;
import oracle.ldap.util.UtilException;
import oracle.ldap.util.jndi.ConnectionUtil;
import oracle.ldap.util.nls.NlsMsg;
import oracle.ldap.util.param.CmdArgParser;
import oracle.ldap.util.param.FlagParameterDescriptor;
import oracle.ldap.util.param.Parameter;
import oracle.ldap.util.param.ParameterDescriptor;
import oracle.ldap.util.param.ParameterParser;

public class LDIFMigration {
    private static final String INPUT_FILE = "INPUT_FILE";
    private static final String OUTPUT_FILE = "OUTPUT_FILE";
    private static final String LOG_FILE = "LOG_FILE";
    private static final String HOST = "HOST";
    private static final String PORT = "PORT";
    private static final String DN = "DN";
    private static final String PASSWORD = "PASSWORD";
    private static final String SUBSCRIBER = "SUBSCRIBER";
    private static final String REALM = "REALM";
    private static final char PARAM_NAME_VALUE_DELIM = '=';
    private static final String DEL_OUTPUT_FILE_OPTION = "O";
    private static final String DIRECTORY_LOOKUP_OPTION = "LOOKUP";
    private static final String DIRECTORY_LOAD_OPTION = "LOAD";
    private static final String DIRECTORY_RECONCILE_OPTION = "RECONCILE";
    private static final String NOPROMPT = "NOPROMPT";
    private static final String VERBOSE = "V";
    private static String NEW_LINE = System.getProperty("line.separator");
    private LDIFReader m_ldifReader = null;
    private LDIFWriter m_ldifWriter = null;
    private Vector m_substitutionVector = null;
    private Logger m_logger = null;
    private String m_inputFileName = null;
    private String m_outputFileName = null;
    private String m_logFileName = null;
    private String m_hostName = null;
    private int m_port = 389;
    private String m_bindDn = null;
    private String m_password = null;
    private DirContext m_dirContext = null;
    private boolean m_doDelOutputFlag = false;
    private boolean m_doLookup = false;
    private boolean m_doLoad = false;
    private boolean m_doReconcile = false;
    private String m_reconcileValue = null;
    private boolean m_doVerbose = false;
    private boolean m_noPrompt = false;
    private static final String ROOT_ORACLE_CONTEST_DN = "cn=OracleContext";
    private int m_totalEntries = 0;
    private int m_failedEntries = 0;
    private String m_oHome = null;
    private String m_subscriberName = null;

    private LDIFMigration() throws MigrationException {
    }

    public LDIFMigration(String string, Vector vector, String string2) throws MigrationException {
        this(new File(string), vector, new File(string2));
    }

    public LDIFMigration(File file, Vector vector, File file2) throws MigrationException {
        this.doValidate(file, vector, file2);
        this.m_inputFileName = file.getAbsolutePath();
        this.m_outputFileName = file2.getAbsolutePath();
        try {
            this.m_ldifReader = new LDIFReader(file, "UTF-8");
        }
        catch (IOException iOException) {
            String string = iOException.getMessage();
            if (string == null || string.equals("")) {
                string = NlsMsg.getMessage("MIGRATION_ERROR");
            }
            throw new MigrationException(string);
        }
        try {
            this.m_ldifWriter = new LDIFWriter(file2);
        }
        catch (IOException iOException) {
            String string = iOException.getMessage();
            if (string == null || string.equals("")) {
                string = NlsMsg.getMessage("MIGRATION_ERROR");
            }
            throw new MigrationException(string);
        }
    }

    public LDIFMigration(InputStream inputStream, Vector vector, OutputStream outputStream) throws MigrationException {
        if (vector == null || vector.size() == 0) {
            String string = NlsMsg.getMessage("NO_SUBSTITUTION_VARIABLES");
            throw new MigrationException(string);
        }
        this.m_substitutionVector = vector;
        try {
            this.m_ldifReader = new LDIFReader(inputStream, "UTF-8");
            this.m_inputFileName = "<Input Stream Object> " + inputStream.toString();
        }
        catch (IOException iOException) {
            String string = iOException.getMessage();
            if (string == null || string.equals("")) {
                string = NlsMsg.getMessage("MIGRATION_ERROR");
            }
            throw new MigrationException(string);
        }
        try {
            this.m_ldifWriter = new LDIFWriter(outputStream);
            this.m_outputFileName = "<Output Stream Object> " + inputStream.toString();
        }
        catch (IOException iOException) {
            String string = iOException.getMessage();
            if (string == null || string.equals("")) {
                string = NlsMsg.getMessage("MIGRATION_ERROR");
            }
            throw new MigrationException(string);
        }
    }

    private void initializeLog() throws MigrationException {
        if (null == this.m_logFileName) {
            if (this.m_oHome == null) {
                throw new MigrationException(NlsMsg.getMessage("ORACLE_HOME_NOT_SET"));
            }
            this.m_logFileName = this.m_oHome + File.separator + "ldap" + File.separator + "install";
            Calendar calendar = Calendar.getInstance();
            int n = calendar.get(2) + 1;
            this.m_logFileName = this.m_logFileName + File.separator + "LDIFMig_" + calendar.get(1) + "_" + (calendar.get(2) + 1) + "_" + calendar.get(5) + "_" + calendar.get(11) + "_" + calendar.get(12) + "_" + calendar.get(13) + ".log";
        }
        try {
            this.m_logger = this.m_logFileName.toLowerCase().endsWith("xml") ? new Logger(this.m_logFileName, 15, false, true) : (this.m_logFileName.equals("-") ? new Logger(System.out, 15, false) : new Logger(this.m_logFileName, 15, false));
        }
        catch (LogException logException) {
            throw new MigrationException(logException.getMessage());
        }
    }

    void setDirContext(DirContext dirContext) {
        this.m_dirContext = dirContext;
    }

    void setUserDN(String string) {
        this.m_bindDn = string;
    }

    private String getAttrValue(Property property, String string) throws IOException {
        int n = property.size();
        int n2 = 1;
        Object var5_5 = null;
        if (!this.m_noPrompt && n != 1) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            System.out.println();
            System.out.println("The subscriber `" + (null == this.m_subscriberName ? "Default" : this.m_subscriberName) + "' contains multiple values for the attribute `" + string + "'");
            System.out.println();
            int n3 = 0;
            while (n3 < n) {
                System.out.println("   " + (n3 + 1) + ". " + property.getValue(n3));
                ++n3;
            }
            System.out.println();
            do {
                System.out.print("Please choose a value for substitution [1-" + n + "] ");
                try {
                    n2 = Integer.parseInt(bufferedReader.readLine());
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = 0;
                }
            } while (n2 <= 0 || n2 > n);
        }
        return (String)property.getValue(n2 - 1);
    }

    private void doValidate(File file, Vector vector, File file2) throws MigrationException {
        String string = null;
        if (!(vector != null && vector.size() != 0 || this.m_doLookup)) {
            string = NlsMsg.getMessage("NO_SUBSTITUTION_VARIABLES");
            throw new MigrationException(string);
        }
        this.m_substitutionVector = vector;
        if (file != null) {
            try {
                Util.validateFile(file, 21);
            }
            catch (InvalidParameterException invalidParameterException) {
                throw new MigrationException(invalidParameterException.getMessage());
            }
        }
        if (!this.m_doDelOutputFlag && file2 != null) {
            try {
                Util.validateFile(file2, 34);
            }
            catch (InvalidParameterException invalidParameterException) {
                throw new MigrationException(invalidParameterException.getMessage());
            }
        }
    }

    private Subscriber processCmdLineInput(String[] stringArray) throws MigrationException {
        Subscriber subscriber = null;
        RootOracleContext rootOracleContext = null;
        File file = null;
        File file2 = null;
        File file3 = null;
        Vector vector = null;
        Parameter parameter = null;
        boolean bl = false;
        String string = null;
        ParameterDescriptor[] parameterDescriptorArray = new ParameterDescriptor[]{new ParameterDescriptor(INPUT_FILE, false, null, null), new ParameterDescriptor(OUTPUT_FILE, false, null, null), new ParameterDescriptor(LOG_FILE, false, null, null), new FlagParameterDescriptor(DIRECTORY_LOOKUP_OPTION, false, null), new FlagParameterDescriptor(DIRECTORY_LOAD_OPTION, false, null), new FlagParameterDescriptor(DEL_OUTPUT_FILE_OPTION, false, null), new FlagParameterDescriptor(VERBOSE, false, null), new FlagParameterDescriptor(NOPROMPT, false, null), new FlagParameterDescriptor(DIRECTORY_RECONCILE_OPTION, true, new String[]{"SAFE", "SAFE_EXTENDED", "NORMAL"}), new ParameterDescriptor(HOST, false, null, "localHost"), new ParameterDescriptor(DN, false, null, null), new ParameterDescriptor(PASSWORD, false, null, null), new ParameterDescriptor(SUBSCRIBER, false, null, null), new ParameterDescriptor(REALM, false, null, null), new ParameterDescriptor(PORT, false, null, "389")};
        CmdArgParser cmdArgParser = new CmdArgParser(parameterDescriptorArray, stringArray);
        try {
            ((ParameterParser)cmdArgParser).parse();
            vector = cmdArgParser.getUnParsedParams();
        }
        catch (ParameterException parameterException) {
            string = NlsMsg.getMessage("ERROR_WHILE_PARSING_PARAMETER") + NEW_LINE + parameterException.getMessage();
            throw new MigrationException(string);
        }
        this.m_oHome = System.getProperty("ORACLE_HOME");
        parameter = cmdArgParser.get(INPUT_FILE);
        if (null == parameter) {
            string = NlsMsg.getMessage("INPUT_PARAMETER_NOT_SPECIFIED");
            throw new MigrationException(string);
        }
        this.m_inputFileName = parameter.getValue();
        parameter = cmdArgParser.get(OUTPUT_FILE);
        if (null == parameter) {
            string = NlsMsg.getMessage("OUTPUT_PARAMETER_NOT_SPECIFIED");
            throw new MigrationException(string);
        }
        this.m_outputFileName = parameter.getValue();
        parameter = cmdArgParser.get(LOG_FILE);
        if (null != parameter) {
            this.m_logFileName = parameter.getValue();
            file3 = new File(this.m_logFileName);
        }
        file = new File(this.m_inputFileName);
        file2 = new File(this.m_outputFileName);
        if (file3 != null && file3.equals(file2)) {
            throw new MigrationException(NlsMsg.getMessage("SAME_OUTPUT_AND_LOG_FILE"));
        }
        if (this.m_inputFileName.equals("-")) {
            file = null;
        } else if (file3 != null && file3.equals(file)) {
            throw new MigrationException(NlsMsg.getMessage("SAME_INPUT_AND_LOG_FILE"));
        }
        if (this.m_outputFileName.equals("-")) {
            file2 = null;
        }
        if (file2 != null && file2.equals(file)) {
            throw new MigrationException(NlsMsg.getMessage("SAME_INPUT_AND_OUTPUT_FILE"));
        }
        parameter = cmdArgParser.get(DEL_OUTPUT_FILE_OPTION);
        if (null != parameter) {
            this.m_doDelOutputFlag = true;
        }
        if (null != (parameter = cmdArgParser.get(VERBOSE))) {
            this.m_doVerbose = true;
        }
        if (null != (parameter = cmdArgParser.get(NOPROMPT))) {
            this.m_noPrompt = true;
        }
        if (null != (parameter = cmdArgParser.get(DIRECTORY_LOOKUP_OPTION))) {
            this.m_doLookup = true;
        }
        if (null != (parameter = cmdArgParser.get(DIRECTORY_LOAD_OPTION))) {
            this.m_doLoad = true;
        }
        if (null != (parameter = cmdArgParser.get(DIRECTORY_RECONCILE_OPTION))) {
            this.m_doReconcile = true;
            this.m_reconcileValue = parameter.getValue();
        }
        this.m_password = null;
        this.m_bindDn = null;
        this.m_hostName = null;
        this.m_subscriberName = null;
        parameter = cmdArgParser.get(HOST);
        this.m_hostName = parameter.getValue();
        parameter = cmdArgParser.get(PORT);
        try {
            this.m_port = Integer.parseInt(parameter.getValue());
            if (this.m_port < 1) {
                string = NlsMsg.getMessage("INVALID_PORT_NUMBER_SPECIFIED");
                throw new MigrationException(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            string = NlsMsg.getMessage("INVALID_PORT_NUMBER_SPECIFIED");
            throw new MigrationException(string);
        }
        parameter = cmdArgParser.get(DN);
        if (null == parameter) {
            if (this.m_doLookup || this.m_doLoad || this.m_doReconcile) {
                string = NlsMsg.getMessage("BIND_DN_PARAMETER_NOT_SPECIFIED");
                throw new MigrationException(string);
            }
        } else {
            this.m_bindDn = parameter.getValue();
        }
        this.m_password = null == (parameter = cmdArgParser.get(PASSWORD)) ? "" : parameter.getValue();
        parameter = cmdArgParser.get(SUBSCRIBER);
        if (null != parameter) {
            this.m_subscriberName = parameter.getValue();
        }
        if (null != (parameter = cmdArgParser.get(REALM))) {
            this.m_subscriberName = parameter.getValue();
        }
        this.doValidate(file, vector, file2);
        try {
            if (file != null) {
                this.m_ldifReader = new LDIFReader(file, "UTF-8");
                this.m_inputFileName = file.getAbsolutePath();
            } else {
                this.m_ldifReader = new LDIFReader(System.in, "UTF-8");
                this.m_inputFileName = "stdin";
            }
        }
        catch (IOException iOException) {
            string = iOException.getMessage();
            if (string == null || string.equals("")) {
                string = NlsMsg.getMessage("MIGRATION_ERROR");
            }
            throw new MigrationException(string);
        }
        try {
            if (file2 != null) {
                this.m_ldifWriter = new LDIFWriter(file2);
                this.m_outputFileName = file2.getAbsolutePath();
            } else {
                this.m_ldifWriter = new LDIFWriter(System.out);
                this.m_outputFileName = "stdout";
            }
        }
        catch (IOException iOException) {
            string = iOException.getMessage();
            if (string == null || string.equals("")) {
                string = NlsMsg.getMessage("MIGRATION_ERROR");
            }
            throw new MigrationException(string);
        }
        if (this.m_doLookup || this.m_doLoad || this.m_doReconcile) {
            String string2 = this.m_port + "";
            try {
                this.m_dirContext = ConnectionUtil.getDefaultDirCtx(this.m_hostName, string2, this.m_bindDn, this.m_password);
            }
            catch (NamingException namingException) {
                string = NlsMsg.getMessage("UNABLE_TO_CONNECT_TO_DIR") + NEW_LINE + namingException.getMessage();
                throw new MigrationException(string);
            }
            if (this.m_doLookup) {
                rootOracleContext = new RootOracleContext(this.m_dirContext, this.m_oHome);
                try {
                    subscriber = this.m_subscriberName == null ? rootOracleContext.getSubscriber(this.m_dirContext, Util.IDTYPE_DEFAULT, null, null) : rootOracleContext.getSubscriber(this.m_dirContext, Util.IDTYPE_SIMPLE, this.m_subscriberName, null);
                }
                catch (UtilException utilException) {
                    string = NlsMsg.getMessage("SUBSCRIBER_RETRIEVAL_ERROR") + NEW_LINE + utilException.getMessage();
                    throw new MigrationException(string);
                }
            }
        }
        this.initializeLog();
        return subscriber;
    }

    private ReconciledEntry reconcile(LDIFRecord lDIFRecord, String string) throws NamingException, MigrationException {
        String string2 = null;
        int n = 0;
        Attributes attributes = null;
        LDIFRecord lDIFRecord2 = null;
        LDIFRecord lDIFRecord3 = null;
        ReconciledEntry reconciledEntry = new ReconciledEntry();
        reconciledEntry.originalRecord = lDIFRecord;
        string2 = lDIFRecord.getDN();
        n = lDIFRecord.getChangeType();
        try {
            attributes = this.m_dirContext.getAttributes(string2, new String[]{"*", "orclguid"});
            lDIFRecord2 = Util.getLDIFRecord(string2, attributes);
            reconciledEntry.directoryRecord = lDIFRecord2;
            reconciledEntry.directoryRecordComment = "Entry present in the directory";
            reconciledEntry.reconciledRecordComment = "After reconciliation of the entry";
            if (string.equals("SAFE")) {
                if (n == 2) {
                    reconciledEntry.reconciledRecordComment = "In safe mode deletion of a record is not possible";
                    lDIFRecord3 = null;
                } else {
                    lDIFRecord3 = DirEntryReconcile.getLdifDiffForSafe(lDIFRecord, lDIFRecord2, false);
                }
            } else if (string.equals("SAFE_EXTENDED")) {
                if (n == 2) {
                    reconciledEntry.reconciledRecordComment = "In safe extended mode deletion of a record is not possible";
                    lDIFRecord3 = null;
                } else {
                    lDIFRecord3 = DirEntryReconcile.getLdifDiffForSafe(lDIFRecord, lDIFRecord2, true);
                }
            } else if (string.equals("NORMAL")) {
                lDIFRecord3 = DirEntryReconcile.getLdifDiffForNormal(lDIFRecord, lDIFRecord2);
            }
            if (null == lDIFRecord3 && n != 2) {
                reconciledEntry.reconciledRecordComment = "There is no change to apply to this entry ~ " + string2;
            }
        }
        catch (NameNotFoundException nameNotFoundException) {
            reconciledEntry.directoryRecordComment = "Entry not present in the directory ~ " + string2;
            if (n == 1) {
                lDIFRecord3 = lDIFRecord;
                reconciledEntry.reconciledRecordComment = "Entry will be added for the first time";
            }
            reconciledEntry.reconciledRecordComment = "Ignoring the change to the entry";
        }
        reconciledEntry.reconciledRecord = lDIFRecord3;
        return reconciledEntry;
    }

    public int migrate() throws MigrationException, IOException {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        String[] stringArray = new String[]{"jpegphoto", "usercertificate"};
        this.writeLog(NlsMsg.getMessage("MIGRATIONS_STARTS"), 1);
        this.writeLog(NlsMsg.getMessage(INPUT_FILE) + " : " + this.m_inputFileName, 1);
        this.writeLog(NlsMsg.getMessage(OUTPUT_FILE) + " : " + this.m_outputFileName, 1);
        stringBuffer.append(NlsMsg.getMessage("SUBSTITUTION_VARIABLES"));
        int n = 0;
        while (n < this.m_substitutionVector.size() - 1) {
            stringBuffer.append(NEW_LINE).append("    ").append(this.m_substitutionVector.elementAt(n)).append(" : ").append(this.m_substitutionVector.elementAt(n + 1));
            n += 2;
        }
        string = stringBuffer.toString();
        if (this.m_doVerbose) {
            System.out.println("input_file  : " + this.m_inputFileName);
            System.out.println("output_file : " + this.m_outputFileName);
            System.out.println(string);
        }
        this.writeLog(string, 1);
        stringBuffer = null;
        string = null;
        this.m_ldifReader.setBinaryAttributes(stringArray);
        while (true) {
            Object object;
            LDIFRecord lDIFRecord = null;
            lDIFRecord = this.m_ldifReader.nextRecord();
            if (lDIFRecord == null) break;
            ++this.m_totalEntries;
            lDIFRecord = LDIFSubstitute.substitute(lDIFRecord, this.m_substitutionVector);
            if (this.m_doReconcile) {
                object = null;
                String string2 = lDIFRecord.getDN();
                if (bl) {
                    this.m_ldifWriter.newLine();
                } else {
                    String string3 = this.m_ldifReader.getVersion();
                    if (null != string3) {
                        this.m_ldifWriter.writeAttribute("version", string3);
                    }
                }
                this.m_ldifWriter.writeComment("Before reconciliation of the entry");
                this.m_ldifWriter.writeEntryAsComment(lDIFRecord);
                bl = true;
                if (lDIFRecord.getChangeType() == 4) {
                    string = "The changetype:modrdn / changetype:moddn not supported ~ " + string2;
                    this.m_ldifWriter.newLine();
                    this.m_ldifWriter.writeComment(string);
                    this.writeLog(string, 2);
                    continue;
                }
                try {
                    object = this.reconcile(lDIFRecord, this.m_reconcileValue);
                }
                catch (NamingException namingException) {
                    string = namingException.getMessage();
                    this.writeLog(string, 8);
                    this.writeLog(namingException, 8);
                    throw new MigrationException(string);
                }
                this.m_ldifWriter.newLine();
                this.m_ldifWriter.writeComment(((ReconciledEntry)object).directoryRecordComment);
                this.writeLog(((ReconciledEntry)object).directoryRecordComment, 1);
                if (null != ((ReconciledEntry)object).directoryRecord) {
                    this.m_ldifWriter.writeEntryAsComment(((ReconciledEntry)object).directoryRecord);
                }
                this.m_ldifWriter.newLine();
                this.m_ldifWriter.writeComment(((ReconciledEntry)object).reconciledRecordComment);
                this.writeLog(((ReconciledEntry)object).reconciledRecordComment, 1);
                lDIFRecord = ((ReconciledEntry)object).reconciledRecord;
                if (null != ((ReconciledEntry)object).reconciledRecord) {
                    this.m_ldifWriter.writeEntry(((ReconciledEntry)object).reconciledRecord);
                }
            } else {
                if (bl) {
                    this.m_ldifWriter.newLine();
                } else {
                    object = this.m_ldifReader.getVersion();
                    if (null != object) {
                        this.m_ldifWriter.writeAttribute("version", (String)object);
                    }
                }
                this.m_ldifWriter.writeEntry(lDIFRecord);
                bl = true;
            }
            if (this.m_doLoad && lDIFRecord != null) {
                try {
                    Util.performLDAPOperation(this.m_dirContext, lDIFRecord);
                    this.writeLog("Applied change " + lDIFRecord.getDN(), 1);
                }
                catch (NamingException namingException) {
                    this.writeLog("Failed to apply change " + lDIFRecord.getDN() + " ~ " + namingException.getMessage(), 8);
                    ++this.m_failedEntries;
                }
            }
            if (!this.m_doVerbose) continue;
            System.out.print("# Processed Entries : " + this.m_totalEntries + " # Success : " + (this.m_totalEntries - this.m_failedEntries) + " # Failure : " + this.m_failedEntries + " \r");
        }
        if (this.m_doVerbose) {
            System.out.println();
        }
        if (this.m_failedEntries > 0) {
            this.writeLog(NlsMsg.getMessage("MIGRATION_FAILED"), 1);
        } else {
            this.writeLog(NlsMsg.getMessage("MIGRATION_COMPLETE"), 1);
        }
        return this.m_totalEntries - this.m_failedEntries;
    }

    public int migrate(Subscriber subscriber) throws MigrationException, IOException {
        Object object;
        String[] stringArray = new String[]{"orclCommonUserSearchBase", "orclCommonGroupSearchBase", "orclCommonNickNameAttribute", "orclCommonNamingAttribute"};
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        PropertySetCollection propertySetCollection = null;
        try {
            string = subscriber.getDN(this.m_dirContext);
            string6 = "cn=OracleContext," + string;
            propertySetCollection = subscriber.getExtendedProperties(this.m_dirContext, Subscriber.EXTPROPTYPE_COMMON, stringArray, null);
            if (!propertySetCollection.isEmpty()) {
                object = propertySetCollection.getPropertySet(0);
                Property property = ((PropertySet)object).getProperty(stringArray[0]);
                if (property != null) {
                    string2 = this.getAttrValue(property, stringArray[0]);
                }
                if ((property = ((PropertySet)object).getProperty(stringArray[1])) != null) {
                    string3 = this.getAttrValue(property, stringArray[1]);
                }
                if ((property = ((PropertySet)object).getProperty("orclCommonNickNameAttribute")) != null) {
                    string4 = (String)property.getValue(0);
                }
                if ((property = ((PropertySet)object).getProperty("orclCommonNamingAttribute")) != null) {
                    string5 = (String)property.getValue(0);
                }
            }
        }
        catch (UtilException utilException) {
            String string7 = utilException.getMessage();
            this.writeLog(string7, 8);
            this.writeLog(utilException, 8);
            throw new MigrationException(string7);
        }
        object = "";
        if (string == null) {
            object = (String)object + " s_SubscriberDN,";
        }
        if (string2 == null) {
            object = (String)object + "s_UserContainerDN,";
        }
        if (string3 == null) {
            object = (String)object + "s_GroupContainerDN,";
        }
        if (string4 == null) {
            object = (String)object + "s_UserNicknameAttribute,";
        }
        if (((String)object).length() > 0) {
            object = NlsMsg.getMessage("SUBSTITUTION_VARIALBE_NOT_FOUND") + " [" + ((String)object).substring(0, ((String)object).length() - 1) + " ]";
            this.writeLog((String)object, 1);
            throw new MigrationException((String)object);
        }
        if (!this.m_substitutionVector.contains("s_SubscriberDN")) {
            this.m_substitutionVector.addElement("s_SubscriberDN");
            this.m_substitutionVector.addElement(string);
        }
        if (!this.m_substitutionVector.contains("s_UserContainerDN")) {
            this.m_substitutionVector.addElement("s_UserContainerDN");
            this.m_substitutionVector.addElement(string2);
        }
        if (!this.m_substitutionVector.contains("s_GroupContainerDN")) {
            this.m_substitutionVector.addElement("s_GroupContainerDN");
            this.m_substitutionVector.addElement(string3);
        }
        if (!this.m_substitutionVector.contains("s_SubscriberOracleContextDN")) {
            this.m_substitutionVector.addElement("s_SubscriberOracleContextDN");
            this.m_substitutionVector.addElement(string6);
        }
        if (!this.m_substitutionVector.contains("s_UserNicknameAttribute")) {
            this.m_substitutionVector.addElement("s_UserNicknameAttribute");
            this.m_substitutionVector.addElement(string4);
        }
        if (!this.m_substitutionVector.contains("s_UserNamingAttribute") && null != string5) {
            this.m_substitutionVector.addElement("s_UserNamingAttribute");
            this.m_substitutionVector.addElement(string5);
        }
        if (!this.m_substitutionVector.contains("s_RootOracleContextDN")) {
            this.m_substitutionVector.addElement("s_RootOracleContextDN");
            this.m_substitutionVector.addElement(ROOT_ORACLE_CONTEST_DN);
        }
        if (!this.m_substitutionVector.contains("s_CurrentUserDN")) {
            this.m_substitutionVector.addElement("s_CurrentUserDN");
            this.m_substitutionVector.addElement(this.m_bindDn);
        }
        return this.migrate();
    }

    public void cleanup() throws MigrationException {
        try {
            File file;
            if (this.m_ldifWriter != null) {
                this.m_ldifWriter.close();
                this.m_ldifWriter = null;
            }
            if (this.m_ldifReader != null) {
                this.m_ldifReader.close();
                this.m_ldifReader = null;
            }
            if (this.m_logger != null) {
                this.m_logger.close();
                this.m_logger = null;
            }
            if (this.m_outputFileName != null && (file = new File(this.m_outputFileName)).exists() && file.length() == 0L) {
                file.delete();
            }
        }
        catch (IOException iOException) {
            throw new MigrationException(iOException.getMessage());
        }
    }

    private void writeLog(String string, int n) {
        if (string != null && this.m_logger != null) {
            this.m_logger.log(string, n);
        }
    }

    private void writeLog(Exception exception, int n) {
        if (exception != null && this.m_logger != null) {
            this.m_logger.log(exception, n);
        }
    }

    private static void usage() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append(string).append("usage: ldifmigrator ").append("[options]").append(" {ParameterName=Value ....}").append(" {s_SubVar=val ... }").append(string).append("where:").append(string).append("   Required parameters :").append(string).append("      input_file=<inputfile>").append(string).append("      output_file=<outputfile>").append(string).append("   Optional parameters :").append(string).append("      host=<hostName> [localhost]").append(string).append("      port=<portNumber> [389]").append(string).append("      dn=<bindDn> Required when -lookup ").append("or -load or -reconcile is specifed").append(string).append("      password=<password of the bindDn>").append(string).append("      subscriber/realm=<subscriberName> if not specified").append(" default subscriber/realm is assumed").append(string).append(string).append("options:").append(string).append("      -lookup    lookup the directory for the standard ").append("list of substitution variables").append(string).append("      -load      load the entries to the directory").append(string).append("      -reconcile {SAFE | SAFE_EXTENDED | NORMAL} reconcile ").append("with the entry in the directory").append(string).append("      -noprompt  Do not prompt when the attribute contains ").append("multiple values").append(string).append("      -help      prints this message").append(string).append(string).append("Example:").append(string).append("   ldifmigrator input_file=PortalUser.dat ").append("output_file=PortalUser.ldif \\").append(string).append("   -lookup dn=\"cn=orcladmin\" password=welcome ").append("s_subscriberDomain=\"dc=oracle,dc=com\"").append(string).append(string).append("   ldifmigrator input_file=PortalUser.dat ").append("output_file= - log_file=PortalUser.log \\").append(string).append("   -lookup dn=\"cn=orcladmin\" password=welcome -reconcile ").append("SAFE \\").append(string).append("   s_subscriberDomain=\"dc=oracle,dc=com\"").append(string).append(string).append("   ldifmigrator input_file= - output_file=PortUser.ldif").append("log_file=PortalUser.log\\").append(string).append("   -lookup -load dn=\"cn=orcladmin\" password=welcome ").append("-reconcile NORMAL \\").append(string).append("   s_subscriberDomain=\"dc=oracle,dc=com\"");
        System.out.println(stringBuffer.toString());
    }

    public static void main(String[] stringArray) {
        LDIFMigration lDIFMigration = null;
        Subscriber subscriber = null;
        if (0 == stringArray.length) {
            System.out.println(NlsMsg.getMessage("NOT_ALL_PARAMETERS_ARE_PROVIDED"));
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equalsIgnoreCase("-help") || stringArray[n].equals("?") || stringArray[n].equalsIgnoreCase("help") || stringArray[n].equalsIgnoreCase("-h")) {
                LDIFMigration.usage();
                return;
            }
            ++n;
        }
        try {
            lDIFMigration = new LDIFMigration();
            subscriber = lDIFMigration.processCmdLineInput(stringArray);
        }
        catch (MigrationException migrationException) {
            System.out.println(migrationException.getMessage());
            try {
                if (lDIFMigration != null) {
                    lDIFMigration.cleanup();
                }
            }
            catch (MigrationException migrationException2) {
                System.out.println(migrationException2.getMessage());
                System.exit(1);
            }
            System.exit(1);
        }
        try {
            if (subscriber != null) {
                lDIFMigration.migrate(subscriber);
            } else {
                lDIFMigration.migrate();
            }
            if (lDIFMigration.m_failedEntries > 0) {
                System.out.println(NlsMsg.getMessage("MIGRATION_FAILED"));
            } else {
                System.out.println(NlsMsg.getMessage("MIGRATION_COMPLETE"));
            }
        }
        catch (MigrationException migrationException) {
            System.out.println(NlsMsg.getMessage("MIGRATION_ERROR"));
            System.out.println(migrationException.getMessage());
            try {
                lDIFMigration.cleanup();
            }
            catch (MigrationException migrationException3) {
                System.out.println(migrationException3.getMessage());
                System.exit(1);
            }
            System.exit(1);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            lDIFMigration.cleanup();
        }
        catch (MigrationException migrationException) {
            System.out.println(migrationException.getMessage());
            System.exit(1);
        }
    }

    private class ReconciledEntry {
        private LDIFRecord originalRecord = null;
        private String directoryRecordComment = null;
        private LDIFRecord directoryRecord = null;
        private String reconciledRecordComment = null;
        private LDIFRecord reconciledRecord = null;

        private ReconciledEntry() {
        }
    }
}

