/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.util.Vector;
import oracle.ldap.util.Base64;
import oracle.ldap.util.LDIFAttribute;
import oracle.ldap.util.LDIFRecord;
import oracle.ldap.util.OrclGuid;

public class LDIFSubstitute {
    private static final char ESCAPE_CHAR = '\\';

    private static String substitute(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string == null || string2 == null || string3 == null) {
            stringBuffer = null;
        } else {
            string2 = "%" + string2 + "%";
            int n = string2.length();
            int n2 = 0;
            int n3 = string.indexOf(string2, n2);
            while (n3 != -1) {
                if (n3 != 0 && string.charAt(n3 - 1) == '\\') {
                    stringBuffer.append(string.substring(n2, n3 - 1)).append(string.substring(n3, n3 + n));
                    n2 = n3 + n;
                    n3 = string.indexOf(string2, n2);
                    continue;
                }
                stringBuffer.append(string.substring(n2, n3)).append(string3);
                n2 = n3 + n;
                n3 = string.indexOf(string2, n2);
            }
            stringBuffer.append(string.substring(n2));
        }
        if (stringBuffer == null) {
            return null;
        }
        return stringBuffer.toString();
    }

    private static String substitute(String string, Vector vector) {
        return LDIFSubstitute.substitute(string, vector, false);
    }

    private static String substitute(String string, Vector vector, boolean bl) {
        String string2 = string;
        if (string != null && vector != null) {
            int n = 0;
            if (bl) {
                String string3 = "%s_orclguid";
                int n2 = string3.length();
                int n3 = 0;
                int n4 = string.indexOf(string3);
                while (n4 != -1) {
                    String string4 = null;
                    n3 = string.indexOf("%", n4 + n2);
                    if (n3 == -1) break;
                    string4 = string.substring(n4 + 1, n3);
                    if (!vector.contains(string4)) {
                        vector.add(string4);
                        vector.add(OrclGuid.newInstance().toString());
                    }
                    n4 = string.indexOf(string3, n3);
                }
            }
            n = vector.size();
            int n5 = 0;
            while (n5 < n - 1) {
                String string5 = (String)vector.elementAt(n5);
                String string6 = (String)vector.elementAt(n5 + 1);
                string2 = LDIFSubstitute.substitute(string2, string5, string6);
                n5 += 2;
            }
        }
        return string2;
    }

    public static Vector substitute(Vector vector, Vector vector2) {
        Vector<String> vector3;
        int n = 0;
        int n2 = 0;
        if (vector == null || (n = vector.size()) == 0) {
            vector3 = null;
        } else if (vector2 == null || (n2 = vector2.size()) == 0) {
            vector3 = vector;
        } else {
            vector3 = new Vector<String>();
            int n3 = 0;
            while (n3 < n) {
                boolean bl = false;
                String string = (String)vector.elementAt(n3);
                int n4 = string.indexOf("::");
                if (n4 != -1) {
                    string = string.substring(0, n4 + 2) + new String(Base64.decode(string.substring(n4 + 2).getBytes()));
                    bl = true;
                }
                String string2 = string;
                int n5 = 0;
                while (n5 < n2 - 1) {
                    String string3 = (String)vector2.elementAt(n5);
                    String string4 = (String)vector2.elementAt(n5 + 1);
                    string2 = LDIFSubstitute.substitute(string2, string3, string4);
                    n5 += 2;
                }
                if (string2 != null) {
                    if (bl) {
                        string2 = string2.substring(0, n4 + 2) + new String(Base64.encode(string2.substring(n4 + 2).getBytes()));
                    }
                    vector3.addElement(string2);
                }
                ++n3;
            }
        }
        return vector3;
    }

    public static LDIFRecord substitute(LDIFRecord lDIFRecord, Vector vector) {
        LDIFRecord lDIFRecord2 = null;
        int n = 0;
        int n2 = 0;
        if (lDIFRecord == null) {
            lDIFRecord2 = null;
        } else if (vector == null || (n2 = vector.size()) == 0) {
            lDIFRecord2 = lDIFRecord;
        } else {
            String string = lDIFRecord.getNewRdn();
            String string2 = lDIFRecord.getNewSuperior();
            String string3 = LDIFSubstitute.substitute(lDIFRecord.getDN(), vector, true);
            n = lDIFRecord.size();
            lDIFRecord2 = new LDIFRecord(string3);
            lDIFRecord2.setChangeType(lDIFRecord.getChangeType());
            lDIFRecord2.setExpChgType(lDIFRecord.getExpChgType());
            if (null != string) {
                string = LDIFSubstitute.substitute(string, vector, true);
                if (null != string2) {
                    string2 = LDIFSubstitute.substitute(string2, vector, true);
                }
                lDIFRecord2.setNewRdn(string, lDIFRecord.getDeleteOldRdn(), string2);
            }
            int n3 = 0;
            while (n3 < n) {
                int n4;
                Object object;
                LDIFAttribute lDIFAttribute = lDIFRecord.getAttribute(n3);
                String string4 = LDIFSubstitute.substitute(lDIFAttribute.getName(), vector, true);
                boolean bl = lDIFAttribute.isBinary();
                LDIFAttribute lDIFAttribute2 = new LDIFAttribute(string4, bl);
                lDIFAttribute2.setChangeType(lDIFAttribute.getChangeType());
                if (bl) {
                    object = lDIFAttribute.getByteValueArray();
                    if (object != null) {
                        n4 = 0;
                        while (n4 < ((byte[][])object).length) {
                            lDIFAttribute2.addValue(object[n4]);
                            ++n4;
                        }
                    }
                } else {
                    object = lDIFAttribute.getStringValueArray();
                    if (object != null) {
                        n4 = 0;
                        while (n4 < ((byte[][])object).length) {
                            object[n4] = (byte[])LDIFSubstitute.substitute((String)object[n4], vector, true);
                            ++n4;
                        }
                        lDIFAttribute2.setValues((String[])object);
                    }
                }
                lDIFRecord2.addAttribute(lDIFAttribute2);
                ++n3;
            }
        }
        return lDIFRecord2;
    }

    public static void main(String[] stringArray) {
        String string = "s_var";
        String string2 = "%s_var%,dn: cn=Heman,%s_var%s_var%,dc=ORACLE,dc_COM%s_var%%s_var%";
        String string3 = "dc=IDC";
        System.out.println(string2);
        System.out.println(LDIFSubstitute.substitute(string2, string, string3));
    }
}

