/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.io.PrintStream;
import javax.naming.CommunicationException;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import oracle.ldap.util.CommunicationErrorException;
import oracle.ldap.util.LDAPEntry;
import oracle.ldap.util.OracleContext;
import oracle.ldap.util.PropertySet;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.Subscriber;
import oracle.ldap.util.SubscriberCreator;
import oracle.ldap.util.Util;
import oracle.ldap.util.UtilException;

public final class RootOracleContext
extends OracleContext {
    public static final String rootOracleContextDN = "cn=OracleContext";
    private PropertySetCollection subSchemaSubEntryPsc = null;
    protected String orclCtxFilePrefix = "oidRootContext";
    protected String[] resolveAttrs = new String[]{"orclversion", "orclDefaultSubscriber", "orclSubscriberNickNameAttribute", "orclSubscriberSearchBase"};
    private String subSearchBase = null;

    public RootOracleContext(DirContext dirContext, String string) {
        this(dirContext, string, System.out);
    }

    public RootOracleContext(DirContext dirContext, String string, PrintStream printStream) {
        super(dirContext, string, rootOracleContextDN, printStream);
        ((OracleContext)this).orclCtxFilePrefix = "oidRootContext";
        ((OracleContext)this).resolveAttrs = new String[4];
        ((OracleContext)this).resolveAttrs[0] = "orclversion";
        ((OracleContext)this).resolveAttrs[1] = "orclDefaultSubscriber";
        ((OracleContext)this).resolveAttrs[2] = "orclSubscriberNickNameAttribute";
        ((OracleContext)this).resolveAttrs[3] = "orclSubscriberSearchBase";
    }

    public RootOracleContext(DirContext dirContext) {
        super(dirContext, rootOracleContextDN);
        ((OracleContext)this).orclCtxFilePrefix = "oidRootContext";
        ((OracleContext)this).resolveAttrs = new String[4];
        ((OracleContext)this).resolveAttrs[0] = "orclversion";
        ((OracleContext)this).resolveAttrs[1] = "orclDefaultSubscriber";
        ((OracleContext)this).resolveAttrs[2] = "orclSubscriberNickNameAttribute";
        ((OracleContext)this).resolveAttrs[3] = "orclSubscriberSearchBase";
    }

    public Subscriber[] getAllSubscribers(DirContext dirContext, String string, String[] stringArray) throws UtilException {
        this.resolve(dirContext);
        try {
            String[] stringArray2;
            PropertySetCollection propertySetCollection;
            if (string == null) {
                string = new String("(objectclass=orclSubscriber)");
            }
            this.subSearchBase = (propertySetCollection = this.getCommonProperties(dirContext, stringArray2 = new String[]{"orclsubscribersearchbase"})).getPropertySet(0).isEmpty() ? "" : (String)propertySetCollection.getPropertySet(0).getProperty(0).getValue(0);
            propertySetCollection = Util.getEntryDetails(dirContext, this.subSearchBase, "(&(objectclass=orclSubscriber)(" + string + "))", 2, stringArray);
            int n = propertySetCollection.size();
            Subscriber[] subscriberArray = new Subscriber[n];
            int n2 = 0;
            while (n2 < n) {
                PropertySet propertySet = propertySetCollection.getPropertySet(n2);
                subscriberArray[n2] = new Subscriber(dirContext, propertySet.getDN(), propertySet);
                ++n2;
            }
            return subscriberArray;
        }
        catch (NamingException namingException) {
            if (namingException instanceof CommunicationException) {
                throw new CommunicationErrorException(LDAPEntry.resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), namingException);
            }
            throw new UtilException("Cannot return all Subscribers", namingException);
        }
    }

    public Subscriber[] getAllSubscribers(DirContext dirContext, String[] stringArray) throws UtilException {
        return this.getAllSubscribers(dirContext, "(objectclass=orclSubscriber)", stringArray);
    }

    public Subscriber createDefaultSubscriber(DirContext dirContext, String string, boolean bl) throws UtilException {
        SubscriberCreator subscriberCreator = new SubscriberCreator(dirContext, this.ohome, string, this.pStream);
        subscriberCreator.createDefault(bl);
        return this.getSubscriber(dirContext, Util.IDTYPE_DEFAULT, null, new String[0]);
    }

    public Subscriber createSubscriber(DirContext dirContext, String string, boolean bl) throws UtilException {
        this.resolve(dirContext);
        String[] stringArray = new String[]{"orclSubscriberSearchBase", "orclSubscriberNickNameAttribute"};
        PropertySetCollection propertySetCollection = this.getCommonProperties(dirContext, stringArray);
        String string2 = null;
        string2 = propertySetCollection.getPropertySet(0).isEmpty() ? "" : (String)propertySetCollection.getPropertySet(0).getProperty(0).getValue(0);
        String string3 = (String)propertySetCollection.getPropertySet(0).getProperty("orclSubscriberNickNameAttribute").getValue(0);
        SubscriberCreator subscriberCreator = new SubscriberCreator(dirContext, this.ohome, string, string2, string3, this.pStream);
        subscriberCreator.create(bl);
        return this.getSubscriber(dirContext, Util.IDTYPE_SIMPLE, string, new String[0]);
    }

    public Subscriber getSubscriber(DirContext dirContext, int n, String string, String[] stringArray) throws UtilException {
        this.resolve(dirContext);
        Subscriber subscriber = new Subscriber(dirContext, n, string, this.ohome, this.commonPsc, stringArray);
        return subscriber;
    }

    public void create(DirContext dirContext) throws UtilException {
        try {
            super.create(dirContext);
            String string = this.ohome + this.fileSeparator + "ldap" + this.fileSeparator + "schema" + this.fileSeparator + "oid" + this.fileSeparator + "oidRootACISetup.sbs";
            Util.ldapModify(dirContext, string, null, true, this.pStream);
        }
        catch (Exception exception) {
            if (exception instanceof CommunicationException) {
                throw new CommunicationErrorException(LDAPEntry.resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), exception);
            }
            throw new UtilException(LDAPEntry.resBundle.getString("INVALID_ROOT_CTX"), exception);
        }
    }
}

