/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.CommunicationException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import oracle.ldap.util.CommunicationErrorException;
import oracle.ldap.util.GeneralErrorException;
import oracle.ldap.util.Group;
import oracle.ldap.util.InvalidParameterException;
import oracle.ldap.util.InvalidRootOrclctxException;
import oracle.ldap.util.LDAPObjectClass;
import oracle.ldap.util.LDIFAttribute;
import oracle.ldap.util.LDIFLoader;
import oracle.ldap.util.LDIFReader;
import oracle.ldap.util.LDIFRecord;
import oracle.ldap.util.LDIFSubstitute;
import oracle.ldap.util.LDIFWriter;
import oracle.ldap.util.ModPropertySet;
import oracle.ldap.util.NoGroupMembersException;
import oracle.ldap.util.OUILdap;
import oracle.ldap.util.Property;
import oracle.ldap.util.PropertySet;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.SetPropertiesException;
import oracle.ldap.util.Subscriber;
import oracle.ldap.util.User;
import oracle.ldap.util.UtilException;
import oracle.ldap.util.nls.NlsMsg;

public class Util {
    private static ResourceBundle resBundle = null;
    public static String API_VERSION;
    public static String INTERFACE_VERSION;
    private static String[] SUPPORTED_VERSION;
    public static int PWD_VERIFIERTYPE_COMMON;
    public static int IDTYPE_DN;
    public static int IDTYPE_SIMPLE;
    public static int IDTYPE_GUID;
    public static int IDTYPE_DEFAULT;
    public static int IDTYPE_FILTER;
    public static int IDTYPE_WINDOWS;
    public static int IDTYPE_KERB_PRINCIPAL;
    public static int PROPERTIES_ENTRY;
    public static int PROPERTIES_DETACHED;
    public static int CREDTYPE_PASSWD;
    public static String DASURL_BASE;
    public static String DASURL_CREATE_USER;
    public static String DASURL_EDIT_GROUP;
    public static String DASURL_EDIT_GROUP_GIVEN_GUID;
    public static String DASURL_GROUP_SEARCH;
    public static String DASURL_EDIT_USER;
    public static String DASURL_GROUP_LOV;
    public static String DASURL_DELETE_USER;
    public static String DASURL_USER_PRIVILEGE;
    public static String DASURL_CREATE_GROUP;
    public static String DASURL_USER_SEARCH;
    public static String DASURL_ACCOUNT_INFO;
    public static String DASURL_EDIT_USER_GIVEN_GUID;
    public static String DASURL_DELETE_USER_GIVEN_GUID;
    public static String DASURL_DELETE_GROUP_GIVEN_GUID;
    public static String DASURL_GROUP_PRIVILEGE;
    public static String DASURL_USER_PRIVILEGE_GIVEN_GUID;
    public static String DASURL_PASSWORD_CHANGE;
    public static String DASURL_USER_LOV;
    public static String DASURL_GROUP_PRIVILEGE_GIVEN_GUID;
    public static String DASURL_DELETE_GROUP;
    public static String DASURL_CREATE_RESOURCE;
    public static String DASURL_EUS_CONSOLE;
    public static String DASURL_DELEGATION_CONSOLE;
    public static String DASURL_EDIT_MY_PROFILE;
    public static final int FILE_EXISTENCE = 1;
    public static final int FILE_NOT_EXISTENCE = 2;
    public static final int FILE_READABLE = 4;
    public static final int FILE_WRITABLE = 8;
    public static final int FILE_NOT_EMPTY = 16;
    public static final int FILE_CREATEABLE = 32;
    private static String[] DASurlDNs;
    private static String rootOracleContextDN;
    private static String commonDN;
    private static String DASbaseDN;

    static void addEntry(DirContext dirContext, String string, String[] stringArray, Object[][] objectArray) throws NamingException {
        Object object;
        if (stringArray.length != objectArray.length) {
            System.out.println("Attribute list size and attribute values don't match in sizes");
        }
        BasicAttributes basicAttributes = new BasicAttributes(true);
        int n = 0;
        while (n < stringArray.length) {
            object = new BasicAttribute(stringArray[n]);
            int n2 = 0;
            while (n2 < objectArray[n].length) {
                object.add(objectArray[n][n2]);
                ++n2;
            }
            basicAttributes.put((Attribute)object);
            ++n;
        }
        object = dirContext.createSubcontext(string, (Attributes)basicAttributes);
    }

    static void addEntry(DirContext dirContext, String string, Attributes attributes) throws NamingException {
        DirContext dirContext2 = dirContext.createSubcontext(string, attributes);
    }

    public static PropertySetCollection getEntryDetails(DirContext dirContext, String string, String string2, int n, String[] stringArray) throws NamingException {
        return (PropertySetCollection)Util.getEntryDetails(dirContext, string, string2, n, stringArray, true);
    }

    public static Object getEntryDetails(DirContext dirContext, String string, String string2, int n, String[] stringArray, boolean bl) throws NamingException {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(n);
        if (n == 0 && stringArray != null && stringArray.length == 0) {
            searchControls.setReturningAttributes(new String[]{"dn"});
        } else {
            searchControls.setReturningAttributes(stringArray);
        }
        NamingEnumeration namingEnumeration = (NamingEnumeration)Util.getEntryDetails(dirContext, string, string2, searchControls);
        if (bl) {
            return new PropertySetCollection(string, namingEnumeration);
        }
        return namingEnumeration;
    }

    public static Object getEntryDetails(DirContext dirContext, String string, String string2, SearchControls searchControls) throws NamingException {
        NamingEnumeration<SearchResult> namingEnumeration = dirContext.search(string, string2, searchControls);
        return namingEnumeration;
    }

    public static void setEntryDetails(DirContext dirContext, String string, ModificationItem[] modificationItemArray) throws UtilException {
        try {
            dirContext.modifyAttributes(string, modificationItemArray);
        }
        catch (NamingException namingException) {
            if (namingException instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), namingException);
            }
            throw new SetPropertiesException(namingException.toString(), namingException);
        }
    }

    public static void setEntryDetails(DirContext dirContext, String string, ModPropertySet modPropertySet) throws UtilException {
        Util.ldapModify(dirContext, string, modPropertySet);
    }

    public static void authenticateUser(DirContext dirContext, User user, int n, Object object) throws UtilException {
        user.authenticateUser(dirContext, n, object);
    }

    public static String getSubscriberDn(DirContext dirContext, String string, int n) throws UtilException {
        Subscriber subscriber = new Subscriber(dirContext, n, string, true);
        return subscriber.getDN(dirContext);
    }

    public static String getUserDn(DirContext dirContext, String string, int n, String string2) throws UtilException {
        User user = new User(dirContext, n, string, IDTYPE_DN, string2, true);
        return user.getDN(dirContext);
    }

    public static PropertySetCollection getOwnership(DirContext dirContext, User user, String[] stringArray, boolean bl) throws UtilException {
        return Util.getOwnership(dirContext, user.getDn(dirContext), stringArray, bl);
    }

    public static PropertySetCollection getOwnership(DirContext dirContext, String string, String[] stringArray, boolean bl) throws UtilException {
        PropertySetCollection propertySetCollection = null;
        propertySetCollection = bl ? Util.getGroups(dirContext, string, stringArray, "owner") : Util.getDirectGroupMembership(dirContext, string, stringArray, "owner");
        return propertySetCollection;
    }

    public static PropertySetCollection getGroupMembership(DirContext dirContext, User user, String[] stringArray, boolean bl) throws UtilException {
        return Util.getGroupMembership(dirContext, user.getDN(dirContext), stringArray, bl, "uniquemember");
    }

    public static PropertySetCollection getGroupMembership(DirContext dirContext, String string, String[] stringArray, boolean bl, String string2) throws UtilException {
        PropertySetCollection propertySetCollection = null;
        propertySetCollection = bl ? Util.getGroups(dirContext, string, stringArray, string2) : Util.getDirectGroupMembership(dirContext, string, stringArray, string2);
        return propertySetCollection;
    }

    private static PropertySetCollection getDirectGroupMembership(DirContext dirContext, String string, String[] stringArray, String string2) throws UtilException {
        try {
            return Util.getDirectGroupMembershipVector(dirContext, string, stringArray, string2);
        }
        catch (UtilException utilException) {
            if (utilException instanceof CommunicationErrorException) {
                throw utilException;
            }
            throw new NoGroupMembersException();
        }
    }

    private static PropertySetCollection getDirectGroupMembershipVector(DirContext dirContext, String string, String[] stringArray, String string2) throws UtilException {
        try {
            return Util.getEntryDetails(dirContext, "", "(" + string2 + "=" + string + ")", 2, stringArray);
        }
        catch (NamingException namingException) {
            if (namingException instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), namingException);
            }
            return new PropertySetCollection();
        }
    }

    private static PropertySetCollection getGroups(DirContext dirContext, String string, String[] stringArray, String string2) throws UtilException {
        String[] stringArray2 = null;
        if (stringArray != null) {
            stringArray2 = new String[stringArray.length + 1];
            int n = 0;
            while (n < stringArray.length) {
                stringArray2[n] = stringArray[n];
                ++n;
            }
            stringArray2[stringArray.length] = "orclguid";
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        searchControls.setReturningAttributes(stringArray2);
        Hashtable hashtable = new Hashtable(100);
        Util.getNestedGroups(dirContext, string, string2, searchControls, hashtable);
        return Util.convert2Collection(hashtable, stringArray);
    }

    private static PropertySetCollection convert2Collection(Hashtable hashtable, String[] stringArray) {
        PropertySetCollection propertySetCollection = new PropertySetCollection(hashtable.size());
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            PropertySet propertySet;
            SearchResult searchResult = (SearchResult)enumeration.nextElement();
            if (stringArray == null) {
                propertySet = new PropertySet("", searchResult);
                propertySetCollection.add(propertySet);
                continue;
            }
            propertySet = new PropertySet(searchResult.getName(), searchResult.getAttributes(), null);
            propertySetCollection.add(propertySet.returnPropertySet(stringArray));
        }
        return propertySetCollection;
    }

    protected static void grpErrHandler(NamingException namingException, UtilException utilException) throws UtilException {
        int n = utilException.getLDAPErrorCode();
        switch (n) {
            case 51: 
            case 52: 
            case 53: 
            case 81: 
            case 88: {
                throw new NoGroupMembersException(utilException.toString());
            }
        }
        if (namingException instanceof CommunicationException) {
            throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), namingException);
        }
    }

    private static void getNestedGroups(DirContext dirContext, String string, String string2, SearchControls searchControls, Hashtable hashtable) throws UtilException {
        try {
            NamingEnumeration<SearchResult> namingEnumeration = dirContext.search("", "(" + string2 + "=" + string + ")", searchControls);
            while (namingEnumeration.hasMore()) {
                SearchResult searchResult = namingEnumeration.next();
                String string3 = null;
                try {
                    string3 = (String)searchResult.getAttributes().get("orclguid").get(0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (string3 != null && !hashtable.containsKey(string3)) {
                    hashtable.put(string3, searchResult);
                    Util.getNestedGroups(dirContext, searchResult.getName(), string2, searchControls, hashtable);
                    continue;
                }
                if (string3 != null || Util.isDNInCurrList(hashtable, searchResult.getName())) continue;
                hashtable.put(searchResult.getName(), searchResult);
                Util.getNestedGroups(dirContext, searchResult.getName(), string2, searchControls, hashtable);
            }
        }
        catch (NamingException namingException) {
            Util.grpErrHandler(namingException, new UtilException("getGroupMembership", namingException));
        }
    }

    private static boolean isDNInCurrList(Hashtable hashtable, String string) {
        string = Util.normalizeDN(string);
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            SearchResult searchResult = (SearchResult)enumeration.nextElement();
            String string2 = Util.normalizeDN(searchResult.getName());
            if (!string2.equals(Util.normalizeDN(string))) continue;
            return true;
        }
        return false;
    }

    protected static String[] vector2StrArray(Vector vector) {
        if (vector.size() > 0) {
            String[] stringArray = new String[vector.size()];
            int n = 0;
            while (n < vector.size()) {
                stringArray[n] = (String)vector.elementAt(n);
                ++n;
            }
            return stringArray;
        }
        return null;
    }

    public static String normalizeDN(String string, String[] stringArray) {
        try {
            return Util.normalizeDN(string, 0, stringArray, null);
        }
        catch (UtilException utilException) {
            return null;
        }
    }

    private static String normalizeDN(String string, int n, String[] stringArray, DirContext dirContext) throws UtilException {
        Object object;
        int n2;
        String string2;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        int n3 = n;
        String string3 = "";
        String string4 = string;
        Vector<Object> vector = null;
        Vector<String> vector2 = null;
        if (n3 == 3) {
            vector = new Vector<Object>();
            vector2 = new Vector<String>();
        }
        while (string4.length() > 0) {
            string2 = null;
            if (bl) {
                n2 = string4.indexOf("=");
                if (n2 <= 0) {
                    string3 = null;
                    break;
                }
                object = string4.substring(0, n2).trim().toLowerCase();
                if (n3 == 3) {
                    vector.addElement(object);
                }
                if (stringArray != null) {
                    boolean bl7 = true;
                    int n4 = 0;
                    while (n4 < stringArray.length) {
                        if (((String)object).equalsIgnoreCase(stringArray[n4])) {
                            bl7 = false;
                            break;
                        }
                        ++n4;
                    }
                    if (bl7) {
                        string3 = null;
                        break;
                    }
                }
                string3 = string3 + (String)object + "=";
                string4 = string4.substring(n2 + 1).trim();
                bl = false;
                bl2 = true;
            } else if (bl2) {
                if (string4.startsWith("\"")) {
                    n2 = string4.indexOf("\"", 1);
                    if (n2 <= 1) {
                        string3 = null;
                        break;
                    }
                    string3 = string3 + string4.substring(0, n2 + 1);
                    if (n3 == 3) {
                        vector2.addElement(string4.substring(0, n2 + 1));
                    }
                    string4 = string4.substring(n2 + 1).trim();
                    bl3 = true;
                } else {
                    bl3 = false;
                }
                bl2 = false;
            } else {
                n2 = string4.indexOf(",");
                if (n2 >= 0) {
                    string3 = string3 + string4.substring(0, n2).trim().toLowerCase() + ",";
                    if (n3 == 3 && !bl3) {
                        vector2.addElement(string4.substring(0, n2).trim().toLowerCase());
                    }
                    string4 = string4.substring(n2 + 1);
                    bl = true;
                } else {
                    string3 = string3 + string4.trim().toLowerCase();
                    if (n3 == 3 && !bl3) {
                        vector2.addElement(string4.trim().toLowerCase());
                    }
                    string4 = "";
                    bl = true;
                    bl4 = true;
                }
            }
            if (n3 == 0) continue;
            if (bl && n3 == 1) {
                if (string3.endsWith(",")) {
                    return string3.substring(0, string3.length() - 1);
                }
                return string3;
            }
            if (!bl || n3 != 2) continue;
            string3 = "";
            n3 = 0;
        }
        if (n3 == 3 && vector.size() == vector2.size()) {
            string2 = "";
            n2 = vector.size() - 1;
            while (n2 >= 0) {
                String[] stringArray2;
                object = new ModPropertySet();
                String string5 = (String)vector.elementAt(n2);
                String string6 = (String)vector2.elementAt(n2);
                if (string5.equalsIgnoreCase("dc")) {
                    stringArray2 = new String[]{"domain", "top"};
                    ((ModPropertySet)object).addProperty(0, "objectclass", stringArray2);
                } else if (string5.equalsIgnoreCase("o")) {
                    stringArray2 = new String[]{"organization", "top"};
                    ((ModPropertySet)object).addProperty(0, "objectclass", stringArray2);
                } else if (string5.equalsIgnoreCase("c")) {
                    stringArray2 = new String[]{"country", "top"};
                    ((ModPropertySet)object).addProperty(0, "objectclass", stringArray2);
                } else if (string5.equalsIgnoreCase("l")) {
                    stringArray2 = new String[]{"locality", "top"};
                    ((ModPropertySet)object).addProperty(0, "objectclass", stringArray2);
                }
                ((ModPropertySet)object).addProperty(0, string5, string6);
                string2 = n2 == vector.size() - 1 ? string5 + "=" + string6 : string5 + "=" + string6 + "," + string2;
                if (!Util.dnExists(dirContext, string2)) {
                    Util.ldapAdd(dirContext, string2, (ModPropertySet)object);
                }
                --n2;
            }
        }
        return string3;
    }

    public static String normalizeDN(String string) {
        if (string == null) {
            return null;
        }
        try {
            return Util.normalizeDN(string, 0, null, null);
        }
        catch (UtilException utilException) {
            return null;
        }
    }

    public static String createDN(DirContext dirContext, String string) throws UtilException {
        String[] stringArray = new String[]{"dc", "o", "l", "c"};
        return Util.normalizeDN(string, 3, stringArray, dirContext);
    }

    public static String getDASUrl(DirContext dirContext, String string) throws UtilException {
        String string2 = new String("cn=OperationURLs," + DASbaseDN);
        try {
            Object object;
            PropertySetCollection propertySetCollection = null;
            if (string.equals("")) {
                object = new String[]{"orcldasurlbase"};
                propertySetCollection = Util.getEntryDetails(dirContext, string2, "(objectclass=*)", 0, (String[])object);
            } else {
                object = new String[]{"orcldasurl"};
                propertySetCollection = Util.getEntryDetails(dirContext, Util.normalizeDN(string) + "," + string2, "(objectclass=*)", 0, (String[])object);
            }
            object = propertySetCollection.getPropertySet(0);
            return (String)((PropertySet)object).getProperty(0).getValue(0);
        }
        catch (Exception exception) {
            if (exception instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), exception);
            }
            if (exception instanceof NamingException) {
                throw new InvalidRootOrclctxException(resBundle.getString("INVALID_ROOT_CTX"), exception);
            }
            throw new InvalidRootOrclctxException(resBundle.getString("INVALID_ROOT_CTX"));
        }
    }

    public static Hashtable getAllDASUrl(DirContext dirContext) throws UtilException {
        String string = new String("cn=OperationURLs," + DASbaseDN);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(DASurlDNs.length);
        try {
            String[] stringArray = new String[]{"orcldasurlbase"};
            PropertySetCollection propertySetCollection = Util.getEntryDetails(dirContext, string, "(objectclass=*)", 0, stringArray);
            PropertySet propertySet = propertySetCollection.getPropertySet(0);
            hashtable.put("", propertySet.getProperty(0).getValue(0));
            String[] stringArray2 = new String[]{"orcldasurl"};
            PropertySetCollection propertySetCollection2 = Util.getEntryDetails(dirContext, string, "(objectclass=*)", 1, stringArray2);
            int n = 0;
            while (n < propertySetCollection2.size()) {
                PropertySet propertySet2 = propertySetCollection2.getPropertySet(n);
                String string2 = Util.normalizeDN(new StringTokenizer(propertySet2.getDN(), ",", false).nextToken());
                hashtable.put(string2, propertySet2.getProperty(0).getValue(0));
                ++n;
            }
            return hashtable;
        }
        catch (NamingException namingException) {
            if (namingException instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), namingException);
            }
            throw new InvalidRootOrclctxException(resBundle.getString("INVALID_ROOT_CTX"));
        }
    }

    public static void printResults(PropertySetCollection propertySetCollection) {
        try {
            int n = 0;
            while (n < propertySetCollection.size()) {
                PropertySet propertySet = propertySetCollection.getPropertySet(n);
                Object object = null;
                System.out.println("dn: " + propertySet.getDN());
                int n2 = 0;
                while (n2 < propertySet.size()) {
                    Property property = propertySet.getProperty(n2);
                    int n3 = 0;
                    while (n3 < property.size()) {
                        object = property.getValue(n3);
                        if (object instanceof String) {
                            System.out.println(property.getName() + ": " + (String)object);
                        } else if (object instanceof byte[]) {
                            System.out.println(property.getName() + ": NON ASCII");
                        }
                        ++n3;
                    }
                    ++n2;
                }
                System.out.println();
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public static String[] getDefaultSubscriber() {
        StringTokenizer stringTokenizer = new StringTokenizer(Util.getDomain(), ".", false);
        while (stringTokenizer.countTokens() > 2) {
            stringTokenizer.nextToken();
        }
        String[] stringArray = new String[2];
        stringArray[1] = stringTokenizer.nextToken();
        stringArray[0] = stringTokenizer.nextToken();
        return stringArray;
    }

    public static String getDomain() {
        try {
            String string = InetAddress.getLocalHost().getHostName();
            System.out.println("Inet: " + string);
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            if (stringTokenizer.countTokens() == 1) {
                return stringTokenizer.nextToken() + ".com";
            }
            if (stringTokenizer.countTokens() == 2) {
                return string;
            }
            stringTokenizer.nextToken();
            return stringTokenizer.nextToken("?").substring(1);
        }
        catch (Exception exception) {
            return "domain.com";
        }
    }

    public static void subAndLoadLdif(DirContext dirContext, String string, Vector vector) throws UtilException {
        try {
            System.out.println("in subandload: " + string);
            LDIFReader lDIFReader = new LDIFReader(string);
            LDIFWriter lDIFWriter = null;
            ByteArrayOutputStream byteArrayOutputStream = null;
            byteArrayOutputStream = new ByteArrayOutputStream();
            lDIFWriter = new LDIFWriter(byteArrayOutputStream);
            Vector vector2 = null;
            Vector vector3 = null;
            while ((vector2 = lDIFReader.nextEntry()) != null) {
                vector3 = LDIFSubstitute.substitute(vector2, vector);
                lDIFWriter.writeEntry(vector3);
            }
            lDIFWriter.close();
            lDIFReader.close();
            lDIFReader = new LDIFReader(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            LDIFRecord lDIFRecord = null;
            while ((lDIFRecord = lDIFReader.nextRecord()) != null) {
                switch (lDIFRecord.getChangeType()) {
                    case 1: {
                        Attributes attributes = lDIFRecord.getJNDIAttributes();
                        dirContext.createSubcontext(lDIFRecord.getDN(), attributes);
                        break;
                    }
                    case 3: {
                        ModificationItem[] modificationItemArray = lDIFRecord.getJNDIModificationItems();
                        dirContext.modifyAttributes(lDIFRecord.getDN(), modificationItemArray);
                        break;
                    }
                    case 2: {
                        dirContext.destroySubcontext(lDIFRecord.getDN());
                    }
                }
            }
            lDIFReader.close();
        }
        catch (NamingException namingException) {
            if (namingException instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), namingException);
            }
            System.out.println("Naming Exception in subandload");
        }
        catch (IOException iOException) {
            System.out.println("IOException in performing substitution");
        }
    }

    public static String getFQHN() {
        String string = null;
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            inetAddress = InetAddress.getByName(inetAddress.getHostAddress());
            string = inetAddress.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
        return string;
    }

    public static String getIAC_DNFromFQHN() throws UtilException {
        String string = Util.getFQHN();
        if (string != null) {
            String string2 = new String();
            StringTokenizer stringTokenizer = new StringTokenizer(Util.getFQHN(), ".");
            if (stringTokenizer.countTokens() < 2) {
                string2 = "dc=" + stringTokenizer.nextToken() + ",dc=com";
                return string2;
            }
            stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.countTokens() > 1 ? string2 + "dc=" + stringTokenizer.nextToken() + "," : string2 + "dc=" + stringTokenizer.nextToken();
            }
            return string2;
        }
        return null;
    }

    public static String getParentDN(String string) {
        try {
            return Util.normalizeDN(string, 2, null, null);
        }
        catch (UtilException utilException) {
            return null;
        }
    }

    public static String getRDN(String string) {
        try {
            return Util.normalizeDN(string, 1, null, null);
        }
        catch (UtilException utilException) {
            return null;
        }
    }

    public static boolean dnExists(DirContext dirContext, String string) throws UtilException {
        PropertySetCollection propertySetCollection = Util.dnExists(dirContext, string, new String[0]);
        return propertySetCollection != null;
    }

    public static PropertySetCollection dnExists(DirContext dirContext, String string, String[] stringArray) throws UtilException {
        try {
            PropertySetCollection propertySetCollection = Util.getEntryDetails(dirContext, string, "(objectclass=*)", 0, stringArray);
            return propertySetCollection;
        }
        catch (NamingException namingException) {
            if (namingException instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), namingException);
            }
            if (namingException instanceof NameNotFoundException) {
                return null;
            }
            throw new UtilException(resBundle.getString("GENERAL_ERROR_SEARCH"), namingException);
        }
    }

    public static boolean checkInterfaceVersion(String string) {
        return string.compareTo(SUPPORTED_VERSION[0]) >= 0 && string.compareTo(SUPPORTED_VERSION[1]) <= 0;
    }

    public static void performLDAPOperation(DirContext dirContext, LDIFRecord lDIFRecord) throws NamingException {
        switch (lDIFRecord.getChangeType()) {
            case 1: {
                Attributes attributes = lDIFRecord.getJNDIAttributes();
                dirContext.createSubcontext(lDIFRecord.getDN(), attributes);
                break;
            }
            case 3: {
                ModificationItem[] modificationItemArray = lDIFRecord.getJNDIModificationItems();
                dirContext.modifyAttributes(lDIFRecord.getDN(), modificationItemArray);
                break;
            }
            case 2: {
                dirContext.destroySubcontext(lDIFRecord.getDN());
            }
        }
    }

    public static LDIFRecord getEntryFromDirectory(DirContext dirContext, String string) throws NamingException {
        LDIFRecord lDIFRecord = null;
        if (null != string) {
            SearchControls searchControls = new SearchControls();
            String string2 = "objectclass=*";
            searchControls.setSearchScope(0);
            NamingEnumeration<SearchResult> namingEnumeration = dirContext.search(string, string2, searchControls);
            while (namingEnumeration.hasMore()) {
                SearchResult searchResult = (SearchResult)namingEnumeration.nextElement();
                Attributes attributes = searchResult.getAttributes();
                lDIFRecord = Util.getLDIFRecord(string, attributes);
            }
        }
        return lDIFRecord;
    }

    public static LDIFRecord getLDIFRecord(String string, Attributes attributes) throws NamingException {
        LDIFRecord lDIFRecord = new LDIFRecord(string);
        NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
        while (namingEnumeration.hasMore()) {
            Attribute attribute = (Attribute)namingEnumeration.nextElement();
            NamingEnumeration<?> namingEnumeration2 = attribute.getAll();
            LDIFAttribute lDIFAttribute = new LDIFAttribute(attribute.getID());
            lDIFRecord.addAttribute(lDIFAttribute);
            while (namingEnumeration2.hasMore()) {
                Object e = namingEnumeration2.nextElement();
                try {
                    lDIFAttribute.addValue((String)e);
                }
                catch (ClassCastException classCastException) {
                    lDIFAttribute.removeAll();
                    lDIFAttribute.setBinary(true);
                    lDIFAttribute.addValue((byte[])e);
                }
            }
        }
        return lDIFRecord;
    }

    public static void validateFile(String string, int n) throws InvalidParameterException {
        Util.validateFile(new File(string), n);
    }

    public static void validateFile(File file, int n) throws InvalidParameterException {
        String string = null;
        String string2 = file.getAbsolutePath();
        if (3 == (n & 3)) {
            throw new IllegalArgumentException("Invalid combination of parameters");
        }
        if (!(1 != (n & 1) || file.exists() && file.isFile())) {
            string = NlsMsg.getMessage("FILE_DOES_NOT_EXIST", string2);
            throw new InvalidParameterException(string);
        }
        if (2 == (n & 2) && file.exists()) {
            string = NlsMsg.getMessage("FILE_ALREADY_EXISTS", string2);
            throw new InvalidParameterException(string);
        }
        if (4 == (n & 4) && !file.canRead()) {
            string = NlsMsg.getMessage("FILE_NOT_READABLE", string2);
            throw new InvalidParameterException(string);
        }
        if (8 == (n & 8) && !file.canWrite()) {
            string = NlsMsg.getMessage("FILE_NOT_WRITABLE", string2);
            throw new InvalidParameterException(string);
        }
        if (16 == (n & 0x10) && file.length() == 0L) {
            string = NlsMsg.getMessage("FILE_EMPTY", string2);
            throw new InvalidParameterException(string);
        }
        if (32 == (n & 0x20)) {
            String string3 = file.getAbsolutePath();
            string3 = string3.substring(0, string3.lastIndexOf(File.separatorChar));
            if (file.exists() || !new File(string3).canWrite()) {
                string = NlsMsg.getMessage("FILE_NOT_CREATABLE", string2);
                throw new InvalidParameterException(string);
            }
        }
    }

    public static void addUniquemember(DirContext dirContext, String string, String string2) throws UtilException {
        try {
            BasicAttributes basicAttributes = new BasicAttributes("uniquemember", string2);
            dirContext.modifyAttributes(string, 1, (Attributes)basicAttributes);
        }
        catch (NamingException namingException) {
            if (namingException instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), namingException);
            }
            throw new UtilException("NamingException encountered in addUniqueMember", namingException);
        }
    }

    public static void removeUniquemember(DirContext dirContext, Group[] groupArray, String string) throws UtilException {
        int n = 0;
        while (n < groupArray.length) {
            Util.removeUniquemember(dirContext, groupArray[n].getDN(dirContext), string);
            ++n;
        }
    }

    public static void removeUniquemember(DirContext dirContext, Group group, String string) throws UtilException {
        Util.removeUniquemember(dirContext, group.getDN(dirContext), string);
    }

    public static void removeUniquemember(DirContext dirContext, String[] stringArray, String string) throws UtilException {
        int n = 0;
        while (n < stringArray.length) {
            Util.removeUniquemember(dirContext, stringArray[n], string);
            ++n;
        }
    }

    public static void removeUniquemember(DirContext dirContext, String string, String string2) throws UtilException {
        try {
            ModificationItem[] modificationItemArray = new ModificationItem[]{new ModificationItem(3, new BasicAttribute("uniquemember", string2))};
            dirContext.modifyAttributes(string, modificationItemArray);
        }
        catch (NamingException namingException) {
            if (namingException instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), namingException);
            }
            throw new UtilException("NamingException encountered in removeUniqueMember", namingException);
        }
    }

    public static void bulkDelete(DirContext dirContext, String string, boolean bl) throws NamingException {
        try {
            Vector vector;
            PropertySetCollection propertySetCollection = Util.getEntryDetails(dirContext, string, "(objectclass=*)", 2, new String[0]);
            Vector vector2 = new Vector(30);
            int n = 0;
            while (n < 30) {
                vector2.insertElementAt(new Vector(), n);
                ++n;
            }
            int n2 = new StringTokenizer(string, ",").countTokens() - 1;
            int n3 = 0;
            while (n3 < propertySetCollection.size()) {
                String string2 = propertySetCollection.getPropertySet(n3).getDN();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                vector = (Vector)vector2.elementAt(stringTokenizer.countTokens() - 1 - n2);
                vector.add(string2);
                ++n3;
            }
            int n4 = bl ? 0 : 1;
            int n5 = 29;
            while (n5 >= n4) {
                vector = (Vector)vector2.elementAt(n5);
                if (!vector.isEmpty()) {
                    int n6 = 0;
                    while (n6 < vector.size()) {
                        dirContext.destroySubcontext((String)vector.elementAt(n6));
                        ++n6;
                    }
                }
                --n5;
            }
        }
        catch (Exception exception) {
            if (exception instanceof CommunicationException) {
                throw (CommunicationException)exception;
            }
            throw new NamingException("Error occurrs in bulkDelete");
        }
    }

    public static String getAttrOfRDN(String string) {
        return string.substring(0, string.indexOf("="));
    }

    public static String getAttrValueOfRDN(String string) {
        return string.substring(string.indexOf("=") + 1);
    }

    public static String getParameterFromFile(String string, String string2) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string2));
        String string3 = null;
        while (bufferedReader.ready()) {
            String string4;
            String string5 = bufferedReader.readLine();
            if (!string5.startsWith(string)) continue;
            int n = string5.indexOf("=");
            if (n == -1 || (string4 = string5.substring(string5.indexOf("=") + 1).trim()) == "") break;
            string3 = string4;
            break;
        }
        return string3;
    }

    public static LDAPObjectClass getObjectClass(DirContext dirContext, String string) throws UtilException {
        PropertySetCollection propertySetCollection = null;
        Object object = new String[]{"objectclasses"};
        propertySetCollection = Util.ldapSearch(dirContext, "cn=subschemasubentry", "(objectclass=*)", 0, (String[])object);
        object = propertySetCollection.getPropertySet(0).getProperty("objectclasses");
        boolean bl = false;
        if (string.indexOf(".") > -1) {
            bl = true;
        }
        int n = 0;
        while (n < ((Property)object).size()) {
            String string2 = (String)((Property)object).getValue(n);
            boolean bl2 = false;
            if (bl ? LDAPObjectClass.getOID(string2).equalsIgnoreCase(string) : LDAPObjectClass.getName(string2).equalsIgnoreCase(string)) {
                return new LDAPObjectClass(string2);
            }
            ++n;
        }
        return null;
    }

    public static PropertySetCollection ldapSearch(DirContext dirContext, String string, String string2, int n, String[] stringArray) throws UtilException {
        try {
            return Util.getEntryDetails(dirContext, string, string2, n, stringArray);
        }
        catch (NamingException namingException) {
            if (namingException instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), namingException);
            }
            throw new UtilException("NamingException encountered in ldapSearch", namingException);
        }
    }

    public static void ldapAdd(DirContext dirContext, String string, ModPropertySet modPropertySet) throws UtilException {
        try {
            Attributes attributes = modPropertySet.getModProperty().getJNDIAttributes();
            dirContext.createSubcontext(string, attributes);
        }
        catch (NamingException namingException) {
            if (namingException instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), namingException);
            }
            throw new UtilException("NamingException encountered in ldapAdd", namingException);
        }
    }

    public static void ldapModify(DirContext dirContext, String string, ModPropertySet modPropertySet) throws UtilException {
        LDIFRecord lDIFRecord = modPropertySet.getModProperty();
        try {
            ModificationItem[] modificationItemArray = lDIFRecord.getJNDIModificationItems();
            dirContext.modifyAttributes(string, modificationItemArray);
        }
        catch (NamingException namingException) {
            if (namingException instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), namingException);
            }
            throw new UtilException("NamingException encountered in ldapModify", namingException);
        }
    }

    public static void ldapModify(DirContext dirContext, String string, Vector vector, boolean bl) throws UtilException {
        LDIFLoader lDIFLoader = new LDIFLoader(dirContext, string, vector);
        lDIFLoader.load(bl, System.out);
    }

    public static void ldapModify(DirContext dirContext, String string, Vector vector, boolean bl, PrintStream printStream) throws UtilException {
        LDIFLoader lDIFLoader = new LDIFLoader(dirContext, string, vector);
        lDIFLoader.load(bl, printStream);
    }

    public static void ldapDelete(DirContext dirContext, String string) throws UtilException {
        try {
            dirContext.destroySubcontext(string);
        }
        catch (NamingException namingException) {
            if (namingException instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), namingException);
            }
            throw new UtilException("NamingException encountered in ldapDelete", namingException);
        }
    }

    public static boolean ldapCompare(DirContext dirContext, String string, String string2, Object object) throws UtilException {
        try {
            SearchControls searchControls = new SearchControls();
            searchControls.setReturningAttributes(new String[0]);
            searchControls.setSearchScope(0);
            NamingEnumeration<SearchResult> namingEnumeration = dirContext.search(string, "(" + string2 + "=" + object + ")", searchControls);
            return namingEnumeration.hasMore();
        }
        catch (NamingException namingException) {
            if (namingException instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), namingException);
            }
            throw new GeneralErrorException(resBundle.getString("UNABLE_SET_CONTROLS"), namingException);
        }
    }

    public static PropertySetCollection multiSearchBaseSearch(DirContext dirContext, String string, String[] stringArray, String string2, String[] stringArray2, boolean bl) throws UtilException {
        boolean bl2;
        String[] stringArray3 = null;
        if (string != null) {
            bl2 = false;
            int n = 0;
            while (n < stringArray.length) {
                String string3 = Util.normalizeDN(stringArray[n]);
                if (string3.equals(Util.normalizeDN(string))) {
                    bl2 = true;
                    break;
                }
                ++n;
            }
            if (!bl2) {
                throw new UtilException("Invalid search base");
            }
            stringArray3 = new String[]{string};
        } else {
            stringArray3 = stringArray;
        }
        bl2 = false;
        PropertySetCollection propertySetCollection = null;
        propertySetCollection = new PropertySetCollection();
        int n = 0;
        while (n < stringArray3.length) {
            String string4 = stringArray3[n];
            PropertySetCollection propertySetCollection2 = null;
            try {
                propertySetCollection2 = Util.ldapSearch(dirContext, string4, string2, 2, stringArray2);
            }
            catch (UtilException utilException) {
                if (utilException instanceof CommunicationErrorException) {
                    throw utilException;
                }
                throw new UtilException("NamingException encountered when resolving object using the following filter: " + string2);
            }
            if (propertySetCollection2.isEmpty() && n == stringArray.length - 1 && bl && !bl2) {
                throw new UtilException("Object cannot be found using the following filter: " + string2);
            }
            int n2 = 0;
            while (n2 < propertySetCollection2.size()) {
                if (bl && bl2) {
                    throw new UtilException("Multiple Objects found using the following filter: " + string2);
                }
                propertySetCollection.add(propertySetCollection2.getPropertySet(n2));
                if (bl) {
                    bl2 = true;
                }
                ++n2;
            }
            ++n;
        }
        return propertySetCollection;
    }

    public static String[] getSSODBInfo(DirContext dirContext) throws Exception {
        String[] stringArray = OUILdap.getSSODBInfo(dirContext, new String[0]);
        return stringArray;
    }

    static {
        try {
            resBundle = ResourceBundle.getBundle("oracle.ldap.util.nls.UtilityResource");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        API_VERSION = "9.0.2.1.0";
        INTERFACE_VERSION = "1";
        SUPPORTED_VERSION = new String[]{"1", "1"};
        PWD_VERIFIERTYPE_COMMON = 1;
        IDTYPE_DN = 0;
        IDTYPE_SIMPLE = 1;
        IDTYPE_GUID = 2;
        IDTYPE_DEFAULT = 3;
        IDTYPE_FILTER = 4;
        IDTYPE_WINDOWS = 5;
        IDTYPE_KERB_PRINCIPAL = 6;
        PROPERTIES_ENTRY = 0;
        PROPERTIES_DETACHED = 0;
        CREDTYPE_PASSWD = 0;
        DASURL_BASE = "";
        DASURL_CREATE_USER = "cn=create user";
        DASURL_EDIT_GROUP = "cn=edit group";
        DASURL_EDIT_GROUP_GIVEN_GUID = "cn=edit groupgivenguid";
        DASURL_GROUP_SEARCH = "cn=group search";
        DASURL_EDIT_USER = "cn=edit user";
        DASURL_GROUP_LOV = "cn=group lOV";
        DASURL_DELETE_USER = "cn=deleteUser";
        DASURL_USER_PRIVILEGE = "cn=user privilege";
        DASURL_CREATE_GROUP = "cn=create group";
        DASURL_USER_SEARCH = "cn=user search";
        DASURL_ACCOUNT_INFO = "cn=account info";
        DASURL_EDIT_USER_GIVEN_GUID = "cn=edit usergivenguid";
        DASURL_DELETE_USER_GIVEN_GUID = "cn=deleteusergivenguid";
        DASURL_DELETE_GROUP_GIVEN_GUID = "cn=deletegroupgivenguid";
        DASURL_GROUP_PRIVILEGE = "cn=group privilege";
        DASURL_USER_PRIVILEGE_GIVEN_GUID = "cn=user privilege given guid";
        DASURL_PASSWORD_CHANGE = "cn=password change";
        DASURL_USER_LOV = "cn=user lov";
        DASURL_GROUP_PRIVILEGE_GIVEN_GUID = "cn=group privilege given guid";
        DASURL_DELETE_GROUP = "cn=DeleteGroup";
        DASURL_CREATE_RESOURCE = "cn=create resource";
        DASURL_EUS_CONSOLE = "cn=eus console";
        DASURL_DELEGATION_CONSOLE = "cn=delegation console";
        DASURL_EDIT_MY_PROFILE = "cn=edit my profile";
        DASurlDNs = new String[]{"", "cn=Create User", "cn=Edit Group", "cn=Edit GroupGivenGUID", "cn=Group Search", "cn=Edit User", "cn=Group LOV", "cn=DeleteUser", "cn=User Privilege", "cn=Create Group", "cn=User Search", "cn=Account Info", "cn=Edit UserGivenGUID", "cn=DeleteUserGivenGUID", "cn=DeleteGroupGivenGUID", "cn=Group Privilege", "cn=User Privilege Given GUID", "cn=Password Change", "cn=User LOV", "cn=Group Privilege Given GUID", "cn=DeleteGroup", "cn=Create Resource"};
        rootOracleContextDN = "cn=OracleContext";
        commonDN = "cn=Common,cn=Products,cn=OracleContext";
        DASbaseDN = "cn=DAS,cn=Products,cn=OracleContext";
    }
}

