/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.util.StringTokenizer;
import javax.naming.NamingException;

public class UtilException
extends Exception {
    protected int ldapErrorCode = -1;
    protected int passwordPolicyErrorCode = -1;
    protected Exception e = null;
    protected boolean isNamingException = false;
    protected boolean hasPasswordPolicyError = false;
    protected boolean hasLDAPErrorCode = false;
    protected NamingException ne = null;

    protected UtilException() {
    }

    protected UtilException(String string) {
        super(string);
    }

    private UtilException(NamingException namingException) {
        this.isNamingException = true;
        this.parseErrorCode(namingException);
    }

    protected UtilException(String string, Exception exception) {
        super(string + " " + exception.getMessage());
        if (exception instanceof NamingException) {
            this.ne = (NamingException)exception;
            this.isNamingException = true;
            this.parseErrorCode((NamingException)exception);
        }
        this.e = exception;
    }

    public NamingException returnNamingException() {
        return this.ne;
    }

    public boolean isNamingException() {
        return this.isNamingException;
    }

    public boolean hasPasswordPolicyError() {
        return this.hasPasswordPolicyError;
    }

    public boolean hasLDAPErrorCode() {
        return this.hasLDAPErrorCode;
    }

    public int getLDAPErrorCode() {
        return this.ldapErrorCode;
    }

    public int getPasswordPolicyErrorCode() {
        return this.passwordPolicyErrorCode;
    }

    public static int getLDAPErrorCode(NamingException namingException) {
        return new UtilException(namingException).getLDAPErrorCode();
    }

    private void parseErrorCode(NamingException namingException) {
        StringTokenizer stringTokenizer;
        String string = namingException.toString();
        int n = string.indexOf("LDAP: error code");
        if (n > -1) {
            this.hasLDAPErrorCode = true;
            stringTokenizer = new StringTokenizer(string.substring(n));
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                try {
                    this.ldapErrorCode = new Integer(stringTokenizer.nextToken());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if ((n = string.indexOf(":")) > -1) {
            stringTokenizer = new StringTokenizer(string.substring(n), ":");
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    this.passwordPolicyErrorCode = new Integer(stringTokenizer.nextToken());
                    if (this.passwordPolicyErrorCode <= 999 || this.passwordPolicyErrorCode >= 10000) continue;
                    this.hasPasswordPolicyError = true;
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }
}

