/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.discovery;

import java.util.HashMap;
import java.util.Properties;

public class DiscoveryHelper {
    public int discoveryType;
    private Properties prop;
    public static final int DNS_DISCOVER = 1;
    public static final int CFGFILE_DISCOVER = 2;
    public static final int AUTO_DISCOVER = 3;
    public static final Integer DEF_ADMIN_CTXT = new Integer(1);
    public static final Integer DIR_SERVERS = new Integer(2);
    public static final Integer DIR_SERVER_TYPE = new Integer(3);
    public static final Integer ALTDIR_SERVERS = new Integer(4);
    public static final Integer ORCLCOMMCTXMAP = new Integer(5);
    public static final Integer DIR_SERVER_CONN_SEC = new Integer(6);
    public static final Integer CFGFL_PATH = new Integer(7);
    public static final String SSL_FALSE = "0";
    public static final String SSL_TRUE = "1";
    public static final String DNS_DN = "1";
    public static final String DNS_DISCOVER_METHOD = "2";
    public static final String SSLMODE = "3";
    public static final String USE_INPUT_DN_METHOD = "1";
    public static final String USE_MC_DOMAIN_METHOD = "2";
    public static final String USE_DFLT_LOOKUP_METHOD = "4";
    public static final String USE_ALL_METHODS = "7";
    public static final int LDAP_NO_INFO_OBTAINED = 500;
    public static final int LDAP_LOOKUP_ERROR = 501;
    public static final int LDAP_DNS_ADDR_NOT_FOUND = 502;
    public static final int LDAP_FILE_NOT_FOUND = 503;
    public static final int LDAP_FILE_PARSE_ERROR = 504;
    public static final int LDAP_PARAM_ERROR = 89;
    public static final int LDAP_SUCCESS = 0;

    public DiscoveryHelper(int n) {
        this.discoveryType = n;
        this.prop = new Properties();
    }

    public int discover(HashMap hashMap) {
        return DiscoveryHelper.ldapDiscover(this.discoveryType, this.prop, hashMap);
    }

    public Object setProperty(String string, String string2) {
        return this.prop.setProperty(string, string2);
    }

    public String getProperty(String string) {
        return this.prop.getProperty(string);
    }

    private static native int ldapDiscover(int var0, Properties var1, HashMap var2);

    static {
        if (System.getProperty("os.name", "DEFAULT").startsWith("Windows")) {
            System.loadLibrary("oraldapjclnt9");
        } else {
            System.loadLibrary("ldapjclnt9");
        }
    }
}

