/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.param;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.ldap.util.ParameterException;
import oracle.ldap.util.nls.NlsMsg;
import oracle.ldap.util.param.FlagParameterDescriptor;
import oracle.ldap.util.param.Parameter;
import oracle.ldap.util.param.ParameterDescriptor;

public abstract class ParameterParser {
    protected String mParamNameValueDelim = "=";
    protected ParameterDescriptor[] mParamDes = null;
    protected Hashtable mParsedParamHT = null;
    protected Vector mUnParsedParamVector = null;
    protected boolean mAllowUndescribedParam = true;

    protected ParameterParser(ParameterDescriptor[] parameterDescriptorArray) {
        this.mParamDes = parameterDescriptorArray;
    }

    protected ParameterParser(ParameterDescriptor[] parameterDescriptorArray, boolean bl) {
        this(parameterDescriptorArray);
        this.mAllowUndescribedParam = bl;
    }

    protected ParameterParser(ParameterDescriptor[] parameterDescriptorArray, String string) {
        this(parameterDescriptorArray);
        if (null == string) {
            throw new IllegalArgumentException("The delimiter cannot be NULL");
        }
        this.mParamNameValueDelim = string;
    }

    protected boolean containsParameterDescriptor(String string) {
        return this.getParameterDescriptorIndex(string, false) != -1;
    }

    protected Hashtable getParsedParams() {
        return this.mParsedParamHT;
    }

    protected Enumeration getParams() {
        return this.mParsedParamHT.elements();
    }

    protected int getParameterDescriptorIndex(String string, boolean bl) {
        int n = -1;
        if (this.mParamDes != null && string != null) {
            int n2 = 0;
            while (n2 < this.mParamDes.length) {
                if (this.mParamDes[n2] != null && (!bl || this.mParamDes[n2] instanceof FlagParameterDescriptor) && this.mParamDes[n2].equals(string)) {
                    n = n2;
                    break;
                }
                ++n2;
            }
        }
        return n;
    }

    protected void validateAndAddDefaultParams() throws ParameterException {
        if (this.mParamDes != null) {
            int n = 0;
            while (n < this.mParamDes.length) {
                String string = this.mParamDes[n].getName();
                if (this.mParamDes[n].isManadatory()) {
                    if (this.mParsedParamHT == null || this.mParsedParamHT.get(string) == null) {
                        throw new ParameterException(NlsMsg.getMessage("PARAMETER_MANDATORY_MISSING", string));
                    }
                } else {
                    String string2 = this.mParamDes[n].getDefaultValue();
                    if (null != string2) {
                        if (this.mParsedParamHT == null) {
                            this.mParsedParamHT = new Hashtable();
                            this.mParsedParamHT.put(string, new Parameter(string, string2, false));
                        } else if (this.mParsedParamHT.get(string) == null) {
                            this.mParsedParamHT.put(string, new Parameter(string, string2, false));
                        }
                    }
                }
                ++n;
            }
        }
    }

    public abstract void parse() throws ParameterException;

    public Parameter get(String string) {
        if (null == this.mParsedParamHT) {
            return null;
        }
        return (Parameter)this.mParsedParamHT.get(string);
    }

    public Vector getUnParsedParams() {
        return this.mUnParsedParamVector;
    }

    public int size() {
        return this.mParsedParamHT.size();
    }
}

