/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.param;

import java.util.Hashtable;
import java.util.Properties;
import oracle.ldap.util.InvalidParameterException;
import oracle.ldap.util.ParameterException;
import oracle.ldap.util.nls.NlsMsg;
import oracle.ldap.util.param.Parameter;
import oracle.ldap.util.param.ParameterDescriptor;
import oracle.ldap.util.param.ParameterParser;

public class PropertyFileParser
extends ParameterParser {
    private Properties mProp = null;

    public PropertyFileParser(ParameterDescriptor[] parameterDescriptorArray, Properties properties) {
        super(parameterDescriptorArray);
        if (null == properties) {
            throw new IllegalArgumentException("prop parameter cannot be NULL");
        }
        this.mProp = properties;
    }

    public void parse() throws ParameterException {
        this.mParsedParamHT = new Hashtable();
        int n = 0;
        while (n < this.mParamDes.length) {
            String string = this.mParamDes[n].getName();
            String string2 = this.mProp.getProperty(string);
            String string3 = this.mParamDes[n].getDefaultValue();
            if (this.mParamDes[n].isManadatory() && null == string2 && null == string3) {
                throw new ParameterException(NlsMsg.getMessage("PARAMETER_MANDATORY_MISSING", string));
            }
            if (string2 == null) {
                string2 = string3;
            }
            if (string2 != null) {
                if (this.mParamDes[n].isValueValid(string2)) {
                    this.mParsedParamHT.put(string, new Parameter(string, string2, false));
                } else {
                    throw new InvalidParameterException(NlsMsg.getMessage("PARAMETER_INVALID_ARGUMENT_VALUE", new String[]{string, string2}));
                }
            }
            ++n;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Properties properties = new Properties();
        ParameterDescriptor[] parameterDescriptorArray = new ParameterDescriptor[]{new ParameterDescriptor("odip.bootstrap.srctype", true, new String[]{"LDIF", "LDAP"}, null), new ParameterDescriptor("odip.bootstrap.desttype", true, new String[]{"LDIF", "LDAP"}, null), new ParameterDescriptor("odip.bootstrap.srcurl", true, null, null), new ParameterDescriptor("odip.bootstrap.desturl", true, null, null), new ParameterDescriptor("odip.bootstrap.mapfile", true, null, null), new ParameterDescriptor("odip.bootstrap.srcdn", true, null, null), new ParameterDescriptor("odip.bootstrap.srcpassword", true, null, null), new ParameterDescriptor("odip.bootstrap.destdn", true, null, null), new ParameterDescriptor("odip.bootstrap.destpassword", true, null, null), new ParameterDescriptor("odip.bootstrap.schemasync", false, new String[]{"true", "false"}, "false")};
        PropertyFileParser propertyFileParser = new PropertyFileParser(parameterDescriptorArray, properties);
        properties.setProperty("odip.bootstrap.srctype", "LDIF");
        properties.setProperty("odip.bootstrap.srcurl", "/tmp/dump.ldif");
        properties.setProperty("odip.bootstrap.srcdn", "cn=orcladmin");
        properties.setProperty("odip.bootstrap.srcpassword", "welcome");
        properties.setProperty("odip.bootstrap.desttype", "LDAP");
        properties.setProperty("odip.bootstrap.desturl", "localhost:3060");
        properties.setProperty("odip.bootstrap.destdn", "cn=Directory Manager");
        properties.setProperty("odip.bootstrap.destpassword", "welcome123");
        properties.setProperty("odip.bootstrap.mapfile", "/tmp/Mapfile.cfg");
        ((ParameterParser)propertyFileParser).parse();
        System.out.println(propertyFileParser.get("odip.bootstrap.srctype").getValue());
        System.out.println(propertyFileParser.get("odip.bootstrap.srcurl").getValue());
        System.out.println(propertyFileParser.get("odip.bootstrap.srcdn").getValue());
        System.out.println(propertyFileParser.get("odip.bootstrap.srcpassword").getValue());
        System.out.println(propertyFileParser.get("odip.bootstrap.desttype").getValue());
        System.out.println(propertyFileParser.get("odip.bootstrap.desturl").getValue());
        System.out.println(propertyFileParser.get("odip.bootstrap.destdn").getValue());
        System.out.println(propertyFileParser.get("odip.bootstrap.destpassword").getValue());
        System.out.println(propertyFileParser.get("odip.bootstrap.mapfile").getValue());
        System.out.println(propertyFileParser.get("odip.bootstrap.schemasync").getValue());
    }
}

