/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.provisioning;

import java.util.Vector;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import oracle.ldap.util.Property;
import oracle.ldap.util.PropertySet;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.Util;
import oracle.ldap.util.provisioning.ProvisioningCmdArgs;
import oracle.ldap.util.provisioning.ProvisioningProfile;
import oracle.ldap.util.provisioning.ProvisioningProfileV2;

public class ProvisioningInboundProfileV2
extends ProvisioningProfileV2 {
    public static final String ATTR_AppLastId = "orclODIPProfileLastAppliedAppEventID";
    public static final String ATTR_ProvMapRules = "orclODIPProvisioningEventMappingRules";
    public static final String ATTR_ProvEventOprns = "orclODIPProvisioningEventPermittedOperations";
    protected Vector profileEventMapRules;
    protected Vector profileEventPermittedOprns;
    protected String profileAppLastId;
    protected String profileProcessingStatus;
    protected Vector profileProcessingErrors = null;
    protected String profileLastProcessingTime;
    protected String profileLastSuccessfulProcTime;
    protected boolean valid = true;

    public ProvisioningInboundProfileV2(DirContext dirContext, String string) throws Exception {
        try {
            this.readProfileFromDirectory(dirContext, "cn=ApplicationToOID," + string);
            this.valid = true;
        }
        catch (Exception exception) {
            this.valid = false;
        }
    }

    public ProvisioningInboundProfileV2(DirContext dirContext, String string, String string2) throws Exception {
        try {
            String string3 = ProvisioningProfile.composeProfileDN(dirContext, string, string2);
            this.readProfileFromDirectory(dirContext, "cn=ApplicationToOID," + string3);
        }
        catch (Exception exception) {
            this.valid = false;
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public void modify(DirContext dirContext, ProvisioningCmdArgs provisioningCmdArgs) throws Exception {
        Vector vector;
        int n = 0;
        ModificationItem[] modificationItemArray = new ModificationItem[32];
        BasicAttribute basicAttribute = null;
        Vector vector2 = provisioningCmdArgs.getVector("EVENT_MAPPING_RULES");
        if (vector2 != null) {
            ProvisioningCmdArgs.LOG("Updating Attribute :orclODIPProvisioningEventMappingRules");
            basicAttribute = new BasicAttribute(ATTR_ProvMapRules);
            int n2 = 0;
            while (n2 < vector2.size()) {
                basicAttribute.add(vector2.elementAt(n2));
                ++n2;
            }
            modificationItemArray[n++] = new ModificationItem(2, basicAttribute);
        }
        if ((vector = provisioningCmdArgs.getVector("EVENT_PERMITTED_OPERATIONS")) != null) {
            ProvisioningCmdArgs.LOG("Updating Attribute :orclODIPProvisioningEventPermittedOperations");
            basicAttribute = new BasicAttribute(ATTR_ProvEventOprns);
            int n3 = 0;
            while (n3 < vector.size()) {
                basicAttribute.add(vector.elementAt(n3));
                ++n3;
            }
            modificationItemArray[n++] = new ModificationItem(2, basicAttribute);
        }
        if (n == 0) {
            ProvisioningCmdArgs.LOG("Nothing TO modify in INBOUND Profile");
            return;
        }
        ModificationItem[] modificationItemArray2 = new ModificationItem[n];
        System.arraycopy(modificationItemArray, 0, modificationItemArray2, 0, n);
        ProvisioningCmdArgs.LOG("Modifying entry : (" + this.profileDN + ")");
        dirContext.modifyAttributes(this.profileDN, modificationItemArray2);
    }

    public void status(DirContext dirContext) throws Exception {
        String[] stringArray = new String[]{"*", "orclguid"};
        Property property = null;
        PropertySetCollection propertySetCollection = Util.getEntryDetails(dirContext, this.profileDN, "objectclass=*", 0, stringArray);
        PropertySet propertySet = propertySetCollection.getPropertySet(0);
        property = propertySet.getProperty("orclODIPProfileProcessingStatus");
        if (property != null) {
            this.setProfileProcessingStatus((String)property.getValue(0));
            System.out.println("orclODIPProfileProcessingStatus" + ": " + (String)property.getValue(0));
        }
        if ((property = propertySet.getProperty("orclODIPProfileProcessingErrors")) != null && property.size() > 0) {
            Vector<Object> vector = new Vector<Object>();
            int n = 0;
            while (n < property.size()) {
                vector.addElement(property.getValue(n));
                System.out.println("orclODIPProfileProcessingErrors" + ": " + (String)property.getValue(0));
                ++n;
            }
            this.setProfileProcessingErrors(vector);
        }
        if ((property = propertySet.getProperty("orclODIPProfileLastProcessingTime")) != null) {
            this.setProfileLastProcessingTime((String)property.getValue(0));
            System.out.println("orclODIPProfileLastProcessingTime" + ": " + (String)property.getValue(0));
        }
        if ((property = propertySet.getProperty("orclODIPProfileLastSuccessfulProcessingTime")) != null) {
            this.setProfileLastSuccessfulProcTime((String)property.getValue(0));
            System.out.println("orclODIPProfileLastSuccessfulProcessingTime" + ": " + (String)property.getValue(0));
        }
    }

    public static ProvisioningInboundProfileV2 createNewInboundProfileV2(DirContext dirContext, ProvisioningCmdArgs provisioningCmdArgs) throws Exception {
        int n;
        ProvisioningInboundProfileV2 provisioningInboundProfileV2 = null;
        boolean bl = false;
        Vector vector = null;
        Vector vector2 = null;
        String string = ProvisioningProfile.composeProfileDN(dirContext, provisioningCmdArgs.get("APPLICATION_DN"), provisioningCmdArgs.get("ORGANIZATION_DN"));
        bl = ProvisioningProfile.directoryEntryExists(dirContext, "cn=ApplicationToOID," + string);
        if (bl) {
            throw new Exception("Provisioning Profile Already Exists..");
        }
        BasicAttribute basicAttribute = null;
        BasicAttributes basicAttributes = new BasicAttributes();
        BasicAttribute basicAttribute2 = new BasicAttribute("objectclass");
        basicAttribute2.add("top");
        basicAttribute2.add("orclODIPProvisioningIntegrationInBoundProfileV2");
        basicAttributes.put(basicAttribute2);
        basicAttribute = new BasicAttribute("cn");
        basicAttribute.add("ApplicationToOID");
        basicAttributes.put(basicAttribute);
        basicAttribute = new BasicAttribute("orclStatus");
        basicAttribute.add(provisioningCmdArgs.get("PROFILE_STATUS"));
        basicAttributes.put(basicAttribute);
        basicAttribute = new BasicAttribute(ATTR_AppLastId);
        basicAttribute.add("0");
        basicAttributes.put(basicAttribute);
        basicAttribute = new BasicAttribute("orclODIPProvisioningAppGUID");
        basicAttribute.add(ProvisioningProfile.getDirectoryEntryGUID(dirContext, provisioningCmdArgs.get("APPLICATION_DN")));
        basicAttributes.put(basicAttribute);
        vector = provisioningCmdArgs.getVector("EVENT_MAPPING_RULES");
        if (vector != null) {
            basicAttribute = new BasicAttribute(ATTR_ProvMapRules);
            n = 0;
            while (n < vector.size()) {
                basicAttribute.add((String)vector.elementAt(n));
                ++n;
            }
            basicAttributes.put(basicAttribute);
        }
        if ((vector2 = provisioningCmdArgs.getVector("EVENT_PERMITTED_OPERATIONS")) != null) {
            basicAttribute = new BasicAttribute(ATTR_ProvEventOprns);
            n = 0;
            while (n < vector2.size()) {
                basicAttribute.add((String)vector2.elementAt(n));
                ++n;
            }
            basicAttributes.put(basicAttribute);
        }
        ProvisioningCmdArgs.LOG(((Object)basicAttributes).toString());
        DirContext dirContext2 = dirContext.createSubcontext("cn=ApplicationToOID," + string, (Attributes)basicAttributes);
        ProvisioningCmdArgs.LOG("Created InBound SubProfile Entry Successfully");
        provisioningInboundProfileV2 = new ProvisioningInboundProfileV2(dirContext, string);
        ProvisioningCmdArgs.LOG("Created InBound SubProfile Object Successfully");
        return provisioningInboundProfileV2;
    }

    private void readProfileFromDirectory(DirContext dirContext, String string) throws Exception {
        int n;
        Vector<Object> vector;
        String[] stringArray = new String[]{"*", "orclguid"};
        Property property = null;
        ProvisioningCmdArgs.LOG("Searching For INBOUND Profile : " + string);
        PropertySetCollection propertySetCollection = Util.getEntryDetails(dirContext, string, "objectclass=*", 0, stringArray);
        PropertySet propertySet = propertySetCollection.getPropertySet(0);
        this.profileDN = string;
        property = propertySet.getProperty("orclStatus");
        if (property != null) {
            this.setProfileStatus((String)property.getValue(0));
        }
        if ((property = propertySet.getProperty(ATTR_AppLastId)) != null) {
            this.setProfileLastAppId((String)property.getValue(0));
        }
        if ((property = propertySet.getProperty("orclODIPProvisioningAppGUID")) != null) {
            this.setProvisioningProfileAppGUID((String)property.getValue(0));
        }
        if ((property = propertySet.getProperty(ATTR_ProvMapRules)) != null && property.size() > 0) {
            vector = new Vector<Object>();
            n = 0;
            while (n < property.size()) {
                vector.addElement(property.getValue(n));
                ++n;
            }
            this.setProfileMapRules(vector);
        }
        if ((property = propertySet.getProperty(ATTR_ProvEventOprns)) != null && property.size() > 0) {
            vector = new Vector();
            n = 0;
            while (n < property.size()) {
                vector.addElement(property.getValue(n));
                ++n;
            }
            this.setProfilePermttdOprns(vector);
        }
        if ((property = propertySet.getProperty("orclODIPProfileProcessingStatus")) != null) {
            this.setProfileProcessingStatus((String)property.getValue(0));
        }
        if ((property = propertySet.getProperty("orclODIPProfileProcessingErrors")) != null && property.size() > 0) {
            vector = new Vector();
            n = 0;
            while (n < property.size()) {
                vector.addElement(property.getValue(n));
                ++n;
            }
            this.setProfileProcessingErrors(vector);
        }
        if ((property = propertySet.getProperty("orclODIPProfileLastProcessingTime")) != null) {
            this.setProfileLastProcessingTime((String)property.getValue(0));
        }
        if ((property = propertySet.getProperty("orclODIPProfileLastSuccessfulProcessingTime")) != null) {
            this.setProfileLastSuccessfulProcTime((String)property.getValue(0));
        }
    }

    public String getProfileStatus() {
        return this.profileStatus;
    }

    public void setProfileStatus(String string) {
        this.profileStatus = string;
    }

    public void setProfileLastAppId(String string) {
        this.profileAppLastId = string;
    }

    public Vector getProfileMapRules() {
        return this.profileEventMapRules;
    }

    public void setProfileMapRules(Vector vector) {
        this.profileEventMapRules = vector;
    }

    public Vector getProfilePermttdOprns() {
        return this.profileEventPermittedOprns;
    }

    public void setProfilePermttdOprns(Vector vector) {
        this.profileEventPermittedOprns = vector;
    }

    public String getProfileProcessingStatus() {
        return this.profileProcessingStatus;
    }

    public void setProfileProcessingStatus(String string) {
        this.profileProcessingStatus = string;
    }

    public Vector getProfileProcessingErrors() {
        return this.profileProcessingErrors;
    }

    public void setProfileProcessingErrors(Vector vector) {
        this.profileProcessingErrors = vector;
    }

    public String getProfileLastProcessingTime() {
        return this.profileLastProcessingTime;
    }

    public void setProfileLastProcessingTime(String string) {
        this.profileLastProcessingTime = string;
    }

    public String getProfileLastSuccessfulProcTime() {
        return this.profileLastSuccessfulProcTime;
    }

    public void setProfileLastSuccessfulProcTime(String string) {
        this.profileLastSuccessfulProcTime = string;
    }
}

