/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.provisioning;

import java.util.Vector;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import oracle.ldap.util.Property;
import oracle.ldap.util.PropertySet;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.Util;
import oracle.ldap.util.provisioning.ProvisioningCmdArgs;
import oracle.ldap.util.provisioning.ProvisioningInboundProfileV2;
import oracle.ldap.util.provisioning.ProvisioningOutboundProfileV2;
import oracle.ldap.util.provisioning.ProvisioningProfile;

public class ProvisioningProfileV2
extends ProvisioningProfile {
    public static final int MODE_INBOUND = 1;
    public static final int MODE_OUTBOUND = 2;
    public static final int MODE_BOTH = 3;
    public static final String INBOUND_RDN = "cn=ApplicationToOID";
    public static final String OUTBOUND_RDN = "cn=OIDToApplication";
    public static final String INBOUND_RDN_VAL = "ApplicationToOID";
    public static final String OUTBOUND_RDN_VAL = "OIDToApplication";
    protected String profileStatus;
    protected int profileMode = 2;
    protected String profileMaxEventPerInvocation;
    protected String profileMaxEventPerSchedule;
    protected String profileMaxErrors;
    protected String crypt_key;
    public static final String ATTR_MaxEventPerInvocation = "orclODIPProfileMaxEventsPerInvocation";
    public static final String ATTR_MaxEventPerSchedule = "orclODIPProfileMaxEventsPerSchedule";
    public static final String ATTR_ProfileMaxErrors = "orclODIPProfileMaxErrors";
    public static final String ATTR_CryptKey = "orclODIPEncryptedAttrKey";
    protected ProvisioningInboundProfileV2 inBoundV2Profile;
    protected ProvisioningOutboundProfileV2 outBoundV2Profile;
    public static final String PROV_PROFILE_VERSION = "2.0";

    public ProvisioningProfileV2() {
    }

    public ProvisioningProfileV2(DirContext dirContext, String string) throws Exception {
        this.readV2ProfileFromDir(dirContext, string);
        this.readInboundV2ProfileFromDir(dirContext, string);
        this.readOutboundV2ProfileFromDir(dirContext, string);
        if (!this.getInboundProfilev2().isValid()) {
            this.setProfileMode(2);
        } else if (!this.getOutboundProfilev2().isValid()) {
            this.setProfileMode(1);
        } else {
            this.setProfileMode(3);
        }
    }

    public ProvisioningProfileV2(DirContext dirContext, String string, String string2) throws Exception {
        String string3 = ProvisioningProfile.composeProfileDN(dirContext, string, string2);
        this.readV2ProfileFromDir(dirContext, string3);
        this.readInboundV2ProfileFromDir(dirContext, string3);
        this.readOutboundV2ProfileFromDir(dirContext, string3);
        if (!this.getInboundProfilev2().isValid()) {
            this.setProfileMode(2);
        } else if (!this.getOutboundProfilev2().isValid()) {
            this.setProfileMode(1);
        } else {
            this.setProfileMode(3);
        }
    }

    public static void processV2(DirContext dirContext, ProvisioningCmdArgs provisioningCmdArgs) throws Exception {
        int n = 0;
        String string = "";
        ProvisioningProfileV2 provisioningProfileV2 = null;
        switch (provisioningCmdArgs.getOperation()) {
            case 1: {
                try {
                    provisioningProfileV2 = ProvisioningProfileV2.createNewProfileV2(dirContext, provisioningCmdArgs);
                    if (ProvisioningProfile.apimode) break;
                    System.out.println(ProvisioningProfile.resBundle.getString("PROV_PROFILE_SUCCESS"));
                    System.out.println(" Profile Name: " + provisioningProfileV2.getProfileName());
                    break;
                }
                catch (Exception exception) {
                    string = ProvisioningProfile.getResultStr(exception, "PROV_PROFILE_FAILURE");
                    if (!ProvisioningProfile.apimode) {
                        System.out.println(string);
                        break;
                    }
                    throw new Exception(string);
                }
            }
            case 2: {
                try {
                    provisioningProfileV2 = new ProvisioningProfileV2(dirContext, provisioningCmdArgs.get("APPLICATION_DN"), provisioningCmdArgs.get("ORGANIZATION_DN"));
                    ProvisioningCmdArgs.LOG("Updating Profile(s)");
                    int n2 = provisioningProfileV2.getProfileMode();
                    String string2 = provisioningCmdArgs.get("PROFILE_MODE");
                    provisioningProfileV2.checkIntfVersion(provisioningCmdArgs);
                    boolean bl = false;
                    if (n2 == 1) {
                        if (!string2.equalsIgnoreCase("INBOUND")) {
                            throw new Exception("Profile currently INBOUND.Cannot Disable");
                        }
                        provisioningProfileV2.getInboundProfilev2().disable(dirContext);
                        ProvisioningCmdArgs.LOG("Disabled InBound Profile");
                    } else if (n2 == 2) {
                        if (!string2.equalsIgnoreCase("OUTBOUND")) {
                            throw new Exception("Profile currently OUTBOUND.Cannot Disable");
                        }
                        provisioningProfileV2.getOutboundProfilev2().disable(dirContext);
                        ProvisioningCmdArgs.LOG("Disabled OutBound Profile");
                    } else if (string2.equalsIgnoreCase("INBOUND")) {
                        provisioningProfileV2.getInboundProfilev2().disable(dirContext);
                        ProvisioningCmdArgs.LOG("Disabled InBound Profile");
                    } else if (string2.equalsIgnoreCase("OUTBOUND")) {
                        provisioningProfileV2.getOutboundProfilev2().disable(dirContext);
                        ProvisioningCmdArgs.LOG("Disabled OutBound Profile");
                    } else {
                        provisioningProfileV2.getInboundProfilev2().disable(dirContext);
                        ProvisioningCmdArgs.LOG("Disabled InBound Profile");
                        provisioningProfileV2.getOutboundProfilev2().disable(dirContext);
                        ProvisioningCmdArgs.LOG("Disabled OutBound Profile");
                        ProvisioningCmdArgs.LOG("Disabled Main Profile");
                    }
                    if (ProvisioningProfile.apimode) break;
                    System.out.println(ProvisioningProfile.resBundle.getString("PROV_PROFILE_DISABLED"));
                    break;
                }
                catch (Exception exception) {
                    string = ProvisioningProfile.getResultStr(exception, "PROV_PROFILE_MOD_FAILURE");
                    if (!ProvisioningProfile.apimode) {
                        System.out.println(string);
                        break;
                    }
                    throw new Exception(string);
                }
            }
            case 3: {
                try {
                    provisioningProfileV2 = new ProvisioningProfileV2(dirContext, provisioningCmdArgs.get("APPLICATION_DN"), provisioningCmdArgs.get("ORGANIZATION_DN"));
                    ProvisioningCmdArgs.LOG("Updating Profile(s)");
                    int n3 = provisioningProfileV2.getProfileMode();
                    String string3 = provisioningCmdArgs.get("PROFILE_MODE");
                    provisioningProfileV2.checkIntfVersion(provisioningCmdArgs);
                    if (n3 == 1) {
                        if (!string3.equalsIgnoreCase("INBOUND")) {
                            throw new Exception("Profile currently INBOUND.Cannot Enable");
                        }
                        provisioningProfileV2.getInboundProfilev2().enable(dirContext);
                        ProvisioningCmdArgs.LOG("Enabled InBound Profile");
                    } else if (n3 == 2) {
                        if (!string3.equalsIgnoreCase("OUTBOUND")) {
                            throw new Exception("Profile currently OUTBOUND.Cannot Enable");
                        }
                        provisioningProfileV2.getOutboundProfilev2().enable(dirContext);
                        ProvisioningCmdArgs.LOG("Enabled OutBound Profile");
                    } else if (string3.equalsIgnoreCase("INBOUND")) {
                        provisioningProfileV2.getInboundProfilev2().enable(dirContext);
                        ProvisioningCmdArgs.LOG("Enabled InBound Profile");
                    } else if (string3.equalsIgnoreCase("OUTBOUND")) {
                        provisioningProfileV2.getOutboundProfilev2().enable(dirContext);
                        ProvisioningCmdArgs.LOG("Enabled OutBound Profile");
                    } else {
                        provisioningProfileV2.getInboundProfilev2().enable(dirContext);
                        ProvisioningCmdArgs.LOG("Enabled InBound Profile");
                        provisioningProfileV2.getOutboundProfilev2().enable(dirContext);
                        ProvisioningCmdArgs.LOG("Enabled OutBound Profile");
                    }
                    if (ProvisioningProfile.apimode) break;
                    System.out.println(ProvisioningProfile.resBundle.getString("PROV_PROFILE_ENABLED"));
                    break;
                }
                catch (Exception exception) {
                    string = ProvisioningProfile.getResultStr(exception, "PROV_PROFILE_MOD_FAILURE");
                    if (!ProvisioningProfile.apimode) {
                        System.out.println(string);
                        break;
                    }
                    throw new Exception(string);
                }
            }
            case 4: {
                try {
                    provisioningProfileV2 = new ProvisioningProfileV2(dirContext, provisioningCmdArgs.get("APPLICATION_DN"), provisioningCmdArgs.get("ORGANIZATION_DN"));
                    ProvisioningCmdArgs.LOG("Getting Profile(s) Status");
                    int n4 = provisioningProfileV2.getProfileMode();
                    provisioningProfileV2.checkIntfVersion(provisioningCmdArgs);
                    if (n4 == 1) {
                        provisioningProfileV2.status(dirContext);
                        provisioningProfileV2.getInboundProfilev2().status(dirContext);
                        ProvisioningCmdArgs.LOG("InBound Profile Status Success");
                        break;
                    }
                    if (n4 == 2) {
                        provisioningProfileV2.status(dirContext);
                        provisioningProfileV2.getOutboundProfilev2().status(dirContext);
                        ProvisioningCmdArgs.LOG("OutBound Profile Status Success");
                        break;
                    }
                    provisioningProfileV2.status(dirContext);
                    provisioningProfileV2.getInboundProfilev2().status(dirContext);
                    provisioningProfileV2.getOutboundProfilev2().status(dirContext);
                    ProvisioningCmdArgs.LOG("Main Profile(s) Status");
                    break;
                }
                catch (Exception exception) {
                    string = ProvisioningProfile.getResultStr(exception, "PROV_PROFILE_NO_STATUS");
                    if (!ProvisioningProfile.apimode) {
                        System.out.println(string);
                        break;
                    }
                    throw new Exception(string);
                }
            }
            case 5: {
                try {
                    provisioningProfileV2 = new ProvisioningProfileV2(dirContext, provisioningCmdArgs.get("APPLICATION_DN"), provisioningCmdArgs.get("ORGANIZATION_DN"));
                    ProvisioningCmdArgs.LOG("Deleting Profile(s)");
                    int n5 = provisioningProfileV2.getProfileMode();
                    ProvisioningCmdArgs.LOG("Profile Mode : " + n5);
                    provisioningProfileV2.checkIntfVersion(provisioningCmdArgs);
                    String string4 = provisioningCmdArgs.get("PROFILE_MODE");
                    if (n5 == 1) {
                        if (!string4.equalsIgnoreCase("INBOUND")) {
                            throw new Exception("Profile currently INBOUND. Cannot Delete");
                        }
                        provisioningProfileV2.getInboundProfilev2().delete(dirContext);
                        ProvisioningCmdArgs.LOG("Deleted InBound Profile");
                        provisioningProfileV2.delete(dirContext);
                        ProvisioningCmdArgs.LOG("Deleted Main Profile");
                    } else if (n5 == 2) {
                        if (!string4.equalsIgnoreCase("OUTBOUND")) {
                            throw new Exception("Profile currently OUTBOUND.Cannot Delete");
                        }
                        provisioningProfileV2.getOutboundProfilev2().delete(dirContext);
                        ProvisioningCmdArgs.LOG("Deleted OutBound Profile");
                        provisioningProfileV2.delete(dirContext);
                        ProvisioningCmdArgs.LOG("Deleted Main Profile");
                    } else {
                        if (!string4.equalsIgnoreCase("BOTH")) {
                            throw new Exception("Profile currently BOTH. Please use PROFILE_MODE=BOTH to Delete");
                        }
                        provisioningProfileV2.getInboundProfilev2().delete(dirContext);
                        ProvisioningCmdArgs.LOG("Deleted InBound Profile");
                        provisioningProfileV2.getOutboundProfilev2().delete(dirContext);
                        ProvisioningCmdArgs.LOG("Deleted OutBound Profile");
                        provisioningProfileV2.delete(dirContext);
                        ProvisioningCmdArgs.LOG("Deleted Main Profile");
                    }
                    if (ProvisioningProfile.apimode) break;
                    System.out.println(ProvisioningProfile.resBundle.getString("PROV_PROFILE_DELETED"));
                    break;
                }
                catch (Exception exception) {
                    string = ProvisioningProfile.getResultStr(exception, "PROV_PROFILE_DELETE_FAILURE");
                    if (!ProvisioningProfile.apimode) {
                        System.out.println(string);
                        break;
                    }
                    throw new Exception(string);
                }
            }
            case 6: {
                try {
                    provisioningProfileV2 = new ProvisioningProfileV2(dirContext, provisioningCmdArgs.get("APPLICATION_DN"), provisioningCmdArgs.get("ORGANIZATION_DN"));
                    ProvisioningCmdArgs.LOG("Resetting Profile(s)");
                    int n6 = provisioningProfileV2.getProfileMode();
                    String string5 = provisioningCmdArgs.get("PROFILE_MODE");
                    provisioningProfileV2.checkIntfVersion(provisioningCmdArgs);
                    if (n6 == 1) {
                        if (!string5.equalsIgnoreCase("INBOUND")) {
                            throw new Exception("Profile currently INBOUND.Cannot Reset");
                        }
                        provisioningProfileV2.getInboundProfilev2().reset(dirContext);
                        ProvisioningCmdArgs.LOG("Reset InBound Profile");
                    } else if (n6 == 2) {
                        if (!string5.equalsIgnoreCase("OUTBOUND")) {
                            throw new Exception("Profile currently OUTBOUND.Cannot Reset");
                        }
                        provisioningProfileV2.getOutboundProfilev2().reset(dirContext);
                        ProvisioningCmdArgs.LOG("Reset OutBound Profile");
                    } else {
                        if (string5.equalsIgnoreCase("INBOUND")) {
                            provisioningProfileV2.getInboundProfilev2().reset(dirContext);
                            ProvisioningCmdArgs.LOG("Reset InBound Profile");
                        }
                        if (string5.equalsIgnoreCase("OUTBOUND")) {
                            provisioningProfileV2.getOutboundProfilev2().reset(dirContext);
                            ProvisioningCmdArgs.LOG("Reset OutBound Profile");
                        }
                    }
                    if (ProvisioningProfile.apimode) break;
                    System.out.println(ProvisioningProfile.resBundle.getString("PROV_PROFILE_RESET_SUCCESS"));
                    break;
                }
                catch (Exception exception) {
                    string = ProvisioningProfile.getResultStr(exception, "PROV_PROFILE_RESET_FAILURE");
                    if (!ProvisioningProfile.apimode) {
                        System.out.println(string);
                        break;
                    }
                    throw new Exception(string);
                }
            }
            case 7: {
                try {
                    provisioningProfileV2 = new ProvisioningProfileV2(dirContext, provisioningCmdArgs.get("APPLICATION_DN"), provisioningCmdArgs.get("ORGANIZATION_DN"));
                    ProvisioningCmdArgs.LOG("Modifying Profile(s)");
                    int n7 = provisioningProfileV2.getProfileMode();
                    String string6 = provisioningCmdArgs.get("PROFILE_MODE");
                    provisioningProfileV2.checkIntfVersion(provisioningCmdArgs);
                    if (n7 == 1) {
                        if (!string6.equalsIgnoreCase("INBOUND")) {
                            throw new Exception("Profile currently INBOUND.Cannot Modify");
                        }
                        provisioningProfileV2.getInboundProfilev2().modify(dirContext, provisioningCmdArgs);
                        ProvisioningCmdArgs.LOG("Modified InBound Profile");
                        provisioningProfileV2.modify(dirContext, provisioningCmdArgs);
                        ProvisioningCmdArgs.LOG("Modified Main Profile");
                    } else if (n7 == 2) {
                        if (!string6.equalsIgnoreCase("OUTBOUND")) {
                            throw new Exception("Profile currently OUTBOUND.Cannot Modify");
                        }
                        provisioningProfileV2.getOutboundProfilev2().modify(dirContext, provisioningCmdArgs);
                        ProvisioningCmdArgs.LOG("Modified OutBound Profile");
                        provisioningProfileV2.modify(dirContext, provisioningCmdArgs);
                        ProvisioningCmdArgs.LOG("Modified Main Profile");
                    } else {
                        if (!string6.equalsIgnoreCase("OUTBOUND")) {
                            provisioningProfileV2.getInboundProfilev2().modify(dirContext, provisioningCmdArgs);
                            ProvisioningCmdArgs.LOG("Modified InBound Profile");
                        }
                        if (!string6.equalsIgnoreCase("INBOUND")) {
                            provisioningProfileV2.getOutboundProfilev2().modify(dirContext, provisioningCmdArgs);
                            ProvisioningCmdArgs.LOG("Modified OutBound Profile");
                        }
                        provisioningProfileV2.modify(dirContext, provisioningCmdArgs);
                        ProvisioningCmdArgs.LOG("Modified Main Profile");
                    }
                    if (ProvisioningProfile.apimode) break;
                    System.out.println(ProvisioningProfile.resBundle.getString("PROV_PROFILE_MOD_SUCCESS"));
                    break;
                }
                catch (Exception exception) {
                    string = ProvisioningProfile.getResultStr(exception, "PROV_PROFILE_MOD_FAILURE");
                    if (!ProvisioningProfile.apimode) {
                        System.out.println(string);
                        break;
                    }
                    throw new Exception(string);
                }
            }
            default: {
                if (!ProvisioningProfile.apimode) {
                    System.out.println("Invalid Operation");
                    n = -1;
                    break;
                }
                throw new Exception("Invalid Operation argument!! ");
            }
        }
    }

    public void modify(DirContext dirContext, ProvisioningCmdArgs provisioningCmdArgs) throws Exception {
        Vector vector;
        int n = 0;
        ModificationItem[] modificationItemArray = new ModificationItem[64];
        BasicAttribute basicAttribute = null;
        if (provisioningCmdArgs.get("SCHEDULE") != null) {
            int n2 = n++;
            modificationItemArray[n2] = new ModificationItem(2, new BasicAttribute("orclODIPProfileSchedule", provisioningCmdArgs.get("SCHEDULE")));
        }
        if (provisioningCmdArgs.get("MAX_RETRIES") != null) {
            int n3 = n++;
            modificationItemArray[n3] = new ModificationItem(2, new BasicAttribute("orclODIPProfileMaxRetries", provisioningCmdArgs.get("MAX_RETRIES")));
        }
        if (provisioningCmdArgs.get("INTERFACE_NAME") != null) {
            int n4 = n++;
            modificationItemArray[n4] = new ModificationItem(2, new BasicAttribute("orclODIPProfileInterfaceName", provisioningCmdArgs.get("INTERFACE_NAME")));
        }
        if (provisioningCmdArgs.get("INTERFACE_TYPE") != null) {
            int n5 = n++;
            modificationItemArray[n5] = new ModificationItem(2, new BasicAttribute("orclODIPProfileInterfaceType", provisioningCmdArgs.get("INTERFACE_TYPE")));
        }
        if (provisioningCmdArgs.get("INTERFACE_VERSION") != null) {
            int n6 = n++;
            modificationItemArray[n6] = new ModificationItem(2, new BasicAttribute("orclODIPProfileInterfaceVersion", provisioningCmdArgs.get("INTERFACE_VERSION")));
        }
        if (provisioningCmdArgs.get("INTERFACE_CONNECT_INFO") != null) {
            int n7 = n++;
            modificationItemArray[n7] = new ModificationItem(2, new BasicAttribute("orclODIPProfileInterfaceConnectInformation", provisioningCmdArgs.get("INTERFACE_CONNECT_INFO")));
        }
        if ((vector = provisioningCmdArgs.getVector("INTERFACE_ADDITIONAL_INFO")) != null) {
            ProvisioningCmdArgs.LOG("Updating Attribute :orclODIPProfileInterfaceAdditionalInformation");
            basicAttribute = new BasicAttribute("orclODIPProfileInterfaceAdditionalInformation");
            int n8 = 0;
            while (n8 < vector.size()) {
                basicAttribute.add(vector.elementAt(n8));
                ++n8;
            }
            modificationItemArray[n++] = new ModificationItem(2, basicAttribute);
        }
        if (provisioningCmdArgs.get("MAX_EVENTS_PER_INVOCATION") != null) {
            int n9 = n++;
            modificationItemArray[n9] = new ModificationItem(2, new BasicAttribute(ATTR_MaxEventPerInvocation, provisioningCmdArgs.get("MAX_EVENTS_PER_INVOCATION")));
        }
        if (provisioningCmdArgs.get("MAX_EVENTS_PER_SCHEDULE") != null) {
            int n10 = n++;
            modificationItemArray[n10] = new ModificationItem(2, new BasicAttribute(ATTR_MaxEventPerSchedule, provisioningCmdArgs.get("MAX_EVENTS_PER_SCHEDULE")));
        }
        if (provisioningCmdArgs.get("PROFILE_GROUP") != null) {
            int n11 = n++;
            modificationItemArray[n11] = new ModificationItem(2, new BasicAttribute("orclODIPProfileExecGroupID", provisioningCmdArgs.get("PROFILE_GROUP")));
        }
        if (provisioningCmdArgs.get("PROFILE_DEBUG") != null) {
            int n12 = n++;
            modificationItemArray[n12] = new ModificationItem(2, new BasicAttribute("orclODIPProfileDebugLevel", provisioningCmdArgs.get("PROFILE_DEBUG")));
        }
        if (provisioningCmdArgs.get("CRYPT_KEY") != null) {
            int n13 = n++;
            modificationItemArray[n13] = new ModificationItem(2, new BasicAttribute(ATTR_CryptKey, provisioningCmdArgs.get("CRYPT_KEY")));
        }
        if (provisioningCmdArgs.get("PROFILE_MAX_ERRORS") != null) {
            int n14 = n++;
            modificationItemArray[n14] = new ModificationItem(2, new BasicAttribute(ATTR_ProfileMaxErrors, provisioningCmdArgs.get("PROFILE_MAX_ERRORS")));
        }
        ModificationItem[] modificationItemArray2 = new ModificationItem[n];
        System.arraycopy(modificationItemArray, 0, modificationItemArray2, 0, n);
        ProvisioningCmdArgs.LOG("Modifying entry : (" + this.profileDN + ")");
        dirContext.modifyAttributes(this.profileDN, modificationItemArray2);
    }

    public void disable(DirContext dirContext) throws Exception {
        if (this.getProfileStatus().equalsIgnoreCase("DISABLED") && !ProvisioningProfile.apimode) {
            System.out.println(ProvisioningProfile.resBundle.getString("PROV_PROFILE_ALREADY_DISABLED"));
        }
        ProvisioningCmdArgs.LOG("Disabling entry : (" + this.profileDN + ")");
        ModificationItem[] modificationItemArray = new ModificationItem[1];
        modificationItemArray[0] = new ModificationItem(2, new BasicAttribute("orclStatus", "DISABLED"));
        dirContext.modifyAttributes(this.profileDN, modificationItemArray);
    }

    public void enable(DirContext dirContext) throws Exception {
        if (this.getProfileStatus().equalsIgnoreCase("ENABLED") && !ProvisioningProfile.apimode) {
            System.out.println(ProvisioningProfile.resBundle.getString("PROV_PROFILE_ALREADY_ENABLED"));
        }
        ProvisioningCmdArgs.LOG("Enabling entry : (" + this.profileDN + ")");
        ModificationItem[] modificationItemArray = new ModificationItem[1];
        modificationItemArray[0] = new ModificationItem(2, new BasicAttribute("orclStatus", "ENABLED"));
        dirContext.modifyAttributes(this.profileDN, modificationItemArray);
    }

    public void reset(DirContext dirContext) throws Exception {
        ModificationItem[] modificationItemArray = new ModificationItem[1];
        ProvisioningCmdArgs.LOG("Resetting entry : (" + this.profileDN + ")");
        if (this.getProfileProcessingErrors() != null) {
            modificationItemArray[0] = new ModificationItem(3, new BasicAttribute("orclODIPProfileProcessingErrors"));
            dirContext.modifyAttributes(this.profileDN, modificationItemArray);
        }
    }

    public void delete(DirContext dirContext) throws Exception {
        ProvisioningCmdArgs.LOG("Deleting entry : (" + this.profileDN + ")");
        dirContext.destroySubcontext(this.profileDN);
    }

    public void status(DirContext dirContext) throws Exception {
    }

    public static ProvisioningProfileV2 createNewProfileV2(DirContext dirContext, ProvisioningCmdArgs provisioningCmdArgs) throws Exception {
        ProvisioningProfileV2 provisioningProfileV2 = null;
        boolean bl = false;
        Object var4_4 = null;
        Object var5_5 = null;
        String string = provisioningCmdArgs.get("PROFILE_MODE");
        int n = 2;
        if (string.equalsIgnoreCase("OUTBOUND")) {
            n = 2;
        }
        if (string.equalsIgnoreCase("INBOUND")) {
            n = 1;
        }
        if (string.equalsIgnoreCase("BOTH")) {
            n = 3;
        }
        String string2 = ProvisioningProfile.composeProfileDN(dirContext, provisioningCmdArgs.get("APPLICATION_DN"), provisioningCmdArgs.get("ORGANIZATION_DN"));
        if (n != 2 && (bl = ProvisioningProfile.directoryEntryExists(dirContext, "cn=ApplicationToOID," + string2))) {
            throw new Exception("Provisioning Profile Already Exists..");
        }
        if (n != 1 && (bl = ProvisioningProfile.directoryEntryExists(dirContext, "cn=OIDToApplication," + string2))) {
            throw new Exception("Provisioning Profile Already Exists..");
        }
        bl = ProvisioningProfile.directoryEntryExists(dirContext, string2);
        if (bl) {
            throw new Exception("Provisioning Profile Already Exists..");
        }
        BasicAttribute basicAttribute = null;
        BasicAttributes basicAttributes = new BasicAttributes();
        BasicAttribute basicAttribute2 = new BasicAttribute("objectclass");
        basicAttribute2.add("top");
        basicAttribute2.add("orclODIPProvisioningIntegrationProfileV2");
        basicAttributes.put(basicAttribute2);
        basicAttribute = new BasicAttribute("orclODIPProfileName");
        basicAttribute.add(ProvisioningProfile.getRDNAttrValue(dirContext, string2));
        basicAttributes.put(basicAttribute);
        basicAttribute = new BasicAttribute("orclVersion");
        basicAttribute.add(PROV_PROFILE_VERSION);
        basicAttributes.put(basicAttribute);
        basicAttribute = new BasicAttribute("orclStatus");
        basicAttribute.add(provisioningCmdArgs.get("PROFILE_STATUS"));
        basicAttributes.put(basicAttribute);
        basicAttribute = new BasicAttribute("orclODIPProvisioningAppName");
        basicAttribute.add(ProvisioningProfile.getRDNAttrValue(dirContext, provisioningCmdArgs.get("APPLICATION_DN")));
        basicAttributes.put(basicAttribute);
        basicAttribute = new BasicAttribute("orclODIPProvisioningOrgName");
        basicAttribute.add(ProvisioningProfile.getRDNAttrValue(dirContext, provisioningCmdArgs.get("ORGANIZATION_DN")));
        basicAttributes.put(basicAttribute);
        basicAttribute = new BasicAttribute("orclODIPProvisioningAppGUID");
        basicAttribute.add(ProvisioningProfile.getDirectoryEntryGUID(dirContext, provisioningCmdArgs.get("APPLICATION_DN")));
        basicAttributes.put(basicAttribute);
        basicAttribute = new BasicAttribute("orclODIPProvisioningOrgGUID");
        basicAttribute.add(ProvisioningProfile.getDirectoryEntryGUID(dirContext, provisioningCmdArgs.get("ORGANIZATION_DN")));
        basicAttributes.put(basicAttribute);
        basicAttribute = new BasicAttribute("orclODIPProfileSchedule");
        basicAttribute.add(provisioningCmdArgs.get("SCHEDULE"));
        basicAttributes.put(basicAttribute);
        basicAttribute = new BasicAttribute("orclODIPProfileMaxRetries");
        basicAttribute.add(provisioningCmdArgs.get("MAX_RETRIES"));
        basicAttributes.put(basicAttribute);
        basicAttribute = new BasicAttribute("orclODIPProfileInterfaceName");
        basicAttribute.add(provisioningCmdArgs.get("INTERFACE_NAME"));
        basicAttributes.put(basicAttribute);
        basicAttribute = new BasicAttribute("orclODIPProfileInterfaceType");
        basicAttribute.add(provisioningCmdArgs.get("INTERFACE_TYPE"));
        basicAttributes.put(basicAttribute);
        basicAttribute = new BasicAttribute("orclODIPProfileInterfaceVersion");
        basicAttribute.add(provisioningCmdArgs.get("INTERFACE_VERSION"));
        basicAttributes.put(basicAttribute);
        basicAttribute = new BasicAttribute("orclODIPProfileInterfaceConnectInformation");
        basicAttribute.add(provisioningCmdArgs.get("INTERFACE_CONNECT_INFO"));
        basicAttributes.put(basicAttribute);
        Vector vector = null;
        vector = provisioningCmdArgs.getVector("INTERFACE_ADDITIONAL_INFO");
        if (vector != null) {
            basicAttribute = new BasicAttribute("orclODIPProfileInterfaceAdditionalInformation");
            int n2 = 0;
            while (n2 < vector.size()) {
                basicAttribute.add((String)vector.elementAt(n2));
                ++n2;
            }
            basicAttributes.put(basicAttribute);
        }
        basicAttribute = new BasicAttribute(ATTR_MaxEventPerInvocation);
        basicAttribute.add(provisioningCmdArgs.get("MAX_EVENTS_PER_INVOCATION"));
        basicAttributes.put(basicAttribute);
        basicAttribute = new BasicAttribute(ATTR_MaxEventPerSchedule);
        basicAttribute.add(provisioningCmdArgs.get("MAX_EVENTS_PER_SCHEDULE"));
        basicAttributes.put(basicAttribute);
        basicAttribute = new BasicAttribute("orclODIPProfileExecGroupID");
        basicAttribute.add(provisioningCmdArgs.get("PROFILE_GROUP"));
        basicAttributes.put(basicAttribute);
        basicAttribute = new BasicAttribute("orclODIPProfileDebugLevel");
        basicAttribute.add(provisioningCmdArgs.get("PROFILE_DEBUG"));
        basicAttributes.put(basicAttribute);
        basicAttribute = new BasicAttribute(ATTR_CryptKey);
        basicAttribute.add(provisioningCmdArgs.get("CRYPT_KEY"));
        basicAttributes.put(basicAttribute);
        basicAttribute = new BasicAttribute(ATTR_ProfileMaxErrors);
        basicAttribute.add(provisioningCmdArgs.get("PROFILE_MAX_ERRORS"));
        basicAttributes.put(basicAttribute);
        ProvisioningCmdArgs.LOG(((Object)basicAttributes).toString());
        DirContext dirContext2 = dirContext.createSubcontext(string2, (Attributes)basicAttributes);
        ProvisioningCmdArgs.LOG("Created Main Profile Entry Successfully");
        ProvisioningInboundProfileV2 provisioningInboundProfileV2 = null;
        if (n != 2) {
            provisioningInboundProfileV2 = ProvisioningInboundProfileV2.createNewInboundProfileV2(dirContext, provisioningCmdArgs);
        }
        ProvisioningOutboundProfileV2 provisioningOutboundProfileV2 = null;
        if (n != 1) {
            provisioningOutboundProfileV2 = ProvisioningOutboundProfileV2.createNewOutboundProfileV2(dirContext, provisioningCmdArgs);
        }
        provisioningProfileV2 = new ProvisioningProfileV2(dirContext, string2);
        provisioningProfileV2.setProfileMode(n);
        ProvisioningCmdArgs.LOG("Created Main Profile Object Successfully");
        if (!ProvisioningProfile.apimode) {
            System.out.println("Application : " + provisioningProfileV2.getProvisioningProfileAppName());
            System.out.println("Organization : " + provisioningProfileV2.getProvisioningProfileOrgName());
            System.out.println("Status : " + provisioningProfileV2.getProfileStatus());
            System.out.println("Schedule : " + provisioningProfileV2.getProfileSchedule());
            System.out.println("Retries : " + provisioningProfileV2.getProfileMaxRetries());
            System.out.println("Execution Group : " + provisioningProfileV2.getProfileGroup());
            System.out.println("Interface Name : " + provisioningProfileV2.getProfileInterfaceName());
            System.out.println("Interface Type : " + provisioningProfileV2.getProfileInterfaceType());
            System.out.println("Interface Version : " + provisioningProfileV2.getProfileInterfaceVersion());
            System.out.println("Interface Connection Info : ---");
            System.out.println("Interface Additional Info : " + provisioningProfileV2.getProfileInterfaceAdditionalInfo());
            if (provisioningInboundProfileV2 != null) {
                System.out.println("Mapping Rules : " + provisioningProfileV2.getInboundProfilev2().getProfileMapRules());
                System.out.println("Event Permitted Operations : " + provisioningProfileV2.getInboundProfilev2().getProfilePermttdOprns());
            }
            if (provisioningOutboundProfileV2 != null) {
                System.out.println("Last Applied Change Number : " + provisioningProfileV2.getOutboundProfilev2().getProfileChgLogLastAppliedChangeNumber());
                System.out.println("Event Subscriptions : " + provisioningProfileV2.getOutboundProfilev2().getProvisioningProfileEventSubscription());
            }
        }
        return provisioningProfileV2;
    }

    private void readV2ProfileFromDir(DirContext dirContext, String string) throws Exception {
        String[] stringArray = new String[]{"*", "orclguid"};
        Property property = null;
        ProvisioningCmdArgs.LOG("Searching For MAIN Profile v2 : " + string);
        PropertySetCollection propertySetCollection = Util.getEntryDetails(dirContext, string, "objectclass=*", 0, stringArray);
        PropertySet propertySet = propertySetCollection.getPropertySet(0);
        this.profileDN = string;
        property = propertySet.getProperty("orclODIPProfileName");
        if (property != null) {
            this.setProfileName((String)property.getValue(0));
        }
        if ((property = propertySet.getProperty("orclStatus")) != null) {
            this.setProfileStatus((String)property.getValue(0));
        }
        if ((property = propertySet.getProperty("orclVersion")) != null) {
            this.setProfileVersion((String)property.getValue(0));
        }
        if ((property = propertySet.getProperty("orclODIPProfileSchedule")) != null) {
            this.setProfileSchedule((String)property.getValue(0));
        }
        if ((property = propertySet.getProperty("orclODIPProfileMaxRetries")) != null) {
            this.setProfileMaxRetries((String)property.getValue(0));
        }
        if ((property = propertySet.getProperty(ATTR_MaxEventPerInvocation)) != null) {
            this.setProfileMaxEventPerInvc((String)property.getValue(0));
        }
        if ((property = propertySet.getProperty(ATTR_MaxEventPerSchedule)) != null) {
            this.setProfileMaxEventPerSch((String)property.getValue(0));
        }
        if ((property = propertySet.getProperty("orclODIPProfileExecGroupID")) != null) {
            this.setProfileGroup((String)property.getValue(0));
        }
        if ((property = propertySet.getProperty(ATTR_CryptKey)) != null) {
            this.setProfileCryptKey((String)property.getValue(0));
        }
        if ((property = propertySet.getProperty(ATTR_ProfileMaxErrors)) != null) {
            this.setProfileMaxErrors((String)property.getValue(0));
        }
        if ((property = propertySet.getProperty("orclODIPProfileInterfaceName")) != null) {
            this.setProfileInterfaceName((String)property.getValue(0));
        }
        if ((property = propertySet.getProperty("orclODIPProfileInterfaceType")) != null) {
            this.setProfileInterfaceType((String)property.getValue(0));
        }
        if ((property = propertySet.getProperty("orclODIPProfileInterfaceVersion")) != null) {
            this.setProfileInterfaceVersion((String)property.getValue(0));
        }
        if ((property = propertySet.getProperty("orclODIPProfileInterfaceConnectInformation")) != null) {
            this.setProfileInterfaceConnectInfo((String)property.getValue(0));
        }
        if ((property = propertySet.getProperty("orclODIPProfileInterfaceAdditionalInformation")) != null && property.size() > 0) {
            Vector<Object> vector = new Vector<Object>();
            int n = 0;
            while (n < property.size()) {
                vector.addElement(property.getValue(n));
                ++n;
            }
            this.setProfileInterfaceAdditionalInfo(vector);
        }
        if ((property = propertySet.getProperty("orclODIPProvisioningAppName")) != null) {
            this.setProvisioningProfileAppName((String)property.getValue(0));
        }
        if ((property = propertySet.getProperty("orclODIPProvisioningAppGUID")) != null) {
            this.setProvisioningProfileAppGUID((String)property.getValue(0));
        }
        if ((property = propertySet.getProperty("orclODIPProvisioningOrgName")) != null) {
            this.setProvisioningProfileOrgName((String)property.getValue(0));
        }
        if ((property = propertySet.getProperty("orclODIPProvisioningOrgGUID")) != null) {
            this.setProvisioningProfileOrgGUID((String)property.getValue(0));
        }
    }

    public void readInboundV2ProfileFromDir(DirContext dirContext, String string) throws Exception {
        this.inBoundV2Profile = new ProvisioningInboundProfileV2(dirContext, string);
    }

    public void readOutboundV2ProfileFromDir(DirContext dirContext, String string) throws Exception {
        this.outBoundV2Profile = new ProvisioningOutboundProfileV2(dirContext, string);
    }

    public ProvisioningInboundProfileV2 getInboundProfilev2() {
        return this.inBoundV2Profile;
    }

    public void setInboundProfilev2(ProvisioningInboundProfileV2 provisioningInboundProfileV2) {
        this.inBoundV2Profile = provisioningInboundProfileV2;
    }

    public ProvisioningOutboundProfileV2 getOutboundProfilev2() {
        return this.outBoundV2Profile;
    }

    public void setOutboundProfilev2(ProvisioningOutboundProfileV2 provisioningOutboundProfileV2) {
        this.outBoundV2Profile = provisioningOutboundProfileV2;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String string) {
        this.profileName = string;
    }

    public int getProfileMode() {
        return this.profileMode;
    }

    public void setProfileMode(int n) {
        this.profileMode = n;
    }

    public String getProfileStatus() {
        return this.profileStatus;
    }

    public void setProfileStatus(String string) {
        this.profileStatus = string;
    }

    public String getProfileVersion() {
        return this.profileVersion;
    }

    public void setProfileVersion(String string) {
        this.profileVersion = string;
    }

    public String getProfileSchedule() {
        return this.profileSchedule;
    }

    public void setProfileSchedule(String string) {
        this.profileSchedule = string;
    }

    public String getProfileMaxRetries() {
        return this.profileMaxRetries;
    }

    public void setProfileMaxRetries(String string) {
        this.profileMaxRetries = string;
    }

    public void setProfileMaxEventPerInvc(String string) {
        this.profileMaxEventPerInvocation = string;
    }

    public void setProfileMaxEventPerSch(String string) {
        this.profileMaxEventPerSchedule = string;
    }

    public void setProfileGroup(String string) {
        this.profileGroup = string;
    }

    public void setProfileCryptKey(String string) {
        this.crypt_key = string;
    }

    public void setProfileMaxErrors(String string) {
        this.profileMaxErrors = string;
    }

    public String getProfileInterfaceName() {
        return this.profileInterfaceName;
    }

    public void setProfileInterfaceName(String string) {
        this.profileInterfaceName = string;
    }

    public String getProfileInterfaceType() {
        return this.profileInterfaceType;
    }

    public void setProfileInterfaceType(String string) {
        this.profileInterfaceType = string;
    }

    public String getProfileInterfaceVersion() {
        return this.profileInterfaceVersion;
    }

    public void setProfileInterfaceVersion(String string) {
        this.profileInterfaceVersion = string;
    }

    public String getProfileInterfaceConnectInfo() {
        return this.profileInterfaceConnectInfo;
    }

    public void setProfileInterfaceConnectInfo(String string) {
        this.profileInterfaceConnectInfo = string;
    }

    public Vector getProfileInterfaceAdditionalInfo() {
        return this.profileInterfaceAdditionalInfo;
    }

    public void setProfileInterfaceAdditionalInfo(Vector vector) {
        this.profileInterfaceAdditionalInfo = vector;
    }

    public String getProfileChgLogLastAppliedChangeNumber() {
        return this.profileChgLogLastAppliedChangeNumber;
    }

    public void setProfileChgLogLastAppliedChangeNumber(String string) {
        this.profileChgLogLastAppliedChangeNumber = string;
    }

    public String getProfileChgLogSubscriberDisable() {
        return this.profileChgLogSubscriberDisable;
    }

    public void setProfileChgLogSubscriberDisable(String string) {
        this.profileChgLogSubscriberDisable = string;
    }

    public Vector getProvisioningProfileEventSubscription() {
        return this.provisioningProfileEventSubscription;
    }

    public void setProvisioningProfileEventSubscription(Vector vector) {
        this.provisioningProfileEventSubscription = vector;
    }

    public String getProvisioningProfileAppName() {
        return this.provisioningProfileAppName;
    }

    public void setProvisioningProfileAppName(String string) {
        this.provisioningProfileAppName = string;
    }

    public String getProvisioningProfileAppGUID() {
        return this.provisioningProfileAppGUID;
    }

    public void setProvisioningProfileAppGUID(String string) {
        this.provisioningProfileAppGUID = string;
    }

    public String getProvisioningProfileOrgName() {
        return this.provisioningProfileOrgName;
    }

    public void setProvisioningProfileOrgName(String string) {
        this.provisioningProfileOrgName = string;
    }

    public String getProvisioningProfileOrgGUID() {
        return this.provisioningProfileOrgGUID;
    }

    public void setProvisioningProfileOrgGUID(String string) {
        this.provisioningProfileOrgGUID = string;
    }
}

