/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.config.db;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.driver.oui.Configurable;
import oracle.install.driver.oui.config.ConfigAssistantParams;
import oracle.install.ivw.db.bean.DBInstallSettings;
import oracle.install.ivw.db.bean.DBSetupBean;
import oracle.install.library.util.PlatformInfo;
import oracle.sysman.oii.oiip.osd.win32.OiipwWin32NativeCalls;
import oracle.sysman.oii.oiix.OiixPlatform;

public class DBCAHelper {
    private static final Logger logger = Logger.getLogger(DBCAHelper.class.getName());
    public static final Map<String, String> secretParamRegexMap = new LinkedHashMap<String, String>();
    private static final String HOST_USER_PASSWORD_FLAG = "-hostUserPassword";
    private static final String SYS_PASSWORD_FLAG = "-sysPassword";
    private static final String SYSTEM_PASSWORD_FLAG = "-systemPassword";
    private static final String DBSNMP_PASSWORD_FLAG = "-dbsnmpPassword";
    private static final String ASMSNMP_PASSWORD_FLAG = "-asmSysPassword";
    private static final String SYSMAN_PASSWORD_FLAG = "-sysmanPassword";
    public static final String SILENT_FLAG = "-silent";
    public static final String CREATE_DATABASE_FLAG = "-createDatabase";
    public static final String TEMPLATE_NAME_FLAG = "-templateName";
    public static final String SID_FLAG = "-sid";
    public static final String GLOBAL_DB_NAME_FLAG = "-gdbName";
    public static final String EM_CONFIGURE_FLAG = "-emConfiguration";
    public static final String EM_SMTP_SERVER_FLAG = "-smtpServer";
    public static final String EM_EMAIL_ADDRESS_FLAG = "-emailAddress";
    public static final String EM_CENTRAL_AGENT_FLAG = "-centralAgent";
    public static final String CUSTOM_CREATE_FLAG = "-customCreate";
    public static final String DATA_FILE_JAR_FLAG = "-datafileJarLocation";
    public static final String RESPONSE_FILE_FLAG = "-responseFile";
    public static final String NODE_INFO_FLAG = "-nodeinfo";
    public static final String OBFUSCATED_PASSWORDS_FLAG = "-obfuscatedPasswords";
    public static final String ORATAB_LOCATION_FLAG = "-oratabLocation";
    public static final String DISABLE_SECURITY_FLAG = "-disableSecurityConfiguration";
    public static final String TOTAL_MEMORY_FLAG = "-totalMemory";
    public static final String AUTO_MEMORY_MNGT_FLAG = "-automaticMemoryManagement";
    public static final String MASK_PASSWORDS_FLAG = "-maskPasswords";
    public static final String REDUNDANCY_FLAG = "-redundancy";
    public static final String HOST_USER_NAME_FLAG = "-hostUserName";
    public static final String CHARACTER_SET_FLAG = "-characterset";
    public static final String SAMPLE_SCHEMA_FLAG = "-sampleSchema";
    public static final String PROGRESS_ONLY_FLAG = "-progress_only";
    public static final String STORAGE_TYPE_FLAG = "-storageType";
    public static final String DISK_GROUP_NAME_FLAG = "-diskGroupName";
    public static final String DATAFILE_DESTINATION_FLAG = "-datafileDestination";
    public static final String RECOVERY_AREA_DESTINATION_FLAG = "-recoveryAreaDestination";
    public static final String RECOVERY_AREA_DESTINATION_ASM_FLAG = "-recoveryGroupName";
    public static final String DBCA_ARGS_OVERRIDE = "s_dbcaArgsOverride";
    public static final String DBCA_ARGS = "s_dbcaArgs";
    public static final String HOST_USER_PASSWORD_FLAG_NAME = "s_hostUserPasswordFlag";
    public static final String HOST_USER_PASSWORD_NAME = "S_HOSTUSERPASSWORD";
    public static final String HOST_USER_PASSWORD_VALUE = "${S_HOSTUSERPASSWORD}";
    public static final String SYS_PASSWORD_FLAG_NAME = "s_sysPasswordFlag";
    public static final String SYS_PASSWORD_NAME = "S_SYSPASSWORD";
    public static final String SYS_PASSWORD_VALUE = "${S_SYSPASSWORD}";
    public static final String SYSTEM_PASSWORD_FLAG_NAME = "s_systemPasswordFlag";
    public static final String SYSTEM_PASSWORD_NAME = "S_SYSTEMPASSWORD";
    public static final String SYSTEM_PASSWORD_VALUE = "${S_SYSTEMPASSWORD}";
    public static final String SYSMAN_PASSWORD_FLAG_NAME = "s_sysmanPasswordFlag";
    public static final String SYSMAN_PASSWORD_NAME = "S_SYSMANPASSWORD";
    public static final String SYSMAN_PASSWORD_VALUE = "${S_SYSMANPASSWORD}";
    public static final String DBSNMP_PASSWORD_FLAG_NAME = "s_dbsnmpPasswordFlag";
    public static final String DBSNMP_PASSWORD_NAME = "S_DBSNMPPASSWORD";
    public static final String DBSNMP_PASSWORD_VALUE = "${S_DBSNMPPASSWORD}";
    public static final String ASMSNMP_PASSWORD_FLAG_NAME = "s_asmsnmpPasswordFlag";
    public static final String ASMSNMP_PASSWORD_NAME = "S_ASMSNMPPASSWORD";
    public static final String ASMSNMP_PASSWORD_VALUE = "${S_ASMSNMPPASSWORD}";
    public static final String DBCA = "DBCA";
    public static final String NOBACKUP = "NOBACKUP";
    public static final String ALL = "ALL";
    public static final String NOEMAIL = "NOEMAIL";
    public static final String DATA_FILE_JAR_LOCATION = "/assistants/dbca/templates";
    public static final String ASM = "ASM";
    public static final String FS = "FS";

    public static ConfigAssistantParams constructConfigParams(Configurable configJob, DBSetupBean setupBean) {
        String[] nodeList;
        ConfigAssistantParams params = new ConfigAssistantParams(DBCA);
        DBInstallSettings installSettings = setupBean.getDBInstallSettings();
        PlatformInfo platformInfo = PlatformInfo.getInstance();
        LinkedList<String> arguments = new LinkedList<String>();
        HashMap<String, String> secretArguments = new HashMap<String, String>();
        Long totalMemory = installSettings.getAllocatedMemory();
        Boolean autoMemorySelect = installSettings.getAutoMemoryOptionSelection();
        Boolean isSilent = Boolean.getBoolean("oracle.installer.silent");
        Boolean isClone = Boolean.getBoolean("oracle.installer.clone");
        Boolean isUnix = false;
        String emConfig = System.getProperty("oracle.sysman.server.EMConfigureOption");
        String emSmtpServer = installSettings.getEm_SMTPServer();
        String emEmailAddress = installSettings.getEm_EmailAddress();
        String emCentralAgent = installSettings.getEm_CentralAgentHome();
        String userName = installSettings.getRecoveryBackUpUsername();
        String oracleHome = installSettings.getOracleHome();
        String responseFile = System.getProperty("oracle.installer.responseFile");
        String createType = System.getProperty("oracle.server.createtype");
        String disableSecurity = System.getProperty("oracle.assistants.server.disableSecurity");
        String genericPassword = "";
        String recoveryAreaDest = "NO_VALUE ".trim();
        String oratabLocation = "NO_VALUE ".trim();
        String template = "NO_VALUE ".trim();
        StringBuilder dbcaArgs = new StringBuilder("");
        String dbcaArgsOverride = System.getProperty("oracle.installer.db.dbcaArgsOverride");
        String windowsCommandLinePrefix = "";
        String hostUserPasswordFlag = "";
        String hostUserPassword = "";
        dbcaArgsOverride = dbcaArgsOverride == null ? "" : dbcaArgsOverride;
        emConfig = emConfig == null ? "" : emConfig;
        emConfig = emConfig.length() == 0 ? NOBACKUP : emConfig;
        userName = userName == null ? "" : userName;
        userName = userName.length() == 0 ? "NO_VALUE ".trim() : userName;
        responseFile = responseFile == null ? "" : responseFile;
        responseFile = responseFile.length() == 0 ? "NO_VALUE ".trim() : responseFile;
        createType = createType == null ? "" : createType;
        disableSecurity = disableSecurity == null ? "" : disableSecurity;
        int platformId = platformInfo.getCurrentPlatform();
        int platformGroupId = OiixPlatform.getPlatGroup((int)platformId);
        if (platformGroupId == -1) {
            isUnix = true;
        }
        if (platformInfo.isWindows()) {
            String systemDir = "";
            try {
                systemDir = OiipwWin32NativeCalls.getWindowsSystemDirectory();
                windowsCommandLinePrefix = systemDir + "\\cmd /c call ";
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Unable to get windows system directory - " + e.getMessage());
            }
        }
        configJob.setTransientParameter("oracle.assistants.server", "windows_commandline_prefix", windowsCommandLinePrefix);
        if (dbcaArgsOverride.length() > 0) {
            String[] args;
            for (String arg : args = dbcaArgsOverride.trim().split("\\s+")) {
                arguments.add(arg);
            }
            params.setArguments(arguments);
            params.setSecretArguments(secretArguments);
            params.setSecretParamRegexMap(secretParamRegexMap);
            configJob.setTransientParameter("oracle.assistants.server", DBCA_ARGS_OVERRIDE, dbcaArgsOverride.trim());
            configJob.setTransientParameter("oracle.assistants.server", DBCA_ARGS, dbcaArgs.toString());
            return params;
        }
        if (isSilent.booleanValue()) {
            arguments.add(SILENT_FLAG);
            dbcaArgs.append("-silent ");
        } else {
            arguments.add(PROGRESS_ONLY_FLAG);
            dbcaArgs.append("-progress_only ");
        }
        if (createType.length() > 0) {
            arguments.add(createType);
            dbcaArgs.append(createType + " ");
        }
        if (createType.equals(CREATE_DATABASE_FLAG)) {
            template = installSettings.getStarterDatabaseType() == DBInstallSettings.StarterDatabaseType.GENERAL_PURPOSE ? "General_Purpose.dbc" : (installSettings.getStarterDatabaseType() == DBInstallSettings.StarterDatabaseType.DATA_WAREHOUSE ? "Data_Warehouse.dbc" : "New_Database.dbt");
        }
        arguments.add(TEMPLATE_NAME_FLAG);
        arguments.add(template);
        dbcaArgs.append("-templateName " + template + " ");
        arguments.add(SID_FLAG);
        arguments.add(installSettings.getDb_SID());
        dbcaArgs.append("-sid " + installSettings.getDb_SID() + " ");
        arguments.add(GLOBAL_DB_NAME_FLAG);
        arguments.add(installSettings.getGlobalDBName());
        dbcaArgs.append("-gdbName " + installSettings.getGlobalDBName() + " ");
        if (installSettings.getConfigurationType() != DBInstallSettings.ConfigurationType.NO_CONFIGURATION) {
            arguments.add(EM_CONFIGURE_FLAG);
            arguments.add(emConfig);
            dbcaArgs.append("-emConfiguration " + emConfig + " ");
        }
        if (!installSettings.isUseDBControlCase() && emCentralAgent != null && emCentralAgent != "") {
            arguments.add(EM_CENTRAL_AGENT_FLAG);
            arguments.add(emCentralAgent);
            dbcaArgs.append("-centralAgent " + emCentralAgent + " ");
        }
        if (installSettings.isReceiveEmailNotification() && emSmtpServer != null && emEmailAddress != null) {
            arguments.add(EM_SMTP_SERVER_FLAG);
            arguments.add(emSmtpServer);
            arguments.add(EM_EMAIL_ADDRESS_FLAG);
            arguments.add(emEmailAddress);
            dbcaArgs.append("-smtpServer " + emSmtpServer + " " + EM_EMAIL_ADDRESS_FLAG + " " + emEmailAddress + " ");
        }
        if (emConfig.equals(ALL) || emConfig.equals(NOEMAIL)) {
            arguments.add(HOST_USER_NAME_FLAG);
            arguments.add(userName);
            dbcaArgs.append("-hostUserName " + userName + " ");
            secretArguments.put(HOST_USER_PASSWORD_FLAG, installSettings.getRecoveryBackUpPassword());
            hostUserPasswordFlag = HOST_USER_PASSWORD_FLAG;
            hostUserPassword = HOST_USER_PASSWORD_VALUE;
        }
        configJob.setTransientParameter("oracle.assistants.server", HOST_USER_PASSWORD_FLAG_NAME, hostUserPasswordFlag);
        configJob.setTransientParameter("oracle.assistants.server", HOST_USER_PASSWORD_NAME, hostUserPassword);
        if (installSettings.getDatabase_StorageType_Chosen() == 2) {
            arguments.add(STORAGE_TYPE_FLAG);
            arguments.add(ASM);
            dbcaArgs.append("-storageType ASM ");
            arguments.add(DISK_GROUP_NAME_FLAG);
            arguments.add(installSettings.getDiskGroupNameForASM());
            dbcaArgs.append("-diskGroupName " + installSettings.getDiskGroupNameForASM() + " ");
        } else if (installSettings.getDatabase_StorageType_Chosen() == 1) {
            arguments.add(STORAGE_TYPE_FLAG);
            arguments.add(FS);
            dbcaArgs.append("-storageType FS ");
            arguments.add(DATAFILE_DESTINATION_FLAG);
            arguments.add(installSettings.getOraDataLocation());
            dbcaArgs.append("-datafileDestination " + installSettings.getOraDataLocation() + " ");
        }
        arguments.add(DATA_FILE_JAR_FLAG);
        arguments.add(oracleHome + DATA_FILE_JAR_LOCATION);
        dbcaArgs.append("-datafileJarLocation " + oracleHome + DATA_FILE_JAR_LOCATION + " ");
        arguments.add(RESPONSE_FILE_FLAG);
        arguments.add(responseFile);
        dbcaArgs.append("-responseFile " + responseFile + " ");
        if (installSettings.isRACinstall() && (nodeList = installSettings.getListOfSelectedNodes()) != null) {
            StringBuilder nodes = new StringBuilder("");
            for (int ix = 0; ix < nodeList.length; ++ix) {
                nodes.append(nodeList[ix]);
                if (ix >= nodeList.length - 1) continue;
                nodes.append(",");
            }
            String nodeInfo = isUnix != false ? nodes.toString() : "\"" + nodes.toString() + "\"";
            arguments.add(NODE_INFO_FLAG);
            arguments.add(nodeInfo);
            dbcaArgs.append("-nodeinfo " + nodeInfo + " ");
        }
        if (installSettings.getCharacterSet() != null && installSettings.getCharacterSet().trim().length() > 0) {
            arguments.add(CHARACTER_SET_FLAG);
            arguments.add(installSettings.getCharacterSet());
            dbcaArgs.append("-characterset " + installSettings.getCharacterSet() + " ");
        }
        arguments.add(OBFUSCATED_PASSWORDS_FLAG);
        arguments.add("false");
        dbcaArgs.append("-obfuscatedPasswords false ");
        if (createType.equals(CREATE_DATABASE_FLAG)) {
            StringTokenizer tokenizer = new StringTokenizer(installSettings.getSampleSchema().trim());
            while (tokenizer.hasMoreTokens()) {
                if (!tokenizer.nextToken().equals(SAMPLE_SCHEMA_FLAG) || !tokenizer.hasMoreTokens()) continue;
                arguments.add(SAMPLE_SCHEMA_FLAG);
                String schema = tokenizer.nextToken();
                arguments.add(schema);
                dbcaArgs.append("-sampleSchema " + schema + " ");
            }
        }
        if (isUnix.booleanValue()) {
            if (!isClone.booleanValue()) {
                oratabLocation = oracleHome + "/install/oratab";
            }
            arguments.add(ORATAB_LOCATION_FLAG);
            arguments.add(oratabLocation);
            dbcaArgs.append("-oratabLocation " + oratabLocation + " ");
        }
        if (installSettings.isEnableAutoBackup()) {
            if (installSettings.isUseFileSystemForRecoverySelected()) {
                recoveryAreaDest = installSettings.getRecoveryBackUpLocation();
                arguments.add(RECOVERY_AREA_DESTINATION_FLAG);
                arguments.add(recoveryAreaDest);
                dbcaArgs.append("-recoveryAreaDestination " + recoveryAreaDest + " ");
            } else {
                recoveryAreaDest = installSettings.getDiskGroupNameForASM();
                arguments.add(RECOVERY_AREA_DESTINATION_ASM_FLAG);
                arguments.add(recoveryAreaDest);
                dbcaArgs.append("-recoveryGroupName " + recoveryAreaDest + " ");
            }
        }
        if (disableSecurity.equals("yes")) {
            arguments.add(DISABLE_SECURITY_FLAG);
            arguments.add(ALL);
            dbcaArgs.append("-disableSecurityConfiguration ALL ");
        }
        arguments.add(AUTO_MEMORY_MNGT_FLAG);
        arguments.add(autoMemorySelect.toString());
        dbcaArgs.append("-automaticMemoryManagement " + autoMemorySelect.toString() + " ");
        if (totalMemory > 0L) {
            arguments.add(TOTAL_MEMORY_FLAG);
            arguments.add(Long.toString(totalMemory));
            dbcaArgs.append("-totalMemory " + Long.toString(totalMemory) + " ");
        }
        arguments.add(MASK_PASSWORDS_FLAG);
        arguments.add("false");
        dbcaArgs.append("-maskPasswords false ");
        params.setArguments(arguments);
        configJob.setTransientParameter("oracle.assistants.server", DBCA_ARGS_OVERRIDE, dbcaArgsOverride.trim());
        configJob.setTransientParameter("oracle.assistants.server", DBCA_ARGS, dbcaArgs.toString());
        if (installSettings.isUseSamePasswordCase()) {
            genericPassword = installSettings.getGenericPassword();
            secretArguments.put(SYS_PASSWORD_FLAG, genericPassword);
            secretArguments.put(SYSTEM_PASSWORD_FLAG, genericPassword);
            secretArguments.put(SYSMAN_PASSWORD_FLAG, genericPassword);
            secretArguments.put(DBSNMP_PASSWORD_FLAG, genericPassword);
        } else {
            String[] superAdminPasswords = installSettings.getListOfSuperAdminPasswords();
            if (superAdminPasswords != null) {
                String key = "";
                for (int ix = 0; ix < superAdminPasswords.length; ++ix) {
                    if (superAdminPasswords[ix].length() <= 0) continue;
                    switch (ix) {
                        case 0: {
                            key = SYS_PASSWORD_FLAG;
                            break;
                        }
                        case 1: {
                            key = SYSTEM_PASSWORD_FLAG;
                            break;
                        }
                        case 2: {
                            key = SYSMAN_PASSWORD_FLAG;
                            break;
                        }
                        case 3: {
                            key = DBSNMP_PASSWORD_FLAG;
                            break;
                        }
                    }
                    secretArguments.put(key, superAdminPasswords[ix]);
                }
            }
        }
        configJob.setTransientParameter("oracle.assistants.server", SYS_PASSWORD_FLAG_NAME, SYS_PASSWORD_FLAG);
        configJob.setTransientParameter("oracle.assistants.server", SYS_PASSWORD_NAME, SYS_PASSWORD_VALUE);
        configJob.setTransientParameter("oracle.assistants.server", SYSTEM_PASSWORD_FLAG_NAME, SYSTEM_PASSWORD_FLAG);
        configJob.setTransientParameter("oracle.assistants.server", SYSTEM_PASSWORD_NAME, SYSTEM_PASSWORD_VALUE);
        configJob.setTransientParameter("oracle.assistants.server", SYSMAN_PASSWORD_FLAG_NAME, SYSMAN_PASSWORD_FLAG);
        configJob.setTransientParameter("oracle.assistants.server", SYSMAN_PASSWORD_NAME, SYSMAN_PASSWORD_VALUE);
        configJob.setTransientParameter("oracle.assistants.server", DBSNMP_PASSWORD_FLAG_NAME, DBSNMP_PASSWORD_FLAG);
        configJob.setTransientParameter("oracle.assistants.server", DBSNMP_PASSWORD_NAME, DBSNMP_PASSWORD_VALUE);
        if (installSettings.getDatabase_StorageType_Chosen() == 2) {
            secretArguments.put(ASMSNMP_PASSWORD_FLAG, installSettings.getAsmsnmpPassword());
            configJob.setTransientParameter("oracle.assistants.server", ASMSNMP_PASSWORD_FLAG_NAME, ASMSNMP_PASSWORD_FLAG);
            configJob.setTransientParameter("oracle.assistants.server", ASMSNMP_PASSWORD_NAME, ASMSNMP_PASSWORD_VALUE);
        } else {
            configJob.setTransientParameter("oracle.assistants.server", ASMSNMP_PASSWORD_FLAG_NAME, "");
            configJob.setTransientParameter("oracle.assistants.server", ASMSNMP_PASSWORD_NAME, "");
        }
        params.setSecretArguments(secretArguments);
        params.setSecretParamRegexMap(secretParamRegexMap);
        return params;
    }

    static {
        secretParamRegexMap.put(SYS_PASSWORD_FLAG, ".*SYS_PASSWORD_PROMPT.*");
        secretParamRegexMap.put(SYSTEM_PASSWORD_FLAG, ".*SYSTEM_PASSWORD_PROMPT.*");
        secretParamRegexMap.put(DBSNMP_PASSWORD_FLAG, ".*DBSNMP_PASSWORD_PROMPT.*");
        secretParamRegexMap.put(SYSMAN_PASSWORD_FLAG, ".*SYSMAN_PASSWORD_PROMPT.*");
        secretParamRegexMap.put(ASMSNMP_PASSWORD_FLAG, ".*ASMSYS_PASSWORD_PROMPT.*");
        secretParamRegexMap.put(HOST_USER_PASSWORD_FLAG, ".*HOSTUSER_PASSWORD_PROMPT.*");
    }
}

