/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.action;

import oracle.install.commons.flow.Action;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.Route;
import oracle.install.commons.flow.annotation.UIRef;
import oracle.install.commons.flow.validation.annotation.ValidatorRef;
import oracle.install.ivw.db.bean.DBInstallSettings;
import oracle.install.ivw.db.validator.ConfigurationOptionsValidator;
import oracle.install.library.memory.MemoryInfo;
import oracle.install.library.util.PlatformInfo;

@UIRef(value="ConfigurationOptionsUI")
@ValidatorRef(value=ConfigurationOptionsValidator.class)
public class ConfigurationOptionsAction
implements Action {
    public void execute(FlowContext flowContext) {
    }

    public Route transition(FlowContext flowContext) {
        DBInstallSettings dbBean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        if (dbBean.isLoadExampleSchemas()) {
            dbBean.setSampleSchema("-sampleSchema true");
        } else {
            dbBean.setSampleSchema("-sampleSchema false");
        }
        System.setProperty("oracle.assistants.server.absoluteMemory", String.valueOf(dbBean.getAllocatedMemory()));
        System.setProperty("oracle.assistants.server.autoMemoryOption", String.valueOf(dbBean.getAutoMemoryOptionSelection()));
        if (dbBean.isSecureConfigDisabled()) {
            System.setProperty("oracle.assistants.server.disableSecurity", "yes");
        } else {
            System.setProperty("oracle.assistants.server.disableSecurity", "no");
        }
        return Route.SUCCESS;
    }

    public static void setDefaultCharacterSet(DBInstallSettings dbBean) {
        String defCharset = new String("AL32UTF8");
        dbBean.setCharacterSet(defCharset);
    }

    public static void setDefaultMemoryOptionsInBean(DBInstallSettings dbBean) {
        long totalPhysicalMemory;
        String[] nodes = dbBean.getListOfSelectedNodes();
        long allocatedMemory = 256L;
        boolean autoMemoryOption = true;
        long nSharedMemSize = totalPhysicalMemory = MemoryInfo.getInstance().getTotalPhysicalMemory();
        PlatformInfo platformInfo = PlatformInfo.getInstance();
        if (platformInfo.isWin32System() && totalPhysicalMemory >= 3072L) {
            totalPhysicalMemory = 3072L;
            nSharedMemSize = 3072L;
        }
        long nFortyPercentMem = Math.round(Math.ceil((double)totalPhysicalMemory * 40.0 / 100.0));
        if (PlatformInfo.getInstance().isLinux()) {
            String sharedMemLocation = "/dev/shm";
            nSharedMemSize = nodes != null && nodes.length > 0 ? MemoryInfo.getInstance().getClusterMaxFreeDiskSpace(nodes, sharedMemLocation) : MemoryInfo.getInstance().getFreeDiskSpace(sharedMemLocation);
        }
        if (256L < nFortyPercentMem) {
            allocatedMemory = (int)nFortyPercentMem;
        }
        if (256L < nSharedMemSize) {
            if (nSharedMemSize < allocatedMemory) {
                allocatedMemory = (int)nSharedMemSize;
            }
            autoMemoryOption = true;
        }
        dbBean.setAllocatedMemory(allocatedMemory);
        dbBean.setAutoMemoryOptionSelection(autoMemoryOption);
    }
}

