/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.action;

import java.net.URL;
import java.util.Map;
import java.util.logging.Logger;
import oracle.install.commons.base.util.ComponentConfig;
import oracle.install.commons.base.util.ComponentConfigBuilder;
import oracle.install.commons.flow.Action;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.Route;
import oracle.install.commons.flow.annotation.UIRef;
import oracle.install.ivw.db.bean.DBInstallSettings;

@UIRef(value="DBEditionUI")
public class DBEditionAction
implements Action {
    private Logger logger = Logger.getLogger(DBEditionAction.class.getName());
    private final String COMPONENT_XML = "/oracle/install/ivw/db/resource/custom_component-config.xml";

    public void execute(FlowContext flowContext) {
        ComponentConfig componentBean = this.getComponentConfig();
        if (componentBean != null) {
            DBInstallSettings dbBean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
            String[] componentIDs = dbBean.getCustomComponents();
            ComponentConfigBuilder builder = ComponentConfigBuilder.getInstance();
            builder.selectForInstall(componentBean, componentIDs);
        }
    }

    public Route transition(FlowContext flowContext) {
        DBInstallSettings installSettings = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        this.logger.info("Install Type selected :" + (Object)((Object)installSettings.getDBInstallType()));
        this.logger.info("Database Edition selected: " + installSettings.getDbInstallEdition().getValue());
        System.setProperty("oracle.server.bundleName", installSettings.getDbInstallEdition().getValue());
        if (installSettings.isCustomInstall()) {
            ComponentConfig componentConfig = this.getComponentConfig();
            componentConfig.setSelectedVisibleComponents(installSettings.getCustomComponents());
            ComponentConfigBuilder builder = ComponentConfigBuilder.getInstance();
            Map boolMap = builder.buildBooleanMap(componentConfig);
            installSettings.setComponentBooleanMap(boolMap);
        }
        return new Route("oraclehome_location");
    }

    private ComponentConfig getComponentConfig() {
        ComponentConfig bean = null;
        try {
            URL url = DBEditionAction.class.getResource("/oracle/install/ivw/db/resource/custom_component-config.xml");
            ComponentConfigBuilder builder = ComponentConfigBuilder.getInstance();
            bean = builder.getComponentBean(url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bean;
    }
}

