/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.action;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.flow.Action;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.Route;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.UIType;
import oracle.install.ivw.db.bean.DBInstallSettings;

public class FinishAction
implements Action {
    private Logger logger = Logger.getLogger(FinishAction.class.getName());

    public void execute(FlowContext flowContext) {
        this.logger.log(Level.INFO, "FinishAction Actions.execute called");
        try {
            DBInstallSettings bean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
            Application application = Application.getInstance();
            if (bean.getSelectedInstallOption() == DBInstallSettings.InstallOption.UPGRADE_DB && application.getUIType() == UIType.NONE) {
                Resource resource = application.getResource("oracle.install.ivw.db.resource.DBDialogLabelResID");
                final String description = resource.getString("INSTALL_DB_INSTALL_FINISH_SILENT_UPGRADE_MESSAGE", "Invoke Database Upgrade Assistant to upgrade the database.", new Object[0]);
                String hashline = "##########################################################";
                this.logger.log(Level.INFO, "##########################################################");
                this.logger.log(Level.INFO, description);
                this.logger.log(Level.INFO, "##########################################################");
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    public void run() {
                        try {
                            System.out.println("##########################################################");
                            System.out.println(description);
                            System.out.println("##########################################################");
                        }
                        catch (Exception e) {
                            System.err.println(e.getMessage());
                        }
                    }
                });
            }
        }
        catch (Throwable t) {
            System.err.println("Error while performing operations in Finish Action");
            t.printStackTrace();
        }
    }

    public Route transition(FlowContext flowContext) {
        return null;
    }
}

