/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.action;

import oracle.install.commons.flow.Action;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.Route;
import oracle.install.commons.flow.annotation.UIRef;
import oracle.install.commons.flow.validation.annotation.ValidatorRef;
import oracle.install.ivw.db.bean.DBInstallSettings;
import oracle.install.ivw.db.validator.InstallLocationValidator;
import oracle.install.library.util.InventoryInfo;

@UIRef(value="InstallLocationUI")
@ValidatorRef(value=InstallLocationValidator.class)
public class InstallLocationAction
implements Action {
    public void execute(FlowContext flowContext) {
    }

    public Route transition(FlowContext flowContext) {
        DBInstallSettings dbBean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        InventoryInfo invInfo = InventoryInfo.getInstance();
        if (!invInfo.isInventoryExist()) {
            return new Route("advanced_yes_inventory_no");
        }
        if (dbBean.getSelectedInstallOption() == DBInstallSettings.InstallOption.UPGRADE_DB) {
            return new Route("advanced_yes_upgrade_yes");
        }
        if (dbBean.getSelectedInstallOption() == DBInstallSettings.InstallOption.INSTALL_DB_AND_CONFIG) {
            return new Route("advanced_yes_createDB_yes");
        }
        if (dbBean.getSelectedInstallOption() == DBInstallSettings.InstallOption.INSTALL_DB_SWONLY) {
            return new Route("advanced_yes_softwareDB_yes");
        }
        return Route.FAILURE;
    }
}

