/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.action;

import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.cluster.install.InstallException;
import oracle.install.commons.flow.DefaultAction;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.Route;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.UIType;
import oracle.install.commons.util.Version;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.ivw.db.bean.DBInstallSettings;
import oracle.install.library.crs.CRSInfo;
import oracle.install.library.db.DatabaseInfo;
import oracle.install.library.util.InstallConstants;
import oracle.install.library.util.InventoryInfo;

public class InstallOptionsAction
extends DefaultAction {
    private Logger logger = Logger.getLogger(InstallOptionsAction.class.getName());
    private static final Route SYSTEM_CLASS = new Route("system_class");
    private static final Route ADVANCED_SOFTWARE_DB = new Route("advanced_yes_softwareDB_yes");
    private static final Route MIGRATE_YES_CLUSTERWARE_YES = new Route("migrate_yes_clusterware_yes");
    private static final Route MIGRATE_YES_CLUSTERWARE_NO = new Route("migrate_yes_clusterware_no");

    public final Route transition(FlowContext flowContext) {
        DBInstallSettings dbBean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        Route route = null;
        this.logger.log(Level.INFO, "InstallOptionsAction Actions.transition called");
        DBInstallSettings.InstallOption selectedInstallOption = dbBean.getSelectedInstallOption();
        this.logger.log(Level.INFO, "selectedInstallOption is :" + (Object)((Object)selectedInstallOption));
        boolean launchNETCA = true;
        try {
            InventoryInfo invInfo = InventoryInfo.getInstance();
            if (invInfo.isCRSConfigured()) {
                launchNETCA = false;
            }
            this.logger.log(Level.INFO, "launchNETCA = " + launchNETCA);
        }
        catch (InstallException e) {
            ExceptionManager.handle((Throwable)e);
        }
        if (selectedInstallOption == DBInstallSettings.InstallOption.INSTALL_DB_AND_CONFIG) {
            System.setProperty("oracle.server.createtype", "-createDatabase");
            dbBean.setLaunchNETCA(launchNETCA);
            dbBean.setLaunchDBCA(true);
            dbBean.setLaunchODMA(false);
        }
        if (selectedInstallOption == DBInstallSettings.InstallOption.INSTALL_DB_SWONLY) {
            dbBean.setLaunchNETCA(false);
            dbBean.setLaunchDBCA(false);
            dbBean.setLaunchODMA(false);
            System.setProperty("oracle.server.createtype", "-createDatabase");
        }
        if (selectedInstallOption == DBInstallSettings.InstallOption.UPGRADE_DB) {
            Application application = Application.getInstance();
            if (application.getUIType().equals((Object)UIType.NONE)) {
                dbBean.setLaunchODMA(false);
            } else {
                dbBean.setLaunchODMA(true);
            }
            dbBean.setLaunchNETCA(launchNETCA);
            dbBean.setNoMigrationCase(false);
            dbBean.setLaunchDBCA(false);
        } else {
            dbBean.setNoMigrationCase(true);
        }
        switch (selectedInstallOption) {
            case INSTALL_DB_AND_CONFIG: {
                route = SYSTEM_CLASS;
                break;
            }
            case INSTALL_DB_SWONLY: {
                route = ADVANCED_SOFTWARE_DB;
                break;
            }
            case UPGRADE_DB: {
                CRSInfo crsInfo = CRSInfo.getInstance();
                HashMap SIDBs = null;
                if (crsInfo.isCRSPresent()) {
                    try {
                        SIDBs = DatabaseInfo.getInstance().getListOfSIDatabasesLocalNode();
                    }
                    catch (oracle.install.library.util.InstallException e) {
                        this.logger.log(Level.WARNING, e.getStackTrace().toString());
                    }
                    if (Version.parseVersion((String)crsInfo.getCRSActiveVersion()).compareTo(InstallConstants.VERSION) < 0 && (SIDBs == null || SIDBs.size() == 0)) {
                        route = MIGRATE_YES_CLUSTERWARE_NO;
                        break;
                    }
                    route = MIGRATE_YES_CLUSTERWARE_YES;
                    break;
                }
                route = MIGRATE_YES_CLUSTERWARE_NO;
            }
        }
        return route;
    }
}

