/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.action;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.flow.Action;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.Route;
import oracle.install.ivw.db.bean.DBInstallSettings;
import oracle.install.library.crs.CRSInfo;

public class InventoryAction
implements Action {
    private Logger logger = Logger.getLogger(InventoryAction.class.getName());

    public final void execute(FlowContext flowContext) {
        this.logger.log(Level.INFO, "Inventory Actions Entering and Exiting execute");
    }

    public final Route transition(FlowContext flowContext) {
        DBInstallSettings dbBean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        boolean advancedInstall = dbBean.isAdvancedInstall();
        boolean clusterwareFound = CRSInfo.getInstance().isCRSPresent();
        DBInstallSettings.InstallOption installOption = dbBean.getSelectedInstallOption();
        this.logger.log(Level.INFO, "installOption Selected:" + installOption.toString());
        switch (installOption) {
            case INSTALL_DB_AND_CONFIG: {
                if (advancedInstall) {
                    return new Route("advanced_yes_createDB_yes");
                }
                return new Route("basic_yes");
            }
            case INSTALL_DB_SWONLY: {
                return new Route("advanced_yes_softwareDB_yes");
            }
            case UPGRADE_DB: {
                return new Route("advanced_yes_softwareDB_yes");
            }
        }
        return null;
    }
}

