/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.action;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.flow.Action;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.Route;
import oracle.install.commons.flow.annotation.UIRef;
import oracle.install.commons.flow.validation.annotation.ValidatorRef;
import oracle.install.ivw.db.bean.DBInstallSettings;
import oracle.install.ivw.db.validator.ManagementOptionsValidator;
import oracle.install.library.util.InventoryInfo;

@UIRef(value="ManagementOptionsUI")
@ValidatorRef(value=ManagementOptionsValidator.class)
public class ManagementOptionsAction
implements Action {
    private Logger logger = Logger.getLogger(ManagementOptionsAction.class.getName());

    public final void execute(FlowContext flowContext) {
        this.logger.log(Level.INFO, "ManagementOptionsAction-> inside execute method");
    }

    public final Route transition(FlowContext flowContext) {
        String centralAgentSelected;
        DBInstallSettings dbBean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        if (!dbBean.isUseDBControlCase()) {
            dbBean.setReceiveEmailNotification(false);
        }
        if ((centralAgentSelected = dbBean.getEm_CentralAgentSelected()) == null) {
            centralAgentSelected = "";
        }
        String centralAgentOraHome = "";
        Map agentHomeMap = InventoryInfo.getInstance().getEMAgentsOnLocalNode();
        if (agentHomeMap.containsKey(centralAgentSelected)) {
            centralAgentOraHome = (String)agentHomeMap.get(centralAgentSelected);
        }
        if (dbBean.isUseDBControlCase()) {
            System.setProperty("oracle.sysman.server.EMConfigureOption", "LOCAL");
        } else {
            System.setProperty("oracle.sysman.server.EMConfigureOption", "CENTRAL");
            System.setProperty("oracle.sysman.server.centralagent", centralAgentOraHome);
            dbBean.setEm_CentralAgentHome(centralAgentOraHome);
        }
        return Route.SUCCESS;
    }
}

