/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.action;

import java.util.List;
import java.util.logging.Logger;
import oracle.cluster.verification.ClusterVerification;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationTask;
import oracle.install.commons.base.interview.common.action.AbstractPrereqAction;
import oracle.install.commons.base.interview.common.validator.PrereqValidator;
import oracle.install.commons.base.prereq.PrereqChecker;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.annotation.UIRef;
import oracle.install.commons.flow.validation.annotation.ValidatorRef;
import oracle.install.ivw.db.bean.DBInstallSettings;
import oracle.install.ivw.db.bean.DBSetupBean;
import oracle.install.library.util.PlatformInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UIRef(value="PrereqUI")
@ValidatorRef(value=PrereqValidator.class)
public class PrereqAction
extends AbstractPrereqAction {
    private static final Logger logger = Logger.getLogger(PrereqAction.class.getName());

    public List<VerificationTask> getProductVerificationTasks(FlowContext flowContext) throws VerificationException {
        String[] nodes;
        List tasks = null;
        ClusterVerification cvu = ClusterVerification.getInstance();
        DBInstallSettings bean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        if (this.isStandalone() && (nodes = this.getTargetNodes()) != null && nodes.length > 0) {
            bean.setRACinstall(true);
            bean.setListOfSelectedNodes(nodes);
        }
        this.setCVUVariables(flowContext, cvu);
        if (bean.isRACinstall()) {
            PrereqChecker.getInstance().setNodes(bean.getListOfSelectedNodes());
            tasks = cvu.getPreReqTasksForDBInst(bean.getListOfSelectedNodes());
        } else {
            PrereqChecker.getInstance().setNodes(null);
            tasks = cvu.getPreReqTasksForSIDBInst();
        }
        return tasks;
    }

    public void setCVUVariables(FlowContext flowContext, ClusterVerification cvu) throws VerificationException {
        Object nodeList = null;
        DBSetupBean dbSetupBean = (DBSetupBean)((Object)flowContext.getBean(DBSetupBean.class));
        DBInstallSettings dbBean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        if (System.getProperty("user.name") != null && System.getProperty("user.name").trim().length() > 0) {
            cvu.setVariableValue("INSTALL_USER", System.getProperty("user.name"));
        }
        PlatformInfo platformInfo = PlatformInfo.getInstance();
        String temp = null;
        if (platformInfo.isWindows()) {
            temp = System.getenv("temp");
        } else {
            String string = temp = System.getenv("TMP") != null ? System.getenv("TMP") : "/tmp";
        }
        if (temp != null) {
            cvu.setVariableValue("TEMP_AREA", temp);
        }
        if (dbSetupBean != null) {
            if (dbSetupBean.getCentralInventory().getInventoryLocation() != null && dbSetupBean.getCentralInventory().getInventoryLocation().trim().length() > 0) {
                cvu.setVariableValue("INVENTORY_LOCATION", dbSetupBean.getCentralInventory().getInventoryLocation());
            }
            if (dbSetupBean.getCentralInventory().getGroupOwnership() != null && dbSetupBean.getCentralInventory().getGroupOwnership().trim().length() > 0) {
                cvu.setVariableValue("INSTALL_GROUP", dbSetupBean.getCentralInventory().getGroupOwnership());
            }
            if (dbBean != null) {
                if (dbBean.getDbaGroupNameUsed() != null && dbBean.getDbaGroupNameUsed().trim().length() > 0) {
                    cvu.setVariableValue("DBA_GROUP", dbBean.getDbaGroupNameUsed());
                }
                if (dbBean.getOperGroupNameUsed() != null && dbBean.getOperGroupNameUsed().trim().length() > 0) {
                    cvu.setVariableValue("OPER_GROUP", dbBean.getOperGroupNameUsed());
                }
            }
            if (dbBean.getOracleHome() != null && dbBean.getOracleHome().trim().length() > 0) {
                cvu.setVariableValue("ORACLE_HOME", dbBean.getOracleHome());
            }
            if (dbBean.getOracleBase() != null && dbBean.getOracleBase().trim().length() > 0) {
                cvu.setVariableValue("ORACLE_BASE", dbBean.getOracleBase());
            }
            if (dbBean.getGlobalDBName() != null && dbBean.getGlobalDBName().trim().length() > 0) {
                cvu.setVariableValue("GLOBAL_DATABASE_NAME", dbBean.getGlobalDBName());
            }
            if (dbBean.getDb_SID() != null && dbBean.getDb_SID().trim().length() > 0) {
                cvu.setVariableValue("SID", dbBean.getDb_SID());
            }
            int storageType = dbBean.getDatabase_StorageType_Chosen();
            switch (storageType) {
                case 1: {
                    cvu.setConditionValue("DATA_ON_ASM", false);
                    break;
                }
                case 2: {
                    cvu.setConditionValue("DATA_ON_ASM", true);
                }
            }
        }
    }
}

