/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.db.action;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.flow.Action;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.Route;
import oracle.install.commons.flow.annotation.UIRef;
import oracle.install.commons.flow.validation.annotation.ValidatorRef;
import oracle.install.ivw.db.action.ConfigurationOptionsAction;
import oracle.install.ivw.db.bean.DBInstallSettings;
import oracle.install.ivw.db.validator.QuickInstallValidator;
import oracle.install.library.util.InventoryInfo;

@UIRef(value="QuickInstallUI")
@ValidatorRef(value=QuickInstallValidator.class)
public class QuickInstallAction
implements Action {
    private Logger logger = Logger.getLogger(QuickInstallAction.class.getName());
    private static final Route BASIC_INVENTORY = new Route("basic_yes_inventory_yes");
    private static final Route BASIC_NOINVENTORY = new Route("basic_yes_inventory_no");

    public final void execute(FlowContext flowContext) {
    }

    public final Route transition(FlowContext flowContext) {
        DBInstallSettings dbBean = (DBInstallSettings)((Object)flowContext.getBean(DBInstallSettings.class));
        Route route = null;
        if (dbBean.getAllocatedMemory() == null) {
            ConfigurationOptionsAction.setDefaultMemoryOptionsInBean(dbBean);
        }
        if (dbBean.getCharacterSet() == null || dbBean.getCharacterSet().trim().length() <= 0) {
            ConfigurationOptionsAction.setDefaultCharacterSet(dbBean);
        }
        boolean invFound = InventoryInfo.getInstance().isInventoryExist();
        this.logger.log(Level.INFO, "Is inventory detected?:" + invFound);
        route = invFound ? BASIC_INVENTORY : BASIC_NOINVENTORY;
        return route;
    }
}

